/*
 * Decompiled with CFR 0.152.
 */
package User;

import User.UserClass;
import User.UserData;
import User.UserInfo;
import Vdb.CollectSlaveStats;
import Vdb.Report;
import Vdb.SdStats;
import Vdb.Slave;
import Vdb.SlaveList;
import Vdb.SlaveStats;
import Vdb.SocketMessage;
import Vdb.WG_entry;
import Vdb.common;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Vector;

public class ControlUsers {
    private static final String c = "Copyright (c) 2000, 2012, Oracle and/or its affiliates. All rights reserved.";
    private static boolean any_users = false;
    private static HashMap<String, UserInfo> userinfo_map = new HashMap(16);
    private static HashMap missing_methods = new HashMap(16);

    public static UserClass createInstance(WG_entry wG_entry) {
        String[] stringArray = wG_entry.user_class_parms;
        String string = stringArray[0];
        ControlUsers.checkClassname(string);
        String[] stringArray2 = new String[stringArray.length - 1];
        System.arraycopy(stringArray, 1, stringArray2, 0, stringArray.length - 1);
        UserInfo userInfo = new UserInfo(wG_entry.wd_name, string, stringArray2);
        UserClass userClass = (UserClass)ControlUsers.instantiate(userInfo);
        userInfo.setInstance(userClass);
        if (!userClass.parser(userInfo.getParms())) {
            common.failure("ControlUsers.create(wg): parser failed for wd=%s,user=%s", wG_entry.wd_name, userInfo.getClassName());
        }
        userinfo_map.put(string, userInfo);
        any_users = true;
        return userClass;
    }

    public static void clearClasses() {
        userinfo_map = new HashMap(32);
    }

    private static void checkClassname(String string) {
        try {
            Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            common.failure("checkClassname(): %s is not a valid class name", string);
        }
    }

    private static Object instantiate(UserInfo userInfo) {
        try {
            userInfo.setInstance((UserClass)Class.forName(userInfo.getClassName()).newInstance());
            return userInfo.getInstance();
        }
        catch (Exception exception) {
            common.failure(exception);
            return null;
        }
    }

    public static boolean anyUserClasses() {
        return any_users;
    }

    public static Vector getIntervalDataForMaster() {
        Vector<UserData[]> vector = new Vector<UserData[]>(16);
        String[] stringArray = userinfo_map.keySet().toArray(new String[0]);
        for (int i = 0; i < stringArray.length; ++i) {
            UserInfo userInfo = userinfo_map.get(stringArray[i]);
            UserData[] userDataArray = (UserData[])ControlUsers.callStaticMethod(userInfo, "getIntervalDataForMaster", null);
            if (userDataArray == null) continue;
            vector.add(userDataArray);
        }
        return vector;
    }

    public static UserData[] receivedIntervalDataFromSlaves(CollectSlaveStats collectSlaveStats) {
        Serializable serializable;
        HashMap<UserData, UserData> hashMap = new HashMap<UserData, UserData>(64);
        for (int i = 0; i < collectSlaveStats.getDataFromSlaves().length; ++i) {
            SlaveStats slaveStats = collectSlaveStats.getDataFromSlaves()[i];
            if (slaveStats.getUserData() == null) continue;
            serializable = slaveStats.getUserData();
            for (int j = 0; j < ((Vector)serializable).size(); ++j) {
                UserData[] userDataArray = (UserData[])((Vector)serializable).elementAt(j);
                for (int k = 0; k < userDataArray.length; ++k) {
                    if (hashMap.put(userDataArray[k], userDataArray[k]) == null) continue;
                    common.failure("receivedIntervalDataFromSlaves(): received duplicate data");
                }
            }
        }
        UserData[] userDataArray = hashMap.values().toArray(new UserData[0]);
        for (int i = 0; i < userDataArray.length; ++i) {
            serializable = userDataArray[i];
            SdStats sdStats = Report.getReport(((UserData)serializable).GetSdName()).getData().getIntervalSdStats();
            ((UserData)serializable).setRate(sdStats.rate());
            ((UserData)serializable).setRdPct(sdStats.readpct());
            ((UserData)serializable).setResp(sdStats.respTime());
        }
        String[] stringArray = userinfo_map.keySet().toArray(new String[0]);
        for (int i = 0; i < stringArray.length; ++i) {
            UserInfo userInfo = userinfo_map.get(stringArray[i]);
            ControlUsers.callStaticMethod(userInfo, "receivedIntervalDataFromSlaves", userDataArray);
        }
        return userDataArray;
    }

    public static Vector receivedIntervalDataFromMaster(UserData[] userDataArray) {
        Vector<Object> vector = new Vector<Object>(16);
        String[] stringArray = userinfo_map.keySet().toArray(new String[0]);
        for (int i = 0; i < stringArray.length; ++i) {
            UserInfo userInfo = userinfo_map.get(stringArray[i]);
            Object object = ControlUsers.callStaticMethod(userInfo, "receivedIntervalDataFromMaster", userDataArray);
            if (object == null) continue;
            vector.add(object);
        }
        return vector;
    }

    public static void sendUserDataToSlaves(UserData[] userDataArray) {
        for (int i = 0; i < SlaveList.getSlaveList().size(); ++i) {
            Slave slave = SlaveList.getSlaveList().elementAt(i);
            if (slave.getCurrentWork() == null) continue;
            SocketMessage socketMessage = new SocketMessage(SocketMessage.USER_DATA_TO_SLAVES);
            socketMessage.setData(userDataArray);
            slave.getSocket().putMessage(socketMessage);
        }
    }

    private static Object callStaticMethod(UserInfo userInfo, String string, Object object) {
        try {
            Class<?> clazz = Class.forName(userInfo.getClassName());
            Method[] methodArray = clazz.getMethods();
            for (int i = 0; i < methodArray.length; ++i) {
                if (!methodArray[i].getName().equals(string)) continue;
                return methodArray[i].invoke((Object)userInfo.getInstance(), object);
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            common.failure("callClass(): %s is not a valid class name", userInfo.getClassName());
        }
        catch (Exception exception) {
            common.failure(exception);
        }
        return null;
    }

    public static void callDataMethods(String string, String string2) {
        UserInfo[] userInfoArray = userinfo_map.values().toArray(new UserInfo[0]);
        for (int i = 0; i < userInfoArray.length; ++i) {
            UserInfo userInfo = userInfoArray[i];
            try {
                common.ptod("ui.getInstance().getClass().getName(): " + userInfo.getInstance().getClass().getName());
                if (!userInfo.getInstance().getClass().getName().equals(string)) continue;
                userInfo.getInstance().passData(string2);
                continue;
            }
            catch (RuntimeException runtimeException) {
                common.where();
                return;
            }
        }
    }
}

