/*
 * Decompiled with CFR 0.152.
 */
package User;

import User.UserDeviceInfo;
import Vdb.Cmd_entry;
import Vdb.SD_entry;
import Vdb.SlaveJvm;
import Vdb.SlaveWorker;
import Vdb.WG_entry;
import Vdb.WT_task;
import Vdb.common;
import Vdb.ownmath;

public class WorkloadInfo {
    private static final String c = "Copyright (c) 2000, 2014, Oracle and/or its affiliates. All rights reserved.";
    private int distribution = 0;
    private WG_entry wg;
    private SD_entry sd;
    private long high_lba;
    private long first_starttime;
    private long interarrival;
    private int rd_pct;
    private int seekpct;
    private int[] xf_table;
    private boolean use_block_zero = false;
    private int calls_since_done = 0;
    private long last_start_delta = 0L;
    private UserDeviceInfo device_info;
    private Cmd_entry cmd = null;
    private boolean first_io = true;

    public WorkloadInfo(WG_entry wG_entry) {
        this.wg = wG_entry;
        this.sd = this.wg.sd_used;
        this.use_block_zero = this.sd.canWeUseBlockZero();
        this.distribution = SlaveWorker.work.distribution;
        this.rd_pct = (int)this.wg.readpct;
        this.seekpct = (int)this.wg.seekpct;
        this.interarrival = (long)this.wg.arrival;
        this.setXferTable(this.wg.getXfersizes());
        this.wg.suspend_fifo_use = true;
    }

    public SD_entry getSd() {
        return this.sd;
    }

    public int getDistribution() {
        return this.distribution;
    }

    public void setFirstStartDelta(long l) {
        this.first_starttime = this.last_start_delta = l;
    }

    public long getLastStartDelta() {
        return this.last_start_delta;
    }

    public void setInterArrivalTime(long l) {
        this.interarrival = l;
    }

    public long getInterArrivalTime() {
        return this.interarrival;
    }

    public int getRdPct() {
        return this.rd_pct;
    }

    public int getSeekPct() {
        return this.seekpct;
    }

    public void setDeviceInfo(UserDeviceInfo userDeviceInfo) {
        this.device_info = userDeviceInfo;
    }

    public UserDeviceInfo getDeviceInfo() {
        if (this.device_info == null) {
            common.failure("WorkloadInfo.getDeviceInfo(): info still null");
        }
        return this.device_info;
    }

    public void setNotEOF() {
        this.wg.add_io(this.cmd);
    }

    public void setEOF(long l) {
        this.wg.seq_eof = true;
        if (l == 0L) {
            this.wg.sequentials_lower();
        }
    }

    private void setXferTable(double[] dArray) {
        this.xf_table = new int[dArray.length];
        for (int i = 0; i < dArray.length; ++i) {
            this.xf_table[i] = (int)dArray[i];
        }
    }

    public int getXferSize() {
        int n;
        if (this.xf_table.length == 1) {
            return this.xf_table[0];
        }
        int n2 = (int)(ownmath.zero_to_one() * 100.0);
        int n3 = 0;
        for (n = 0; n < this.xf_table.length && n2 >= (n3 += this.xf_table[n + 1]); n += 2) {
        }
        int n4 = this.xf_table[n];
        return n4;
    }

    public int getAverageXferSize() {
        int n;
        if (this.xf_table.length == 1) {
            return this.xf_table[0];
        }
        int n2 = 0;
        for (n = 0; n < this.xf_table.length; n += 2) {
            n2 += this.xf_table[n] * this.xf_table[n + 1];
        }
        n = n2 / 100;
        n = n + 511 & 0xFFFFFE00;
        return n;
    }

    public boolean readOrWrite() {
        boolean bl;
        if (this.rd_pct == 100) {
            bl = true;
        } else if (this.rd_pct == 0) {
            bl = false;
        }
        bl = ownmath.zero_to_one() * 100.0 < (double)this.rd_pct;
        return bl;
    }

    public long calculateNextDelta() {
        long l;
        if (this.getDistribution() == 0) {
            l = (long)ownmath.exponential(this.getInterArrivalTime());
            if (l > 180000000L) {
                l = 180000000L;
            }
        } else if (this.getDistribution() == 1) {
            l = (long)ownmath.uniform(0.0, this.getInterArrivalTime() * 2L);
            if (l > 1000000L) {
                l = 1000000L;
            }
        } else {
            l = this.getInterArrivalTime();
        }
        return l;
    }

    public boolean scheduleIO(long l, int n, boolean bl) {
        return this.scheduleIO(this.calculateNextDelta(), l, n, bl);
    }

    public boolean scheduleIO() {
        return this.scheduleIO(this.calculateNextDelta(), 0L, 0, true);
    }

    public boolean scheduleIO(long l) {
        return this.scheduleIO(l, 0L, 0, true);
    }

    public boolean scheduleIO(long l, long l2, int n, boolean bl) {
        this.cmd = new Cmd_entry();
        this.cmd.delta_tod = this.last_start_delta += l;
        this.cmd.cmd_lba = l2;
        this.cmd.cmd_xfersize = n;
        this.cmd.cmd_wg = this.wg;
        this.cmd.sd_ptr = this.getSd();
        this.cmd.cmd_read_flag = bl;
        this.cmd.cmd_hit = false;
        this.cmd.cmd_rand = true;
        this.cmd.jni_index = this.wg.jni_index_list.get((int)0).jni_index;
        this.wg.add_io(this.cmd);
        try {
            if (this.cmd.cmd_wg == null) {
                common.failure("error2");
            }
            if (this.cmd.cmd_wg.fifo_to_wait == null) {
                common.failure("error1");
            }
            this.cmd.cmd_wg.fifo_to_wait.waitForRoom();
            this.cmd.cmd_wg.fifo_to_wait.put(this.cmd);
        }
        catch (InterruptedException interruptedException) {
            return false;
        }
        if (this.first_io) {
            this.addRuningWorkload();
        }
        if (SlaveJvm.isWorkloadDone()) {
            if (this.calls_since_done++ > 100) {
                common.failure("WorkloadInfo.scheduleIO(): continued calls beyond 'end of run'");
            } else {
                return false;
            }
        }
        return true;
    }

    public boolean waitUntilEmpty() {
        this.cmd.cmd_wg.fifo_to_wait.waitUntilEmpty();
        return true;
    }

    public void drainQueue() {
        this.cmd.cmd_wg.fifo_to_wait.drainFifo();
    }

    public void setStartingWorkload() {
        if (!this.wg.suspend_fifo_use) {
            common.failure("WorkloadInfo.openWorkloadFifo(): recursive call");
        }
        this.wg.suspend_fifo_use = false;
        WT_task.buildFifoSearchList();
        this.first_io = false;
    }

    public void addRuningWorkload() {
        this.setStartingWorkload();
    }
}

