/*
 * Decompiled with CFR 0.152.
 */
package Utils;

import Utils.Bin;
import Utils.Semaphore;
import Utils.common;
import Utils.printf;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;

public class AsyncZip
extends Thread {
    private static final String c = "Copyright (c) 2000, 2012, Oracle and/or its affiliates. All rights reserved.";
    private String fname = null;
    private int file_number = 0;
    private boolean reading = true;
    private BufferedInputStream zip_in_stream = null;
    private GZIPOutputStream zip_out_stream = null;
    private int PIPE_LENGTH = 8;
    private Semaphore sema_get_slot = new Semaphore(0L);
    private Semaphore sema_put_slot = new Semaphore(this.PIPE_LENGTH);
    private ByteBuffer[] pipe = new ByteBuffer[this.PIPE_LENGTH];
    private int get_slot = 0;
    private int put_slot = 0;
    private double total_bytes = 0.0;
    private static int DEFAULT_LEVEL = 4;
    private boolean report_async_results = true;

    public AsyncZip(String string, boolean bl) {
        this.fname = new File(string).getAbsolutePath();
        this.reading = bl;
        try {
            if (this.reading) {
                this.createZipInStream();
            } else {
                this.createZipOutStream();
            }
        }
        catch (Exception exception) {
            common.ptod("Error while (un) compressing file: " + this.fname);
            Vdb.common.failure(exception);
        }
    }

    public void setReport(boolean bl) {
        this.report_async_results = bl;
    }

    private boolean createZipInStream() throws Exception {
        if (this.file_number == 0) {
            BufferedInputStream bufferedInputStream = new BufferedInputStream(new FileInputStream(this.fname));
            DataInputStream dataInputStream = new DataInputStream(bufferedInputStream);
            this.zip_in_stream = new BufferedInputStream(new GZIPInputStream(dataInputStream));
            ++this.file_number;
            return true;
        }
        ++this.file_number;
        String string = this.fname.endsWith(".gz") ? this.fname.substring(0, this.fname.lastIndexOf(".gz")) : this.fname.substring(0, this.fname.lastIndexOf(".jz"));
        if (!new File(string + ".jz" + this.file_number).exists()) {
            return false;
        }
        this.fname = string + ".jz" + this.file_number;
        BufferedInputStream bufferedInputStream = new BufferedInputStream(new FileInputStream(this.fname));
        DataInputStream dataInputStream = new DataInputStream(bufferedInputStream);
        this.zip_in_stream = new BufferedInputStream(new GZIPInputStream(dataInputStream));
        return true;
    }

    private void createZipOutStream() throws Exception {
        Object object;
        if (this.file_number == 0) {
            Bin.delete(this.fname);
            ++this.file_number;
            BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(this.fname));
            DataOutputStream dataOutputStream = new DataOutputStream(bufferedOutputStream);
            this.zip_out_stream = new GZIPOutputStream(dataOutputStream){
                {
                    this.def.setLevel(DEFAULT_LEVEL);
                }
            };
            return;
        }
        this.zip_out_stream.close();
        if (this.file_number == 1) {
            object = this.fname.substring(0, this.fname.indexOf(".gz")) + ".jz1";
            if (!new File(this.fname).renameTo(new File((String)object))) {
                Vdb.common.failure("Unable to rename " + this.fname + " to " + (String)object);
            }
            common.ptod("");
            common.ptod("Compression code in Java only allows 2Gigabytes of uncompressed data. ");
            common.ptod("Since we have more data than that the file will be renamed from ");
            common.ptod("a file name ending with '.gz' to ending with '.jz1'");
            common.ptod("and new files will be created ending with '.jz2, .jz3, etc'");
            common.ptod("These file will then be all concatenated at read time.");
            common.ptod("");
        }
        ++this.file_number;
        this.fname = this.fname.substring(0, this.fname.lastIndexOf(".")) + ".jz" + this.file_number;
        object = new BufferedOutputStream(new FileOutputStream(this.fname));
        DataOutputStream dataOutputStream = new DataOutputStream((OutputStream)object);
        this.zip_out_stream = new GZIPOutputStream(dataOutputStream){
            {
                this.def.setLevel(DEFAULT_LEVEL);
            }
        };
    }

    public static void setLevel(int n) {
        DEFAULT_LEVEL = n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void putAsyncBuffer(ByteBuffer byteBuffer) throws InterruptedException {
        this.sema_put_slot.acquire();
        AsyncZip asyncZip = this;
        synchronized (asyncZip) {
            this.pipe[this.put_slot++ % this.PIPE_LENGTH] = byteBuffer;
            this.sema_get_slot.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ByteBuffer getAsyncBuffer() throws InterruptedException {
        this.sema_get_slot.acquire();
        AsyncZip asyncZip = this;
        synchronized (asyncZip) {
            ByteBuffer byteBuffer = this.pipe[this.get_slot++ % this.PIPE_LENGTH];
            this.sema_put_slot.release();
            return byteBuffer;
        }
    }

    @Override
    public void run() {
        long l = 0x80000000L;
        long l2 = 0x200000L;
        try {
            if (!this.reading) {
                ByteBuffer byteBuffer;
                while ((byteBuffer = this.getAsyncBuffer()) != null) {
                    this.zip_out_stream.write(byteBuffer.array(), 0, byteBuffer.limit());
                    this.total_bytes += (double)byteBuffer.limit();
                    if (!(this.total_bytes > (double)(l - l2))) continue;
                    this.zip_out_stream.close();
                    this.reportCompression();
                    this.createZipOutStream();
                    this.total_bytes = 0.0;
                }
                this.zip_out_stream.close();
                this.reportCompression();
            } else {
                while (true) {
                    ByteBuffer byteBuffer;
                    int n;
                    if ((n = this.zip_in_stream.read((byteBuffer = ByteBuffer.allocate(65536)).array(), 0, byteBuffer.capacity())) < 0) {
                        this.zip_in_stream.close();
                        this.reportUnCompression(this.total_bytes);
                        if (!this.createZipInStream()) break;
                        this.total_bytes = 0.0;
                        continue;
                    }
                    byteBuffer.position(n);
                    this.total_bytes += (double)n;
                    byteBuffer.flip();
                    this.putAsyncBuffer(byteBuffer);
                }
                this.putAsyncBuffer(null);
            }
        }
        catch (InterruptedException interruptedException) {
        }
        catch (Exception exception) {
            common.ptod("AsyncZip error; filename: " + this.fname);
            Vdb.common.failure(exception);
        }
        catch (Throwable throwable) {
            Vdb.common.abnormal_term(throwable);
        }
    }

    public void close() throws Exception {
        if (!this.reading) {
            this.zip_out_stream.close();
        }
    }

    public double getCompression() {
        double d = new File(this.fname).length();
        return d * 100.0 / this.total_bytes;
    }

    private void reportCompression() {
        if (this.report_async_results) {
            double d = new File(this.fname).length();
            printf printf2 = new printf("AsyncZip: Compression to file %s: in: %d; out: %d; compression: %.2f%%");
            printf2.add(this.fname);
            printf2.add(this.total_bytes);
            printf2.add(d);
            printf2.add(d * 100.0 / this.total_bytes);
            common.ptod(printf2.print());
        }
    }

    private void reportUnCompression(double d) {
        if (this.report_async_results) {
            double d2 = new File(this.fname).length();
            printf printf2 = new printf("AsyncZip: Uncompress of file %s; in: %d; out: %d; compression: %.2f%%");
            printf2.add(this.fname);
            printf2.add(d2);
            printf2.add(d);
            printf2.add(d2 * 100.0 / d);
            common.ptod(printf2.print());
        }
    }

    public static void main(String[] stringArray) throws Exception {
    }
}

