/*
 * Decompiled with CFR 0.152.
 */
package Utils;

import Utils.AsyncZip;
import Utils.Format;
import Utils.Fput;
import Utils.common;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.LongBuffer;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;
import java.util.Vector;

public class Bin {
    private static final String c = "Copyright (c) 2000, 2014, Oracle and/or its affiliates. All rights reserved.";
    private int array_offset = 0;
    private int bytes_left = 8;
    private long[] longs = new long[256];
    public byte record_type;
    public byte record_version;
    public static final byte DATE_RECORD = 1;
    public static final byte FIXED_RECORD = 2;
    public static final byte KIO_RECORD = 3;
    public static final byte TNF_RECORD = 4;
    public static final byte spare1 = 5;
    public static final byte STF_RECORD = 6;
    public static final byte CPU_RECORD = 7;
    public static final byte STRING_ARRAY = 31;
    public static final byte XFER_SIZES_RECORD = 32;
    public static final byte XFER_COUNTS_RECORD = 33;
    public static final byte XFER_BYTES_RECORD = 34;
    public static final byte SEQ_SIZES_RECORD = 35;
    public static final byte SEQ_COUNTS_RECORD = 36;
    public static final byte SEQ_STREAMS_RECORD = 37;
    public static final byte SEQ_BYTES_RECORD = 38;
    public static final byte NFS2_FIELDS = 39;
    public static final byte NFS2_RECORD = 40;
    public static final byte NFS3_FIELDS = 41;
    public static final byte NFS3_RECORD = 42;
    public static final byte NFS4_FIELDS = 43;
    public static final byte NFS4_RECORD = 44;
    public static final byte NAMED_HEADER = 45;
    public static final byte NAMED_FIELDS = 46;
    public static final byte NAMED_LONGS = 47;
    private Vector vector_data = null;
    private int vector_index = 0;
    private boolean vector_processing = false;
    private boolean opened_for_write;
    private String fname = "Bin Real time?";
    private boolean reached_eof = false;
    private long file_size = 0L;
    private long bytes_read = 0L;
    private AsyncZip asynczip = null;
    private WritableByteChannel write_channel = null;
    private ReadableByteChannel read_channel = null;
    private ByteBuffer bb = ByteBuffer.allocate(65536);
    private LongBuffer lb = this.bb.asLongBuffer();
    private int how_many_longs = 0;
    private boolean report_async_results = false;
    private static int MAX_ARRAY_LENGTH = 0x7FFFFF;
    private static long EYE_CATCHER = 61166L;
    private static Vector open_bin_files = new Vector(16, 0);

    public Bin(String string, String string2) {
        this(new File(string, string2).getAbsolutePath());
    }

    public Bin(String string) {
        this.fname = string;
        open_bin_files.addElement(this);
        if (open_bin_files.size() > 15000) {
            Vdb.common.failure("Too many (%d) Bin files currently open", open_bin_files.size());
        }
    }

    public boolean isEOF() {
        return this.reached_eof;
    }

    public void input() {
        this.opened_for_write = false;
        try {
            if (this.fname.endsWith(".gz") && !new File(this.fname).exists()) {
                this.fname = this.fname.substring(0, this.fname.indexOf(".gz"));
            }
            if (new File(this.fname + ".jz1").exists()) {
                this.fname = this.fname + ".jz1";
            }
            if (this.fname.endsWith("-")) {
                this.read_channel = Channels.newChannel(System.in);
                this.bb.rewind();
                this.readBuffer();
            } else if (!this.fname.endsWith(".gz") && !this.fname.endsWith(".jz1")) {
                File file = new File(this.fname);
                this.read_channel = new RandomAccessFile(file, "r").getChannel();
                this.bb.rewind();
                this.readBuffer();
            } else {
                this.asynczip = new AsyncZip(this.fname, !this.opened_for_write);
                this.asynczip.setReport(this.report_async_results);
                this.asynczip.start();
                this.bb.rewind();
                this.readBuffer();
            }
        }
        catch (Exception exception) {
            common.failure(exception);
        }
    }

    public void output() {
        this.opened_for_write = true;
        try {
            if (this.fname.endsWith("-")) {
                this.write_channel = Channels.newChannel(System.out);
            } else if (!this.fname.endsWith(".gz")) {
                this.write_channel = new FileOutputStream(this.fname).getChannel();
            } else {
                this.asynczip = new AsyncZip(this.fname, !this.opened_for_write);
                this.asynczip.setReport(this.report_async_results);
                this.asynczip.start();
                this.bb.rewind();
            }
            this.start_new_record();
        }
        catch (Exception exception) {
            common.ptod("Exception for file: " + this.fname);
            common.failure(exception);
        }
        Fput.chmod(this.fname);
    }

    public String getFileName() {
        return this.fname;
    }

    public void setAsyncReport(boolean bl) {
        this.report_async_results = bl;
        if (this.asynczip != null) {
            this.asynczip.setReport(this.report_async_results);
        }
    }

    public double getCompression() {
        return this.asynczip.getCompression();
    }

    public static boolean exists(String string) {
        if (string.indexOf(".bin") == -1) {
            common.failure("Bin.exists() method is only allowed for '.bin' files: " + string);
        }
        if (new File(string).exists()) {
            return true;
        }
        if (new File(string + ".gz").exists()) {
            return true;
        }
        if (!string.endsWith(".gz")) {
            return false;
        }
        string = string.substring(0, string.indexOf(".gz"));
        if (new File(string).exists()) {
            return true;
        }
        return new File(string + ".jz1").exists();
    }

    public int howFar() {
        if (this.opened_for_write) {
            return 0;
        }
        if (this.file_size == 0L) {
            return 0;
        }
        return (int)(this.bytes_read * 100L / this.file_size);
    }

    public void fake_input() {
        this.opened_for_write = false;
        this.vector_processing = true;
        this.start_new_record();
    }

    public void fake_output() {
        this.opened_for_write = true;
        this.vector_processing = true;
        this.start_new_record();
    }

    public boolean isFake() {
        return this.vector_processing;
    }

    public void set_vector_processing(Vector vector) {
        this.vector_data = vector;
        this.vector_index = 0;
    }

    public Vector getVector() {
        return common.assertit(this.vector_data);
    }

    private void start_new_record() {
        this.array_offset = 0;
        this.bytes_left = 0;
        this.longs[0] = EYE_CATCHER << 48;
        this.longs[1] = 0L;
    }

    private void put_type(char c) {
        this.longs[0] = this.longs[0] | (long)c << 32;
    }

    public void close() {
        if (!open_bin_files.remove(this)) {
            common.failure("Unable to remove Bin file: " + this);
        }
        if (this.vector_processing) {
            return;
        }
        try {
            if (this.opened_for_write) {
                this.writeBuffer();
                if (this.asynczip != null) {
                    this.asynczip.putAsyncBuffer(null);
                    this.asynczip.join();
                } else {
                    this.write_channel.close();
                }
            } else if (this.asynczip == null && this.read_channel != null) {
                this.read_channel.close();
            }
            if (this.asynczip != null) {
                this.asynczip.interrupt();
            }
            this.asynczip = null;
        }
        catch (Exception exception) {
            common.failure(exception);
        }
    }

    public static void closeAll() {
        while (open_bin_files.size() > 0) {
            Bin bin = (Bin)open_bin_files.firstElement();
            bin.close();
            open_bin_files.remove(bin);
        }
    }

    private void set_offset(int n) {
        if (this.bytes_left < n) {
            ++this.array_offset;
            this.bytes_left = 8;
            if (this.array_offset >= this.longs.length) {
                long[] lArray = this.longs;
                this.longs = new long[lArray.length * 2];
                System.arraycopy(lArray, 0, this.longs, 0, lArray.length);
                common.ptod("extending Bin array from " + lArray.length + " to " + this.longs.length);
            }
            if (this.opened_for_write) {
                this.longs[this.array_offset] = 0L;
            }
        } else if (n == 4) {
            if ((this.bytes_left & 3) != 0) {
                this.bytes_left &= 0xFFFFFFFC;
            }
        } else if (n == 2) {
            if ((this.bytes_left & 1) != 0) {
                this.bytes_left &= 0xFFFFFFFE;
            }
        } else if (n != 1 && n != 8) {
            common.failure("Unexpected byte count: " + n);
        }
    }

    public void put_long(long l) {
        this.set_offset(8);
        this.longs[this.array_offset] = l;
        this.bytes_left -= 8;
    }

    public void put_int(int n) {
        this.set_offset(4);
        int n2 = (this.bytes_left - 4) * 8;
        int n3 = this.array_offset;
        this.longs[n3] = this.longs[n3] | (long)n << n2;
        this.bytes_left -= 4;
    }

    public void put_short(short s) {
        this.set_offset(2);
        int n = (this.bytes_left - 2) * 8;
        int n2 = this.array_offset;
        this.longs[n2] = this.longs[n2] | (long)s << n;
        this.bytes_left -= 2;
    }

    public void put_char(char c) {
        this.set_offset(2);
        int n = (this.bytes_left - 2) * 8;
        int n2 = this.array_offset;
        this.longs[n2] = this.longs[n2] | (long)c << n;
        this.bytes_left -= 2;
    }

    public void put_byte(byte by) {
        this.set_offset(1);
        int n = (this.bytes_left - 1) * 8;
        int n2 = this.array_offset;
        this.longs[n2] = this.longs[n2] | (long)by << n;
        --this.bytes_left;
    }

    public void put_string(String string) {
        if (string == null) {
            this.put_short((short)0);
            return;
        }
        if (string.length() > Short.MAX_VALUE) {
            common.failure("Input data length larger than 32767 bytes: " + string);
        }
        this.put_short((short)string.length());
        for (int i = 0; i < string.length(); ++i) {
            this.put_char(string.charAt(i));
        }
    }

    public void copyTo(Bin bin) {
        if (this.longs.length > bin.longs.length) {
            long[] lArray = bin.longs;
            bin.longs = new long[this.longs.length + 256];
            common.ptod("extending Bin array from " + lArray.length + " to " + bin.longs.length);
        }
        bin.start_new_record();
        System.arraycopy(this.longs, 1, bin.longs, 1, this.longs.length - 1);
        bin.array_offset = this.how_many_longs;
        bin.write_record(this.record_type, this.record_version);
    }

    public long get_long() {
        this.set_offset(8);
        long l = this.longs[this.array_offset];
        this.bytes_left -= 8;
        return l;
    }

    public int get_int() {
        this.set_offset(4);
        int n = (this.bytes_left - 4) * 8;
        int n2 = (int)(this.longs[this.array_offset] >>> n);
        this.bytes_left -= 4;
        return n2;
    }

    public short get_short() {
        this.set_offset(2);
        int n = (this.bytes_left - 2) * 8;
        short s = (short)(this.longs[this.array_offset] >>> n);
        this.bytes_left -= 2;
        return s;
    }

    public char get_char() {
        this.set_offset(2);
        int n = (this.bytes_left - 2) * 8;
        char c = (char)(this.longs[this.array_offset] >>> n);
        this.bytes_left -= 2;
        return c;
    }

    public byte get_byte() {
        this.set_offset(1);
        int n = (this.bytes_left - 1) * 8;
        byte by = (byte)(this.longs[this.array_offset] >>> n);
        --this.bytes_left;
        return by;
    }

    public String get_string() {
        int n = this.get_short();
        if (n == 0) {
            return null;
        }
        StringBuffer stringBuffer = new StringBuffer(n);
        for (int i = 0; i < n; ++i) {
            stringBuffer.append(this.get_char());
        }
        return stringBuffer.toString();
    }

    public void write_record(byte by, byte by2) {
        this.put_type((char)(by << 8 | by2));
        this.set_offset(8);
        long l = this.array_offset;
        this.longs[0] = this.longs[0] | l;
        if (l > (long)MAX_ARRAY_LENGTH) {
            common.failure("Binary array length too long: " + l);
        }
        this.check_eyecatcher();
        if (this.vector_processing) {
            long[] lArray = new long[(int)l];
            System.arraycopy(this.longs, 0, lArray, 0, (int)l);
            this.vector_data.addElement(lArray);
            this.start_new_record();
            return;
        }
        try {
            if ((long)this.lb.remaining() < l) {
                this.writeBuffer();
            }
            this.lb.put(this.longs, 0, (int)l);
        }
        catch (IOException iOException) {
            common.failure(iOException);
        }
        this.start_new_record();
    }

    private void writeBuffer() throws IOException {
        this.bb.limit(this.lb.limit() * 8);
        this.bb.position(this.lb.position() * 8);
        this.bb.flip();
        if (this.asynczip == null) {
            if (this.write_channel != null) {
                this.write_channel.write(this.bb);
            }
        } else {
            try {
                this.asynczip.putAsyncBuffer(this.bb);
            }
            catch (InterruptedException interruptedException) {
                common.failure(interruptedException);
            }
            this.bb = ByteBuffer.allocate(65536);
            this.lb = this.bb.asLongBuffer();
        }
        this.lb.clear();
    }

    private boolean readBuffer() throws IOException {
        int n = 0;
        this.bb.position(this.lb.position() * 8);
        if (this.bb.position() > 0) {
            this.bb.compact();
        }
        do {
            if (this.asynczip == null) {
                n = this.read_channel.read(this.bb);
                this.bb.flip();
            } else {
                try {
                    this.bb = this.asynczip.getAsyncBuffer();
                }
                catch (InterruptedException interruptedException) {
                    common.failure(interruptedException);
                }
                n = this.bb != null ? this.bb.remaining() : -1;
            }
            if (n >= 0) continue;
            this.reached_eof = true;
            return false;
        } while (n == 0);
        this.lb = this.bb.asLongBuffer();
        return true;
    }

    public void flush() {
        try {
            if (this.opened_for_write) {
                this.writeBuffer();
            }
        }
        catch (IOException iOException) {
            common.failure(iOException);
        }
    }

    public boolean read_record() {
        long l = 0L;
        if (this.vector_processing) {
            if (this.vector_index >= this.vector_data.size()) {
                this.reached_eof = true;
                return false;
            }
            long[] lArray = (long[])this.vector_data.elementAt(this.vector_index++);
            this.how_many_longs = lArray.length;
            if (this.how_many_longs > this.longs.length) {
                this.longs = new long[this.how_many_longs + 512];
            }
            System.arraycopy(lArray, 0, this.longs, 0, this.how_many_longs);
            this.check_eyecatcher();
        } else {
            try {
                if (this.lb.remaining() < 1 && !this.readBuffer()) {
                    return false;
                }
                this.longs[0] = l = this.lb.get();
                this.bytes_read += 8L;
                if (this.bytes_read >= 60000L) {
                    // empty if block
                }
                this.how_many_longs = (int)l & 0xFFFFFF;
                this.check_eyecatcher();
                if (this.how_many_longs > this.longs.length) {
                    long[] lArray = this.longs;
                    this.longs = new long[this.how_many_longs];
                    this.longs[0] = l;
                    common.ptod("extending Bin array from " + lArray.length + " to " + this.longs.length);
                }
                if (this.lb.remaining() >= this.how_many_longs - 1) {
                    this.lb.get(this.longs, 1, this.how_many_longs - 1);
                } else {
                    for (int i = 1; i < this.how_many_longs; ++i) {
                        if (this.lb.remaining() < 1 && !this.readBuffer()) {
                            return false;
                        }
                        this.longs[i] = this.lb.get();
                    }
                }
                this.bytes_read += (long)((this.how_many_longs - 1) * 8);
            }
            catch (IOException iOException) {
                this.reached_eof = true;
                return false;
            }
        }
        this.record_type = (byte)(this.longs[0] >>> 40);
        this.record_version = (byte)(this.longs[0] >>> 32);
        this.array_offset = 0;
        this.bytes_left = 0;
        return true;
    }

    public void put_array(long[] lArray, int n) {
        this.put_array(lArray, n, 0);
    }

    public void put_array(long[] lArray, int n, int n2) {
        if (n > 127 || n2 > 127) {
            common.failure("Bin.put_array(): record type and version can be maximum 127");
        }
        this.put_int(lArray.length);
        for (int i = 0; i < lArray.length; ++i) {
            this.put_long(lArray[i]);
        }
        this.write_record((byte)n, (byte)n2);
    }

    public long[] get_long_array() {
        int n = this.get_int();
        long[] lArray = new long[n];
        for (int i = 0; i < n; ++i) {
            lArray[i] = this.get_long();
        }
        return lArray;
    }

    public void put_array(String string, int n) {
        String[] stringArray = new String[]{string};
        this.put_array(stringArray, n, 0);
    }

    public void put_array(String[] stringArray, int n) {
        this.put_array(stringArray, n, 0);
    }

    public void put_array(String[] stringArray, int n, int n2) {
        if (n > 127 || n2 > 127) {
            common.failure("Bin.put_array(): record type and version can be maximum 127");
        }
        this.put_int(stringArray.length);
        for (int i = 0; i < stringArray.length; ++i) {
            this.put_string(stringArray[i]);
        }
        this.write_record((byte)n, (byte)n2);
    }

    public String[] get_string_array() {
        int n = this.get_int();
        String[] stringArray = new String[n];
        for (int i = 0; i < n; ++i) {
            stringArray[i] = this.get_string();
        }
        return stringArray;
    }

    private void check_eyecatcher() {
        if (this.longs[0] >>> 48 != EYE_CATCHER) {
            common.failure("Bin.read_record(): the first 16 bits of the record must match the eye catcher: " + this.fname + " " + Format.f("(%04X) ", EYE_CATCHER) + Format.X(this.longs[0]));
        }
    }

    private void printBin() {
        for (int i = 0; i < 4; ++i) {
            System.out.print(Format.X(this.longs[i]));
        }
        System.out.println("");
    }

    public static void save_this_main(String[] stringArray) throws IOException {
        int n;
        int n2 = Integer.parseInt(stringArray[0]);
        Vector vector = new Vector(16, 0);
        Bin bin = new Bin("test.bin");
        bin.set_vector_processing(vector);
        bin.put_string("1234567");
        bin.put_string("123456");
        bin.put_string("12345");
        bin.put_string("1234");
        bin.put_string("123");
        bin.put_string("12");
        bin.put_string("1");
        for (n = 0; n < n2; ++n) {
            bin.put_byte((byte)(n & 0x7F));
        }
        bin.write_record((byte)5, (byte)5);
        bin.close();
        System.out.println("closed");
        bin = new Bin("test.bin");
        bin.set_vector_processing(vector);
        bin.read_record();
        common.ptod("string: " + bin.get_string());
        common.ptod("string: " + bin.get_string());
        common.ptod("string: " + bin.get_string());
        common.ptod("string: " + bin.get_string());
        common.ptod("string: " + bin.get_string());
        common.ptod("string: " + bin.get_string());
        common.ptod("string: " + bin.get_string());
        for (n = 0; n < n2; ++n) {
            byte by = bin.get_byte();
            if (by == (n & 0x7F)) continue;
            common.failure("bad contents, expected: " + n + " obtained: " + by);
        }
        bin.close();
    }

    public static void delete(String string) {
        File file = new File(string);
        string = file.getAbsolutePath();
        String string2 = new File(string).getParent();
        String string3 = new File(string).getName();
        if (string3.endsWith(".gz")) {
            string3 = string3.substring(0, string3.indexOf(".gz"));
        }
        new File(string2, string3 + ".gz").delete();
        new File(string2, string3).delete();
        String[] stringArray = new File(string2).list();
        for (int i = 0; stringArray != null && i < stringArray.length; ++i) {
            if (!stringArray[i].startsWith(string3 + ".jz") || new File(string2, stringArray[i]).delete()) continue;
            common.failure("Unable to delete file " + stringArray[i]);
        }
    }

    public static void compressBinFile(String string) {
        if (new File(string).length() == 0L) {
            return;
        }
        Bin bin = new Bin(string);
        Bin bin2 = new Bin(string + ".gz");
        bin.input();
        bin2.output();
        while (bin.read_record()) {
            bin.copyTo(bin2);
        }
        bin.close();
        bin2.close();
        new File(string).delete();
        common.ptod("Compressed file " + string);
    }

    public static void main(String[] stringArray) {
        Bin.compressBinFile(stringArray[0]);
    }
}

