/*
 * Decompiled with CFR 0.152.
 */
package Utils;

import Utils.Fget;
import Utils.common;
import java.io.File;

public class ClassPath {
    private static final String c = "Copyright (c) 2000, 2012, Oracle and/or its affiliates. All rights reserved.";
    private static String classpath_directory_name = ClassPath.load_classpath_dir();

    public static String load_classpath_dir() {
        String string;
        String string2 = System.getProperty("java.class.path");
        String string3 = string = common.onWindows() ? ";" : ":";
        if (string2.indexOf(string) != -1) {
            string2 = string2.substring(0, string2.indexOf(string));
        }
        try {
            classpath_directory_name = new File(string2).getCanonicalPath();
        }
        catch (Exception exception) {
            common.failure(exception);
        }
        if (classpath_directory_name.endsWith(".jar")) {
            classpath_directory_name = new File(classpath_directory_name).getParent();
        }
        if (!classpath_directory_name.endsWith(File.separator)) {
            classpath_directory_name = classpath_directory_name + File.separator;
        }
        if (classpath_directory_name.indexOf(File.separator + "classes" + File.separator) != -1) {
            String string4 = classpath_directory_name;
            string4 = string4.substring(0, string4.indexOf(File.separator + "classes" + File.separator));
            classpath_directory_name = string4 + File.separator;
        }
        return classpath_directory_name;
    }

    public static String classPath() {
        return classpath_directory_name;
    }

    public static String classPath(String string) {
        return classpath_directory_name + string;
    }

    public static String wholePath() {
        return System.getProperty("java.class.path");
    }

    public static void reportVdbenchScript() {
        if (common.onWindows()) {
            String string = ClassPath.classPath("vdbench.bat");
            if (!new File(string).exists()) {
                common.plog("Unable to find file " + string);
                return;
            }
            common.plog("");
            common.plog("reportVdbenchScript() contents of " + string + ": ");
            Fget fget = new Fget(string);
            String string2 = null;
            while ((string2 = fget.get()) != null) {
                if ((string2 = string2.trim()).length() <= 0 || string2.startsWith("rem")) continue;
                common.plog(string2);
            }
            fget.close();
        } else {
            String string = ClassPath.classPath("vdbench");
            if (!new File(string).exists()) {
                common.plog("Unable to find file " + string);
                return;
            }
            common.plog("");
            common.plog("reportVdbenchScript() contents of " + string + ": ");
            Fget fget = new Fget(string);
            String string3 = null;
            while ((string3 = fget.get()) != null) {
                if ((string3 = string3.trim()).length() <= 0 || string3.startsWith("#")) continue;
                common.plog(string3);
            }
            fget.close();
        }
    }
}

