/*
 * Decompiled with CFR 0.152.
 */
package Utils;

import Utils.Lookup;
import Utils.LookupAnchor;
import Utils.common;
import java.io.Serializable;
import java.util.Date;

public class NamedData
implements Serializable {
    private static final String c = "Copyright (c) 2000, 2012, Oracle and/or its affiliates. All rights reserved.";
    private LookupAnchor instance_anchor = null;
    private long last_ts = 0L;
    private long elapsed = 0L;
    private long[] counters = null;
    private int seqno = tcounter++;
    private static int tcounter = 0;
    private static String current_new_label = null;

    public NamedData() {
    }

    public NamedData(LookupAnchor lookupAnchor) {
        this.instance_anchor = lookupAnchor;
        this.counters = new long[lookupAnchor.getFieldCount()];
    }

    public static synchronized NamedData newInstance(String string) {
        String string2 = string;
        if (string.startsWith("Utils.NamedData")) {
            LookupAnchor lookupAnchor = LookupAnchor.findAnchor(string);
            if (lookupAnchor == null) {
                lookupAnchor = new LookupAnchor(string);
            }
            NamedData namedData = new NamedData(lookupAnchor);
            return namedData;
        }
        if (string.indexOf("/") != -1) {
            string2 = string.substring(0, string.indexOf("/"));
            current_new_label = string.substring(string.indexOf("/") + 1);
        }
        try {
            return (NamedData)Class.forName(string2).newInstance();
        }
        catch (ClassNotFoundException classNotFoundException) {
            common.failure(classNotFoundException);
        }
        catch (InstantiationException instantiationException) {
            common.ptod("This error can happen if the Class being instantiated ");
            common.ptod("does not have a 'blank' instantiation defined, ");
            common.ptod("e.getCause. public Vmstatdata() { };");
            common.failure(instantiationException);
        }
        catch (IllegalAccessException illegalAccessException) {
            common.failure(illegalAccessException);
        }
        return null;
    }

    public static String getCurrentNewLabel() {
        if (current_new_label == null) {
            common.failure("current_new_label may not be null");
        }
        return current_new_label;
    }

    public static void clearCurrentNewLabel() {
        current_new_label = null;
    }

    public String getAnchorName() {
        return this.instance_anchor.getAnchorName();
    }

    public void setAnchor(LookupAnchor lookupAnchor) {
        this.instance_anchor = lookupAnchor;
    }

    public void setCounters(long[] lArray) {
        this.counters = lArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void validateCounterLength() {
        if (this.instance_anchor.getFieldCount() > this.counters.length) {
            NamedData namedData = this;
            synchronized (namedData) {
                if (this.instance_anchor.getFieldCount() > this.counters.length) {
                    long[] lArray = new long[this.instance_anchor.getFieldCount()];
                    System.arraycopy(this.counters, 0, lArray, 0, this.counters.length);
                    this.counters = lArray;
                }
            }
        }
    }

    public double getTotal() {
        double d = 0.0;
        for (int i = 0; i < this.counters.length; ++i) {
            d += (double)this.counters[i];
        }
        return d;
    }

    public double getCounter(Lookup lookup) {
        double d = 0.0;
        try {
            this.validateCounterLength();
            d = (double)this.counters[lookup.getIndex()] / lookup.getScale();
        }
        catch (Exception exception) {
            common.ptod("look: " + lookup);
            if (lookup != null) {
                common.ptod("title: " + lookup.getTitle());
            }
            common.failure(exception);
        }
        return d;
    }

    public void setCounter(Lookup lookup, long l) {
        this.validateCounterLength();
        this.counters[lookup.getIndex()] = l;
    }

    public long[] getCounters() {
        this.validateCounterLength();
        return this.counters;
    }

    public void setElapsed(long l) {
        this.elapsed = l;
    }

    public long getElapsed() {
        return this.elapsed;
    }

    public void setTime(long l) {
        this.last_ts = l;
    }

    public long getTime() {
        return this.last_ts;
    }

    public double getRate(int n) {
        this.validateCounterLength();
        return (double)this.counters[n] * 1000000.0 / (double)this.getElapsed();
    }

    public void delta(NamedData namedData, NamedData namedData2) {
        this.validateCounterLength();
        namedData.validateCounterLength();
        namedData2.validateCounterLength();
        if (namedData.counters.length != namedData2.counters.length) {
            common.failure("Unequal array lengths: " + namedData.counters.length + "/" + namedData2.counters.length);
        }
        this.counters = new long[namedData.counters.length];
        for (int i = 0; i < this.counters.length; ++i) {
            if (namedData.counters[i] >= namedData2.counters[i]) {
                this.counters[i] = namedData.counters[i] - namedData2.counters[i];
                continue;
            }
            this.counters[i] = namedData2.counters[i] - namedData.counters[i];
            common.ptod("NamedData.delta() overflow handled for " + this.instance_anchor.getFieldNames()[i]);
        }
        this.elapsed = namedData.last_ts - namedData2.last_ts;
        this.last_ts = namedData.last_ts;
    }

    public void accum(NamedData namedData) {
        this.validateCounterLength();
        namedData.validateCounterLength();
        if (this.counters == null) {
            this.counters = new long[namedData.counters.length];
        }
        for (int i = 0; i < this.counters.length; ++i) {
            int n = i;
            this.counters[n] = this.counters[n] + namedData.counters[i];
        }
        this.elapsed += namedData.elapsed;
        this.last_ts = namedData.last_ts;
    }

    public long[] export() {
        long[] lArray = new long[this.counters.length + 2];
        lArray[0] = this.last_ts;
        lArray[1] = this.elapsed;
        System.arraycopy(this.counters, 0, lArray, 2, this.counters.length);
        return lArray;
    }

    public void emport(long[] lArray) {
        this.counters = new long[lArray.length - 2];
        this.last_ts = lArray[0];
        this.elapsed = lArray[1];
        System.arraycopy(lArray, 2, this.counters, 0, this.counters.length);
    }

    public String[] getFieldTitles() {
        return this.instance_anchor.getFieldTitles();
    }

    public String[] getFieldNames() {
        return this.instance_anchor.getFieldNames();
    }

    public String toString() {
        String string = this.getAnchorName() + " " + this.seqno + " " + new Date(this.last_ts) + " " + this.elapsed;
        for (int i = 0; this.counters != null && i < this.counters.length; ++i) {
            string = string + " " + this.counters[i];
        }
        return string;
    }

    public Lookup getLookupForField(String string) {
        return this.instance_anchor.getLookupForField(string);
    }

    public int obsolete_getIndexForField(String string) {
        return this.instance_anchor.getLookupForField(string).getIndex();
    }

    public void validateLookupTable(String[] stringArray) {
        this.instance_anchor.validateLookupTable(stringArray);
    }

    public LookupAnchor getAnchor() {
        return this.instance_anchor;
    }

    public void parseNamedData(String string) {
        String string2;
        String[] stringArray;
        String string3;
        String[] stringArray2;
        if (string.indexOf("*") == -1) {
            common.failure("Invalid data syntax: " + string);
        }
        if ((stringArray2 = (string3 = string.substring(0, string.indexOf("*")).trim()).indexOf("$") == -1 ? string3.split(" +") : string3.split("\\$")).length != (stringArray = (string2 = string.substring(string.indexOf("*") + 1).trim()).split(" +")).length) {
            common.ptod("fields.length:   " + stringArray2.length);
            common.ptod("field_string:    " + string3);
            common.ptod("counters.length: " + stringArray.length);
            common.ptod("counter_string:  " + string2);
            common.failure("Unequal token count. Receiving more labels than expected");
        }
        this.validateLookupTable(stringArray2);
        for (int i = 0; i < stringArray2.length; ++i) {
            Lookup lookup = this.getLookupForField(stringArray2[i]);
            if (lookup == null) {
                common.ptod("Lookup missing for field: " + stringArray2[i]);
            }
            if (!this.instance_anchor.useDoubles()) {
                if (stringArray[i].indexOf(".") == -1) {
                    this.setCounter(lookup, Long.parseLong(stringArray[i]));
                    continue;
                }
                this.setCounter(lookup, (long)Double.parseDouble(stringArray[i]));
                continue;
            }
            this.setCounter(lookup, (long)(Double.parseDouble(stringArray[i]) * 1000.0));
        }
    }
}

