/*
 * Decompiled with CFR 0.152.
 */
package Utils;

public class Semaphore {
    private static final String c = "Copyright (c) 2000, 2012, Oracle and/or its affiliates. All rights reserved.";
    protected long permits_;
    int waiters = 0;

    public Semaphore(long l) {
        this.permits_ = l;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void acquire() throws InterruptedException {
        Semaphore semaphore = this;
        synchronized (semaphore) {
            try {
                while (this.permits_ <= 0L) {
                    ++this.waiters;
                    this.wait();
                    --this.waiters;
                }
                --this.permits_;
            }
            catch (InterruptedException interruptedException) {
                this.notifyAll();
                throw interruptedException;
            }
        }
    }

    public boolean attempt(long l) throws InterruptedException {
        Semaphore semaphore = this;
        synchronized (semaphore) {
            if (this.permits_ > 0L) {
                --this.permits_;
                return true;
            }
            if (l <= 0L) {
                return false;
            }
            try {
                long l2 = System.currentTimeMillis();
                long l3 = l;
                do {
                    ++this.waiters;
                    this.wait(l3);
                    --this.waiters;
                    if (this.permits_ <= 0L) continue;
                    --this.permits_;
                    return true;
                } while ((l3 = l - (System.currentTimeMillis() - l2)) > 0L);
                return false;
            }
            catch (InterruptedException interruptedException) {
                this.notifyAll();
                throw interruptedException;
            }
        }
    }

    public synchronized void release() {
        ++this.permits_;
        if (this.waiters > 0) {
            this.notify();
        }
    }

    public synchronized long permits() {
        return this.permits_;
    }
}

