/*
 * Decompiled with CFR 0.152.
 */
package Utils;

import Utils.Format;
import Utils.common;
import java.util.StringTokenizer;
import java.util.Vector;

public class printf {
    private static final String c = "Copyright (c) 2000, 2012, Oracle and/or its affiliates. All rights reserved.";
    private Vector masks;
    public String text;
    private int index = 0;
    private static String double_mask = "$^&";

    public printf(String string) {
        string = common.replace(string, "%%", double_mask);
        StringTokenizer stringTokenizer = new StringTokenizer(string, "%");
        if (stringTokenizer.countTokens() == 0) {
            common.failure("printf of '" + string + "' failed; bad mask");
        }
        this.masks = new Vector(stringTokenizer.countTokens());
        this.text = "";
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            if (this.masks.size() > 0 || string.startsWith("%")) {
                string2 = "%" + string2;
            }
            if (string2.indexOf(double_mask) != -1) {
                string2 = common.replace(string2, double_mask, "%%");
            }
            this.masks.addElement(string2);
        }
    }

    public void add(int n) {
        String string = this.find_mask();
        this.text = this.text + Format.f(string, n);
    }

    public void add(long l) {
        String string = this.find_mask();
        this.text = this.text + Format.f(string, l);
    }

    public void add(double d) {
        String string = this.find_mask();
        this.text = this.text + Format.f(string, d);
    }

    public void add(String string) {
        String string2 = this.find_mask();
        this.text = this.text + Format.f(string2, string);
    }

    public void add(boolean bl) {
        String string = this.find_mask();
        this.text = this.text + Format.f(string, "" + bl);
    }

    public void leftTitle(String string) {
        String string2 = this.find_mask();
        String string3 = Format.f(string2, 0);
        this.text = this.text + Format.f("%-" + string3.length() + "s", string);
    }

    public void rightTitle(String string) {
        String string2 = this.find_mask();
        int n = 0;
        while (string2.endsWith(" ")) {
            string2 = string2.substring(0, string2.length() - 1);
            ++n;
        }
        String string3 = Format.f(string2.trim(), 0);
        this.text = this.text + Format.f("%" + string3.length() + "s", string) + Format.f("%" + n + "s", " ");
    }

    private String find_mask() {
        String string = null;
        while (this.index < this.masks.size()) {
            string = (String)this.masks.elementAt(this.index);
            if (string.indexOf("%") != -1) {
                ++this.index;
                break;
            }
            this.text = this.text + string;
            ++this.index;
        }
        if (string == null) {
            common.failure("printf find_mask(): not enough masks");
        }
        return string;
    }

    public String print() {
        String string = this.text;
        this.index = 0;
        this.text = "";
        return string;
    }

    public static void main2(String[] stringArray) {
        printf printf2 = new printf("   %7.2f   %7.2f      %7.2f");
        printf2.leftTitle("a234");
        printf2.leftTitle("b23");
        printf2.leftTitle("c2");
        common.ptod(printf2.print());
        printf2.add(1234.5);
        printf2.add(1234.6);
        printf2.add(1234.7);
        common.ptod(printf2.print());
        printf2.rightTitle("a234");
        printf2.rightTitle("b23");
        printf2.rightTitle("c2");
        common.ptod(printf2.print());
        printf2.add(1234.5);
        printf2.add(1234.6);
        printf2.add(1234.7);
        common.ptod(printf2.print());
    }
}

