/*
 * Decompiled with CFR 0.152.
 */
package Vdb;

import Utils.OS_cmd;
import Vdb.AuxReport;
import Vdb.FwdStats;
import Vdb.RD_entry;
import Vdb.Report;
import Vdb.Reporter;
import Vdb.SdStats;
import Vdb.Vdbmain;
import Vdb.common;
import java.util.StringTokenizer;

public class AuxExternal
extends AuxReport {
    private static final String c = "Copyright (c) 2000, 2013, Oracle and/or its affiliates. All rights reserved.";
    private String[] parms = null;
    private boolean disabled = false;
    private boolean no_output = false;
    private OS_cmd ocmd = null;
    private String[] blank_header = new String[]{"n/a", "n/a"};
    private String[] disabled_header = new String[]{"disabled", "disabled"};
    private String[] header1 = null;
    private String[] header2 = null;
    private String[] masks = null;
    private double[] data = null;
    private int[] widths = null;
    private String head1 = null;
    private String head2 = null;
    private static double free_bytes = -1.0;

    @Override
    public void parseParameters(String[] stringArray) {
        this.parms = stringArray;
        if (stringArray.length < 2) {
            common.failure("'auxreport=' must consist of a minimum of two parameters.");
        }
        if (stringArray.length > 2 && stringArray[2].equals("no_output")) {
            this.no_output = true;
        }
        if (!this.no_output) {
            this.obtainSummaryHeaders();
        }
    }

    @Override
    public void storeRunInfo(int n, int n2, int n3) {
        common.where();
    }

    @Override
    public String[] getSummaryHeaders() {
        if (this.no_output) {
            return new String[]{"", ""};
        }
        if (this.disabled) {
            return this.disabled_header;
        }
        return new String[]{this.head1, this.head2};
    }

    private void obtainSummaryHeaders() {
        Object object;
        int n;
        if (this.disabled) {
            return;
        }
        this.header1 = null;
        this.header2 = null;
        this.masks = null;
        String string = this.callScript("header1");
        String string2 = this.callScript("header2");
        String string3 = this.callScript("masks");
        if (string != null) {
            this.header1 = string.split(" +");
        }
        if (string2 != null) {
            this.header2 = string2.split(" +");
        }
        if (string3 != null) {
            this.masks = string3.split(" +");
        }
        if (this.header1 == null || this.header2 == null || this.masks == null) {
            this.disabled = true;
            return;
        }
        if (this.header1.length != this.header2.length) {
            common.ptod("'auxreport=' failure. header1 and header2 field count not equal (%d/%d)", this.header1.length, this.header2.length);
            this.disabled = true;
            return;
        }
        if (this.header1.length != this.masks.length) {
            common.ptod("'auxreport=' failure. header and mask count not equal (%d/%d)", this.header1.length, this.masks.length);
            this.disabled = true;
            return;
        }
        this.widths = new int[this.header1.length];
        for (n = 0; n < this.header1.length; ++n) {
            this.widths[n] = Math.max(this.header1[n].length(), this.header2[n].length());
        }
        for (n = 0; n < this.masks.length; ++n) {
            object = new StringTokenizer(this.masks[n], ".");
            if (((StringTokenizer)object).countTokens() == 1) {
                common.failure("AuxExternal: you must specify full field width in printf mask: " + this.masks[n]);
            }
            this.widths[n] = Math.max(this.widths[n], Integer.parseInt(((StringTokenizer)object).nextToken()));
        }
        for (n = 0; n < this.masks.length; ++n) {
            if (this.masks[n].startsWith("%")) continue;
            this.masks[n] = "%" + this.masks[n];
        }
        this.head1 = "";
        for (n = 0; n < this.header1.length; ++n) {
            object = "%" + this.widths[n] + "s ";
            this.head1 = this.head1 + String.format((String)object, this.header1[n]);
        }
        this.head2 = "";
        for (n = 0; n < this.header2.length; ++n) {
            object = "%" + this.widths[n] + "s ";
            this.head2 = this.head2 + String.format((String)object, this.header2[n]);
        }
    }

    private String callScript(String string) {
        try {
            String[] stringArray;
            Object object;
            int n;
            this.ocmd = new OS_cmd();
            this.ocmd.addQuot(this.parms[1]);
            this.ocmd.addText(string);
            int n2 = n = this.no_output ? 3 : 2;
            while (n < this.parms.length) {
                this.ocmd.addQuot(this.parms[n]);
                ++n;
            }
            if (Vdbmain.isWdWorkload()) {
                object = Report.getSummaryReport().getData().getIntervalSdStats();
                stringArray = Report.getSummaryReport().getData().getIntervalCpuStats();
                if (object != null) {
                    this.ocmd.addText(String.format("rd    %s", RD_entry.next_rd.rd_name));
                    this.ocmd.addText(String.format("iops  %.3f", ((SdStats)object).rate()));
                    this.ocmd.addText(String.format("resp  %.3f", ((SdStats)object).respTime()));
                    this.ocmd.addText(String.format("rresp %.3f", ((SdStats)object).readResp()));
                    this.ocmd.addText(String.format("wresp %.3f", ((SdStats)object).writeResp()));
                    this.ocmd.addText(String.format("max   %.3f", ((SdStats)object).respMax()));
                    this.ocmd.addText(String.format("std   %.3f", ((SdStats)object).resptime_std()));
                    if (stringArray != null) {
                        this.ocmd.addText(String.format("cpu     %.3f", stringArray.kernel_pct() + stringArray.user_pct()));
                        this.ocmd.addText(String.format("cpu_sys %.3f", stringArray.kernel_pct()));
                        this.ocmd.addText(String.format("cpu_usr %.3f", stringArray.user_pct()));
                    }
                }
            } else {
                object = Report.getSummaryReport().getData().getIntervalFwdStats();
                stringArray = Report.getSummaryReport().getData().getIntervalCpuStats();
                if (object != null) {
                    this.ocmd.addText(String.format("rd    %s", RD_entry.next_rd.rd_name));
                    this.ocmd.addText(String.format("iops  %.3f", ((FwdStats)object).getReqstdRate()));
                    this.ocmd.addText(String.format("resp  %.3f", ((FwdStats)object).getReqstdlResp()));
                    if (stringArray != null) {
                        this.ocmd.addText(String.format("cpu     %.3f", stringArray.kernel_pct() + stringArray.user_pct()));
                        this.ocmd.addText(String.format("cpu_sys %.3f", stringArray.kernel_pct()));
                        this.ocmd.addText(String.format("cpu_usr %.3f", stringArray.user_pct()));
                    }
                }
            }
            if (!this.ocmd.execute(false)) {
                this.ocmd.printStderr();
                this.ocmd.printStdout();
                common.ptod("'auxreport=' failure. Disabled.");
                this.disabled = true;
                return null;
            }
            object = null;
            for (String string2 : this.ocmd.getStdout()) {
                if ((string2 = string2.trim()).startsWith(string)) {
                    object = string2.substring(string2.indexOf(" ")).trim();
                    continue;
                }
                if (string2.startsWith("stdout")) {
                    common.ptod("Info from %s: %s", this.parms[1], string2);
                    continue;
                }
                common.plog("Info from %s: %s", this.parms[1], string2);
            }
            this.ocmd.printStderr();
            this.ocmd = null;
            if (object == null && !this.no_output) {
                common.failure("No response received from last AuxExternal call: " + string);
            }
            return object;
        }
        catch (Exception exception) {
            common.ptod("'auxreport=' failure. Disabled.");
            common.ptod(exception);
            this.disabled = true;
            return null;
        }
    }

    @Override
    public String getSummaryData() {
        if (this.no_output) {
            return "";
        }
        if (this.disabled) {
            return " disabled";
        }
        if (this.isShutdown()) {
            return " shutdown";
        }
        if (this.data == null) {
            return " no data yet";
        }
        try {
            String string = "";
            for (int i = 0; i < this.data.length; ++i) {
                string = string + String.format(this.masks[i], this.data[i]) + " ";
            }
            return string;
        }
        catch (Exception exception) {
            common.ptod("'auxreport=' error. Disabled.");
            common.ptod(exception);
            return null;
        }
    }

    @Override
    public String[] getReportHeader() {
        common.where();
        return null;
    }

    @Override
    public String getReportData() {
        common.where();
        return null;
    }

    @Override
    public void runStart() {
        common.where();
    }

    @Override
    public void collectIntervalData() {
        if (this.disabled) {
            return;
        }
        if (this.isShutdown()) {
            return;
        }
        try {
            if (this.ocmd != null) {
                return;
            }
            String string = this.callScript("data");
            if (string == null) {
                return;
            }
            String[] stringArray = string.split(" +");
            String string2 = stringArray[0];
            if (string2.equals("shutdown_rd")) {
                if (!this.isShutdown()) {
                    this.setShutdown(true);
                    common.pboth("'auxreport=' requested shutdown of the current RD.", new Object[0]);
                }
                stringArray = string.substring(string.indexOf(" ")).trim().split(" +");
            } else if (string2.equals("shutdown")) {
                Reporter.monitor_final = true;
                if (!this.isShutdown()) {
                    this.setShutdown(true);
                    common.pboth("'auxreport=' requested shutdown of Vdbench.", new Object[0]);
                }
                stringArray = string.substring(string.indexOf(" ")).trim().split(" +");
            } else if (string2.equals("end_warmup")) {
                if (!this.isWarmupComplete()) {
                    this.setWarmupComplete(true);
                    common.pboth("'auxreport=' requested end to warmup.", new Object[0]);
                }
                stringArray = string.substring(string.indexOf(" ")).trim().split(" +");
            }
            if (this.no_output) {
                return;
            }
            if (stringArray.length != this.header1.length) {
                common.ptod("split.length: " + stringArray.length);
                common.ptod("header1.size() : " + this.header1.length);
                common.pboth("'auxreport=' The header column count and data count do not match.", new Object[0]);
                this.disabled = true;
                return;
            }
            this.data = new double[stringArray.length];
            for (int i = 0; i < stringArray.length; ++i) {
                this.data[i] = Double.parseDouble(stringArray[i]);
            }
        }
        catch (Exception exception) {
            common.ptod("'auxreport=' auxiliarly reporting is being disabled.");
            common.ptod(exception);
            this.disabled = true;
        }
    }
}

