/*
 * Decompiled with CFR 0.152.
 */
package Vdb;

import Vdb.ActiveFile;
import Vdb.BadKeyBlock;
import Vdb.BadSector;
import Vdb.Dedup;
import Vdb.ErrorLog;
import Vdb.SD_entry;
import Vdb.Validate;
import Vdb.common;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;

public class BadDataBlock {
    private static final String c = "Copyright (c) 2000, 2016, Oracle and/or its affiliates. All rights reserved.";
    private int key_blksize;
    private int data_blksize;
    private int key_blocks;
    private int key_blocks_added = 0;
    private int sectors_added = 0;
    private long file_lba;
    private String lun;
    private BadKeyBlock[] bad_keyblocks = null;
    public static Object reporting_lock = new Object();
    private static boolean header_printed = false;

    public BadDataBlock(BadSector badSector) {
        this.key_blksize = badSector.key_blksize;
        this.data_blksize = badSector.data_blksize;
        this.key_blocks = this.data_blksize / this.key_blksize;
        this.bad_keyblocks = new BadKeyBlock[this.key_blocks];
        this.file_lba = badSector.file_lba;
        this.lun = badSector.lun;
    }

    public void addSector(BadSector badSector) {
        BadKeyBlock badKeyBlock;
        if (badSector.key_blksize != this.key_blksize) {
            throw new RuntimeException("Unexpected key block size");
        }
        if (badSector.data_blksize != this.data_blksize) {
            throw new RuntimeException("Unexpected data block size");
        }
        if (this.bad_keyblocks[badSector.keyblock_in_datablock] == null) {
            this.bad_keyblocks[badSector.keyblock_in_datablock] = badKeyBlock = new BadKeyBlock();
            badKeyBlock.owning_bdb = this;
            ++this.key_blocks_added;
        }
        badKeyBlock = this.bad_keyblocks[badSector.keyblock_in_datablock];
        badSector.owning_bdb = this;
        badSector.owning_bkb = badKeyBlock;
        ++this.sectors_added;
        badKeyBlock.addSector(badSector);
    }

    public ArrayList<BadKeyBlock> getBadKeyBlocks() {
        ArrayList<BadKeyBlock> arrayList = new ArrayList<BadKeyBlock>(8);
        for (BadKeyBlock badKeyBlock : this.bad_keyblocks) {
            if (badKeyBlock == null) continue;
            arrayList.add(badKeyBlock);
        }
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean reportBadDataBlock(Object object, long l, long l2, long l3) {
        try {
            Object object2 = reporting_lock;
            synchronized (object2) {
                HashMap<Long, BadDataBlock> hashMap = null;
                SD_entry sD_entry = null;
                ActiveFile activeFile = null;
                if (object instanceof SD_entry) {
                    sD_entry = (SD_entry)object;
                    hashMap = sD_entry.bad_data_map;
                } else {
                    activeFile = (ActiveFile)object;
                    hashMap = activeFile.getFileEntry().getAnchor().bad_data_map;
                }
                BadDataBlock badDataBlock = hashMap.get(l + l2);
                if (badDataBlock == null) {
                    throw new Exception("Lba can not be found in bad data map: " + l);
                }
                hashMap.remove(l);
                if (Validate.isJournalRecoveryActive()) {
                    BadKeyBlock badKeyBlock = badDataBlock.getBadKeyBlocks().get(0);
                    BadSector object3 = badKeyBlock.getSectors().get(0);
                    boolean bl = false;
                    if ((object3.data_flag & Validate.FLAG_PENDING_READ) != 0) {
                        for (BadKeyBlock badKeyBlock2 : badDataBlock.bad_keyblocks) {
                            if (badKeyBlock2 == null || badKeyBlock.checkPendingKeyBlock(l, l2, l3)) continue;
                            bl = true;
                        }
                        if (!bl) {
                            ErrorLog.flush();
                            return true;
                        }
                    }
                }
                BadDataBlock.printHeaders();
                BadDataBlock.plog("", new Object[0]);
                BadDataBlock.plog("", new Object[0]);
                BadDataBlock.plog("", new Object[0]);
                if (sD_entry != null) {
                    BadDataBlock.plog("Corrupted data block for sd=%s,lun=%s; lba: %,d (0x%08x) xfersize=%d", sD_entry.sd_name, badDataBlock.lun, l, l, badDataBlock.data_blksize);
                } else {
                    BadDataBlock.plog("Corrupted data block for fsd=%s,file=%s; file lba: 0x%08x xfersize=%d", activeFile.getFileEntry().getAnchor().fsd_name_active, activeFile.getFileEntry().getFullName(), l, badDataBlock.data_blksize);
                }
                BadDataBlock.plog("", new Object[0]);
                BadDataBlock.plog("Data block has %d key block(s) of %d bytes each.", badDataBlock.key_blocks, badDataBlock.key_blksize);
                if (badDataBlock.key_blocks == badDataBlock.key_blocks_added) {
                    BadDataBlock.plog("All key blocks are corrupted.", new Object[0]);
                } else {
                    BadDataBlock.plog("%d of %d key blocks are corrupted.", badDataBlock.key_blocks_added, badDataBlock.key_blocks);
                }
                for (BadKeyBlock badKeyBlock : badDataBlock.getBadKeyBlocks()) {
                    badKeyBlock.reportBadKeyBlock();
                }
                ErrorLog.flush();
            }
        }
        catch (Exception exception) {
            common.ptod("Exception while reporting corrupted data.");
            common.ptod("Please report this problem");
            common.ptod(exception);
            common.ptod("Vdbench will abort AFTER these %d pending messages", ErrorLog.size());
            ErrorLog.flush();
            common.failure(exception);
        }
        return false;
    }

    public static BadSector getFirstBadSector(Object object, long l, long l2) {
        HashMap<Long, BadDataBlock> hashMap = null;
        SD_entry sD_entry = null;
        ActiveFile activeFile = null;
        if (object instanceof SD_entry) {
            sD_entry = (SD_entry)object;
            hashMap = sD_entry.bad_data_map;
        } else {
            activeFile = (ActiveFile)object;
            hashMap = activeFile.getFileEntry().getAnchor().bad_data_map;
        }
        BadDataBlock badDataBlock = hashMap.get(l + l2);
        if (badDataBlock == null) {
            common.failure("Lba can not be found in bad data map: " + l);
        }
        BadKeyBlock badKeyBlock = badDataBlock.getBadKeyBlocks().get(0);
        BadSector badSector = badKeyBlock.getSectors().get(0);
        return badSector;
    }

    public static void printHeaders() {
        if (header_printed) {
            return;
        }
        header_printed = true;
        BadDataBlock.plog("", new Object[0]);
        BadDataBlock.plog("Time of first corruption: " + BadSector.dv_df.format(new Date()), new Object[0]);
        BadDataBlock.plog("", new Object[0]);
        BadDataBlock.plog("At least one Data Validation error has been detected.                               ", new Object[0]);
        BadDataBlock.plog("", new Object[0]);
        BadDataBlock.plog("Terminology:                                                                        ", new Object[0]);
        BadDataBlock.plog("- Data block: a block of xfersize= bytes.                                           ", new Object[0]);
        BadDataBlock.plog("- Key block:  the smallest xfersize specified by the user which is the unit of      ", new Object[0]);
        BadDataBlock.plog("              data that Data Validation keeps track of.                             ", new Object[0]);
        BadDataBlock.plog("- Sector:     512 bytes of disk storage, regardless of actual storage sector size.  ", new Object[0]);
        BadDataBlock.plog("- Lba:        Logical Byte Address, not to be confused with Logical Block Address.  ", new Object[0]);
        BadDataBlock.plog("", new Object[0]);
        BadDataBlock.plog("", new Object[0]);
        BadDataBlock.plog("The output starts with a summary of a data block, followed by a summary of each     ", new Object[0]);
        BadDataBlock.plog("key block. If all sectors in a key block show a similar type of data corruption     ", new Object[0]);
        BadDataBlock.plog("only the FIRST sector of the key block will be reported.                            ", new Object[0]);
        BadDataBlock.plog("For all other cases, ALL sectors will be reported.                                  ", new Object[0]);
        BadDataBlock.plog("", new Object[0]);
        BadDataBlock.plog("Contents of the first 32 bytes of each sector:                                      ", new Object[0]);
        BadDataBlock.plog("", new Object[0]);
        if (!Dedup.isDedup()) {
            BadDataBlock.plog("Byte 0x00 -  0x07: Byte offset of this disk block ", new Object[0]);
            BadDataBlock.plog("Byte 0x08 -  0x0f: Timestamp: number of milliseconds since 1/1/1970 ", new Object[0]);
            BadDataBlock.plog("Byte 0x10        : Data Validation key from 1 - 126 ", new Object[0]);
            BadDataBlock.plog("Byte 0x11        : Checksum of timestamp ", new Object[0]);
            BadDataBlock.plog("Byte 0x12 -  0x13: Reserved ", new Object[0]);
            BadDataBlock.plog("Byte 0x14 -  0x1b: SD or FSD name in ASCII hexadecimal ", new Object[0]);
            BadDataBlock.plog("Byte 0x1c -  0x1f: Owner ID when written ", new Object[0]);
            if (!Validate.isCompression()) {
                BadDataBlock.plog("Byte 0x20 - 0x1ff: 480 bytes of LFSR based data", new Object[0]);
            } else {
                BadDataBlock.plog("Byte 0x20 - 0x1ff: 480 bytes of compression data pattern", new Object[0]);
            }
        } else {
            BadDataBlock.plog("For unique blocks, dedupacross=yes:", new Object[0]);
            BadDataBlock.plog("Byte 0x00 -  0x07: Byte offset of this disk block", new Object[0]);
            BadDataBlock.plog("Byte 0x08 -  0x0f: Timestamp: number of milliseconds since 1/1/1970", new Object[0]);
            BadDataBlock.plog("Byte 0x10        : Data Validation key from 1 - 126", new Object[0]);
            BadDataBlock.plog("Byte 0x11        : Checksum of timestamp", new Object[0]);
            BadDataBlock.plog("Byte 0x12 -  0x13: Reserved", new Object[0]);
            BadDataBlock.plog("Byte 0x14 -  0x1b: SD or FSD name in ASCII hexadecimal", new Object[0]);
            BadDataBlock.plog("Byte 0x1c -  0x1f: Owner ID when written ", new Object[0]);
            BadDataBlock.plog("Byte 0x20 - 0x1ff: 480 bytes of compression data pattern", new Object[0]);
            BadDataBlock.plog("", new Object[0]);
            BadDataBlock.plog("For duplicate blocks:", new Object[0]);
            BadDataBlock.plog("Byte 0x00 -  0x07: Vdbench calculated dedup set", new Object[0]);
            BadDataBlock.plog("Byte 0x08 - 0x1ff: 504 bytes of compression data pattern", new Object[0]);
        }
        BadDataBlock.plog("", new Object[0]);
        BadDataBlock.plog("On the left:  the data that was expected ('.' marks unknown value).", new Object[0]);
        BadDataBlock.plog("On the right: the data that was found.", new Object[0]);
        BadDataBlock.plog("", new Object[0]);
        ErrorLog.flush();
    }

    public static void plog(String string, Object ... objectArray) {
        ErrorLog.add(String.format(string, objectArray), new Object[0]);
    }
}

