/*
 * Decompiled with CFR 0.152.
 */
package Vdb;

import Vdb.BadDataBlock;
import Vdb.BadSector;
import Vdb.Dedup;
import Vdb.DedupBitMap;
import Vdb.ErrorLog;
import Vdb.Native;
import Vdb.Validate;
import Vdb.common;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;

public class BadKeyBlock {
    private static final String c = "Copyright (c) 2000, 2016, Oracle and/or its affiliates. All rights reserved.";
    public BadDataBlock owning_bdb;
    public long dedup_set;
    public long key_lba;
    public int sectors;
    public int sectors_added;
    public BadSector[] bad_sectors = null;
    public long last_used_tod = -1L;
    public String last_used_txt;
    public String last_used_op;
    public long first_error_found = System.currentTimeMillis();
    private int dedup_set_printed = 0;
    public String fname;

    public void addSector(BadSector badSector) {
        if (this.bad_sectors == null) {
            this.bad_sectors = new BadSector[badSector.key_blksize / 512];
            this.key_lba = badSector.key_lba;
            this.sectors = badSector.key_blksize / 512;
            this.dedup_set = badSector.dedup_set;
            if (Validate.isStoreTime()) {
                this.last_used_tod = badSector.dv.getLastTimestamp(this.key_lba);
            }
            this.last_used_op = badSector.dv.getLastOperation(this.key_lba);
            this.last_used_txt = BadSector.dv_df.format(new Date(this.last_used_tod));
            this.fname = badSector.sd != null ? badSector.sd.sd_name : badSector.afe.getFileEntry().getFullName();
        }
        if (this.bad_sectors[badSector.sector_in_keyblock] != null) {
            throw new RuntimeException("Duplicate reporting of sector");
        }
        this.bad_sectors[badSector.sector_in_keyblock] = badSector;
        ++this.sectors_added;
    }

    public void reportBadKeyBlock() {
        block8: {
            block6: {
                block7: {
                    Iterator<BadSector> iterator;
                    BadSector badSector = this.getSectors().get(0);
                    BadKeyBlock.plog("Key block lba: 0x%08x", this.key_lba);
                    BadKeyBlock.plog("   Key block of %,d bytes has %d 512-byte sectors.", badSector.key_blksize, this.sectors);
                    if ((badSector.data_flag & Validate.FLAG_PENDING_REREAD) != 0) {
                        BadKeyBlock.plog("   The last key block write was pending during journal shutdown. ", new Object[0]);
                        BadKeyBlock.plog("   All sectors contained a valid 'before' key, but other errors ", new Object[0]);
                        BadKeyBlock.plog("   were found when the block was read and checked for a second time. ", new Object[0]);
                        BadKeyBlock.plog("", new Object[0]);
                    }
                    this.reportTimeLine();
                    if (Dedup.isDuplicate(badSector.dedup_set) && this.dedup_set_printed++ == 0 && (iterator = Dedup.reportDedupSetTimes(badSector.dedup_set)) != null) {
                        BadKeyBlock.plog("Timeline, in tod order, of all duplicates of this duplicate key block:", new Object[0]);
                        BadKeyBlock.plog("Note: info is for THIS slave only. Use the 'jvms=1' host parameter if needed.", new Object[0]);
                        BadKeyBlock.plog("Note: info may change during or after reporting because i/o may be ongoing!", new Object[0]);
                        Iterator object = ((ArrayList)((Object)iterator)).iterator();
                        while (object.hasNext()) {
                            String string = (String)object.next();
                            BadKeyBlock.plog(string, new Object[0]);
                        }
                        BadKeyBlock.plog("", new Object[0]);
                    }
                    if (this.sectors != this.sectors_added) break block6;
                    BadKeyBlock.plog("   All %d sectors in this key block are corrupted.", this.sectors);
                    if (!this.matchingErrorFlags()) break block7;
                    BadKeyBlock.plog("   All corruptions are of the same type: ", new Object[0]);
                    for (String string : badSector.getFlagText()) {
                        BadKeyBlock.plog("   ===> " + string, new Object[0]);
                    }
                    BadKeyBlock.plog("   Only the FIRST sector will be reported:", new Object[0]);
                    badSector.printOneSector();
                    if (badSector.dv.getLastTimestamp(this.key_lba) == 0L) break block8;
                    BadKeyBlock.plog("Time that this key block 0x%08x was last used for %s: %s", this.key_lba, badSector.dv.getLastOperation(this.key_lba), BadSector.dv_df.format(new Date(badSector.dv.getLastTimestamp(this.key_lba))));
                    break block8;
                }
                BadKeyBlock.plog("   Corruption types do not match. Reporting all sectors: ", new Object[0]);
                this.reportFlagCounts();
                for (BadSector badSector : this.getSectors()) {
                    badSector.printOneSector();
                }
                break block8;
            }
            BadKeyBlock.plog("   %d of %d sectors are corrupted.", this.sectors_added, this.sectors);
            BadKeyBlock.plog("   All %d corrupted sectors will be reported.", this.sectors_added);
            for (BadSector badSector : this.getSectors()) {
                badSector.printOneSector();
            }
        }
    }

    public boolean allMatching() {
        return this.sectors_added == this.sectors && this.matchingChecksums() && this.matchingDedupsets() && this.matchingErrorFlags() && this.matchingKeys() && this.validLbas() && this.matchingNames() && this.matchingTimestamps();
    }

    public boolean matchingErrorFlags() {
        BadSector badSector = this.getSectors().get(0);
        for (BadSector badSector2 : this.bad_sectors) {
            if (badSector.error_flag == badSector2.error_flag) continue;
            return false;
        }
        return true;
    }

    public boolean matchingTimestamps() {
        BadSector badSector = this.getSectors().get(0);
        for (BadSector badSector2 : this.bad_sectors) {
            if (badSector.getTimeStampRead() == badSector2.getTimeStampRead()) continue;
            return false;
        }
        return true;
    }

    public boolean matchingNames() {
        BadSector badSector = this.getSectors().get(0);
        for (BadSector badSector2 : this.bad_sectors) {
            if (badSector.getNameString().startsWith("garbage") || badSector2.getNameString().startsWith("garbage")) {
                return false;
            }
            if (badSector.getNameString().equals(badSector2.getNameString())) continue;
            return false;
        }
        return true;
    }

    public boolean matchingChecksums() {
        BadSector badSector = this.getSectors().get(0);
        for (BadSector badSector2 : this.bad_sectors) {
            if (badSector.getChecksum() == badSector2.getChecksum()) continue;
            return false;
        }
        return true;
    }

    public boolean matchingDedupsets() {
        BadSector badSector = this.getSectors().get(0);
        for (BadSector badSector2 : this.bad_sectors) {
            if (badSector.dedup_set == badSector2.dedup_set) continue;
            return false;
        }
        return true;
    }

    public boolean matchingKeys() {
        BadSector badSector = this.getSectors().get(0);
        for (BadSector badSector2 : this.bad_sectors) {
            if (badSector.getKey() == badSector2.getKey()) continue;
            return false;
        }
        return true;
    }

    public boolean validLbas() {
        for (BadSector badSector : this.bad_sectors) {
            if (badSector.getLba() == badSector.sector_lba) continue;
            return false;
        }
        return true;
    }

    public ArrayList<BadSector> getSectors() {
        ArrayList<BadSector> arrayList = new ArrayList<BadSector>(this.sectors_added);
        for (BadSector badSector : this.bad_sectors) {
            if (badSector == null) continue;
            arrayList.add(badSector);
        }
        if (arrayList.size() == 0) {
            throw new RuntimeException("No sectors found");
        }
        return arrayList;
    }

    private static void plog(String string, Object ... objectArray) {
        ErrorLog.add(String.format(string, objectArray), new Object[0]);
    }

    private void reportTimeLine() {
        BadSector badSector = this.getSectors().get(0);
        ArrayList<String> arrayList = new ArrayList<String>(8);
        BadKeyBlock.plog("   Timeline: ", new Object[0]);
        if (badSector.bad_checksum) {
            BadKeyBlock.plog("   No valid timestamp found in first corrupted sector", new Object[0]);
        }
        if (Validate.isStoreTime()) {
            if (Validate.isStoreTime() && this.last_used_tod == 0L) {
                BadKeyBlock.plog("   This key block has not been used (yet) during this vdbench test.", new Object[0]);
            } else if (Validate.isXferHistory()) {
                if (!Validate.isJournaling()) {
                    int n = badSector.dv.getWriteXfer(this.key_lba);
                    arrayList.add(String.format("%032d0001 %s Key block was last written as part of an xfersize=%d write request.", this.last_used_tod, this.last_used_txt, n));
                }
                arrayList.add(String.format("%032d0001 %s Key block was last %s. (Timestamp is taken just AFTER the actual read or write).", this.last_used_tod, this.last_used_txt, this.last_used_op));
            }
        }
        if (!badSector.bad_checksum && Dedup.isUnique(badSector.dedup_set)) {
            arrayList.add(String.format("%032d0000 %s Sector last written. (As found in the first corrupted sector, timestamp is taken just BEFORE the actual write).", badSector.getTimeStampRead(), badSector.getTimeStampText()));
        }
        if ((badSector.data_flag & Validate.FLAG_PENDING_READ) != 0) {
            BadKeyBlock.plog(">>>>>>> This key block was read because journal recovery determined a write was pending", new Object[0]);
        }
        String string = "n/a";
        if ((badSector.data_flag & Validate.FLAG_NORMAL_READ) != 0) {
            string = "workload requested read";
        } else if ((badSector.data_flag & Validate.FLAG_PRE_READ) != 0) {
            string = "read-before-write";
        } else if ((badSector.data_flag & Validate.FLAG_READ_IMMEDIATE) != 0) {
            string = "read-after-write";
        } else if ((badSector.data_flag & Validate.FLAG_PENDING_READ) != 0) {
            string = "pending-write-read";
        } else if ((badSector.data_flag & Validate.FLAG_PENDING_REREAD) != 0) {
            string = "pending-write-reread";
        }
        arrayList.add(String.format("%032d0002 %s Key block first found to be corrupted during a %s.", this.first_error_found, BadSector.dv_df.format(this.first_error_found), string));
        Collections.sort(arrayList);
        for (String string2 : arrayList) {
            BadKeyBlock.plog("   " + string2.substring(string2.indexOf(" ")).trim(), new Object[0]);
        }
        BadKeyBlock.plog("", new Object[0]);
    }

    public void reportFlagCounts() {
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        int n7 = 0;
        int n8 = 0;
        for (BadSector badSector : this.getSectors()) {
            if ((badSector.error_flag & BadSector.BAD_KEY) != 0) {
                ++n;
            }
            if ((badSector.error_flag & BadSector.BAD_CHECKSUM) != 0) {
                ++n2;
            }
            if ((badSector.error_flag & BadSector.BAD_LBA) != 0) {
                ++n3;
            }
            if ((badSector.error_flag & BadSector.BAD_NAME) != 0) {
                ++n4;
            }
            if ((badSector.error_flag & BadSector.BAD_DATA) != 0) {
                ++n5;
            }
            if ((badSector.error_flag & BadSector.BAD_COMP) != 0) {
                ++n6;
            }
            if ((badSector.error_flag & BadSector.BAD_DEDUPSET) != 0) {
                ++n7;
            }
            if ((badSector.error_flag & BadSector.BAD_ZERO) == 0) continue;
            ++n8;
        }
        BadKeyBlock.plog("   Error type counts:", new Object[0]);
        if (n != 0) {
            BadKeyBlock.plog("   %-40s %3d", "===> Data Validation Key miscompare:", n);
        }
        if (n2 != 0) {
            BadKeyBlock.plog("   %-40s %3d", "===> Checksum error on timestamp:", n2);
        }
        if (n3 != 0) {
            BadKeyBlock.plog("   %-40s %3d", "===> Logical byte address miscompare:", n3);
        }
        if (n4 != 0) {
            BadKeyBlock.plog("   %-40s %3d", "===> SD or FSD name miscompare:", n4);
        }
        if (n5 != 0) {
            BadKeyBlock.plog("   %-40s %3d", "===> Data miscompare:", n5);
        }
        if (n6 != 0) {
            BadKeyBlock.plog("   %-40s %3d", "===> Compression pattern miscompare:", n6);
        }
        if (n7 != 0) {
            BadKeyBlock.plog("   %-40s %3d", "===> Bad dedup set value:", n7);
        }
        if (n8 != 0) {
            BadKeyBlock.plog("   %-40s %3d", "===> Bad reserved field contents (mbz):", n8);
        }
    }

    public boolean checkPendingKeyBlock(long l, long l2, long l3) {
        BadSector badSector = this.getSectors().get(0);
        int n = badSector.dv.journal.before_map.pending_map.get(this.key_lba) & 0xFF;
        BadKeyBlock.plog("checkPendingKeyBlock for %s lba 0x%08x key 0x%02x bad_data_flag 0x%04x pending_flag 0x%02x", this.fname, l, badSector.key_expected, badSector.data_flag, n);
        int n2 = badSector.key_expected;
        int n3 = 0;
        if (n == 128) {
            n3 = 0;
        } else if (n == 130) {
            n3 = 126;
        } else if (n == 131) {
            common.ptod("proof that we have PENDING_KEY_ROLL_DEDUP");
            n3 = 2;
        } else if (n == 129) {
            n3 = n2 - 1;
        } else {
            common.failure("Invalid pending flag: 0x%02x", n);
        }
        long l4 = l + l2;
        long l5 = l4 / (long)badSector.key_blksize;
        DedupBitMap dedupBitMap = badSector.sd != null ? DedupBitMap.findUniqueBitmap("sd=" + badSector.sd.sd_name) : DedupBitMap.findUniqueBitmap("fsd=" + badSector.afe.getAnchor().fsd_name_active);
        boolean bl = true;
        if (Validate.isDedup()) {
            bl = badSector.dv.getDedup().getDedupPct() == 100.0 || dedupBitMap.isUnique(l5);
        }
        int n4 = this.countKeys(l3, badSector.key_blksize, n3, bl);
        int n5 = this.countKeys(l3, badSector.key_blksize, n2, bl);
        BadKeyBlock.plog("sectors: %d; before_key: %d; after_key: %d; before_keys: %d; after_keys: %d ", this.sectors, n3, n2, n4, n5);
        if (n == 128) {
            BadKeyBlock.plog("checkPendingKeyBlock for key lba 0x%08x key 0x%02x. This was the first write, results always unpredictable. Block set to 'unknown'", this.key_lba, badSector.key_expected);
            badSector.dv.dv_set(this.key_lba, 128);
            return true;
        }
        if (n4 == this.sectors) {
            BadKeyBlock.plog("checkPendingKeyBlock for key lba 0x%08x key 0x%02x. Write never completed, key set back to 0x%02x", this.key_lba, badSector.key_expected, n3);
            BadKeyBlock.plog("Key Block will be re-checked.", new Object[0]);
            badSector.dv.dv_set(this.key_lba, n3 | 0x80);
            if (badSector.dv.journal.before_map.pending_map.put(this.key_lba, (byte)-124) == null) {
                common.failure("Invalid pending state");
            }
            return true;
        }
        if (n5 == this.sectors) {
            BadKeyBlock.plog("checkPendingKeyBlock for lba 0x%08x key 0x%02x. All keys are valid, but there are other errors. Block will be marked in error.", l, n2);
            badSector.dv.dv_set(l, 127);
            return false;
        }
        BadKeyBlock.plog("checkPendingKeyBlock valid before/after keys: %d/%d out of %d sectors", n4, n5, this.sectors);
        BadKeyBlock.plog("checkPendingKeyBlock for lba 0x%08x key 0x%02x. Unacceptable mismatch between before/after keys. Block will be marked in error.", l, badSector.key_expected, n2);
        BadKeyBlock.plog("However, because this was a pending write this will not be counted as a FATAL error, but manual verification is highly recommended.", new Object[0]);
        BadKeyBlock.plog("Key values found: %s", this.createKeySequence(l3, badSector.key_blksize, bl));
        badSector.dv.dv_set(l, 127);
        return true;
    }

    private int countKeys(long l, int n, int n2, boolean bl) {
        int n3 = 0;
        int[] nArray = new int[n / 4];
        Native.buffer_to_array(nArray, l, n);
        for (int i = 0; i < this.sectors; ++i) {
            int n4 = i * 128;
            int n5 = bl ? nArray[n4 + 4] >> 24 : nArray[n4 + 0] >> 24;
            if (n5 != n2) continue;
            ++n3;
        }
        return n3;
    }

    private String createKeySequence(long l, int n, boolean bl) {
        String string = "";
        int[] nArray = new int[n / 4];
        Native.buffer_to_array(nArray, l, n);
        int n2 = Integer.MAX_VALUE;
        int n3 = Integer.MAX_VALUE;
        for (int i = 0; i < this.sectors; ++i) {
            int n4 = i * 128;
            int n5 = bl ? nArray[n4 + 4] >> 24 : nArray[n4 + 0] >> 24;
            if (n2 == Integer.MAX_VALUE) {
                n2 = n5;
                n3 = 1;
                continue;
            }
            if (n2 == n5) {
                ++n3;
                continue;
            }
            string = string + String.format("(%02x),%d ", n2, n3);
            n2 = n5;
            n3 = 1;
        }
        string = string + String.format("(%02x),%d ", n2, n3);
        return string;
    }
}

