/*
 * Decompiled with CFR 0.152.
 */
package Vdb;

import Utils.CommandOutput;
import Utils.Getopt;
import Utils.OS_cmd;
import Vdb.common;
import java.util.StringTokenizer;
import java.util.Vector;

public class BuildSds {
    private static final String c = "Copyright (c) 2000, 2012, Oracle and/or its affiliates. All rights reserved.";
    private static Vector paths;
    private static String partition;
    private static int sd_num;
    private static Vector luns;

    public static void main(String[] stringArray) {
        Getopt getopt;
        if (stringArray.length < 2) {
            common.ptod("");
            common.ptod("Usage: ./vdbench sds -px [-sx] path .....");
            common.ptod("");
            common.ptod("'-px' partition number, e.g. -p6, default 6");
            common.ptod("'-sx' starting sd number, default 1");
            common.ptod("");
            common.ptod("Example: ./vdbench sds -p6 -s1 c34 c35");
            common.failure("Invalid parameters. Fix and try again");
        }
        if (!(getopt = new Getopt(stringArray, "s:p:", 99)).isOK()) {
            common.failure("Parameter scan error");
        }
        getopt.print("BuilsSds");
        common.ptod("");
        if (getopt.check('p')) {
            partition = getopt.get_string();
        }
        if (getopt.check('s')) {
            sd_num = Integer.parseInt(getopt.get_string());
        }
        if ((paths = getopt.get_positionals()).size() == 0) {
            common.failure("No paths requested");
        }
        OS_cmd oS_cmd = new OS_cmd();
        oS_cmd.setOutputMethod(new CommandOutput(){

            @Override
            public boolean newLine(String string, String string2, boolean bl) {
                BuildSds.processLine(string, string2);
                return true;
            }
        });
        oS_cmd.addText("format << EOF");
        oS_cmd.execute();
        if (luns.size() == 0) {
            common.failure("No valid devices found.");
        }
        System.out.println("\n\n");
        for (int i = 0; i < luns.size(); ++i) {
            String string = (String)luns.elementAt(i);
            System.out.println("sd=sd" + sd_num++ + ",lun=/dev/rdsk/" + string + "s" + partition);
        }
        System.out.println("\n\n");
    }

    private static void processLine(String string, String string2) {
        if (string2.equals("stdout") && string.indexOf("<") != -1) {
            common.ptod(string2 + ": " + string);
            StringTokenizer stringTokenizer = new StringTokenizer(string);
            String string3 = stringTokenizer.nextToken();
            String string4 = stringTokenizer.nextToken();
            for (int i = 0; i < paths.size(); ++i) {
                String string5 = (String)paths.elementAt(i);
                if (!string4.startsWith(string5)) continue;
                luns.add(string4);
                break;
            }
        }
    }

    static {
        partition = "6";
        sd_num = 1;
        luns = new Vector(16, 0);
    }
}

