/*
 * Decompiled with CFR 0.152.
 */
package Vdb;

import User.ControlUsers;
import User.UserData;
import Utils.Semaphore;
import Vdb.Blocked;
import Vdb.CpuStats;
import Vdb.FileAnchor;
import Vdb.FwdReport;
import Vdb.FwdStats;
import Vdb.FwgRun;
import Vdb.FwgThread;
import Vdb.InfoFromHost;
import Vdb.InstancePointer;
import Vdb.Interval;
import Vdb.JniIndex;
import Vdb.Kstat_data;
import Vdb.Native;
import Vdb.NfsStats;
import Vdb.NwStats;
import Vdb.RD_entry;
import Vdb.Report;
import Vdb.ReportData;
import Vdb.Reporter;
import Vdb.SD_entry;
import Vdb.SdStats;
import Vdb.Slave;
import Vdb.SlaveJvm;
import Vdb.SlaveList;
import Vdb.SlaveStats;
import Vdb.SlaveWorker;
import Vdb.SocketMessage;
import Vdb.ThreadMonitor;
import Vdb.Timeout;
import Vdb.Validate;
import Vdb.Vdbmain;
import Vdb.WD_entry;
import Vdb.WG_entry;
import Vdb.WG_stats;
import Vdb.common;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Vector;

public class CollectSlaveStats
extends Thread {
    private static final String c = "Copyright (c) 2000, 2016, Oracle and/or its affiliates. All rights reserved.";
    private static Reporter reporter = null;
    private long request_sequence_number;
    private int requested_interval;
    private long interval_duration;
    private boolean last_interval;
    private Semaphore wait_for_last = null;
    private boolean some_data_returned = false;
    private SlaveStats[] data_from_slaves;
    private static long static_seqno = 0L;
    private static Vector<CollectSlaveStats> stats_pending_queue = new Vector(64, 0);
    private static Vector<CollectSlaveStats> reporting_queue = new Vector(8);
    private static Semaphore async_sema = new Semaphore(0L);
    public long expected_interval_end = 0L;
    public long expected_next_interval = 0L;
    public long start_send = 0L;
    public long last_receive = 0L;
    public long start_reporting = 0L;
    public long end_reporting = 0L;
    private static long last_permit_tod = 0L;
    private static Object just_one_test = new Object();

    public CollectSlaveStats(Reporter reporter) {
        CollectSlaveStats.reporter = reporter;
    }

    public CollectSlaveStats(int n, long l, boolean bl) {
        this.interval_duration = l;
        this.request_sequence_number = static_seqno++;
        this.requested_interval = n;
        this.last_interval = bl;
        this.data_from_slaves = new SlaveStats[SlaveList.getSlaveCount()];
        this.expected_interval_end = Interval.expected_interval_end;
        this.expected_next_interval = Interval.expected_next_interval;
        this.expected_interval_end -= Interval.getSeconds() * 1000L;
        this.expected_next_interval -= Interval.getSeconds() * 1000L;
        this.requestStatistics(bl);
    }

    public void requestStatistics(boolean bl) {
        long[] lArray;
        Slave slave;
        int n;
        boolean bl2;
        boolean bl3 = bl2 = this.requested_interval == Reporter.getWarmupIntervals();
        if (this.requested_interval == 1) {
            ReportData.clearAllTotalStats();
        }
        if (bl) {
            this.wait_for_last = new Semaphore(0L);
        }
        stats_pending_queue.addElement(this);
        for (n = 0; n < SlaveList.getSlaveCount(); ++n) {
            slave = SlaveList.getSlaveList().elementAt(n);
            if (slave.getCurrentWork() != null) continue;
            this.data_from_slaves[n] = new SlaveStats(this.request_sequence_number);
            this.data_from_slaves[n].owning_slave = slave;
            this.data_from_slaves[n].setSdStats(new SdStats[0]);
            lArray = this.data_from_slaves[n].getBlockCounters();
            for (int i = 0; i < lArray.length; ++i) {
                lArray[i] = 0L;
            }
        }
        this.start_send = System.currentTimeMillis();
        for (n = 0; n < SlaveList.getSlaveCount(); ++n) {
            slave = SlaveList.getSlaveList().elementAt(n);
            if (slave.getCurrentWork() == null) continue;
            lArray = new long[]{this.request_sequence_number, this.last_interval ? 1L : 0L, bl2 ? 1L : 0L};
            SocketMessage socketMessage = new SocketMessage(SocketMessage.REQUEST_SLAVE_STATISTICS);
            socketMessage.setData(lArray);
            slave.getSocket().putMessage(socketMessage);
        }
        if (Report.getAuxReport() != null) {
            Report.getAuxReport().collectIntervalData();
        }
    }

    public SlaveStats[] getDataFromSlaves() {
        return this.data_from_slaves;
    }

    public static SlaveStats getStatsForMaster(long l, boolean bl, boolean bl2) {
        SlaveStats slaveStats = new SlaveStats(l);
        if ((common.onSolaris() || common.onWindows() || common.onLinux()) && SlaveJvm.isFirstSlaveOnHost()) {
            slaveStats.setCpuStats(CpuStats.getNativeCpuStats());
            if (common.onSolaris() || common.onWindows()) {
                slaveStats.setKstatData(CollectSlaveStats.getAllKstatData());
            }
            if (common.onSolaris()) {
                NfsStats.getAllNfsDeltasFromKstat();
                slaveStats.setNfsData(NfsStats.getNfs3(), NfsStats.getNfs4());
            }
            if (common.onSolaris() && SlaveWorker.work.nw_monitor_now) {
                NwStats.loadStatistics();
                slaveStats.nw_stats = NwStats.getData();
            }
        }
        if (SlaveWorker.work.wgs_for_slave != null) {
            CollectSlaveStats.getSdStatistics(slaveStats, bl, bl2);
        } else {
            CollectSlaveStats.getFileSystemStatistics(slaveStats, bl, bl2);
        }
        return slaveStats;
    }

    private static void getSdStatistics(SlaveStats slaveStats, boolean bl, boolean bl2) {
        WG_stats.get_jni_statistics(bl, bl2);
        ArrayList<SdStats> arrayList = new ArrayList<SdStats>(64);
        for (int i = 0; i < SlaveWorker.work.wgs_for_slave.size(); ++i) {
            WG_entry wG_entry = SlaveWorker.work.wgs_for_slave.get(i);
            for (int j = 0; j < wG_entry.jni_index_list.size(); ++j) {
                JniIndex jniIndex = wG_entry.jni_index_list.get(j);
                jniIndex.dlt_stats.work_done = wG_entry.seq_eof;
                arrayList.add(jniIndex.dlt_stats);
                jniIndex.dlt_stats.sd_name = jniIndex.sd_name;
                jniIndex.dlt_stats.wd_name = jniIndex.wd_name;
            }
        }
        slaveStats.setSdStats(arrayList.toArray(new SdStats[0]));
        slaveStats.setThreadMonData(ThreadMonitor.getAllDeltas());
    }

    private static void getFileSystemStatistics(SlaveStats slaveStats, boolean bl, boolean bl2) {
        FwdStats fwdStats = new FwdStats();
        FwdStats fwdStats2 = new FwdStats();
        HashMap<String, FwdStats> hashMap = new HashMap<String, FwdStats>(32);
        HashMap<String, FwdStats> hashMap2 = new HashMap<String, FwdStats>(32);
        long l = 0L;
        long l2 = 0L;
        Vector vector = FwgRun.getThreads();
        for (int i = 0; i < vector.size(); ++i) {
            FwgThread fwgThread = (FwgThread)vector.elementAt(i);
            long l3 = fwgThread.permit_time - fwgThread.permit_last;
            l += l3;
            fwgThread.permit_last = fwgThread.permit_time;
            fwdStats2.delta(fwgThread.per_thread_stats, fwgThread.old_stats);
            fwdStats.accum(fwdStats2, false);
            fwdStats.permit_time += l3;
            ++fwdStats.permit_count;
            FwdStats fwdStats3 = (FwdStats)hashMap.get(fwgThread.fwg.fsd_name);
            if (fwdStats3 == null) {
                fwdStats3 = new FwdStats();
                hashMap.put(fwgThread.fwg.fsd_name, fwdStats3);
            }
            fwdStats3.accum(fwdStats2, false);
            fwdStats3.work_done = fwgThread.fwg.work_done;
            fwdStats3.permit_time += l3;
            ++fwdStats3.permit_count;
            FwdStats fwdStats4 = (FwdStats)hashMap2.get(fwgThread.fwg.getName());
            if (fwdStats4 == null) {
                fwdStats4 = new FwdStats();
                hashMap2.put(fwgThread.fwg.getName(), fwdStats4);
            }
            fwdStats4.accum(fwdStats2, false);
            fwdStats4.permit_time += l3;
            ++fwdStats4.permit_count;
            fwgThread.old_stats.copyStats(fwgThread.per_thread_stats);
        }
        slaveStats.permit_time = l;
        slaveStats.permit_threads = vector.size();
        slaveStats.setSlaveIntervalStats(fwdStats, hashMap, hashMap2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void receiveStats(Slave slave, SlaveStats slaveStats) {
        Object object = just_one_test;
        synchronized (object) {
            CollectSlaveStats collectSlaveStats = null;
            boolean bl = false;
            for (int i = 0; i < stats_pending_queue.size(); ++i) {
                collectSlaveStats = stats_pending_queue.elementAt(i);
                if (collectSlaveStats.request_sequence_number != slaveStats.getNumber()) continue;
                bl = true;
                collectSlaveStats.last_receive = System.currentTimeMillis();
                break;
            }
            if (!bl) {
                common.failure("CollectSlaveStats sequence number not found: " + slaveStats.getNumber());
            }
            slaveStats.owning_slave = slave;
            CollectSlaveStats collectSlaveStats2 = collectSlaveStats;
            synchronized (collectSlaveStats2) {
                int n = slave.getSlaveNumber();
                if (collectSlaveStats.data_from_slaves[n] != null) {
                    common.failure("CollectSlaveStats returned twice");
                }
                collectSlaveStats.data_from_slaves[n] = slaveStats;
                for (int i = 0; i < collectSlaveStats.data_from_slaves.length; ++i) {
                    if (collectSlaveStats.data_from_slaves[i] != null) continue;
                    return;
                }
                collectSlaveStats.start_reporting = System.currentTimeMillis();
                stats_pending_queue.remove(collectSlaveStats);
                reporting_queue.add(collectSlaveStats);
                async_sema.release();
            }
        }
    }

    private void addDataToSlave(Slave slave, SlaveStats slaveStats) {
        Object object;
        if (Vdbmain.isWdWorkload()) {
            this.storeSlaveSdStats(slave, slaveStats);
            slave.accumMonData(slaveStats.tmonitor_deltas);
        } else {
            if (RD_entry.next_rd.getOrPutUsed()) {
                slaveStats.getSlaveIntervalStats().r_bytes = NwStats.getInbytes(slaveStats.nw_stats);
                slaveStats.getSlaveIntervalStats().w_bytes = NwStats.getOtbytes(slaveStats.nw_stats);
            }
            Blocked.accumCounters(slaveStats.getBlockCounters());
            if (slaveStats.getSlaveIntervalStats() != null) {
                object = Report.getReport(slave).getData();
                ((ReportData)object).accumIntervalFwdStats(slaveStats.getSlaveIntervalStats());
                object = Report.getReport(slave.getHost()).getData();
                ((ReportData)object).accumIntervalFwdStats(slaveStats.getSlaveIntervalStats());
                object = Report.getSummaryReport().getData();
                ((ReportData)object).accumIntervalFwdStats(slaveStats.getSlaveIntervalStats());
                ReportData.accumMappedFsdStats(slave, slaveStats.getFsdMap());
                ReportData.accumMappedFwdStats(slaveStats.getFwdMap());
            }
        }
        if (slaveStats.getCpuStats() != null) {
            slave.getHost().getSummaryReport().getData().accumIntervalCpuStats(slaveStats.getCpuStats());
            Report.getSummaryReport().getData().accumIntervalCpuStats(slaveStats.getCpuStats());
        }
        object = slave.getHost().getHostInfo();
        if (!InfoFromHost.anyKstatErrors() && object != null && ((InfoFromHost)object).isSolaris() && slaveStats.getKstatData() != null) {
            if (slaveStats.getKstatData().size() != ((InfoFromHost)object).getInstancePointers().size()) {
                common.failure("receiveStats() host: " + slave.getHost().getLabel() + " unmatched Kstat data count: " + slaveStats.getKstatData().size() + "/" + ((InfoFromHost)object).getInstancePointers().size());
            }
            this.storeKstats(slave, slaveStats);
        }
    }

    private boolean doDetailedReporting(boolean bl) {
        Serializable serializable;
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("HH:mm:ss.SSS");
        Report.setInterval(this.requested_interval);
        if (Vdbmain.isWdWorkload()) {
            if (!bl) {
                Report.reportWdInterval();
            }
            if (Reporter.isWarmupDone()) {
                ReportData.addSdIntervalToTotals();
                ReportData.addCpuIntervalToTotals();
                ReportData.addKstatIntervalToTotals();
                ReportData.addNfsIntervalToTotals();
            }
            serializable = Report.getSummaryReport().getData().getTotalSdStats();
            CollectSlaveStats.checkMaxData(((SdStats)serializable).r_bytes, ((SdStats)serializable).w_bytes);
        } else {
            if (!bl) {
                FwdReport.reportFwdInterval();
            }
            if (Reporter.isWarmupDone()) {
                ReportData.addFwdIntervalToTotals();
                ReportData.addCpuIntervalToTotals();
                ReportData.addKstatIntervalToTotals();
                ReportData.addNfsIntervalToTotals();
            }
            serializable = Report.getSummaryReport().getData().getTotalFwdStats();
            CollectSlaveStats.checkMaxData(((FwdStats)serializable).getTotalBytesRead(), ((FwdStats)serializable).getTotalBytesWritten());
        }
        serializable = ControlUsers.receivedIntervalDataFromSlaves(this);
        ControlUsers.sendUserDataToSlaves((UserData[])serializable);
        this.end_reporting = System.currentTimeMillis();
        if (bl || this.end_reporting - this.expected_interval_end > 1000L) {
            common.plog("Reporting delay: %5d (%3d) (%3d) %s %7.3f %7.3f %7.3f %7.3f %7.3f", this.requested_interval, stats_pending_queue.size(), reporting_queue.size(), simpleDateFormat.format(new Date(this.expected_interval_end)), (double)(this.start_send - this.expected_interval_end) / 1000.0, (double)(this.last_receive - this.expected_interval_end) / 1000.0, (double)(this.start_reporting - this.expected_interval_end) / 1000.0, (double)(this.end_reporting - this.expected_interval_end) / 1000.0, (double)(this.end_reporting - this.start_reporting) / 1000.0);
            return false;
        }
        return true;
    }

    private static void checkMaxData(long l, long l2) {
        long l3 = l + l2;
        RD_entry rD_entry = RD_entry.next_rd;
        if (rD_entry.max_data == Double.MAX_VALUE && rD_entry.max_data_r == Double.MAX_VALUE && rD_entry.max_data_w == Double.MAX_VALUE) {
            return;
        }
        if (Vdbmain.isWorkloadDone()) {
            return;
        }
        double d = CollectSlaveStats.getLimit(rD_entry.max_data);
        double d2 = CollectSlaveStats.getLimit(rD_entry.max_data_r);
        double d3 = CollectSlaveStats.getLimit(rD_entry.max_data_w);
        if (rD_entry.max_data != Double.MAX_VALUE && (double)l3 > d) {
            common.pboth("Reached maxdata=%s. rd=%s shutting down after next interval. ", FileAnchor.whatSize(l3), rD_entry.rd_name);
            Vdbmain.setWorkloadDone(true);
        } else if (rD_entry.max_data_r != Double.MAX_VALUE && (double)l > d2) {
            common.pboth("Reached maxdataread=%s. rd=%s shutting down after next interval. ", FileAnchor.whatSize(d2), rD_entry.rd_name);
            Vdbmain.setWorkloadDone(true);
        } else if (rD_entry.max_data_w != Double.MAX_VALUE && (double)l2 > d3) {
            common.pboth("Reached maxdatawritten=%s. rd=%s shutting down after next interval. ", FileAnchor.whatSize(d3), rD_entry.rd_name);
            Vdbmain.setWorkloadDone(true);
        }
    }

    private static double getLimit(double d) {
        double d2 = d;
        if (d <= 100.0) {
            d2 = 0.0;
            for (SD_entry sD_entry : Vdbmain.sd_list) {
                if (!sD_entry.isActive()) continue;
                d2 += (double)sD_entry.end_lba;
            }
            d2 = d2 * d / 100.0;
        }
        return d2;
    }

    public void waitForLast() {
        try {
            long l = 0L;
            while (!this.wait_for_last.attempt(500L)) {
                if ((l = common.signal_caller(l, 2000L)) != 0L) continue;
                common.ptod("Waiting for the last interval's statistics to be reported");
                for (int i = 1; i < this.data_from_slaves.length; ++i) {
                    if (this.data_from_slaves[i] != null) continue;
                    common.ptod("Waiting for slave: " + SlaveList.getSlaveList().elementAt(i).getLabel());
                }
            }
        }
        catch (InterruptedException interruptedException) {
            common.where();
        }
        if (!Vdbmain.isWdWorkload()) {
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void storeSlaveSdStats(Slave slave, SlaveStats slaveStats) {
        int n;
        SdStats[] sdStatsArray = slaveStats.getSdStats();
        HashMap hashMap = new HashMap(64);
        for (int i = 0; i < sdStatsArray.length; ++i) {
            hashMap.put(sdStatsArray[i].sd_name, null);
            sdStatsArray[i].elapsed = this.interval_duration * 1000000L;
        }
        String[] stringArray = hashMap.keySet().toArray(new String[0]);
        SdStats[] sdStatsArray2 = new SdStats[stringArray.length];
        for (n = 0; n < stringArray.length; ++n) {
            sdStatsArray2[n] = new SdStats();
            sdStatsArray2[n].sd_name = stringArray[n];
            for (int i = 0; i < sdStatsArray.length; ++i) {
                if (!sdStatsArray[i].sd_name.equals(stringArray[n])) continue;
                if (sdStatsArray[i].work_done) {
                    SD_entry.findSD((String)stringArray[n]).work_done = true;
                }
                sdStatsArray2[n].stats_accum(sdStatsArray[i], false);
                sdStatsArray2[n].elapsed = this.interval_duration * 1000000L;
            }
        }
        for (n = 0; n < sdStatsArray2.length; ++n) {
            SdStats sdStats = sdStatsArray2[n];
            Report.getReport(sdStats.sd_name).getData().accumIntervalSdStats(sdStats);
            Report.getSummaryReport().getData().accumIntervalSdStats(sdStats);
            Report.getReport(slave).getData().accumIntervalSdStats(sdStats);
            slave.getReport(sdStats.sd_name).getData().accumIntervalSdStats(sdStats);
            if (Report.host_detail) {
                slave.getHost().getReport(sdStats.sd_name).getData().accumIntervalSdStats(sdStats);
            }
            Report.getReport(slave.getHost()).getData().accumIntervalSdStats(sdStats);
            slave.reads += sdStats.reads;
            slave.writes += sdStats.writes;
        }
        for (n = 0; n < sdStatsArray.length; ++n) {
            String string = sdStatsArray[n].wd_name;
            WD_entry wD_entry = null;
            for (int i = 0; i < Vdbmain.wd_list.size(); ++i) {
                wD_entry = Vdbmain.wd_list.get(i);
                if (wD_entry.wd_name.equals(string)) break;
            }
            if (wD_entry == null) {
                common.failure("Unable to find wd=" + string);
            }
            WD_entry wD_entry2 = wD_entry;
            synchronized (wD_entry2) {
                if (Vdbmain.wd_list.size() > 1 && wD_entry.wd_is_used) {
                    Report.getReport(string).getData().accumIntervalSdStats(sdStatsArray[n]);
                }
                if (Reporter.isWarmupDone()) {
                    wD_entry.total_io_done += sdStatsArray[n].reads + sdStatsArray[n].writes;
                }
                continue;
            }
        }
    }

    private void storeKstats(Slave slave, SlaveStats slaveStats) {
        Vector vector = slaveStats.getKstatData();
        for (int i = 0; i < vector.size(); ++i) {
            Kstat_data kstat_data = (Kstat_data)vector.elementAt(i);
            kstat_data.pointer = slave.getHost().getInstancePointer(i);
            ReportData reportData = Report.getReport("kstat").getData();
            reportData.accumIntervalKstats(kstat_data);
            reportData = slave.getHost().getReport("kstat").getData();
            reportData.accumIntervalKstats(kstat_data);
            reportData = slave.getHost().getReport(kstat_data.pointer.getID()).getData();
            reportData.accumIntervalKstats(kstat_data);
            if (!NfsStats.areNfsReportsNeeded()) continue;
            slave.getHost().getReport("nfsstat3").getData().accumIntervalNfs(slaveStats.getNfs3());
            slave.getHost().getReport("nfsstat4").getData().accumIntervalNfs(slaveStats.getNfs4());
        }
    }

    public static Vector getAllKstatData() {
        Vector vector = SlaveWorker.work.instance_pointers;
        if (vector == null) {
            return null;
        }
        Vector<Kstat_data> vector2 = new Vector<Kstat_data>(vector.size());
        long l = Native.get_simple_tod();
        for (int i = 0; i < vector.size(); ++i) {
            InstancePointer instancePointer = (InstancePointer)vector.elementAt(i);
            vector2.add(instancePointer.getDeltaKstatData(l));
        }
        return vector2;
    }

    @Override
    public void run() {
        Thread.currentThread().setPriority(10);
        try {
            do {
                boolean bl = false;
                async_sema.attempt(100L);
                while (reporting_queue.size() > 0) {
                    int n;
                    CollectSlaveStats collectSlaveStats = reporting_queue.get(0);
                    Blocked.resetCounters();
                    ReportData.clearAllIntervalStats(collectSlaveStats.interval_duration);
                    for (n = 0; n < collectSlaveStats.data_from_slaves.length; ++n) {
                        SlaveStats slaveStats = collectSlaveStats.data_from_slaves[n];
                        collectSlaveStats.addDataToSlave(slaveStats.owning_slave, slaveStats);
                    }
                    int n2 = n = reporting_queue.size() > 10 ? 1 : 0;
                    if (!bl && n != 0) {
                        bl = true;
                        common.pboth("Detailed reporting is running behind; reporting of intervals %d-%d has been skipped.", CollectSlaveStats.reporting_queue.get((int)0).requested_interval, CollectSlaveStats.reporting_queue.get((int)(CollectSlaveStats.reporting_queue.size() - 1)).requested_interval);
                    }
                    boolean bl2 = collectSlaveStats.doDetailedReporting(bl);
                    reporting_queue.remove(collectSlaveStats);
                    if (Reporter.isWarmupDone() && bl2) {
                        Timeout.lookForTimeouts();
                    }
                    if (collectSlaveStats.requested_interval >= Reporter.getWarmupIntervals() && !Reporter.isWarmupDone()) {
                        Reporter.setWarmupDone(collectSlaveStats.requested_interval);
                    }
                    if (!collectSlaveStats.last_interval) continue;
                    collectSlaveStats.wait_for_last.release();
                    Validate.setJournalRecovered(true);
                    for (SD_entry sD_entry : Vdbmain.sd_list) {
                        sD_entry.journal_recovery_complete = true;
                    }
                }
                if (reporter.isAlive()) continue;
                return;
            } while (!Thread.currentThread().isInterrupted());
        }
        catch (Exception exception) {
            common.ptod("CollectSlaveStats died unexpectedly. Run terminated.");
            common.memory_usage();
            common.failure(exception);
        }
    }
}

