/*
 * Decompiled with CFR 0.152.
 */
package Vdb;

import Vdb.MiscParms;
import Vdb.RD_entry;
import Vdb.WG_entry;
import Vdb.common;
import java.util.ArrayList;

public class CompareWorkInfo {
    private static final String c = "Copyright (c) 2000, 2016, Oracle and/or its affiliates. All rights reserved.";

    public static String[] generateDebugInfo(RD_entry rD_entry) {
        String[] stringArray = MiscParms.getKeyParameters("work");
        if (!common.get_debug(common.GENERATE_WORK_INFO) && stringArray == null) {
            return null;
        }
        ArrayList<String> arrayList = new ArrayList<String>(8);
        arrayList.add(String.format("misc=(work,%s,", rD_entry.rd_name));
        RD_entry.printWgInfo2("Sort order: slave", new Object[0]);
        ArrayList<WG_entry> arrayList2 = WG_entry.sortWorkloads(RD_entry.getAllWorkloads(), "slave");
        for (int i = 0; i < arrayList2.size(); ++i) {
            WG_entry wG_entry = arrayList2.get(i);
            arrayList.add(String.format("%s,%s,%s,%d%s", wG_entry.getSlave().getLabel(), wG_entry.wd_used.wd_name, wG_entry.sd_used.sd_name, rD_entry.getSdThreadsUsedForSlave(wG_entry.sd_used.sd_name, wG_entry.getSlave()), i == arrayList2.size() - 1 ? ")" : ","));
        }
        return arrayList.toArray(new String[0]);
    }

    public static boolean debugCompareNeeded() {
        String[] stringArray = MiscParms.getKeyParameters("work");
        if (stringArray == null) {
            return false;
        }
        return stringArray.length > 1;
    }

    public static boolean debugOutputNeeded() {
        String[] stringArray = MiscParms.getKeyParameters("work");
        if (stringArray == null) {
            return false;
        }
        return stringArray.length == 1;
    }

    public static void compareWorkInfo(RD_entry rD_entry) {
        String[] stringArray = null;
        String[] stringArray2 = null;
        try {
            int n;
            stringArray = MiscParms.getKeyParameters("work", rD_entry.rd_name);
            if (stringArray == null) {
                common.failure("compareWorkInfo: no info found for rd=%s", rD_entry.rd_name);
            }
            ArrayList<String> arrayList = new ArrayList<String>(8);
            arrayList.add(String.format("misc=(work,%s,", stringArray[1]));
            int n2 = 4;
            for (n = 2; n < stringArray.length; n += n2) {
                String string = String.format("%s,%s,%s,%s%s", stringArray[n + 0], stringArray[n + 1], stringArray[n + 2], stringArray[n + 3], n + n2 == stringArray.length ? ")" : ",");
                arrayList.add(string);
            }
            stringArray = arrayList.toArray(new String[0]);
            if (stringArray.length != (stringArray2 = CompareWorkInfo.generateDebugInfo(rD_entry)).length) {
                CompareWorkInfo.printInfo(stringArray, "Info found in parameter file 'misc=' parameter:");
                CompareWorkInfo.printInfo(stringArray2, "Info generated during run:");
                common.failure("compareWorkInfo: mismatch in element count");
            }
            for (n = 0; n < stringArray.length; ++n) {
                if (stringArray[n].equals(stringArray2[n])) continue;
                common.ptod("compareWorkInfo: mismatch old: %s", stringArray[n]);
                common.ptod("compareWorkInfo: mismatch new: %s", stringArray2[n]);
                CompareWorkInfo.printInfo(stringArray, "Info found in parameter file 'misc=' parameter:");
                CompareWorkInfo.printInfo(stringArray2, "Info generated during run:");
                common.failure("compareWorkInfo: mismatch in element compare, element %d", n);
            }
        }
        catch (Exception exception) {
            if (stringArray != null) {
                CompareWorkInfo.printInfo(stringArray, "Info found in parameter file 'misc=' parameter:");
            }
            if (stringArray2 != null) {
                CompareWorkInfo.printInfo(stringArray2, "Info generated during run:");
            }
            common.failure(exception);
        }
    }

    private static void printInfo(String[] stringArray, String string) {
        common.ptod("compareWorkInfo: %s", string);
        common.ptod("compareWorkInfo: elements: %d", stringArray.length);
        for (int i = 0; i < stringArray.length; ++i) {
            common.ptod("                 element %2d: %s", i, stringArray[i]);
        }
    }
}

