/*
 * Decompiled with CFR 0.152.
 */
package Vdb;

import Vdb.common;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;

public class CompressObject {
    private static final String c = "Copyright (c) 2000, 2016, Oracle and/or its affiliates. All rights reserved.";

    public static byte[] compressObj(Object object) {
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            GZIPOutputStream gZIPOutputStream = new GZIPOutputStream(byteArrayOutputStream);
            ObjectOutputStream objectOutputStream = new ObjectOutputStream(gZIPOutputStream);
            objectOutputStream.writeObject(object);
            gZIPOutputStream.finish();
            byteArrayOutputStream.flush();
            return byteArrayOutputStream.toByteArray();
        }
        catch (Exception exception) {
            common.failure(exception);
            return null;
        }
    }

    public static Object unCompressObj(byte[] byArray) {
        try {
            Object object = null;
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
            GZIPInputStream gZIPInputStream = new GZIPInputStream(byteArrayInputStream);
            ObjectInputStream objectInputStream = new ObjectInputStream(gZIPInputStream);
            try {
                object = objectInputStream.readObject();
            }
            catch (ClassNotFoundException classNotFoundException) {
                common.failure(classNotFoundException);
            }
            return object;
        }
        catch (Exception exception) {
            common.failure(exception);
            return null;
        }
    }

    public static int sizeof(Object object) {
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            ObjectOutputStream objectOutputStream = new ObjectOutputStream(byteArrayOutputStream);
            objectOutputStream.writeObject(object);
            byteArrayOutputStream.flush();
            return byteArrayOutputStream.toByteArray().length;
        }
        catch (Exception exception) {
            common.failure(exception);
            return 0;
        }
    }

    public static void main(String[] stringArray) throws Exception {
        CompressObject.test4();
    }

    public static void test4() throws IOException {
        common.where();
        long[] lArray = new long[100];
        for (int i = 0; i < lArray.length; ++i) {
            lArray[i] = i;
        }
        common.ptod("sizeof: " + CompressObject.sizeof(lArray));
        common.ptod("temp: " + lArray.length * 8);
        common.ptod("temp: " + lArray);
        byte[] byArray = CompressObject.compressObj(lArray);
        common.ptod("ret: " + byArray.length);
        Object object = CompressObject.unCompressObj(byArray);
        common.ptod("obj: " + object);
    }
}

