/*
 * Decompiled with CFR 0.152.
 */
package Vdb;

import Vdb.Cmd_entry;
import Vdb.ConcatLbaSearch;
import Vdb.FileAnchor;
import Vdb.For_loop;
import Vdb.RD_entry;
import Vdb.SD_entry;
import Vdb.Validate;
import Vdb.Vdbmain;
import Vdb.WD_entry;
import Vdb.WG_entry;
import Vdb.common;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Vector;

public class ConcatSds {
    private static final String c = "Copyright (c) 2000, 2016, Oracle and/or its affiliates. All rights reserved.";

    public static void createConcatSds(Vector<WD_entry> vector, Vector<RD_entry> vector2) {
        for (WD_entry cloneable : vector) {
            cloneable.concat_sd = ConcatSds.createOneConcatSd(cloneable.sd_names, cloneable.wd_name);
            cloneable.concat_sd.threads = cloneable.wd_threads;
        }
        for (RD_entry rD_entry : vector2) {
            if (rD_entry.sd_names == null) continue;
            rD_entry.concat_sd = ConcatSds.createOneConcatSd(rD_entry.sd_names, "rd=" + rD_entry.rd_name);
        }
    }

    public static void calculateSize() {
        Vector<SD_entry> vector = Vdbmain.sd_list;
        for (int i = 0; i < vector.size(); ++i) {
            SD_entry sD_entry = vector.get(i);
            if (!sD_entry.concatenated_sd) continue;
            sD_entry.end_lba = 0L;
            String string = "";
            for (int j = 0; j < sD_entry.sds_in_concatenation.size(); ++j) {
                SD_entry sD_entry2 = sD_entry.sds_in_concatenation.get(j);
                if (sD_entry2.concatenated_sd) continue;
                sD_entry.end_lba += sD_entry2.end_lba;
                string = string + sD_entry2.sd_name + " ";
            }
            common.plog("Total size is %s for concatenated sd=%s consisting of sd=(%s)", FileAnchor.whatSize(sD_entry.end_lba), sD_entry.sd_name, common.replace(string.trim(), " ", ","));
        }
    }

    public static void checkForWdThreads(RD_entry rD_entry) {
        if (!Validate.sdConcatenation()) {
            return;
        }
        if (rD_entry.current_override.getThreads() != For_loop.NOVALUE) {
            return;
        }
        Vector<WD_entry> vector = Vdbmain.wd_list;
        for (int i = 0; i < vector.size(); ++i) {
            WD_entry wD_entry = vector.get(i);
            if (wD_entry.wd_threads != 0) continue;
            common.failure("wd=%s: for SD concatenation each WD must request a threads= value, unless overridden by the RD threads= or forthreads= parameter", wD_entry.wd_name);
        }
    }

    public static void calculateLbaRanges(WG_entry wG_entry) {
        long l = 0L;
        for (SD_entry sD_entry : wG_entry.sds_in_concatenation) {
            if (sD_entry.csd_start_lba >= 0L && sD_entry.csd_start_lba != l) {
                common.failure("SD concatenation: an SD (%s) may not be reused in a non-matching concatenation.", sD_entry.sd_name);
            }
            sD_entry.csd_start_lba = l;
            sD_entry.csd_end_lba = l + sD_entry.end_lba - 1L;
            l += sD_entry.end_lba;
            sD_entry.trackSdXfersizes(wG_entry.getXfersizes());
        }
    }

    private static SD_entry createOneConcatSd(String[] stringArray, String string) {
        int n = 0;
        for (int i = 0; i < Vdbmain.sd_list.size(); ++i) {
            if (!Vdbmain.sd_list.get((int)i).concatenated_sd) continue;
            ++n;
        }
        SD_entry sD_entry = new SD_entry();
        sD_entry.concatenated_sd = true;
        sD_entry.concat_wd_name = string;
        sD_entry.sd_name = String.format("concat#%02d", n + 1);
        sD_entry.sd_name8 = "concatxx";
        sD_entry.sds_in_concatenation = new ArrayList<SD_entry>(Arrays.asList(ConcatSds.getSdsOrdered(stringArray)));
        Vdbmain.sd_list.add(sD_entry);
        SD_entry.max_sd_name = Math.max(SD_entry.max_sd_name, sD_entry.sd_name.length());
        String string2 = "";
        for (SD_entry sD_entry2 : sD_entry.sds_in_concatenation) {
            if (sD_entry2.concatenated_sd) {
                common.failure("Oops: concatenated SD included in concatenation");
            }
            string2 = string2 + sD_entry2.sd_name + " ";
        }
        String string3 = String.format("wd=%%-%ds ", WD_entry.max_wd_name);
        common.plog("Created concatenated SD %s for " + (String)string3 + "sd=(%s)", sD_entry.sd_name, string, string2.trim().replace(" ", ","));
        return sD_entry;
    }

    public static SD_entry translateConcatToRealSd(Cmd_entry cmd_entry, SD_entry sD_entry, ConcatLbaSearch concatLbaSearch, boolean bl) {
        long l = cmd_entry.cmd_lba;
        ArrayList<SD_entry> arrayList = cmd_entry.cmd_wg.sds_in_concatenation;
        sD_entry.csd_end_lba = cmd_entry.cmd_lba;
        int n = Collections.binarySearch(arrayList, sD_entry, concatLbaSearch);
        if (n < 0) {
            n = (n + 1) * -1;
        }
        cmd_entry.sd_ptr = arrayList.get(n);
        if (cmd_entry.cmd_lba + cmd_entry.cmd_xfersize - 1L > cmd_entry.sd_ptr.csd_end_lba) {
            n = (n + 1) % arrayList.size();
            cmd_entry.sd_ptr = arrayList.get(n);
            cmd_entry.cmd_lba = cmd_entry.sd_ptr.csd_start_lba;
            common.ptod("lba=%,12d xfersize=%d to concatenated sd=%s; lba straddles two SDs. Switched to lba=0 on sd=", l, cmd_entry.cmd_xfersize, cmd_entry.concat_sd.sd_name, cmd_entry.sd_ptr.sd_name);
        }
        if (!bl && cmd_entry.cmd_lba == cmd_entry.sd_ptr.csd_start_lba) {
            cmd_entry.cmd_lba += cmd_entry.cmd_xfersize;
            common.ptod("Not allowed to access sd=%s,lba=0. Switched to lba=%d", cmd_entry.sd_ptr.sd_name, cmd_entry.cmd_xfersize);
        }
        cmd_entry.cmd_lba -= cmd_entry.sd_ptr.csd_start_lba;
        cmd_entry.jni_index = cmd_entry.cmd_wg.jni_index_list.get((int)n).jni_index;
        if (cmd_entry.cmd_lba < 0L) {
            common.ptod("org_lba:     %,d", l);
            common.ptod("cmd.cmd_lba: %,d", cmd_entry.cmd_lba);
            common.ptod("index:       " + n);
            common.ptod("real_sds:    %,d", arrayList.size());
            common.failure("Negative lba. ");
        }
        return cmd_entry.sd_ptr;
    }

    private static String[] getSdNames(String[] stringArray) {
        HashMap<String, SD_entry> hashMap = ConcatSds.getSdMap(stringArray);
        return hashMap.keySet().toArray(new String[0]);
    }

    private static SD_entry[] obsolete_getSds(String[] stringArray) {
        HashMap<String, SD_entry> hashMap = ConcatSds.getSdMap(stringArray);
        SD_entry[] sD_entryArray = hashMap.values().toArray(new SD_entry[0]);
        return sD_entryArray;
    }

    private static SD_entry[] getSdsOrdered(String[] stringArray) {
        ArrayList<SD_entry> arrayList = new ArrayList<SD_entry>(64);
        HashMap<String, SD_entry> hashMap = new HashMap<String, SD_entry>(64);
        for (int i = 0; i < stringArray.length; ++i) {
            boolean bl = false;
            for (int j = 0; j < Vdbmain.sd_list.size(); ++j) {
                SD_entry sD_entry = Vdbmain.sd_list.elementAt(j);
                if (sD_entry.concatenated_sd || !common.simple_wildcard(stringArray[i], sD_entry.sd_name)) continue;
                bl = true;
                if (hashMap.put(sD_entry.sd_name, sD_entry) != null) {
                    common.failure("'sd=%s' has been requested more than once using 'sd=%s' selection", sD_entry.sd_name, stringArray[i]);
                }
                arrayList.add(sD_entry);
            }
            if (bl) continue;
            common.failure("Could not find sd=" + stringArray[i]);
        }
        return arrayList.toArray(new SD_entry[0]);
    }

    private static HashMap<String, SD_entry> getSdMap(String[] stringArray) {
        HashMap<String, SD_entry> hashMap = new HashMap<String, SD_entry>(16);
        for (int i = 0; i < stringArray.length; ++i) {
            boolean bl = false;
            for (int j = 0; j < Vdbmain.sd_list.size(); ++j) {
                SD_entry sD_entry = Vdbmain.sd_list.elementAt(j);
                if (!common.simple_wildcard(stringArray[i], sD_entry.sd_name)) continue;
                bl = true;
                if (hashMap.get(sD_entry.sd_name) != null) {
                    common.failure("sd=%s has been requested multiple times", sD_entry.sd_name);
                }
                hashMap.put(sD_entry.sd_name, sD_entry);
            }
            if (bl) continue;
            common.failure("Could not find sd=" + stringArray[i]);
        }
        return hashMap;
    }

    public static void abortIf(String string) {
        if (Validate.sdConcatenation()) {
            common.failure("SD concatenation: %s", string);
        }
    }

    public static void abortNotIf(String string) {
        if (!Validate.sdConcatenation()) {
            common.failure("SD concatenation: %s", string);
        }
    }
}

