/*
 * Decompiled with CFR 0.152.
 */
package Vdb;

import Utils.Fget;
import Utils.Fput;
import Vdb.Directory;
import Vdb.FileAnchor;
import Vdb.FileEntry;
import Vdb.FwgEntry;
import Vdb.Operations;
import Vdb.SlaveJvm;
import Vdb.SlaveWorker;
import Vdb.common;
import java.io.File;
import java.util.Date;
import java.util.HashMap;
import java.util.Vector;

public class ControlFile {
    private static final String c = "Copyright (c) 2000, 2016, Oracle and/or its affiliates. All rights reserved.";
    private FileAnchor anchor;
    private boolean[] directory_status;
    private long[] file_status;
    public static String CONTROL_FILE = "vdb_control.file";
    private long running_checksum = 0L;
    private FileEntry last_fe = null;
    private int duplicates = 0;
    private boolean debug = false;

    public ControlFile(FileAnchor fileAnchor) {
        this.anchor = fileAnchor;
    }

    public void clearStatus() {
        this.directory_status = null;
        this.file_status = null;
    }

    public boolean exists() {
        return new File(this.anchor.getAnchorName(), CONTROL_FILE).exists();
    }

    public void writeControlFile(boolean bl, boolean bl2) {
        String string = "";
        common.ptod("Writing control file for anchor=" + this.anchor.getAnchorName() + " at " + (bl2 ? "start" : "end") + " of run.");
        int n = 0;
        int n2 = 0;
        Fput fput = new Fput(this.anchor.getAnchorName(), CONTROL_FILE);
        this.running_checksum = 0L;
        this.printAndCheck(fput, "when  %s %s anchor=%s pid=%s", bl2 ? "start" : "end", new Date(), this.anchor.getAnchorName(), common.getProcessIdString());
        this.printAndCheck(fput, "depth " + this.anchor.depth, new Object[0]);
        this.printAndCheck(fput, "width " + this.anchor.width, new Object[0]);
        this.printAndCheck(fput, "files " + this.anchor.files, new Object[0]);
        this.printAndCheck(fput, "dist  " + this.anchor.dist, new Object[0]);
        for (int i = 0; i < this.anchor.filesizes.length; ++i) {
            this.printAndCheck(fput, "size  " + (long)this.anchor.filesizes[i], new Object[0]);
        }
        if (bl) {
            fput.close();
        } else {
            Vector<Directory> vector = this.anchor.getDirList();
            this.printAndCheck(fput, "directory status " + vector.size(), new Object[0]);
            for (int i = 0; i < vector.size(); ++i) {
                Directory directory = vector.elementAt(i);
                if (this.debug) {
                    string = " " + i + " " + directory.getFullName();
                }
                if (directory.exist()) {
                    ++n2;
                    this.printAndCheck(fput, "y" + string, new Object[0]);
                    continue;
                }
                this.printAndCheck(fput, "n" + string, new Object[0]);
            }
            Vector<FileEntry> vector2 = this.anchor.getFileList();
            int n3 = vector2.size();
            int n4 = 0;
            long l = 0L;
            long l2 = 0L;
            long l3 = 0L;
            this.printAndCheck(fput, "file status " + n3, new Object[0]);
            for (int i = 0; i < n3; ++i) {
                FileEntry fileEntry = vector2.elementAt(i);
                this.writeFileStatus(fput, fileEntry, i, i == n3 - 1);
                l2 += fileEntry.getReqSize();
                if (!fileEntry.exists()) continue;
                ++n;
                l += fileEntry.getCurrentSize();
                if (!fileEntry.getOpened()) continue;
                ++n4;
                l3 += fileEntry.getCurrentSize();
            }
            fput.close();
            long l4 = 0L;
            for (String string2 : Fget.readFileToArray(fput.getName())) {
                for (int i = 0; i < string2.length(); ++i) {
                    l4 += (long)string2.charAt(i);
                }
            }
            if (l4 != this.running_checksum) {
                common.ptod("running_checksum: %12d", this.running_checksum);
                common.ptod("checksum:         %12d", l4);
                common.ptod("delta:            %12d", l4 - this.running_checksum);
                common.failure("Controlfile checksum failure. Corruption on Controlfile %s", fput.getName());
            }
            fput = new Fput(fput.getName(), true);
            fput.println("checksum: %d ", l4);
            fput.close();
            common.ptod("Completed control file for anchor=" + this.anchor.getAnchorName() + " at " + (bl2 ? "start" : "end") + " of run. " + " dirs: " + vector.size() + "/" + n2 + " files: " + n3 + "/" + n + " sizes: " + FileAnchor.whatSize(l2) + "/" + FileAnchor.whatSize(l) + "/" + n4 + "/" + FileAnchor.whatSize(l3));
            this.anchor.reportSizes(n, n2, l, n4, l3);
        }
    }

    private void printAndCheck(Fput fput, String string, Object ... objectArray) {
        String string2 = String.format(string, objectArray);
        for (int i = 0; i < string2.length(); ++i) {
            this.running_checksum += (long)string2.charAt(i);
        }
        fput.println(string2);
    }

    private void writeFileStatus(Fput fput, FileEntry fileEntry, int n, boolean bl) {
        boolean bl2 = false;
        if (n == 0) {
            this.last_fe = null;
            this.duplicates = 0;
        }
        if (bl) {
            if (this.duplicates > 0) {
                this.printAndCheck(fput, "= " + this.duplicates, new Object[0]);
            }
            this.printAndCheck(fput, this.getFileStatus(fileEntry, n), new Object[0]);
            this.last_fe = null;
            this.duplicates = 0;
            return;
        }
        boolean bl3 = bl2 = !this.debug && this.last_fe != null && this.last_fe.exists() == fileEntry.exists() && this.last_fe.isFull() == fileEntry.isFull() && this.last_fe.getCurrentSize() == fileEntry.getCurrentSize();
        if (bl2) {
            ++this.duplicates;
        } else {
            if (this.duplicates > 0) {
                this.printAndCheck(fput, "= " + this.duplicates, new Object[0]);
            }
            this.printAndCheck(fput, this.getFileStatus(fileEntry, n), new Object[0]);
            this.duplicates = 0;
        }
        this.last_fe = fileEntry;
    }

    private String getFileStatus(FileEntry fileEntry, int n) {
        String string = !fileEntry.exists() ? "n" : (fileEntry.isFull() ? "f" : "" + fileEntry.getCurrentSize());
        if (this.debug) {
            string = string + " " + n + " " + fileEntry.getFullName();
        }
        return string;
    }

    private void preserveOldControlFile() {
        String string = new File(this.anchor.getAnchorName(), CONTROL_FILE).getAbsolutePath();
        for (int i = 1; i < 30; ++i) {
            if (new File(string + i).exists() || !new File(string).renameTo(new File(string + i))) continue;
            common.ptod("Debugging: renamed Control File: " + string + i);
            return;
        }
    }

    public void readControlFile(FwgEntry fwgEntry) {
        String string = "'not in control file'";
        long l = 0L;
        long l2 = 0L;
        long l3 = 0L;
        double[] dArray = new double[256];
        int n = 0;
        String string2 = null;
        String[] stringArray = null;
        common.ptod("Reading control file for anchor=" + this.anchor.getAnchorName());
        long l4 = 0L;
        boolean bl = false;
        for (String string3 : Fget.readFileToArray(this.anchor.getAnchorName(), CONTROL_FILE)) {
            if (string3.startsWith("checksum:")) {
                long l5 = Long.parseLong(string3.split(" +")[1]);
                if (l4 != l5) {
                    if (common.get_debug(common.IGNORE_CHECKSUM)) {
                        common.ptod(" Corruption in control file '%s' ignored. Checksums: %d/%d", this.anchor.getAnchorName(), l5, l4);
                    } else {
                        common.failure(" Corruption in control file '%s'. Checksums: %d/%d", this.anchor.getAnchorName(), l5, l4);
                    }
                } else {
                    bl = true;
                }
            }
            for (int i = 0; i < string3.length(); ++i) {
                l4 += (long)string3.charAt(i);
            }
        }
        if (!bl) {
            common.failure("No checksum found in control file for %s", this.anchor.getAnchorName());
        }
        Fget fget = new Fget(this.anchor.getAnchorName(), CONTROL_FILE);
        String string4 = null;
        while ((string4 = fget.get()) != null) {
            stringArray = string4.split(" +");
            if (stringArray[0].equals("when")) {
                string = stringArray[1];
                continue;
            }
            if (stringArray[0].equals("depth")) {
                l = Long.parseLong(stringArray[1]);
                continue;
            }
            if (stringArray[0].equals("width")) {
                l2 = Long.parseLong(stringArray[1]);
                continue;
            }
            if (stringArray[0].equals("files")) {
                l3 = Long.parseLong(stringArray[1]);
                continue;
            }
            if (stringArray[0].equals("dist")) {
                string2 = stringArray[1];
                continue;
            }
            if (stringArray[0].equals("size")) {
                dArray[n++] = Double.parseDouble(stringArray[1]);
                continue;
            }
            if (stringArray[0].equals("directory")) break;
            common.failure("Invalid value in control file: " + string4 + ">>" + stringArray[0] + "<<");
        }
        if (!string.equals("start") && !string.equals("end") || l != (long)this.anchor.depth || l2 != (long)this.anchor.width || l3 != (long)this.anchor.files || !string2.equals(this.anchor.dist) || !this.checkSizes(this.anchor.filesizes, dArray, n)) {
            String string5 = "";
            string5 = string5 + "\n";
            string5 = string5 + "\nfwd=" + fwgEntry.getName();
            string5 = string5 + "\nwhen=" + string;
            string5 = string5 + "\nold depth=" + l + "; new depth=" + this.anchor.depth;
            string5 = string5 + "\nold width=" + l2 + "; new width=" + this.anchor.width;
            string5 = string5 + "\nold files=" + l3 + "; new files=" + this.anchor.files;
            string5 = string5 + "\nold dist=" + string2 + "; new dist=" + this.anchor.dist;
            string5 = string5 + "\nalso check the sizes=() parameters from previous and current execution.";
            string5 = string5 + "\nThe FWD parameters defined for 'fwd=" + fwgEntry.getName() + "' do not";
            string5 = string5 + "\nmatch the parameters used in the previous run. ";
            string5 = string5 + "\n- Correct the parameters, or";
            string5 = string5 + "\n- use the 'format=' RD parameter, or";
            string5 = string5 + "\n- Add '-c' execution parameter";
            string5 = string5 + "\nMake sure you also specify 'format=yes' in the Run Definition (RD)";
            common.ptod(string5);
            SlaveJvm.sendMessageToConsole(string5);
            common.failure("Parameter definition error");
        }
        if (!string.equals("end")) {
            common.ptod("Anchor=" + this.anchor.getAnchorName() + ": Previous run did not " + "complete. control file directory and file content will not be used");
            fget.close();
            return;
        }
        if (common.get_debug(common.NO_CONTROLFILE_DETAIL)) {
            common.ptod("Anchor=" + this.anchor.getAnchorName() + ": Directory and file content" + " from control file will not be used because of debug request");
            fget.close();
            return;
        }
        if (fwgEntry.shared) {
            fget.close();
        } else {
            this.directory_status = new boolean[Integer.parseInt(stringArray[2])];
            int n2 = 0;
            while ((string4 = fget.get()) != null && !string4.startsWith("file")) {
                this.directory_status[n2++] = string4.startsWith("y");
            }
            if (n2 != this.directory_status.length) {
                common.failure("Control file directory error. Expecting " + this.directory_status.length + " but receiving " + n2);
            }
            stringArray = string4.split(" +");
            this.file_status = new long[Integer.parseInt(stringArray[2])];
            int n3 = 0;
            long l6 = -1L;
            while ((string4 = fget.get()) != null) {
                if (string4.startsWith("=")) {
                    stringArray = string4.split(" +");
                    int n4 = Integer.parseInt(stringArray[1]);
                    for (int i = 0; i < n4; ++i) {
                        this.file_status[n3++] = l6;
                    }
                    continue;
                }
                if (string4.startsWith("n")) {
                    l6 = -1L;
                } else if (string4.startsWith("f")) {
                    l6 = -2L;
                } else {
                    if (string4.startsWith("checksum:")) continue;
                    l6 = Long.parseLong(string4.trim().split(" +")[0]);
                }
                this.file_status[n3++] = l6;
            }
            fget.close();
            if (n3 != this.file_status.length) {
                common.failure("Control file file error. Expecting " + this.file_status.length + " but receiving " + n3);
            }
        }
        common.ptod("Completed reading control file.");
    }

    private boolean checkSizes(double[] dArray, double[] dArray2, int n) {
        if (dArray.length != n) {
            return false;
        }
        for (int i = 0; i < n; ++i) {
            if ((int)dArray[i] == (int)dArray2[i]) continue;
            return false;
        }
        return true;
    }

    private String printSizes(double[] dArray, int n) {
        String string = "(";
        for (int i = 0; i < n; ++i) {
            string = string + (long)dArray[i] + ",";
        }
        string = string.substring(0, string.length() - 1) + ")";
        return string;
    }

    public boolean hasDirStatus() {
        return this.directory_status != null;
    }

    public boolean hasFileStatus() {
        return this.file_status != null;
    }

    public boolean getDirStatus(int n) {
        return this.directory_status[n];
    }

    public long getFileSize(int n, long l) {
        if (n > this.file_status.length - 1) {
            return -1L;
        }
        if (this.file_status[n] == -1L) {
            return -1L;
        }
        if (this.file_status[n] == -2L) {
            return l;
        }
        return this.file_status[n];
    }

    public static void writeAllControlFiles() {
        Vector<FwgEntry> vector = SlaveWorker.work.fwgs_for_slave;
        HashMap<FileAnchor, FileAnchor> hashMap = new HashMap<FileAnchor, FileAnchor>(16);
        boolean bl = false;
        for (int i = 0; i < vector.size(); ++i) {
            FwgEntry fwgEntry = vector.elementAt(i);
            hashMap.put(fwgEntry.anchor, fwgEntry.anchor);
            if (!fwgEntry.shared) continue;
            bl = true;
            return;
        }
        FileAnchor[] fileAnchorArray = hashMap.values().toArray(new FileAnchor[0]);
        for (int i = 0; i < fileAnchorArray.length; ++i) {
            fileAnchorArray[i].getControlFile().writeControlFile(bl, false);
            fileAnchorArray[i].clearControlFile();
        }
    }

    public static boolean keepControlFile(Vector<FwgEntry> vector) {
        for (FwgEntry fwgEntry : vector) {
            if (fwgEntry.getOperation() == Operations.WRITE) {
                return false;
            }
            if (fwgEntry.getOperation() == Operations.CREATE) {
                return false;
            }
            if (fwgEntry.getOperation() == Operations.MKDIR) {
                return false;
            }
            if (fwgEntry.getOperation() == Operations.RMDIR) {
                return false;
            }
            if (fwgEntry.getOperation() != Operations.DELETE) continue;
            return false;
        }
        return true;
    }

    public static void main(String[] stringArray) {
        long l = 0L;
        boolean bl = false;
        for (String string : Fget.readFileToArray(stringArray[0], CONTROL_FILE)) {
            if (string.startsWith("checksum:")) {
                long l2 = Long.parseLong(string.split(" +")[1]);
                if (l != l2) {
                    if (common.get_debug(common.IGNORE_CHECKSUM)) {
                        common.ptod(" Corruption in control file '%s' ignored. Checksums: %d/%d", stringArray[0], l2, l);
                    } else {
                        common.failure(" Corruption in control file '%s'. Checksums: %d/%d", stringArray[0], l2, l);
                    }
                } else {
                    bl = true;
                }
            }
            for (int i = 0; i < string.length(); ++i) {
                common.ptod("checksum: %,12d %s", l += (long)string.charAt(i), string);
            }
        }
    }
}

