/*
 * Decompiled with CFR 0.152.
 */
package Vdb;

import Utils.OS_cmd;
import Vdb.BoxPrint;
import Vdb.Host;
import Vdb.Kstat_cpu;
import Vdb.Linux;
import Vdb.Native;
import Vdb.RD_entry;
import Vdb.SlaveJvm;
import Vdb.SlaveList;
import Vdb.Vdbmain;
import Vdb.common;
import java.util.StringTokenizer;

public class CpuStats {
    private static final String c = "Copyright (c) 2000, 2016, Oracle and/or its affiliates. All rights reserved.";
    private static Kstat_cpu old_cpu = new Kstat_cpu();
    private static Kstat_cpu new_cpu = new Kstat_cpu();
    private static Kstat_cpu dlt_cpu = new Kstat_cpu();
    private static int cpu_mhz = 900;
    private static int cpu_count = -1;
    private static boolean cpu_reporting_active = false;

    public static Kstat_cpu getNativeCpuStats() {
        if (common.get_debug(common.NO_CPU_STATS)) {
            dlt_cpu = null;
            return new Kstat_cpu();
        }
        if (dlt_cpu == null) {
            return new Kstat_cpu();
        }
        try {
            if (common.onLinux()) {
                new_cpu = Linux.getCpuStats();
                if (new_cpu == null) {
                    return null;
                }
            } else {
                long l = Native.getCpuData(new_cpu);
                if (l < 0L) {
                    if (common.onWindows()) {
                        common.ptod("Unable to obtain CPU statistics: rc=" + l);
                        common.ptod("Possible language issues for PDH field names.");
                        common.ptod("Try running 'lodctr /R' to resolve this");
                        dlt_cpu = null;
                        return null;
                    }
                    common.failure("Unable to obtain CPU statistics: rc=" + l);
                }
                if (common.onSolaris()) {
                    CpuStats.new_cpu.cpu_total = CpuStats.new_cpu.cpu_total * CpuStats.new_cpu.cpu_hertz / CpuStats.new_cpu.cpu_count;
                    CpuStats.new_cpu.cpu_idle = CpuStats.new_cpu.cpu_idle * CpuStats.new_cpu.cpu_hertz / CpuStats.new_cpu.cpu_count;
                    CpuStats.new_cpu.cpu_user = CpuStats.new_cpu.cpu_user * CpuStats.new_cpu.cpu_hertz / CpuStats.new_cpu.cpu_count;
                    CpuStats.new_cpu.cpu_kernel = CpuStats.new_cpu.cpu_kernel * CpuStats.new_cpu.cpu_hertz / CpuStats.new_cpu.cpu_count;
                }
            }
            if (common.onSolaris() || common.onLinux()) {
                dlt_cpu.cpu_delta(new_cpu, old_cpu);
            } else {
                dlt_cpu.cpu_copy(new_cpu);
            }
            old_cpu.cpu_copy(new_cpu);
            return dlt_cpu;
        }
        catch (UnsatisfiedLinkError unsatisfiedLinkError) {
            common.where(8);
            String string = "UnsatisfiedLinkError while trying to collect CPU statistics. \n\t\tCPU reporting for this host will not be done.";
            SlaveJvm.sendMessageToConsole(string);
            common.ptod(string);
            common.ptod(unsatisfiedLinkError);
            dlt_cpu = null;
            return new Kstat_cpu();
        }
    }

    public static Kstat_cpu getDelta() {
        return dlt_cpu;
    }

    public static void setCpuReporting() {
        cpu_reporting_active = true;
    }

    public static boolean isCpuReporting() {
        return cpu_reporting_active;
    }

    private static int getProcessorCount() {
        if (cpu_count > 0) {
            return cpu_count;
        }
        if (!common.onSolaris()) {
            cpu_count = Runtime.getRuntime().availableProcessors();
            return cpu_count;
        }
        cpu_count = CpuStats.getSolarisProcessorCount();
        return cpu_count;
    }

    private static int getSolarisProcessorCount() {
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        boolean bl = false;
        try {
            OS_cmd oS_cmd = new OS_cmd();
            oS_cmd.setCmd("/usr/sbin/psrinfo -v ");
            oS_cmd.execute();
            String[] stringArray = oS_cmd.getStdout();
            for (int i = 0; i < stringArray.length; ++i) {
                String string = stringArray[i];
                StringTokenizer stringTokenizer = new StringTokenizer(string);
                while (stringTokenizer.hasMoreElements()) {
                    String string2 = stringTokenizer.nextToken();
                    if (string2.equals("on-line")) {
                        bl = true;
                    }
                    if (string2.equals("off-line")) {
                        bl = false;
                    }
                    if (!string2.equals("operates")) continue;
                    if (bl) {
                        ++n2;
                        if (stringTokenizer.countTokens() <= 1) continue;
                        stringTokenizer.nextToken();
                        n += Integer.valueOf(stringTokenizer.nextToken()).intValue();
                        continue;
                    }
                    ++n3;
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (n2 > 0) {
            cpu_mhz = n / n2;
            common.ptod("Online processor count: " + n2 + " ; avg speed: " + cpu_mhz + " mhz");
            if (n3 > 0) {
                common.ptod("Offline processor count: " + n3);
            }
        } else {
            n2 = Runtime.getRuntime().availableProcessors();
            common.ptod("Could not obtain processor count and speed. Using defaults:");
            common.ptod("Processor count: " + n2 + " ; avg speed: " + cpu_mhz + " mhz");
        }
        return n2;
    }

    public static void cpu_shortage(RD_entry rD_entry) {
        int n;
        BoxPrint boxPrint = new BoxPrint();
        for (n = 0; n < Host.getDefinedHosts().size(); ++n) {
            double d;
            Kstat_cpu kstat_cpu;
            Host host = Host.getDefinedHosts().elementAt(n);
            if (!host.anyWork() || (kstat_cpu = host.getSummaryReport().getData().getTotalCpuStats()) == null || !((d = kstat_cpu.user_pct() + kstat_cpu.kernel_pct()) > 80.0)) continue;
            if (boxPrint.size() > 0) {
                boxPrint.add("", new Object[0]);
            }
            boxPrint.add("Warning for host=%s: average processor utilization %.1f%% ", host.getLabel(), d);
            boxPrint.add("Any processor utilization over 80% could mean that your system", new Object[0]);
            boxPrint.add("does not have enough cycles to run the highest rate possible. ", new Object[0]);
        }
        boxPrint.printSumm();
        boxPrint.clear();
        n = SlaveList.countSlavesWithWork(RD_entry.next_rd);
        int n2 = (int)(Vdbmain.observed_iorate / (double)n);
        if (n2 > RD_entry.IOS_PER_JVM) {
            boxPrint.add("Warning: total amount of i/o per second per slave (%,d) greater than %,d.", n2, RD_entry.IOS_PER_JVM);
            boxPrint.add("You may need to adjust your total slave count.", new Object[0]);
            boxPrint.add("", new Object[0]);
            boxPrint.add("See 'jvms=' in documentation for raw (SD/WD) workloads).", new Object[0]);
            boxPrint.add("See 'host=' and/or 'clients=' in documentation for file system (FSD/FWD) workloads).", new Object[0]);
            boxPrint.add("", new Object[0]);
            boxPrint.add("rd=%s actively used %d slaves. ", rD_entry.rd_name, n);
        }
        boxPrint.printSumm();
    }

    public static void main(String[] stringArray) {
        CpuStats.getNativeCpuStats();
        common.sleep_some(1000L);
        Kstat_cpu kstat_cpu = CpuStats.getNativeCpuStats();
        System.out.println("");
        System.out.println("cpu_count      " + kstat_cpu.cpu_count);
        System.out.println("cpu_total      " + kstat_cpu.cpu_total);
        System.out.println("cpu_idle       " + kstat_cpu.cpu_idle);
        System.out.println("cpu_user       " + kstat_cpu.cpu_user);
        System.out.println("cpu_kernel     " + kstat_cpu.cpu_kernel);
        System.out.println("cpu_wait       " + kstat_cpu.cpu_wait);
        common.ptod("delta.user_pct():   " + kstat_cpu.user_pct());
        common.ptod("delta.kernel_pct(): " + kstat_cpu.kernel_pct());
    }
}

