/*
 * Decompiled with CFR 0.152.
 */
package Vdb;

import Utils.Getopt;
import Vdb.ActiveFile;
import Vdb.BoxPrint;
import Vdb.Cmd_entry;
import Vdb.DV_map;
import Vdb.DedupSet;
import Vdb.FileAnchor;
import Vdb.FsdEntry;
import Vdb.FsdSort;
import Vdb.FwgEntry;
import Vdb.HotBand;
import Vdb.KeyMap;
import Vdb.Native;
import Vdb.Patterns;
import Vdb.SD_entry;
import Vdb.SdSort;
import Vdb.SlaveJvm;
import Vdb.SlaveWorker;
import Vdb.Validate;
import Vdb.Vdb_scan;
import Vdb.Vdbmain;
import Vdb.common;
import java.io.File;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Vector;

public class Dedup
implements Serializable,
Cloneable {
    private static final String c = "Copyright (c) 2000, 2016, Oracle and/or its affiliates. All rights reserved.";
    private double dedup_ratio = -1.0;
    private double dedup_pct = Double.MIN_VALUE;
    private double dedup_adjusted = 100.0;
    private long dedup_sets_reqd = Long.MAX_VALUE;
    private long dedup_sets_used;
    private boolean dedup_across = true;
    private int dedup_maxkey = 2;
    private long dedup_seed = 0L;
    public long total_size;
    private static int dedup_type_seq = 1;
    private int dedup_type = dedup_type_seq++;
    private long uniques_written;
    private long uniques_written_acr_no;
    private long duplicates_written;
    public long flipflops;
    private long unique_blocks;
    private long duplicate_blocks;
    private long unit_blocks;
    private double sets_pct;
    private boolean flipflop = false;
    private boolean hotflop = false;
    public int[] hot_dedup_parms = new int[0];
    public long hot_dedup_sets;
    public long hot_dedup_blocks;
    private int[] hot_blocks = null;
    public ArrayList<DedupSet> hot_set_stats = null;
    public static Dedup dedup_default = new Dedup();
    public static boolean any_hotsets_requested = false;
    public static long UNIQUE_KEY_MASK = 0x7F00000000000000L;
    public static long UNIQUE_MASK = 0xF0000000000000L;
    public static long UNIQUE_BLOCK_MASK = 0x80000000000000L;
    public static long UNIQUE_BLOCK_ACROSS_YES = 0xC0000000000000L;
    public static long UNIQUE_BLOCK_ACROSS_NO = 0xE0000000000000L;
    public static long DEDUP_NO_DEDUP = 0xF0000000000000L;
    public static long DEDUPSET_TYPE_MASK = 0xFFFF00000000L;
    public static long DEDUPSET_NUMBER_MASK = 0xFFFFFFFFL;
    private static final long MB = 0x100000L;
    private static SimpleDateFormat df = new SimpleDateFormat("yyyy/MM/dd-HH:mm:ss.SSS");
    private static HashMap<Long, Long> done_map = new HashMap(32);
    private static ArrayList<String> lines = new ArrayList(25);

    public Object clone() {
        try {
            Dedup dedup = (Dedup)super.clone();
            dedup.hot_dedup_parms = (int[])this.hot_dedup_parms.clone();
            dedup.dedup_type = dedup_type_seq++;
            return dedup;
        }
        catch (Exception exception) {
            common.failure(exception);
            return null;
        }
    }

    public static boolean isDedup() {
        return Validate.isDedup();
    }

    public static int getDedupUnit() {
        return Validate.getDedupUnit();
    }

    public double getDedupPct() {
        return this.dedup_pct;
    }

    public boolean isDedupAcross() {
        return this.dedup_across;
    }

    public int getMaxKey() {
        return this.dedup_maxkey;
    }

    public double getAdjustedPct() {
        return this.dedup_adjusted;
    }

    public double getDedupRatio() {
        return this.dedup_ratio;
    }

    public static void reportAllSdCounters() {
        HashMap<Dedup, Dedup> hashMap = new HashMap<Dedup, Dedup>(8);
        for (SD_entry sD_entry : SD_entry.getRealSds(SlaveWorker.sd_list)) {
            hashMap.put(sD_entry.dedup, sD_entry.dedup);
        }
        for (Dedup dedup : hashMap.keySet()) {
            dedup.reportCounters(null);
        }
    }

    public static void reportAllFsdCounters() {
        HashMap<Dedup, Dedup> hashMap = new HashMap<Dedup, Dedup>(8);
        for (FwgEntry serializable : SlaveWorker.work.fwgs_for_slave) {
            hashMap.put(serializable.dedup, serializable.dedup);
        }
        for (Dedup dedup : hashMap.keySet()) {
            dedup.reportCounters(null);
        }
    }

    public void reportCounters(DV_map dV_map) {
        long l = 0L;
        long l2 = 0L;
        long l3 = 0L;
        if (dV_map != null) {
            for (long i = 0L; i < dV_map.key_blocks; ++i) {
                int n = dV_map.dv_get(i * (long)dV_map.getKeyBlockSize());
                if (n == 1) {
                    ++l;
                    continue;
                }
                if (n == 2) {
                    ++l2;
                    continue;
                }
                ++l3;
            }
        }
        int n = Dedup.getDedupUnit();
        long l4 = this.uniques_written + this.uniques_written_acr_no + this.duplicates_written;
        double d = 100.0 - (double)this.duplicates_written * 100.0 / (double)l4 + this.sets_pct;
        common.ptod("Dedup counters. Bytes written: %s across: %s (%.1f%%) on_sd: %s (%.1f%%) dups: %s (%.1f%%) resulting dedup=%.1f%% (%.2f:1)", FileAnchor.whatSize(l4 * (long)n), FileAnchor.whatSize(this.uniques_written * (long)n), (double)this.uniques_written * 100.0 / (double)l4, FileAnchor.whatSize(this.uniques_written_acr_no * (long)n), (double)this.uniques_written_acr_no * 100.0 / (double)l4, FileAnchor.whatSize(this.duplicates_written * (long)n), (double)this.duplicates_written * 100.0 / (double)l4, d, 100.0 / d);
        if (dV_map != null) {
            common.ptod("Key=01: %6d Key=02: %6d zeroes: %d", l, l2, l3);
        }
        common.ptod("Dedup options: " + this.printDedupInfo());
        if (SlaveJvm.isWdWorkload()) {
            this.printHotCounts();
        }
    }

    public void dedupFsdBlock(ActiveFile activeFile) {
        if (!Dedup.isDedup()) {
            common.failure("Is this an illegal call?");
        }
        int n = Dedup.getDedupUnit();
        KeyMap keyMap = activeFile.getKeyMap();
        FileAnchor fileAnchor = activeFile.getFileEntry().getAnchor();
        long l = activeFile.getFileEntry().getAnchor().relative_dedup_offset;
        int n2 = keyMap.getKeyCount();
        for (int i = 0; i < n2; ++i) {
            long l2;
            long l3;
            boolean bl;
            long l4 = activeFile.getFileEntry().getFileStartLba() + activeFile.next_lba + (long)(keyMap.getKeyBlockSize() * i);
            long l5 = l4 / (long)n;
            long l6 = l4 / (long)n + l / (long)n;
            boolean bl2 = bl = this.dedup_pct == 100.0 || fileAnchor.getDedupBitMap().isUnique(l5);
            if (bl) {
                l3 = !Dedup.isDedup() ? DEDUP_NO_DEDUP : (this.dedup_across ? UNIQUE_BLOCK_ACROSS_YES : UNIQUE_BLOCK_ACROSS_NO);
                l2 = Dedup.getUniqueCompressionOffset(l4);
            } else {
                l3 = l6 % this.dedup_sets_used;
                l2 = Dedup.getDuplicateCompressionOffset(l3);
            }
            l3 |= (long)keyMap.getKeys()[i] << 56;
            keyMap.getCompressions()[i] = l2;
            keyMap.getDedupsets()[i] = l3 |= (long)(this.dedup_type << 32);
        }
    }

    public static long getUniqueCompressionOffset(long l) {
        long l2 = l % (long)Patterns.getBufferSize();
        return l2;
    }

    private static long getDuplicateCompressionOffset(long l) {
        long l2 = l * 347L << 2;
        return l2 &= 0xFFFFFL;
    }

    public void dedupSdBlock(KeyMap keyMap, Cmd_entry cmd_entry) {
        int n = Dedup.getDedupUnit();
        SD_entry sD_entry = cmd_entry.sd_ptr;
        int n2 = keyMap.getKeyCount();
        if (!Dedup.isDedup()) {
            common.failure("Is this an illegal call?");
        }
        for (int i = 0; i < n2; ++i) {
            long l;
            long l2;
            boolean bl;
            long l3 = keyMap.pattern_lba + (long)(n * i);
            long l4 = l3 / (long)n;
            long l5 = l4 + sD_entry.sdd.rel_byte_start / (long)n;
            boolean bl2 = bl = this.dedup_pct == 100.0 || sD_entry.sdd.uniques_bitmap.isUnique(l4);
            if (bl) {
                l2 = !Dedup.isDedup() ? DEDUP_NO_DEDUP : (this.dedup_across ? UNIQUE_BLOCK_ACROSS_YES : UNIQUE_BLOCK_ACROSS_NO);
                l = Dedup.getUniqueCompressionOffset(l3);
            } else {
                l2 = sD_entry.sdd.translateDuplicateBlockToSet(l5);
                l = Dedup.getDuplicateCompressionOffset(l2);
            }
            int n3 = keyMap.getKeys()[i];
            l2 |= (long)n3 << 56;
            keyMap.getCompressions()[i] = l;
            keyMap.getDedupsets()[i] = l2 |= (long)this.dedup_type << 32;
        }
    }

    public static ArrayList<String> reportDedupSetTimes(long l) {
        ArrayList<String> arrayList = new ArrayList<String>(4096);
        if (!Validate.isStoreTime()) {
            return null;
        }
        if (!Validate.reportDedupsets()) {
            return null;
        }
        long l2 = l & DEDUPSET_NUMBER_MASK;
        long l3 = (l & DEDUPSET_TYPE_MASK) >> 32;
        if (done_map.put(l, l) != null) {
            arrayList.add(String.format("Dedupset type: %02x set: %08x was reported earlier", l3, l2));
            return arrayList;
        }
        for (SD_entry sD_entry : SD_entry.getRealSds(SlaveWorker.sd_list)) {
            Dedup dedup = sD_entry.sdd.dedup;
            if (l3 != (long)dedup.dedup_type) continue;
            int n = Dedup.getDedupUnit();
            for (long i = 0L; i < sD_entry.end_lba; i += (long)n) {
                long l4;
                boolean bl;
                long l5 = i / (long)n;
                long l6 = l5 + sD_entry.sdd.rel_byte_start / (long)n;
                boolean bl2 = bl = dedup.dedup_pct == 100.0 || sD_entry.sdd.uniques_bitmap.isDuplicate(l5);
                if (!bl || (l4 = sD_entry.sdd.translateDuplicateBlockToSet(l6)) != l2) continue;
                long l7 = sD_entry.dv_map.getLastTimestamp(i);
                String string = sD_entry.dv_map.getLastOperation(i);
                int n2 = sD_entry.dv_map.getLastKey(i);
                if (l7 != 0L && n2 == 0) {
                    arrayList.add(String.format("   %23s sd: %s lba: %08x type: %02d set: %08x key: %02x %s", df.format(new Date(l7)), sD_entry.sd_name, i, l3, l2, n2, "Read, never written"));
                    continue;
                }
                if (l7 == 0L) {
                    arrayList.add(String.format("   %23s sd: %s lba: %08x type: %02d set: %08x %s", "", sD_entry.sd_name, i, l3, l2, "Never read or written"));
                    continue;
                }
                arrayList.add(String.format("   %23s sd: %s lba: %08x type: %02d set: %08x key: %02x %s", df.format(new Date(l7)), sD_entry.sd_name, i, l3, l2, n2, string));
            }
        }
        Collections.sort(arrayList);
        return arrayList;
    }

    public void adjustSdDedupValue() {
        int n = Dedup.getDedupUnit();
        double d = this.total_size / (long)n;
        double d2 = this.dedup_sets_reqd > 0L ? (double)this.dedup_sets_reqd : d * (double)Math.abs(this.dedup_sets_reqd) / 100.0;
        this.dedup_adjusted = Math.max(this.dedup_pct - d2 * 100.0 / d, 0.0);
        this.dedup_adjusted = this.dedup_pct == 100.0 ? 100.0 : this.dedup_adjusted;
        this.dedup_sets_used = Math.max(1L, (long)d2);
        this.unit_blocks = (long)d;
        this.sets_pct = d2 * 100.0 / d;
        this.unique_blocks = (long)(d * this.dedup_adjusted / 100.0);
        this.duplicate_blocks = this.unit_blocks - this.unique_blocks;
        if (this.hotflop && this.hot_dedup_parms.length == 0) {
            common.failure("Requesting 'dedupflipflop=hot' without specifying 'deduphotsets=nnn'");
        }
        if (d2 > d) {
            common.ptod("Dedup options: " + this.printDedupInfo());
            common.failure("adjustDedupValue(): requesting more dedupsets (%.0f) than we have data blocks (%.0f, estimated)", d2, d);
        }
        if (d2 > d * this.dedup_pct / 100.0) {
            common.ptod("Dedup options: " + this.printDedupInfo());
            common.failure("adjustDedupValue(): requesting more dedupsets (%.0f) than we have non-unique data blocks (%.0f, estimated)", d2, d * this.dedup_pct / 100.0);
        }
        common.plog("Dedup options: " + this.printDedupInfo());
        this.hot_dedup_blocks = 0L;
        this.hot_dedup_sets = 0L;
        for (int i = 0; i < this.hot_dedup_parms.length; i += 2) {
            this.hot_dedup_sets += (long)this.hot_dedup_parms[i];
            this.hot_dedup_blocks += (long)(this.hot_dedup_parms[i] * this.hot_dedup_parms[i + 1]);
        }
        if (this.hot_dedup_blocks > 1000000L) {
            common.failure("More than one million hot dedup blocks: " + this.hot_dedup_blocks);
        }
        if (this.dedup_sets_used <= this.hot_dedup_sets) {
            common.ptod("Dedup options: " + this.printDedupInfo());
            common.failure("You do not have enough dedup sets. You are requested more hot dedup sets (%d) than you have dedup sets (%d)", this.hot_dedup_sets, this.dedup_sets_used);
        }
    }

    public static void adjustFsdDedupValues(Vector<FwgEntry> vector) {
        HashMap<Dedup, Dedup> hashMap = new HashMap<Dedup, Dedup>(8);
        for (FwgEntry fwgEntry : vector) {
            hashMap.put(fwgEntry.dedup, fwgEntry.dedup);
        }
        for (Dedup dedup : hashMap.values().toArray(new Dedup[0])) {
            dedup.adjustFsdDedupValue();
        }
    }

    public void adjustFsdDedupValue() {
        int n = Dedup.getDedupUnit();
        ArrayList<String> arrayList = new ArrayList<String>(16);
        for (FileAnchor object : FileAnchor.getAnchorList()) {
            arrayList.add(object.getAnchorName());
        }
        Collections.sort(arrayList);
        this.total_size = 0L;
        for (String string : arrayList) {
            FileAnchor fileAnchor = FileAnchor.findAnchor(string);
            fileAnchor.relative_dedup_offset = this.total_size;
            this.total_size += fileAnchor.bytes_in_file_list;
        }
        double d = this.total_size / (long)n;
        double d2 = this.dedup_sets_reqd > 0L ? (double)this.dedup_sets_reqd : d * (double)Math.abs(this.dedup_sets_reqd) / 100.0;
        this.dedup_adjusted = Math.max(Math.round(this.dedup_pct - d2 * 100.0 / d), 0L);
        this.dedup_adjusted = Math.max(this.dedup_pct - d2 * 100.0 / d, 0.0);
        this.dedup_sets_used = (long)Math.max(d2, 1.0);
        this.unit_blocks = (long)d;
        this.sets_pct = d2 * 100.0 / d;
        this.unique_blocks = (long)(d * this.dedup_adjusted / 100.0);
        this.duplicate_blocks = this.unit_blocks - this.unique_blocks;
        if (d2 > d) {
            common.ptod("Dedup options: " + this.printDedupInfo());
            common.failure("adjustDedupValue(): requesting more dedupsets (%.0f) than we have data blocks (%.0f, estimated)", d2, d);
        }
        if (d2 > d * this.dedup_pct / 100.0) {
            common.ptod("Dedup options: " + this.printDedupInfo());
            common.failure("adjustDedupValue(): requesting more dedupsets (%.0f) than we have non-unique data blocks (%.0f, estimated)", d2, d * this.dedup_pct / 100.0);
        }
        if (this.dedup_sets_used < this.hot_dedup_sets) {
            common.ptod("Dedup options: " + this.printDedupInfo());
            common.failure("You do not have enough dedup sets. You are requested more hot dedup sets (%d) than you have dedup sets (%d)", this.hot_dedup_sets, this.dedup_sets_used);
        }
        common.plog("Dedup options: " + this.printDedupInfo());
    }

    public void parseDedupParms(Vdb_scan vdb_scan, boolean bl) {
        boolean bl2 = false;
        String string = vdb_scan.keyword;
        if (string.equals("xxxdedup")) {
            Validate.setDedup();
            ArrayList<String> arrayList = Vdb_scan.splitRawParms(vdb_scan.raw_value);
            for (String string2 : arrayList) {
                String string3;
                if (bl2) {
                    common.ptod("parm: " + string2);
                }
                string = string2.trim().split("=+")[0];
                if (bl2) {
                    common.ptod("keyword: " + string);
                }
                if (string.equals("flipflop")) {
                    string3 = Vdb_scan.extractpair(string2).toLowerCase();
                    if (string3.startsWith("y")) {
                        this.flipflop = true;
                        continue;
                    }
                    if (string3.startsWith("n")) {
                        this.flipflop = false;
                        continue;
                    }
                    if (string3.startsWith("hot")) {
                        this.hotflop = true;
                        this.flipflop = true;
                        continue;
                    }
                    common.failure("Dedup parameter scan: unexpected input: " + string2);
                    continue;
                }
                if (string.equals("ratio")) {
                    this.dedup_ratio = Vdb_scan.extractDouble(Vdb_scan.extractpair(string2));
                    this.dedup_pct = 100.0 / this.dedup_ratio;
                    if (!(this.dedup_ratio < 1.0)) continue;
                    common.failure("Minimum value for dedupratio=%d is dedupratio=1", this.dedup_ratio);
                    continue;
                }
                if (string.equals("unit")) {
                    if (!bl) {
                        common.failure("'unit=' may not be specified as an SD or FSD parameter");
                    }
                    Validate.setDedupUnit(Vdb_scan.extractInt(Vdb_scan.extractpair(string2)));
                    continue;
                }
                if (string.equals("hotsets")) {
                    any_hotsets_requested = true;
                    string3 = Vdb_scan.extractpair(string2).toLowerCase();
                    double[] dArray = Vdb_scan.extractDoubles(string3);
                    if (dArray.length % 2 != 0) {
                        common.failure("Specifying deduphotsets= must be done in pairs (10 sets of 3 blocks, hotsets=(10,3,. . . .)");
                    }
                    this.hot_dedup_parms = new int[dArray.length];
                    for (int i = 0; i < dArray.length; ++i) {
                        this.hot_dedup_parms[i] = (int)dArray[i];
                        if (this.hot_dedup_parms[i] != 0) continue;
                        common.failure("hotsets: no 'zero' value allowed in parameters");
                    }
                    continue;
                }
                if (string.equals("sets")) {
                    this.dedup_sets_reqd = Vdb_scan.extractLong(Vdb_scan.extractpair(string2));
                    continue;
                }
                common.failure("Unexpected dedup parameter: " + string2);
            }
            return;
        }
        Validate.setDedup();
        if (string.equals("dedupratio")) {
            this.dedup_ratio = vdb_scan.getDouble();
            this.dedup_pct = 100.0 / this.dedup_ratio;
            if (this.dedup_ratio < 1.0) {
                common.failure("Minimum value for dedupratio=%d is dedupratio=1", this.dedup_ratio);
            }
        } else if (string.equals("dedupunit")) {
            if (!bl) {
                common.failure("'dedupunit=' may not be specified as an SD or FSD parameter");
            }
            Validate.setDedupUnit(vdb_scan.getInt());
        } else if (string.equals("dedupacross")) {
            this.dedup_across = vdb_scan.getString().toLowerCase().startsWith("y");
        } else if (string.equals("dedupmaxkey")) {
            this.dedup_maxkey = vdb_scan.getInt();
        } else if (string.equals("dedupsets")) {
            if (vdb_scan.num_count == 1) {
                this.dedup_sets_reqd = vdb_scan.getInt();
                if (this.dedup_sets_reqd == 0L) {
                    common.failure("'dedupsets=' must be a minimum of one: " + this.dedup_sets_reqd);
                }
            }
        } else if (string.equals("deduphotsets")) {
            any_hotsets_requested = true;
            if (vdb_scan.num_count % 2 != 0) {
                common.failure("Specifying deduphotsets= must be done in pairs (10 sets of 3 blocks, hotsets=(10,3,. . . .)");
            }
            this.hot_dedup_parms = new int[vdb_scan.num_count];
            for (int i = 0; i < vdb_scan.num_count; ++i) {
                this.hot_dedup_parms[i] = (int)vdb_scan.numerics[i];
                if (this.hot_dedup_parms[i] != 0) continue;
                common.failure("hotsets: no 'zero' value allowed in parameters");
            }
        } else if (string.equals("xxdedupseed")) {
            this.dedup_seed = vdb_scan.getLong();
        } else if (string.equals("dedupflipflop")) {
            String string4 = vdb_scan.alphas[0];
            if (string4.startsWith("y")) {
                this.flipflop = true;
            } else if (string4.startsWith("n")) {
                this.flipflop = false;
            } else if (string4.startsWith("hot")) {
                this.hotflop = true;
                this.flipflop = true;
            } else {
                common.failure("Dedup parameter scan: unexpected input: " + string4);
            }
        } else {
            common.failure("Invalid dedupxxx parameter: " + string);
        }
    }

    public boolean isFlipFlop() {
        return this.flipflop;
    }

    public boolean isHotFlop() {
        return this.hotflop;
    }

    public boolean isHotSet(long l) {
        long l2 = l & DEDUPSET_NUMBER_MASK;
        return l2 < this.hot_dedup_sets;
    }

    public boolean xxisFlipFlop(long l) {
        if (!this.flipflop) {
            return false;
        }
        if (this.hotflop) {
            if ((l & UNIQUE_MASK) == UNIQUE_BLOCK_ACROSS_YES) {
                return false;
            }
            long l2 = l & DEDUPSET_NUMBER_MASK;
            return l2 < this.hot_dedup_sets;
        }
        return true;
    }

    public void checkDedupParms() {
        int n = Dedup.getDedupUnit();
        if (!Dedup.isDedup()) {
            return;
        }
        if (n == 0) {
            common.failure("Requesting Dedup without specifying dedupunit=nnn");
        }
        if (n % 512 != 0) {
            common.failure("dedupunit= value must be a multiple of 512: " + n);
        }
        if (this.dedup_pct == Double.MIN_VALUE) {
            common.failure("dedupratio= parameter is required. ");
        }
        if (this.dedup_pct < 0.0 || this.dedup_pct > 100.0) {
            common.failure("Dedup rate must be between 0 and 100: " + this.dedup_pct);
        }
        if (this.dedup_sets_reqd == Long.MAX_VALUE) {
            this.dedup_sets_reqd = -5L;
        }
        if (Validate.isRealValidate() && !this.flipflop) {
            BoxPrint.printOne("Data Validation with Dedup requires 'dedup=flipflop'. Flipflop now activated.", new Object[0]);
            this.flipflop = true;
        }
    }

    public synchronized void countDedup(KeyMap keyMap, DV_map dV_map) {
        int n = Dedup.getDedupUnit();
        int n2 = keyMap.getKeyCount();
        int n3 = -1;
        for (int i = 0; i < n2; ++i) {
            long l = keyMap.getDedupsets()[i];
            if (Dedup.isUnique(l)) {
                if ((l & UNIQUE_MASK) == UNIQUE_BLOCK_ACROSS_YES) {
                    ++this.uniques_written;
                    continue;
                }
                ++this.uniques_written_acr_no;
                continue;
            }
            ++this.duplicates_written;
            dV_map.getDedup();
            int n4 = Dedup.getSet(l);
            if (!this.isHotSet(l) || n4 == n3) continue;
            this.hot_set_stats.get(n4).addStatistics(dV_map);
            n3 = n4;
        }
    }

    public String printDedupInfo() {
        int n = Dedup.getDedupUnit();
        lines.clear();
        String string = "";
        String string2 = "no";
        if (this.isHotFlop()) {
            string2 = "hot";
        } else if (this.isFlipFlop()) {
            string2 = "yes";
        }
        Dedup.addLine("dedup_type", "%,15d", this.dedup_type);
        Dedup.addLine("dedup_ratio", "%15.2f", this.dedup_ratio);
        Dedup.addLine("dedup_unit", "%,15d", n);
        Dedup.addLine("flipflop", "%15s", string2);
        Dedup.addLine("hot_dedup_sets", "%,15d", this.hot_dedup_sets);
        Dedup.addLine("hot_dedup_blocks", "%,15d", this.hot_dedup_blocks);
        if (this.dedup_sets_reqd < 0L) {
            Dedup.addLine("dedup_sets_reqd", "%15s", this.dedup_sets_reqd * -1L + "%");
        } else {
            Dedup.addLine("dedup_sets_reqd", "%,15d", this.dedup_sets_reqd);
        }
        Dedup.addLine("dedup_sets_used", "%,15d", this.dedup_sets_used);
        lines.add("");
        Dedup.addLine("unique_blocks", "%,15d", this.unique_blocks);
        Dedup.addLine("duplicate_blocks", "%,15d (including %,d originals)", this.duplicate_blocks, this.dedup_sets_used);
        Dedup.addLine("dedup_pct", "%15.2f", this.dedup_pct);
        Dedup.addLine("dedup_adjusted", "%15.2f", this.dedup_adjusted);
        Dedup.addLine("total_size", "%15s", FileAnchor.whatSize(this.total_size));
        Dedup.addLine("unit_blocks", "%,15d", this.unit_blocks);
        lines.add("\nInfo only reliable if xfersize is multiple of dedupunit:");
        Dedup.addLine("uniques_written", "%,15d; expected %,d; delta %,d ", this.uniques_written, this.unique_blocks, this.uniques_written - this.unique_blocks);
        Dedup.addLine("duplicates_written", "%,15d; expected %,d; delta %,d ", this.duplicates_written, this.duplicate_blocks, this.duplicates_written - this.duplicate_blocks);
        Dedup.addLine("Total writes", "%,15d; delta %,d", this.uniques_written + this.duplicates_written, this.uniques_written + this.duplicates_written - this.unit_blocks);
        Dedup.addLine("flipflops", "%,15d", this.flipflops);
        double d = (double)this.unit_blocks / (double)(this.unique_blocks + this.dedup_sets_used);
        double d2 = (double)this.unit_blocks / (double)(this.unique_blocks + this.dedup_sets_used * 2L);
        double d3 = (double)this.unit_blocks / (double)(this.unique_blocks + this.dedup_sets_used + this.hot_dedup_sets);
        lines.add("");
        Dedup.addLine("Dsim counts: Hash size", "%,15d (%,d uniques + %,d sets)", this.unique_blocks + this.dedup_sets_used, this.unique_blocks, this.dedup_sets_used);
        Dedup.addLine("Dsim counts: Duplicates", "%,15d", this.duplicate_blocks - this.dedup_sets_used);
        Dedup.addLine("Dsim counts: Ratio", "%15.2f (%.5f)", d, d);
        if (this.isFlipFlop()) {
            if (!this.isHotFlop()) {
                Dedup.addLine("Dsim counts: Max hash size possible due to flipflop", "%,d (unique_blocks + dedup_sets_used * 2)", this.unique_blocks + this.dedup_sets_used * 2L);
                Dedup.addLine("Dsim counts: Min ratio possible due to flipflop", "%.2f (%.5f)", d2, d2);
            } else {
                Dedup.addLine("Dsim counts: Max hash size possible due to hotflop", "%,d (unique_blocks + dedup_sets_used + hot_dedup_sets)", this.unique_blocks + this.dedup_sets_used + this.hot_dedup_sets);
                Dedup.addLine("Dsim counts: Min ratio possible due to hotflop", "%.2f (%.5f)", d3, d3);
            }
        }
        lines.add("");
        String string3 = "";
        for (String string4 : lines) {
            string3 = string3 + "\n" + string4;
        }
        return string3;
    }

    public static void addLine(String string, String string2, Object ... objectArray) {
        String string3 = String.format("%-24s ", string + ":");
        string3 = String.format(string3 + string2, objectArray);
        lines.add(string3);
    }

    public static void checkSdDedup() {
        if (!Validate.isDedup()) {
            return;
        }
        SD_entry[] sD_entryArray = Vdbmain.sd_list.toArray(new SD_entry[0]);
        Arrays.sort(sD_entryArray, new SdSort());
        for (SD_entry sD_entry : sD_entryArray) {
            if (sD_entry.dedup == null) {
                sD_entry.dedup = dedup_default;
            }
            sD_entry.dedup.checkDedupParms();
        }
    }

    public static void checkFsdDedup() {
        if (!Validate.isDedup()) {
            return;
        }
        FsdEntry[] fsdEntryArray = FsdEntry.getFsdList().toArray(new FsdEntry[0]);
        Arrays.sort(fsdEntryArray, new FsdSort());
        for (FsdEntry fsdEntry : fsdEntryArray) {
            if (fsdEntry.dedup == null) {
                fsdEntry.dedup = dedup_default;
            }
            fsdEntry.dedup.checkDedupParms();
        }
    }

    public long translateBlockToSet(long l) {
        long l2 = l % (this.dedup_sets_used - this.hot_dedup_sets) + this.hot_dedup_sets;
        if (l2 >= this.dedup_sets_used) {
            common.failure("translateBlockToSet: set# %d >= %d", l2, this.dedup_sets_used);
        }
        if (l2 < 0L) {
            common.failure("translateBlockToSet: negative set#: %d", l2);
        }
        return l2;
    }

    public static void slaveLevelSetup(Vector<SD_entry> vector) {
        SD_entry[] sD_entryArray = SD_entry.getRealSds(vector);
        HashMap<Dedup, Dedup> hashMap = new HashMap<Dedup, Dedup>(4);
        for (SD_entry sD_entry : sD_entryArray) {
            hashMap.put(sD_entry.dedup, sD_entry.dedup);
        }
        for (Dedup dedup : hashMap.values()) {
            Object object;
            int n;
            dedup.hot_blocks = DedupSet.createHotBlockArray(dedup);
            dedup.hot_set_stats = DedupSet.createHotSetList(dedup);
            if (dedup.hot_dedup_sets > 0L) {
                HotBand.doNotAddOnePct();
            }
            ArrayList<Object> arrayList = new ArrayList<Object>(8);
            SD_entry[] sD_entryArray2 = sD_entryArray;
            int n2 = sD_entryArray2.length;
            for (n = 0; n < n2; ++n) {
                object = sD_entryArray2[n];
                if (((SD_entry)object).dedup != dedup) continue;
                arrayList.add(object);
            }
            int n3 = 0;
            for (n2 = 0; n2 < dedup.hot_blocks.length; ++n2) {
                n = dedup.hot_blocks[n2];
                object = (SD_entry)arrayList.get(n3++ % arrayList.size());
                ((SD_entry)object).sdd.receiveHotset(n);
            }
        }
        for (SD_entry sD_entry : sD_entryArray) {
            DV_map dV_map = sD_entry.dv_map;
            Dedup dedup = sD_entry.dedup;
            for (DedupSet dedupSet : dedup.hot_set_stats) {
                dedupSet.addStatistics(dV_map);
                dedupSet.references = 0;
                dedupSet.switches = 0;
            }
        }
    }

    private void printHotCounts() {
        long l = 0L;
        for (DedupSet dedupSet : this.hot_set_stats) {
            l += (long)dedupSet.references;
        }
        double d = 0.0;
        for (DedupSet dedupSet : this.hot_set_stats) {
            double d2 = (double)dedupSet.references * 100.0 / (double)l;
            common.ptod("printHotCounts(): set %5d; blocks: %4d; switches %5d; references: %6d pct: %5.2f  %6.2f", dedupSet.set_number, dedupSet.blocks_in_set, dedupSet.switches, dedupSet.references, d2, d += d2);
        }
        if (l > 0L) {
            common.ptod("printHotCounts(): total references: %,d", l);
        }
    }

    public static boolean isUnique(long l) {
        return (l & UNIQUE_BLOCK_MASK) != 0L;
    }

    public static boolean isDuplicate(long l) {
        return (l & UNIQUE_BLOCK_MASK) == 0L;
    }

    public static String xlate(long l) {
        return Dedup.isUnique(l) ? "unq" : "dup";
    }

    public static int getKey(long l) {
        return (int)(l >> 56);
    }

    public static int getSet(long l) {
        return (int)l;
    }

    public static void main(String[] stringArray) {
        long l = 4096L;
        long l2 = 0x9999931L;
        long l3 = 0L;
        long l4 = 0x100000L;
        long l5 = 0x40000000L;
        HashMap hashMap = new HashMap(10240);
        for (long i = 0L * l5; i < 8200L * l5; i += l) {
            long l6 = i / l;
            long l7 = l6 % (l2 - l3) + l3;
            if (l7 != 0L) continue;
            common.ptod("duplicate: lba: %,20d %,16d", i, l7);
        }
    }

    public static void main3(String[] stringArray) {
        int n;
        int[] nArray = new int[]{10, 2, 20, 3, 30, 4};
        long l = 0L;
        long l2 = 0L;
        for (int i = 0; i < nArray.length; i += 2) {
            l2 += (long)nArray[i];
            l += (long)(nArray[i] * nArray[i + 1]);
        }
        long[] lArray = new long[(int)l];
        int n2 = 0;
        int n3 = 0;
        for (n = 0; n < nArray.length; n += 2) {
            for (int i = 0; i < nArray[n]; ++i) {
                for (int j = 0; j < nArray[n + 1]; ++j) {
                    lArray[n2++] = n3;
                }
                ++n3;
            }
        }
        for (n = 0; n < lArray.length; ++n) {
            common.ptod("dedicates: block: %3d set: %3d", n, lArray[n]);
        }
    }

    public static void main2(String[] stringArray) {
        long l;
        long l2;
        long l3;
        Getopt getopt = new Getopt(stringArray, "u:s:", 99);
        getopt.print("Dedup");
        String string = getopt.get_positional(0);
        String string2 = getopt.get_positional(1);
        String string3 = string + File.separator + getopt.get_positional(2);
        String string4 = string2 + File.separator + getopt.get_positional(2);
        int n = 131072;
        long l4 = Native.openFile(string3);
        if (l4 < 0L) {
            common.failure("Unable to open file: " + string3);
        }
        if ((l3 = Native.openFile(string4)) < 0L) {
            common.failure("Unable to open file: " + string4);
        }
        if ((l2 = Native.getSize(l4, string3)) != (l = Native.getSize(l3, string4))) {
            common.failure("File sizes must be identical: %d %d", l2, l);
        }
        long l5 = Native.allocBuffer(n);
        long l6 = Native.allocBuffer(n);
        int[] nArray = new int[n / 4];
        int[] nArray2 = new int[n / 4];
        long l7 = l2 / (long)n;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        int n6 = 1;
        while ((long)n6 < l7) {
            boolean bl;
            long l8 = n6 * n;
            if (Native.readFile(l4, l8, n, l5) != 0L) {
                common.failure("Error reading %s", string3);
            }
            if (Native.readFile(l3, l8, n, l6) != 0L) {
                common.failure("Error reading %s", string4);
            }
            Native.buffer_to_array(nArray, l5, n);
            Native.buffer_to_array(nArray2, l6, n);
            boolean bl2 = nArray[0] == nArray[1] && nArray[0] == 0;
            boolean bl3 = bl = nArray2[0] == nArray2[1] && nArray2[0] == 0;
            if (bl2) {
                ++n3;
            } else {
                ++n2;
            }
            if (bl) {
                ++n5;
            } else {
                ++n4;
            }
            if (bl2 != bl) {
                common.failure("zero status mismatch. lba: 0x%08x", l8);
            }
            if (bl2) {
                for (int i = 0; i < nArray.length; ++i) {
                    if (nArray[i] == nArray2[i]) continue;
                    common.ptod("mismatch: lba 0x%08x %08x %08x %08x %08x %06x ", l8, nArray[0], nArray[1], nArray[i], nArray2[i], i * 4);
                    break;
                }
            }
            ++n6;
        }
        common.ptod("uniq1: " + n2);
        common.ptod("dups1: " + n3);
        common.ptod("uniq2: " + n4);
        common.ptod("dups2: " + n5);
    }

    public static void main1(String[] stringArray) {
        int n;
        int[] nArray = new int[10];
        int n2 = Integer.parseInt(stringArray[0]);
        for (n = 0; n < n2; ++n) {
            long l = (long)n * 2654435761L;
            int n3 = (int)(l % 10L);
            nArray[n3] = nArray[n3] + 1;
            common.ptod("hash: " + l + " " + l % 10L);
        }
        for (n = 0; n < nArray.length; ++n) {
            common.ptod("col: " + n + " " + nArray[n]);
        }
    }
}

