/*
 * Decompiled with CFR 0.152.
 */
package Vdb;

import Vdb.LS;
import Vdb.LsData;
import Vdb.common;
import java.io.File;
import java.util.Arrays;
import java.util.HashMap;

class DirData
implements Comparable {
    String dirname;
    long dir_total;
    long file_count;
    static HashMap<String, DirData> dir_list = new HashMap(256);
    static StringBuffer work = new StringBuffer(1024);
    static String splitter = common.onWindows() ? "\\\\+" : "/+";

    DirData() {
    }

    public static void addFile(LsData lsData, int n) {
        String string = lsData.dirname + File.separator;
        String[] stringArray = string.split(splitter);
        work.setLength(0);
        for (int i = 0; i < n + 1 && i < stringArray.length; ++i) {
            if (i == 0) {
                work.append(stringArray[i]);
                continue;
            }
            work.append(File.separator + stringArray[i]);
        }
        String string2 = work.toString();
        DirData dirData = dir_list.get(string2.toString());
        if (dirData == null) {
            dirData = new DirData();
            dirData.dirname = string2;
            dir_list.put(string2, dirData);
        }
        dirData.dir_total += lsData.ls_size;
        ++dirData.file_count;
    }

    public static void printDirectories() {
        Object[] objectArray = dir_list.values().toArray(new DirData[0]);
        Arrays.sort(objectArray);
        common.ptod("%12s %8s %8s   %s", "Size", "Size", "Files", "Directory name");
        for (int i = 0; i < objectArray.length && i < LS.limit_lines; ++i) {
            Object object = objectArray[i];
            if (((DirData)object).dir_total < LS.minimum_report) continue;
            String string = LS.xlateSize(((DirData)object).dir_total);
            common.ptod("%12d %8s %8d   %s", ((DirData)object).dir_total, string, ((DirData)object).file_count, ((DirData)object).dirname);
        }
    }

    public int compareTo(Object object) {
        DirData dirData = (DirData)object;
        if (!LS.sort_size) {
            return this.dirname.compareToIgnoreCase(dirData.dirname);
        }
        long l = dirData.dir_total - this.dir_total;
        if (l > 0L) {
            return 1;
        }
        if (l < 0L) {
            return -1;
        }
        return 0;
    }
}

