/*
 * Decompiled with CFR 0.152.
 */
package Vdb;

import Vdb.DVPost;
import Vdb.Sector;
import Vdb.common;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.Vector;

class DvKeyBlock
implements Comparable {
    private static final String c = "Copyright (c) 2000, 2016, Oracle and/or its affiliates. All rights reserved.";
    long logical_lba;
    long file_start_lba;
    long file_lba;
    String lun;
    String sd_wanted;
    int sectors_reported;
    int key_wanted;
    int key_read;
    int key_block_size;
    String first_dvpost_line_tod = null;
    Date first_sector_written_tod = null;
    String last_tod_valid = null;
    String last_valid_rw = null;
    Date last_valid = null;
    Date block_first_seen = null;
    Date dvpost_date = null;
    Sector[] sectors;
    String failed_operation;
    int error_code = 0;
    int different_words_in_block;
    ArrayList raw_input = new ArrayList(4096);
    static String sort_order = null;

    public int compareTo(Object object) {
        DvKeyBlock dvKeyBlock = (DvKeyBlock)object;
        if (sort_order.equals("lba")) {
            return (int)(this.logical_lba - dvKeyBlock.logical_lba);
        }
        if (sort_order.equals("lun")) {
            int n = this.lun.compareTo(dvKeyBlock.lun);
            if (n != 0) {
                return n;
            }
            return (int)(this.logical_lba - dvKeyBlock.logical_lba);
        }
        common.failure("Unknown sort flag");
        return 0;
    }

    public int countSingleBitWords() {
        int n = 0;
        for (int i = 0; i < this.sectors.length; ++i) {
            if (this.sectors[i] == null || this.sectors[i].singlebit_words == 0) continue;
            ++n;
        }
        return n;
    }

    public String getBlockStatusShort() {
        String string = "";
        if (this.getWrongKeys() != null) {
            string = string + "Key; ";
        }
        if (this.getWrongLbas() != null) {
            string = string + "Lba; ";
        }
        if (this.countSingleBitWords() > 0) {
            string = string + "Single bit; ";
        }
        if (this.getWrongSdNames() != null) {
            string = string + "SD; ";
        }
        if (this.getLFSRStatus()) {
            string = string + "Bad lba data is bad; ";
        }
        if (this.anyPartialSectors()) {
            string = string + "Data, partial; ";
        } else if (this.different_words_in_block > 0) {
            string = string + "Data; ";
        }
        string = string + this.getBadSectors() + " ";
        return string;
    }

    public String getBlockStatus() {
        String string = "";
        if (this.error_code == 0 && this.sectors_reported != this.key_block_size / 512) {
            string = string + "- Not all sectors have been reported.\n";
        }
        if (this.getWrongKeys() != null) {
            string = string + "- Invalid key(s) read.\n";
        }
        if (this.getWrongLbas() != null) {
            string = string + "- Invalid lba read.\n";
        }
        if (this.countSingleBitWords() > 0) {
            string = string + "- At least one single bit error.\n";
        }
        if (this.getWrongSdNames() != null) {
            string = string + "- Invalid SD name read.\n";
        }
        if (this.getLFSRStatus()) {
            string = string + "- Data corruption even when using wrong lba or key.\n";
        }
        if (this.anyPartialSectors()) {
            string = string + "- At least one sector is partially correct.\n";
        } else if (this.different_words_in_block > 0) {
            string = string + "- Data corruption.\n";
        }
        string = string + "- " + this.getBadSectors() + " ";
        return string;
    }

    public String getBadSectors() {
        String string;
        Vector<Integer> vector = new Vector<Integer>(this.sectors.length);
        for (int i = 0; i < this.sectors.length; ++i) {
            if (this.sectors[i] == null) continue;
            vector.add(new Integer(i));
        }
        String string2 = string = this.error_code != 0 ? "Bad sectors: " : "Bad sectors: (incomplete) ";
        if (this.sectors[this.sectors.length - 1] != null) {
            string = "Bad sectors: ";
        }
        string = string + DvKeyBlock.compressSectorNumbers(vector, this.sectors.length);
        return string;
    }

    public static String compressSectorNumbers(Vector vector, int n) {
        int n2;
        String string = "";
        if (vector.size() == 0) {
            return "All " + n + " sectors good (based on lba and key that was read)";
        }
        if (vector.size() == n) {
            return "All " + n + " sectors bad ";
        }
        int[] nArray = new int[vector.size()];
        for (n2 = 0; n2 < vector.size(); ++n2) {
            nArray[n2] = (Integer)vector.elementAt(n2);
        }
        n2 = nArray[0];
        int n3 = nArray[0];
        for (int i = 1; i < nArray.length; ++i) {
            if (nArray[i] != n3 + 1) {
                string = n2 == n3 ? string + n2 + "," : string + n2 + "-" + n3 + ",";
                n2 = nArray[i];
            }
            n3 = nArray[i];
        }
        string = n2 == n3 ? string + n2 : string + n2 + "-" + n3;
        return string + " (" + nArray.length + " of " + n + ")";
    }

    public String getWrongKeys() {
        HashMap<Integer, Integer> hashMap = new HashMap<Integer, Integer>(8);
        for (int i = 0; i < this.sectors.length; ++i) {
            if (this.sectors[i] == null || this.sectors[i].key_read == this.sectors[i].key_wanted) continue;
            hashMap.put(new Integer(this.sectors[i].key_read), new Integer(this.sectors[i].key_read));
        }
        if (hashMap.size() == 0) {
            return null;
        }
        Object[] objectArray = hashMap.keySet().toArray(new Integer[0]);
        Arrays.sort(objectArray);
        String string = "";
        for (int i = 0; i < objectArray.length; ++i) {
            string = string + String.format("%02x ", (Integer)objectArray[i] & 0xFF);
        }
        return string;
    }

    public int getHighestKeyDelta() {
        int n = 0;
        for (int i = 0; i < this.sectors.length; ++i) {
            if (this.sectors[i] == null || this.sectors[i].key_read == this.sectors[i].key_wanted) continue;
            int n2 = this.sectors[i].key_wanted - this.sectors[i].key_read;
            n = Math.max(n, Math.abs(n2));
        }
        return n;
    }

    public boolean anyPartialSectors() {
        boolean bl = false;
        for (int i = 0; i < this.sectors.length; ++i) {
            if (this.sectors[i] == null || this.sectors[i].different_words_in_sector == 120) continue;
            bl = true;
        }
        return bl;
    }

    public String getTimestamps() {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("(MM/dd/yy HH:mm:ss.SSS) ");
        HashMap<Date, Date> hashMap = new HashMap<Date, Date>(8);
        for (Sector sector : this.sectors) {
            if (sector == null || sector.tod_in_sector == null) continue;
            hashMap.put(sector.tod_in_sector, sector.tod_in_sector);
        }
        if (hashMap.size() == 0) {
            return null;
        }
        Object[] objectArray = hashMap.keySet().toArray(new Date[0]);
        Arrays.sort(objectArray);
        String string = "";
        for (int i = 0; i < objectArray.length; ++i) {
            string = string + simpleDateFormat.format((Date)objectArray[i]);
        }
        return string;
    }

    public String getWrongLbas() {
        HashMap<Long, Long> hashMap = new HashMap<Long, Long>(8);
        for (int i = 0; i < this.sectors.length; ++i) {
            if (this.sectors[i] == null || this.sectors[i].lba_read == this.sectors[i].lba_wanted) continue;
            hashMap.put(new Long(this.sectors[i].lba_read), new Long(this.sectors[i].lba_read));
        }
        if (hashMap.size() == 0) {
            return null;
        }
        Object[] objectArray = hashMap.keySet().toArray(new Long[0]);
        Arrays.sort(objectArray);
        String string = "";
        for (int i = 0; i < objectArray.length; ++i) {
            if (i > 2) {
                return string + "...";
            }
            string = string + String.format("0x%x ", (Long)objectArray[i]);
        }
        return string;
    }

    public String getWrongSdNames() {
        HashMap<String, String> hashMap = new HashMap<String, String>(8);
        for (int i = 0; i < this.sectors.length; ++i) {
            if (this.sectors[i] == null || this.sectors[i].sd_read == this.sectors[i].sd_wanted) continue;
            hashMap.put(this.sectors[i].sd_read, this.sectors[i].sd_read);
        }
        if (hashMap.size() == 0) {
            return null;
        }
        Object[] objectArray = hashMap.keySet().toArray(new String[0]);
        Arrays.sort(objectArray);
        String string = "";
        for (int i = 0; i < objectArray.length; ++i) {
            string = string + (String)objectArray[i] + " ";
        }
        return string;
    }

    public boolean getLFSRStatus() {
        boolean bl = false;
        for (int i = 0; i < this.sectors.length; ++i) {
            if (this.sectors[i] == null || !this.sectors[i].lfsr_of_bad_lba_bad) continue;
            bl = true;
        }
        return bl;
    }

    public void reReadSectors() {
        for (int i = 0; i < this.sectors.length; ++i) {
            if (this.sectors[i] == null) continue;
            this.sectors[i].reReadSector(this);
        }
    }

    public static String header() {
        return String.format(DVPost.name_mask + " %12s %12s %12s %7s %5s %9s ", "lun/file", "log_lba", "start_lba", "file_lba", "sectors", "(bad)", "Key_e/r/d");
    }

    public String print() {
        int n = 0;
        for (Sector sector : this.sectors) {
            if (sector == null) continue;
            ++n;
        }
        String string = this.key_wanted - this.key_read > 1 ? "/" + (this.key_wanted - this.key_read) : "";
        String string2 = String.format(DVPost.name_mask + " %12x %12x %12x %7d %5d %02x/%02x%-4s", this.lun, this.logical_lba, this.file_start_lba, this.logical_lba - this.file_start_lba, this.sectors.length, n, this.key_wanted, this.key_read, string);
        return string2;
    }
}

