/*
 * Decompiled with CFR 0.152.
 */
package Vdb;

import Vdb.common;
import java.text.SimpleDateFormat;
import java.util.TimeZone;

public class Elapsed {
    private static final String c = "Copyright (c) 2000, 2016, Oracle and/or its affiliates. All rights reserved.";
    private double start;
    private long count = 0L;
    private long frequency = 0L;
    private String label = null;
    private long last_track_report = 0L;

    public Elapsed(String string) {
        this.label = string;
        this.start = System.currentTimeMillis();
    }

    public Elapsed(String string, long l) {
        this.label = string;
        this.start = System.currentTimeMillis();
        this.last_track_report = System.currentTimeMillis();
        this.frequency = l;
    }

    public void track() {
        this.track(1L);
    }

    public void track(long l) {
        if (this.frequency == 0L) {
            common.failure("Elapsed.track(): requesting tracking without a specified frequence");
        }
        ++this.count;
        if (this.count % this.frequency == 0L && this.count != 1L) {
            long l2 = System.currentTimeMillis();
            double d = (double)(l2 - this.last_track_report) / 1000.0;
            common.ptod("Elapsed.track: '%s' tracking has been called %,16d times, at %,10.0f per second", this.label, this.count * l, (double)this.frequency * (double)l / d);
            this.last_track_report = l2;
        }
    }

    public void end() {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("HH:mm:ss");
        simpleDateFormat.setTimeZone(TimeZone.getTimeZone("UTC"));
        double d = System.currentTimeMillis();
        common.ptod("Elapsed.end: %s took %s", this.label, simpleDateFormat.format(d - this.start));
    }

    public void end(int n) {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("HH:mm:ss");
        simpleDateFormat.setTimeZone(TimeZone.getTimeZone("UTC"));
        double d = System.currentTimeMillis();
        double d2 = (d - this.start) / 1000.0;
        if (d2 < (double)n) {
            return;
        }
        common.ptod("Elapsed.end: %s took %s", this.label, simpleDateFormat.format(d - this.start));
    }

    public static void main(String[] stringArray) {
        Elapsed elapsed = new Elapsed("testing", 10000L);
        for (int i = 0; i < 100000; ++i) {
            elapsed.track();
        }
        elapsed.end();
    }
}

