/*
 * Decompiled with CFR 0.152.
 */
package Vdb;

import Vdb.FileAnchor;
import Vdb.common;
import java.io.BufferedReader;
import java.io.InputStreamReader;

public class Estimate {
    private static final String c = "Copyright (c) 2000, 2016, Oracle and/or its affiliates. All rights reserved.";
    private static BufferedReader br = new BufferedReader(new InputStreamReader(System.in));

    public static void main(String[] stringArray) {
        Estimate.display("", new Object[0]);
        Estimate.display("Vdbench memory estimation ", new Object[0]);
        Estimate.display("", new Object[0]);
        Estimate.sdCalculation();
    }

    private static void sdCalculation() {
        Object var0 = null;
        long l = common.parseSize(Estimate.query("How many SDs?", new Object[0]));
        long l2 = common.parseSize(Estimate.query("Number of threads per SD?", new Object[0]));
        long l3 = common.parseSize(Estimate.query("Largest xfersize (k/m)?", new Object[0]));
        boolean bl = Estimate.query("Will you be using Data Validation? (y/n)", new Object[0]).startsWith("y");
        if (!bl) {
            Estimate.display("", new Object[0]);
            Estimate.display("Estimated native memory needs for data buffers: #sds * #threads * max_fersize * 2", new Object[0]);
            Estimate.display("Estimated native memory needs for data buffers: %4d * %8d * %,11d * 2 = %,d (%s)", l, l2, l3, 2L * l * l2 * l3, FileAnchor.whatSize(2L * l * l2 * l3));
            Estimate.display("", new Object[0]);
        } else {
            long l4 = common.parseSize(Estimate.query("Lun size per SD (k/m/g/t)?", new Object[0]));
            long l5 = common.parseSize(Estimate.query("Smallest xfersize (k/m)?", new Object[0]));
            Estimate.display("", new Object[0]);
            Estimate.display("Estimated native memory needs for data buffers: #sds * #threads * max_fersize * 2", new Object[0]);
            Estimate.display("Estimated native memory needs for data buffers: %4d * %8d * %,11d * 2 = %,d (%s)", l, l2, l3, 2L * l * l2 * l3, FileAnchor.whatSize(2L * l * l2 * l3));
            Estimate.display("", new Object[0]);
            long l6 = l * l4;
            Estimate.display("", new Object[0]);
            Estimate.display("Estimated total lun size: %,d (%s) ", l6, FileAnchor.whatSize(l6));
            Estimate.display("Estimated native memory needs for Data Validation table: one byte per smallest xfersize: %,d (%s) ", l6 / l5, FileAnchor.whatSize(l6 / l5));
            Estimate.display("", new Object[0]);
        }
    }

    private static void display(String string, Object ... objectArray) {
        String string2 = String.format(string, objectArray);
        System.out.println(string2);
    }

    private static String query(String string, Object ... objectArray) {
        String string2 = String.format(string, objectArray);
        string2 = String.format("%-40s ===> ", string2);
        System.out.print(string2);
        try {
            String string3 = br.readLine();
            if (string3.startsWith("q")) {
                System.out.println();
                System.out.println("Quitting upon request");
                System.out.println();
                System.exit(0);
            }
            return string3;
        }
        catch (Exception exception) {
            common.failure(exception);
            return null;
        }
    }
}

