/*
 * Decompiled with CFR 0.152.
 */
package Vdb;

import Vdb.FifoGetWaiter;
import Vdb.MiscParms;
import Vdb.SlaveJvm;
import Vdb.Validate;
import Vdb.WT_task;
import Vdb.common;
import java.util.ArrayList;
import java.util.Random;
import java.util.Vector;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;

public class Fifo {
    private static final String c = "Copyright (c) 2000, 2016, Oracle and/or its affiliates. All rights reserved.";
    private long entries;
    private long entries_low;
    public long entries_high;
    private String label;
    private Object[] list;
    private long last_get_index;
    private long last_put_index;
    private int threads = 1;
    private ArrayList waiting_list = new ArrayList(64);
    public Semaphore free_entries;
    private Semaphore avail_entries;
    public Semaphore wait_for_room = new Semaphore(0);
    private long getw = 0L;
    private long gets = 0L;
    private long puts = 0L;
    private long xfers = 0L;
    private long try1 = 0L;
    private long try2 = 0L;
    private long get_acq = 0L;
    private long acq2 = 0L;
    private long putw = 0L;
    private long roomacq = 0L;
    private long nowaits = 0L;
    private long put_queue_sum = 0L;
    private long put_queue_max = 0L;
    private long room_waits = 0L;
    private long room_release = 0L;
    private static final boolean debug = false;
    private static Vector<Fifo> active_fifos = new Vector(64);
    private static int WT_TO_IOT_SIZE = 2000;
    private static int WT_TO_IOT_SIZE_PRIORITIES = 2000;
    private static int WT_TO_IOT_SIZE_DV = 2000;
    private static int WG_TO_WT_SIZE = 2000;
    private long old_puts = 0L;
    private long old_xfers = 0L;
    private long old_gets = 0L;
    private long old_getw = 0L;
    private long old_nowaits = 0L;
    private long old_room_waits = 0L;
    private long old_room_release = 0L;

    public Fifo(String string, int n) {
        this.label = string;
        this.list = new Object[n];
        this.entries = n;
        this.entries_low = n * 30 / 100;
        this.entries_high = n * 90 / 100;
        this.free_entries = new Semaphore(n);
        this.avail_entries = new Semaphore(0);
        active_fifos.add(this);
    }

    public static void clearFifoVector() {
        active_fifos.removeAllElements();
    }

    public void setThreadCount(int n) {
        this.threads = n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void put(Object object) throws InterruptedException {
        boolean bl;
        while (!(bl = this.free_entries.tryAcquire(1, 1000L, TimeUnit.MILLISECONDS))) {
            if (!SlaveJvm.isWorkloadDone()) continue;
            throw new InterruptedException();
        }
        Fifo fifo = this;
        synchronized (fifo) {
            int n = this.waiting_list.size();
            if (n > 0) {
                FifoGetWaiter fifoGetWaiter = (FifoGetWaiter)this.waiting_list.get(n - 1);
                this.waiting_list.remove(n - 1);
                ++this.nowaits;
                fifoGetWaiter.obj = object;
                fifoGetWaiter.sema_waiting.release();
                this.free_entries.release(1);
                ++this.xfers;
                return;
            }
            this.list[(int)(this.last_put_index++ % this.entries)] = object;
            this.avail_entries.release(1);
            int n2 = this.avail_entries.availablePermits();
            ++this.puts;
            this.put_queue_sum += (long)n2;
            this.put_queue_max = Math.max(this.put_queue_max, (long)n2);
        }
    }

    public void putQ(ArrayList arrayList) throws InterruptedException {
        for (int i = 0; i < arrayList.size(); ++i) {
            this.put(arrayList.get(i));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object get() throws InterruptedException {
        FifoGetWaiter fifoGetWaiter = null;
        Fifo fifo = this;
        synchronized (fifo) {
            if (this.avail_entries.availablePermits() > 0) {
                int n;
                this.avail_entries.acquireUninterruptibly();
                Object object = this.list[(int)(this.last_get_index++ % this.entries)];
                this.free_entries.release(1);
                if ((long)this.free_entries.availablePermits() > this.entries) {
                    common.failure("too many free entries: " + this.free_entries.availablePermits() + " " + this.entries);
                }
                ++this.gets;
                if ((long)this.avail_entries.availablePermits() == this.entries_low && (n = this.wait_for_room.getQueueLength()) > 0) {
                    this.wait_for_room.release(n);
                    ++this.room_release;
                }
                return object;
            }
            if (this.avail_entries.availablePermits() == 0) {
                Semaphore semaphore = this.avail_entries;
                synchronized (semaphore) {
                    this.avail_entries.notifyAll();
                }
            }
            fifoGetWaiter = new FifoGetWaiter();
            this.waiting_list.add(fifoGetWaiter);
        }
        try {
            boolean bl;
            while (!(bl = fifoGetWaiter.sema_waiting.tryAcquire(1, 100L, TimeUnit.MILLISECONDS))) {
                if (!SlaveJvm.isWorkloadDone()) continue;
                throw new InterruptedException();
            }
            ++this.getw;
        }
        catch (InterruptedException interruptedException) {
            return null;
        }
        return fifoGetWaiter.obj;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getArray(Object[] objectArray, boolean bl) throws InterruptedException {
        Object var3_3 = null;
        int n = objectArray.length;
        Fifo fifo = this;
        synchronized (fifo) {
            int n2 = this.avail_entries.availablePermits();
            if (n2 > 0) {
                int n3;
                int n4;
                int n5 = (n2 + this.threads - 1) / this.threads;
                if (n5 > n) {
                    n5 = n;
                }
                this.avail_entries.acquireUninterruptibly(n5);
                for (n4 = 0; n4 < n5; ++n4) {
                    objectArray[n4] = this.list[(int)(this.last_get_index++ % this.entries)];
                }
                this.free_entries.release(n5);
                n4 = n5;
                this.gets += (long)n5;
                if (this.avail_entries.availablePermits() == 0) {
                    Semaphore semaphore = this.avail_entries;
                    synchronized (semaphore) {
                        this.avail_entries.notifyAll();
                    }
                }
                if ((long)this.free_entries.availablePermits() > this.entries) {
                    common.ptod("howmany: " + n4);
                    common.failure("too many free entries: " + this.free_entries.availablePermits() + " " + this.entries);
                }
                if ((long)this.avail_entries.availablePermits() == this.entries_low && (n3 = this.wait_for_room.getQueueLength()) > 0) {
                    this.wait_for_room.release(n3);
                    ++this.room_release;
                }
                return n4;
            }
        }
        if (!bl) {
            return 0;
        }
        objectArray[0] = this.get();
        return 1;
    }

    private static void obsolete_getUntilDone(String string, Semaphore semaphore) throws InterruptedException {
        do {
            boolean bl;
            if (!(bl = semaphore.tryAcquire(1, 1000L, TimeUnit.MILLISECONDS))) continue;
            return;
        } while (!SlaveJvm.isWorkloadDone());
        throw new InterruptedException();
    }

    public int getQueueDepth() {
        return this.avail_entries.availablePermits();
    }

    public boolean isGettingFull() {
        return (long)this.avail_entries.availablePermits() > this.entries_high;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitForRoom() throws InterruptedException {
        if ((long)this.avail_entries.availablePermits() > this.entries_high) {
            Fifo fifo = this;
            synchronized (fifo) {
                ++this.room_waits;
            }
            boolean bl = this.wait_for_room.tryAcquire(10, 1L, TimeUnit.MILLISECONDS);
        }
    }

    public void waitAndPut(Object object) throws InterruptedException {
        this.waitForRoom();
        this.put(object);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitUntilEmpty() {
        Semaphore semaphore = this.avail_entries;
        synchronized (semaphore) {
            while (this.avail_entries.availablePermits() > 0) {
                try {
                    this.avail_entries.wait();
                }
                catch (InterruptedException interruptedException) {
                    return;
                }
            }
        }
    }

    public static void drainAllFifos() {
        for (int i = 0; i < active_fifos.size(); ++i) {
            active_fifos.get(i).drainFifo();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void drainFifo() {
        Fifo fifo = this;
        synchronized (fifo) {
            common.ptod("avail_entries.availablePermits(): " + this.avail_entries.availablePermits());
            Semaphore semaphore = this.avail_entries;
            synchronized (semaphore) {
                while (this.avail_entries.availablePermits() > 0) {
                    try {
                        this.get();
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                        break;
                    }
                }
            }
        }
    }

    public long getPutCount() {
        return this.puts;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void printQueues() {
        if (common.get_debug(common.FIFO_STATS)) {
            Object object = common.ptod_lock;
            synchronized (object) {
                Fifo.printQueueLengths("to_iot");
                Fifo.printQueueLengths("to_wait");
            }
        }
    }

    private static void printQueueLengths(String string) {
        long l = 0L;
        long l2 = 0L;
        long l3 = 0L;
        long l4 = 0L;
        long l5 = 0L;
        long l6 = 0L;
        long l7 = 0L;
        long l8 = 0L;
        for (int i = 0; i < active_fifos.size(); ++i) {
            Fifo fifo = active_fifos.elementAt(i);
            if (!fifo.label.startsWith(string)) continue;
            l += fifo.puts;
            l2 += fifo.xfers;
            l3 += fifo.gets;
            l4 += fifo.getw;
            l5 += fifo.nowaits;
            l6 += fifo.put_queue_sum;
            l8 += fifo.room_release;
            l7 += fifo.puts > 0L ? fifo.put_queue_sum / fifo.puts : 0L;
            common.ptod("fifo: %-18s p: %8d x: %8d g: %8d gw: %8d nwt: %8d avq: %4d max: %4d rr: %3d", fifo.label, fifo.puts, fifo.xfers, fifo.gets, fifo.getw, fifo.nowaits, fifo.puts > 0L ? fifo.put_queue_sum / fifo.puts : 0L, fifo.put_queue_max, fifo.room_release);
        }
        common.ptod("fifo: %-18s p: %8d x: %8d g: %8d gw: %8d nwt: %8d avq: %4d rr: %3d", string, l, l2, l3, l4, l5, l > 0L ? l6 / l : 0L, l8);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void printFifoStatuses() {
        if (!common.get_debug(common.FIFO_STATS)) {
            return;
        }
        Object object = common.ptod_lock;
        synchronized (object) {
            Fifo.printStatus("to_wait");
            Fifo.printStatus("to_iot");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void printStatus(String string) {
        int n = 0;
        long l = 0L;
        long l2 = 0L;
        Object object = WT_task.sleep_lock;
        synchronized (object) {
            n = WT_task.sleeping;
            l = WT_task.sleep_count;
            l2 = WT_task.sleep_last;
        }
        for (int i = 0; i < active_fifos.size(); ++i) {
            Fifo fifo;
            Fifo fifo2 = fifo = active_fifos.elementAt(i);
            synchronized (fifo2) {
                if (fifo.label.startsWith(string)) {
                    common.ptod("fifo: %-20s p: %6d x: %6d g: %6d w: %6d nw: %6d f: %4d a: %4d wfrp: %3d wfrq: %2d rwt: %4d rrl: %4d wl: %4d sl: %d sc: %6d sl: %d", fifo.label, fifo.puts - fifo.old_puts, fifo.xfers - fifo.old_xfers, fifo.gets - fifo.old_gets, fifo.getw - fifo.old_getw, fifo.nowaits - fifo.old_nowaits, fifo.free_entries.availablePermits(), fifo.avail_entries.availablePermits(), fifo.wait_for_room.availablePermits(), fifo.wait_for_room.getQueueLength(), fifo.room_waits - fifo.old_room_waits, fifo.room_release - fifo.old_room_release, fifo.waiting_list.size(), n, l, l2);
                    fifo.old_puts = fifo.puts;
                    fifo.old_xfers = fifo.xfers;
                    fifo.old_gets = fifo.gets;
                    fifo.old_getw = fifo.getw;
                    fifo.old_nowaits = fifo.nowaits;
                    fifo.old_room_waits = fifo.room_waits;
                    fifo.old_room_release = fifo.room_release;
                }
                continue;
            }
        }
    }

    public static int getSizeNeeded(int n) {
        int n2 = Fifo.findOverride();
        if (n2 != 0) {
            return n2;
        }
        if (Validate.isRealValidate()) {
            return WT_TO_IOT_SIZE_DV;
        }
        if (n == 1) {
            return WT_TO_IOT_SIZE;
        }
        return WT_TO_IOT_SIZE_PRIORITIES;
    }

    public String getLabel() {
        return this.label;
    }

    private static int findOverride() {
        ArrayList<String[]> arrayList = MiscParms.getMiscellaneous();
        for (String[] stringArray : arrayList) {
            for (String string : stringArray) {
                String[] stringArray2 = string.trim().split("=");
                if (!stringArray2[0].equalsIgnoreCase("fifo")) continue;
                return Integer.parseInt(stringArray2[1]);
            }
        }
        return 0;
    }

    public static void main(String[] stringArray) throws Exception {
        int n = Integer.parseInt(stringArray[0]) * 1000000;
        Fifo fifo = new Fifo("test", 2000);
        Random random = new Random();
        long l = System.currentTimeMillis();
        for (int i = 0; i < n; ++i) {
            double d = random.nextDouble();
        }
        long l2 = System.currentTimeMillis();
        double d = (double)(l2 - l) / 1000.0;
        common.ptod("loop: %,d; per second: %,.0f; seconds: %.6f", n, (double)n / d, d);
    }
}

