/*
 * Decompiled with CFR 0.152.
 */
package Vdb;

import Utils.Format;
import Vdb.ErrorLog;
import Vdb.Kstat_data;
import Vdb.Report;
import Vdb.SdStats;
import Vdb.common;
import java.io.PrintWriter;
import java.util.Date;

public class FinalTotals {
    private static final String c = "Copyright (c) 2000, 2015, Oracle and/or its affiliates. All rights reserved.";
    private static SdStats total_sd = new SdStats();
    private static Kstat_data total_ks = new Kstat_data();

    public static void add(SdStats sdStats) {
        total_sd.stats_accum(sdStats, true);
    }

    public static void add(Kstat_data kstat_data) {
        total_ks.kstat_accum(kstat_data, true);
    }

    public static void printTotals(int n) {
        if (FinalTotals.total_sd.reads + FinalTotals.total_sd.writes == 0L) {
            return;
        }
        PrintWriter printWriter = Report.createHmtlFile("totals_optional.html");
        double d = 1.073741824E9;
        double d2 = (double)FinalTotals.total_sd.r_bytes / d;
        double d3 = (double)FinalTotals.total_sd.w_bytes / d;
        double d4 = d2 + d3;
        double d5 = ErrorLog.getErrorCount() == 0 ? 0.0 : (double)ErrorLog.getErrorCount() / d4;
        String string = common.tod();
        printWriter.println("");
        printWriter.println("This report is created at the end of each successfully completed reporting interval.");
        printWriter.println("Last reported interval is interval #" + n + " on " + new Date());
        printWriter.println("");
        printWriter.println("");
        printWriter.println("Overall execution totals logical i/o: ");
        printWriter.println(Format.f("Total iops:             %12.2f", total_sd.rate()));
        printWriter.println(Format.f("Total reads+writes:     %12d", FinalTotals.total_sd.reads + FinalTotals.total_sd.writes));
        printWriter.println(Format.f("Total gigabytes:        %12.2f", d4));
        printWriter.println(Format.f("Total gigabytes read:   %12.2f", d2));
        printWriter.println(Format.f("Total gigabytes write:  %12.2f", d3));
        printWriter.println(Format.f("Total reads:            %12d", FinalTotals.total_sd.reads));
        printWriter.println(Format.f("Total writes:           %12d", FinalTotals.total_sd.writes));
        printWriter.println(Format.f("Total readpct:          %12.2f", total_sd.readpct()));
        printWriter.println(Format.f("Total I/O or DV errors: %12d", ErrorLog.getErrorCount()) + Format.f(" (%.12f errors per GB)", d5));
        printWriter.println("");
        if (!common.onSolaris()) {
            return;
        }
        d2 = (double)FinalTotals.total_ks.nread / d;
        d3 = (double)FinalTotals.total_ks.nwritten / d;
        d4 = d2 + d3;
        d5 = ErrorLog.getErrorCount() == 0 ? 0.0 : (double)ErrorLog.getErrorCount() / d4;
        printWriter.println("");
        printWriter.println("Overall execution totals physical i/o: ");
        printWriter.println(Format.f("Total iops:             %8.2f", total_ks.kstat_rate()));
        printWriter.println(Format.f("Total reads+writes:     %8d", FinalTotals.total_ks.reads + FinalTotals.total_ks.writes));
        printWriter.println(Format.f("Total gigabytes:        %8.2f", d4));
        printWriter.println(Format.f("Total gigabytes read    %8.2f", d2));
        printWriter.println(Format.f("Total gigabytes write   %8.2f", d3));
        printWriter.println(Format.f("Total reads:            %8d", FinalTotals.total_ks.reads));
        printWriter.println(Format.f("Total writes:           %8d", FinalTotals.total_ks.writes));
        printWriter.println(Format.f("Total readpct:          %8.2f", total_ks.kstat_readpct()));
        printWriter.println(Format.f("Total I/O or DV errors: %8d", ErrorLog.getErrorCount()) + Format.f(" (%.8f errors per GB)", d5));
        printWriter.println("");
        printWriter.close();
    }
}

