/*
 * Decompiled with CFR 0.152.
 */
package Vdb;

import Vdb.Dedup;
import Vdb.FileAnchor;
import Vdb.FsdEntry;
import Vdb.FwgEntry;
import Vdb.Host;
import Vdb.Jnl_entry;
import Vdb.Operations;
import Vdb.Patterns;
import Vdb.RD_entry;
import Vdb.ReplayInfo;
import Vdb.SD_entry;
import Vdb.Validate;
import Vdb.Vdb_scan;
import Vdb.Vdbmain;
import Vdb.WG_entry;
import Vdb.common;
import java.io.Serializable;
import java.util.Vector;

public class For_loop
implements Serializable,
Cloneable {
    private static final String c = "Copyright (c) 2000, 2016, Oracle and/or its affiliates. All rights reserved.";
    private String label;
    private double[] value;
    private double forxfersize;
    private double forseekpct;
    private double forhitarea;
    private double forthreads;
    public double threads_before_override = 0.0;
    private double forrdpct;
    private double forrhpct;
    private double forwhpct;
    private double foriorate;
    private double forcomp;
    private double fordepth;
    private double forwidth;
    private double forfiles;
    private double foroperation;
    private double forsizes;
    private double fortotal;
    private double forwss;
    private String display_text;
    private static RD_entry last_rd_checked = null;
    private static Vector override_display;
    private static boolean any_compressions;
    public static double NOVALUE;
    private static For_loop last;

    For_loop() {
        this.init();
    }

    For_loop(String string, double[] dArray, Vector vector) {
        int n;
        this.init();
        this.label = string;
        this.value = new double[dArray.length];
        if (dArray.length == 0) {
            String string2 = string.substring(3);
            common.failure("For_loop(): 'rd=%s,%s=' or 'rd=%s,%s=': the list of NUMERIC values is empty. ", For_loop.last_rd_checked.rd_name, string, For_loop.last_rd_checked.rd_name, string2);
        }
        for (n = 0; n < vector.size(); ++n) {
            For_loop for_loop = (For_loop)vector.elementAt(n);
            if (!for_loop.label.equals(string)) continue;
            vector.removeElementAt(n);
        }
        for (n = 0; n < dArray.length; ++n) {
            this.value[n] = dArray[n];
        }
        vector.add(this);
    }

    public double getThreads() {
        return this.forthreads;
    }

    public void changeThreads(int n) {
        this.threads_before_override = this.forthreads;
        this.forthreads = n;
    }

    public int getSharedThreads() {
        if (!Validate.sdConcatenation()) {
            return 0;
        }
        if (this.getThreads() == NOVALUE) {
            return 0;
        }
        return (int)this.getThreads();
    }

    public boolean sharingThreads() {
        return this.getSharedThreads() > 0;
    }

    public double getXfersize() {
        return this.forxfersize;
    }

    public double getRdPct() {
        return this.forrdpct;
    }

    public static boolean anyCompression() {
        return any_compressions;
    }

    private void init() {
        this.forxfersize = NOVALUE;
        this.forseekpct = NOVALUE;
        this.forhitarea = NOVALUE;
        this.forthreads = NOVALUE;
        this.forrdpct = NOVALUE;
        this.forrhpct = NOVALUE;
        this.forwhpct = NOVALUE;
        this.foriorate = NOVALUE;
        this.forcomp = NOVALUE;
        this.fordepth = NOVALUE;
        this.forwidth = NOVALUE;
        this.forfiles = NOVALUE;
        this.foroperation = NOVALUE;
        this.forsizes = NOVALUE;
        this.fortotal = NOVALUE;
        this.forwss = NOVALUE;
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (Exception exception) {
            common.failure(exception);
            return null;
        }
    }

    public String getText() {
        if (this.display_text == null) {
            return "For loops: None";
        }
        return "For loops: " + this.display_text;
    }

    public static void for_get(int n, RD_entry rD_entry, Vector vector) {
        int n2;
        For_loop for_loop = null;
        For_loop for_loop2 = null;
        int n3 = 0;
        if (n == 0) {
            last.init();
            vector.removeAllElements();
            override_display = new Vector(8, 0);
        }
        if (n == 0 && rD_entry.for_list.size() == 0) {
            for_loop = new For_loop();
            vector.addElement(for_loop);
            return;
        }
        for (n2 = n; n2 < rD_entry.for_list.size(); ++n2) {
            for_loop = (For_loop)rD_entry.for_list.elementAt(n2);
            for (n3 = 0; n3 < for_loop.value.length; ++n3) {
                if (for_loop.label.equals("forcomp") && Validate.isValidate()) {
                    common.failure("The 'forcompratio=' parameter may not be used during Data Validation");
                }
                if (for_loop.label.equals("forxfersize")) {
                    For_loop.last.forxfersize = for_loop.value[n3];
                } else if (for_loop.label.equals("forseekpct")) {
                    For_loop.last.forseekpct = for_loop.value[n3];
                } else if (for_loop.label.equals("forhitarea")) {
                    For_loop.last.forhitarea = for_loop.value[n3];
                } else if (for_loop.label.equals("forthreads")) {
                    For_loop.last.forthreads = for_loop.value[n3];
                } else if (for_loop.label.equals("forrdpct")) {
                    For_loop.last.forrdpct = for_loop.value[n3];
                } else if (for_loop.label.equals("forrhpct")) {
                    For_loop.last.forrhpct = for_loop.value[n3];
                } else if (for_loop.label.equals("forwhpct")) {
                    For_loop.last.forwhpct = for_loop.value[n3];
                } else if (for_loop.label.equals("foriorate")) {
                    For_loop.last.foriorate = for_loop.value[n3];
                } else if (for_loop.label.equals("forcomp")) {
                    For_loop.last.forcomp = for_loop.value[n3];
                } else if (for_loop.label.equals("fordepth")) {
                    For_loop.last.fordepth = for_loop.value[n3];
                } else if (for_loop.label.equals("forwidth")) {
                    For_loop.last.forwidth = for_loop.value[n3];
                } else if (for_loop.label.equals("forfiles")) {
                    For_loop.last.forfiles = for_loop.value[n3];
                } else if (for_loop.label.equals("foroperation")) {
                    For_loop.last.foroperation = for_loop.value[n3];
                } else if (for_loop.label.equals("forsizes")) {
                    For_loop.last.forsizes = for_loop.value[n3];
                } else if (for_loop.label.equals("fortotalsize")) {
                    For_loop.last.fortotal = for_loop.value[n3];
                } else {
                    if (!for_loop.label.equals("forwss")) continue;
                    For_loop.last.forwss = for_loop.value[n3];
                }
                if (for_loop.label.equals("forcomp")) {
                    any_compressions = true;
                }
                for_loop.updateDisplayList(rD_entry, for_loop.value[n3]);
                For_loop.for_get(n2 + 1, rD_entry, vector);
            }
            if (n3 != for_loop.value.length) continue;
            return;
        }
        for_loop2 = (For_loop)last.clone();
        vector.add(for_loop2);
        for_loop2.display_text = "";
        for (n2 = 0; n2 < override_display.size(); ++n2) {
            String string = (String)override_display.elementAt(n2);
            string = string.substring(3);
            for_loop2.display_text = for_loop2.display_text + string + " ";
        }
        for_loop2.display_text = for_loop2.display_text.trim();
    }

    private void updateDisplayList(RD_entry rD_entry, double d) {
        String string;
        int n;
        String string2;
        double d2 = 1048576.0;
        double d3 = 1.073741824E9;
        String string3 = this.label;
        if (string3.equals("foroperation")) {
            string2 = string3 + "=" + Operations.getOperationText((int)d);
        } else if (d < 0.0) {
            string2 = string3 + "=" + (int)(d * -1.0) + "%";
        } else if (string3.equals("foriorate")) {
            if (Vdbmain.isFwdWorkload()) {
                string3 = "forfwdrate";
            }
            string2 = d == (double)RD_entry.MAX_RATE ? string3 + "=max" : (d == (double)RD_entry.CURVE_RATE ? string3 + "=curve" : string3 + "=" + (int)d);
        } else {
            string2 = string3 + "=" + FileAnchor.whatSize(d);
        }
        if (string2.endsWith(".0")) {
            string2 = string2.replace(".0", "");
        }
        boolean bl = false;
        for (n = 0; n < override_display.size(); ++n) {
            string = (String)override_display.elementAt(n);
            if (!string.startsWith(string3)) continue;
            override_display.set(n, string2);
            bl = true;
            break;
        }
        if (!bl) {
            override_display.add(string2);
        }
        for (n = 9999990; n < override_display.size(); ++n) {
            string = (String)override_display.elementAt(n);
            common.ptod("display: " + n + " " + string);
        }
    }

    public static void for_add_curve(Vector vector, For_loop for_loop, double d, double[] dArray) {
        int n;
        double[] dArray2 = new double[]{10.0, 50.0, 70.0, 80.0, 90.0, 100.0};
        if (dArray != null) {
            dArray2 = dArray;
        }
        if (d < 1.0) {
            common.failure("for_add_curve(): iorate < 1 " + d + "; was your run too short to establish proper iorate?");
        }
        int n2 = 0;
        for (int i = 0; i < dArray2.length && (n = (n = (int)d * (int)dArray2[i] / 100) > 1000 ? (n + 99) / 100 * 100 : (n + 9) / 10 * 10) >= 10; ++i) {
            For_loop for_loop2 = (For_loop)for_loop.clone();
            for_loop2.label = "foriorate";
            for_loop2.foriorate = (int)dArray2[i] * -1;
            vector.insertElementAt(for_loop2, n2++);
        }
    }

    public static void forLoopOverrideWd(RD_entry rD_entry) {
        for (WG_entry wG_entry : Host.getAllWorkloads()) {
            For_loop.useForOverrides(wG_entry, rD_entry, rD_entry.current_override, wG_entry.sd_used, false);
            if (Dedup.isDedup()) {
                // empty if block
            }
            if (rD_entry.rd_name.equals(Jnl_entry.RECOVERY_RUN_NAME) || ReplayInfo.isReplay()) continue;
            wG_entry.sd_used.trackSdXfersizes(wG_entry.getXfersizes());
        }
    }

    public static void forLoopOverrideFwd(RD_entry rD_entry) {
        For_loop for_loop = rD_entry.current_override;
        for (int i = 0; i < rD_entry.fwgs_for_rd.size(); ++i) {
            FsdEntry fsdEntry;
            FwgEntry fwgEntry = rD_entry.fwgs_for_rd.elementAt(i);
            if (for_loop.fordepth != NOVALUE) {
                fwgEntry.depth = (int)for_loop.fordepth;
            }
            if (for_loop.forwidth != NOVALUE) {
                fwgEntry.width = (int)for_loop.forwidth;
            }
            if (for_loop.forfiles != NOVALUE) {
                fwgEntry.files = (int)for_loop.forfiles;
            }
            if (for_loop.fortotal != NOVALUE) {
                fwgEntry.total_size = (long)for_loop.fortotal;
            }
            if (for_loop.forwss != NOVALUE) {
                fwgEntry.working_set = (long)for_loop.forwss;
            }
            if (for_loop.forrdpct != NOVALUE) {
                fwgEntry.readpct = for_loop.forrdpct;
            }
            if (for_loop.foriorate != NOVALUE) {
                rD_entry.fwd_rate = (int)for_loop.foriorate;
            }
            if (!rD_entry.rd_name.startsWith(RD_entry.FSD_FORMAT_RUN) && for_loop.foroperation != NOVALUE) {
                fwgEntry.setOperation((int)for_loop.foroperation);
            }
            if (for_loop.forxfersize != NOVALUE) {
                fwgEntry.xfersizes = new double[1];
                fwgEntry.xfersizes[0] = for_loop.forxfersize;
            }
            if (for_loop.forsizes != NOVALUE) {
                fwgEntry.filesizes = new double[1];
                fwgEntry.filesizes[0] = for_loop.forsizes;
            }
            if (!rD_entry.rd_name.equals(Jnl_entry.RECOVERY_RUN_NAME)) {
                fwgEntry.anchor.trackXfersizes(fwgEntry.xfersizes);
                fwgEntry.anchor.trackFileSizes(fwgEntry.filesizes);
            }
            if (fwgEntry.total_size < 0L) {
                fsdEntry = FsdEntry.findFsd(fwgEntry.fsd_name);
                if (fsdEntry.total_size == Long.MAX_VALUE) {
                    common.failure("Specifying 'totalsize=" + (int)(fwgEntry.total_size * -1L) + "% without a totalsize= value specified for the FSD");
                }
                fwgEntry.total_size = (long)((double)fsdEntry.total_size * (double)(fwgEntry.total_size * -1L) / 100.0);
            }
            if (fwgEntry.total_size == 0L) {
                fsdEntry = FsdEntry.findFsd(fwgEntry.fsd_name);
                fwgEntry.total_size = fsdEntry.total_size;
            }
            rD_entry.compression_ratio_to_use = for_loop.forcomp != NOVALUE ? for_loop.forcomp : Patterns.getDefaultCompressionRatio();
        }
    }

    public static void useForOverrides(WG_entry wG_entry, RD_entry rD_entry, For_loop for_loop, SD_entry sD_entry, boolean bl) {
        if (for_loop.forxfersize != NOVALUE) {
            wG_entry.setXfersizes(new double[]{(int)for_loop.forxfersize});
            if (wG_entry.getXfersizes()[0] % 512.0 != 0.0) {
                common.failure("data transfer size not multiple of 512 bytes: " + wG_entry.getXfersizes()[0]);
            }
        }
        if (for_loop.forrdpct != NOVALUE) {
            wG_entry.readpct = for_loop.forrdpct;
        }
        if (for_loop.foriorate != NOVALUE) {
            rD_entry.iorate_req = for_loop.foriorate;
        }
        if (for_loop.forrhpct != NOVALUE) {
            wG_entry.rhpct = for_loop.forrhpct;
        }
        if (for_loop.forwhpct != NOVALUE) {
            wG_entry.whpct = for_loop.forwhpct;
        }
        if (for_loop.forseekpct != NOVALUE) {
            wG_entry.seekpct = for_loop.forseekpct;
        }
        rD_entry.compression_ratio_to_use = for_loop.forcomp != NOVALUE ? for_loop.forcomp : Patterns.getDefaultCompressionRatio();
        wG_entry.hitarea_used = 0L;
        if ((int)(wG_entry.rhpct + wG_entry.whpct) != 0) {
            wG_entry.hitarea_used = sD_entry.hitarea;
        }
        if (for_loop.forhitarea != NOVALUE) {
            wG_entry.hitarea_used = (long)for_loop.forhitarea;
        }
        if (for_loop.forthreads != NOVALUE) {
            for_loop.forthreads = (int)for_loop.forthreads;
        }
        if (for_loop.forthreads == 0.0) {
            for_loop.forthreads = 1.0;
            common.ptod("Setting some threadcounts to a minimum of 1 ");
        }
        if (wG_entry.readpct != 100.0) {
            sD_entry.setOpenForWrite();
        }
    }

    public static boolean checkForLoop(RD_entry rD_entry, Vdb_scan vdb_scan) {
        last_rd_checked = rD_entry;
        if ("forxfersize".startsWith(vdb_scan.keyword)) {
            new For_loop("forxfersize", vdb_scan.numerics, rD_entry.for_list);
        } else if ("forthreads".startsWith(vdb_scan.keyword)) {
            new For_loop("forthreads", vdb_scan.numerics, rD_entry.for_list);
        } else if ("forrdpct".startsWith(vdb_scan.keyword)) {
            new For_loop("forrdpct", vdb_scan.numerics, rD_entry.for_list);
        } else if ("forrhpct".startsWith(vdb_scan.keyword)) {
            new For_loop("forrhpct", vdb_scan.numerics, rD_entry.for_list);
        } else if ("forwhpct".startsWith(vdb_scan.keyword)) {
            new For_loop("forwhpct", vdb_scan.numerics, rD_entry.for_list);
        } else if ("forseekpct".startsWith(vdb_scan.keyword)) {
            new For_loop("forseekpct", vdb_scan.numerics, rD_entry.for_list);
        } else if ("forhitarea".startsWith(vdb_scan.keyword)) {
            new For_loop("forhitarea", vdb_scan.numerics, rD_entry.for_list);
        } else if ("forcompratio".startsWith(vdb_scan.keyword)) {
            new For_loop("forcomp", vdb_scan.numerics, rD_entry.for_list);
        } else if ("forcompression".startsWith(vdb_scan.keyword)) {
            new For_loop("forcomp", For_loop.percentageToRatio(vdb_scan.numerics), rD_entry.for_list);
        } else if ("fordepth".startsWith(vdb_scan.keyword)) {
            new For_loop("fordepth", vdb_scan.numerics, rD_entry.for_list);
        } else if ("forwidth".startsWith(vdb_scan.keyword)) {
            new For_loop("forwidth", vdb_scan.numerics, rD_entry.for_list);
        } else if ("forfiles".startsWith(vdb_scan.keyword)) {
            new For_loop("forfiles", vdb_scan.numerics, rD_entry.for_list);
        } else if ("forsizes".startsWith(vdb_scan.keyword)) {
            new For_loop("forsizes", vdb_scan.numerics, rD_entry.for_list);
        } else if ("fortotalsize".startsWith(vdb_scan.keyword)) {
            new For_loop("fortotalsize", vdb_scan.numerics, rD_entry.for_list);
        } else if ("forwss".startsWith(vdb_scan.keyword) || "forworkingsetsize".startsWith(vdb_scan.keyword)) {
            new For_loop("forwss", vdb_scan.numerics, rD_entry.for_list);
        } else if ("foroperations".startsWith(vdb_scan.keyword)) {
            rD_entry.storeForOperations(vdb_scan);
        } else if ("xfersize".startsWith(vdb_scan.keyword)) {
            new For_loop("forxfersize", vdb_scan.numerics, rD_entry.for_list);
        } else if ("threads".startsWith(vdb_scan.keyword)) {
            new For_loop("forthreads", vdb_scan.numerics, rD_entry.for_list);
        } else if ("rdpct".startsWith(vdb_scan.keyword)) {
            new For_loop("forrdpct", vdb_scan.numerics, rD_entry.for_list);
        } else if ("rhpct".startsWith(vdb_scan.keyword)) {
            new For_loop("forrhpct", vdb_scan.numerics, rD_entry.for_list);
        } else if ("whpct".startsWith(vdb_scan.keyword)) {
            new For_loop("forwhpct", vdb_scan.numerics, rD_entry.for_list);
        } else if ("seekpct".startsWith(vdb_scan.keyword)) {
            new For_loop("forseekpct", vdb_scan.numerics, rD_entry.for_list);
        } else if ("hitarea".startsWith(vdb_scan.keyword)) {
            new For_loop("forhitarea", vdb_scan.numerics, rD_entry.for_list);
        } else if ("compratio".startsWith(vdb_scan.keyword)) {
            new For_loop("forcomp", vdb_scan.numerics, rD_entry.for_list);
        } else if ("compression".startsWith(vdb_scan.keyword)) {
            new For_loop("forcomp", For_loop.percentageToRatio(vdb_scan.numerics), rD_entry.for_list);
        } else if ("depth".startsWith(vdb_scan.keyword)) {
            new For_loop("fordepth", vdb_scan.numerics, rD_entry.for_list);
        } else if ("width".startsWith(vdb_scan.keyword)) {
            new For_loop("forwidth", vdb_scan.numerics, rD_entry.for_list);
        } else if ("files".startsWith(vdb_scan.keyword)) {
            new For_loop("forfiles", vdb_scan.numerics, rD_entry.for_list);
        } else if ("sizes".startsWith(vdb_scan.keyword)) {
            new For_loop("forsizes", vdb_scan.numerics, rD_entry.for_list);
        } else if ("totalsize".startsWith(vdb_scan.keyword)) {
            new For_loop("fortotalsize", vdb_scan.numerics, rD_entry.for_list);
        } else if ("wss".startsWith(vdb_scan.keyword) || "workingsetsize".startsWith(vdb_scan.keyword)) {
            new For_loop("forwss", vdb_scan.numerics, rD_entry.for_list);
        } else {
            return false;
        }
        return true;
    }

    private static double[] percentageToRatio(double[] dArray) {
        double[] dArray2 = new double[dArray.length];
        for (int i = 0; i < dArray.length; ++i) {
            dArray2[i] = Double.parseDouble(String.format("%.3f", 100.0 / dArray[i]));
            common.plog("For_loop.percentageToRatio(): converted compression=%.3f to compratio=%.3f", dArray[i], dArray2[i]);
        }
        return dArray2;
    }

    static {
        any_compressions = false;
        NOVALUE = Double.MAX_VALUE;
        last = new For_loop();
    }
}

