/*
 * Decompiled with CFR 0.152.
 */
package Vdb;

import Utils.Bin;
import Utils.Fget;
import Utils.Flat_record;
import Utils.Getopt;
import Vdb.Ctrl_c;
import Vdb.common;
import java.util.StringTokenizer;
import java.util.Vector;

public class Ftobin {
    private static final String c = "Copyright (c) 2000-2008 Sun Microsystems, Inc. All Rights Reserved.";
    private static int exceptions = 0;
    private static String input_file = null;
    private static String output_file = null;
    private static int linecount = Integer.MAX_VALUE;
    private static Flat_record frec = new Flat_record();

    public static void main(String[] stringArray) {
        Getopt getopt = new Getopt(stringArray, ":l:d: ", 2);
        Ftobin.scan_args(getopt);
        Ftobin.flat_to_bin();
        Ctrl_c.removeShutdownHook();
    }

    public static void scan_args(Getopt getopt) {
        if (!getopt.isOK()) {
            common.failure("parameter scan error");
        }
        if (getopt.check('l')) {
            linecount = (int)getopt.get_long();
        }
        getopt.print("Ftobin");
        Vector<String> vector = getopt.get_positionals();
        if (vector != null) {
            if (vector.size() > 0) {
                input_file = vector.elementAt(0);
            }
            if (vector.size() > 1) {
                output_file = vector.elementAt(1);
            }
            if (vector.size() > 2) {
                Ftobin.usage();
            }
        }
        if (input_file == null || output_file == null) {
            System.err.println("File name(s) missing");
            Ftobin.usage();
            common.exit(99);
        }
    }

    private static void usage() {
        System.err.println("Usage: ");
        System.err.println("./vdbench Vdb.Ftobin input_file output_file ");
        System.err.println("input_file: file name or '-' for stdin");
        System.err.println("output_file: file name or '-' for stdout");
        common.exit(99);
    }

    private static void flat_to_bin() {
        String string;
        Fget fget = new Fget(input_file);
        int n = 0;
        Bin bin = new Bin(output_file);
        if (!output_file.equals("null")) {
            bin.output();
        } else {
            return;
        }
        while ((string = fget.get()) != null) {
            if ((string = string.trim()).length() == 0 || string.startsWith("*")) continue;
            if (++n > linecount) break;
            try {
                StringTokenizer stringTokenizer = new StringTokenizer(string);
                Ftobin.frec.start = (long)(Double.parseDouble(stringTokenizer.nextToken()) * 1000.0);
                Ftobin.frec.resp = (long)(Double.parseDouble(stringTokenizer.nextToken()) * 1000.0);
                Ftobin.frec.device = Long.parseLong(stringTokenizer.nextToken());
                Ftobin.frec.lba = Long.parseLong(stringTokenizer.nextToken());
                Ftobin.frec.xfersize = Integer.parseInt(stringTokenizer.nextToken());
                Ftobin.frec.flag = stringTokenizer.nextToken().toLowerCase().startsWith("r") ? (byte)1 : 0;
                Ftobin.frec.pid = Integer.parseInt(stringTokenizer.nextToken());
                frec.export(bin);
            }
            catch (Exception exception) {
                System.err.println("Exception while parsing input file " + input_file);
                System.err.println("Line#: " + n + " Contents: " + string);
                common.failure(exception);
            }
        }
        fget.close();
        bin.close();
    }
}

