/*
 * Decompiled with CFR 0.152.
 */
package Vdb;

import Vdb.FwdStats;
import Vdb.Histogram;
import Vdb.common;
import java.io.Serializable;

class FwdCounter
implements Serializable {
    private static final String c = "Copyright (c) 2000, 2012, Oracle and/or its affiliates. All rights reserved.";
    private String type;
    private FwdStats fstats;
    public long operations;
    public long response;
    public long response2;
    public long maxresp;
    private Histogram histogram = new Histogram("default");
    public long op_count;
    public long op_rate;
    public long op_rate2;
    public long op_max;

    public FwdCounter(FwdStats fwdStats, String string) {
        this.fstats = fwdStats;
        this.type = string.trim();
    }

    public Histogram getHistogram() {
        return this.histogram;
    }

    public void addResp(long l) {
        ++this.operations;
        this.response += l;
        this.response2 += l * l;
        this.maxresp = Math.max(this.maxresp, l);
        this.histogram.addToBucket(l);
    }

    public void accum(FwdCounter fwdCounter) {
        if (this.type.equals("xread")) {
            common.ptod("maxresp0: %-25s, %5d %5d", this, this.maxresp, fwdCounter.maxresp);
            common.where(4);
        }
        this.operations += fwdCounter.operations;
        this.response += fwdCounter.response;
        this.response2 += fwdCounter.response2;
        this.maxresp = Math.max(this.maxresp, fwdCounter.maxresp);
        this.histogram.accumBuckets(fwdCounter.histogram);
        ++this.op_count;
        if (fwdCounter.fstats.getElapsed() != 0L && fwdCounter.operations != 0L) {
            this.op_rate = (long)((double)this.op_rate + fwdCounter.rate());
            this.op_rate2 = (long)((double)this.op_rate2 + fwdCounter.rate() * fwdCounter.rate());
            this.op_max = Math.max(this.op_max, (long)fwdCounter.rate());
        }
    }

    public void delta(FwdCounter fwdCounter, FwdCounter fwdCounter2) {
        this.operations = fwdCounter.operations - fwdCounter2.operations;
        this.response = fwdCounter.response - fwdCounter2.response;
        this.response2 = fwdCounter.response2 - fwdCounter2.response2;
        this.maxresp = Math.max(fwdCounter.maxresp, fwdCounter2.maxresp);
        this.histogram.deltaBuckets(fwdCounter.histogram, fwdCounter2.histogram);
    }

    public void copy(FwdCounter fwdCounter) {
        this.operations = fwdCounter.operations;
        this.response = fwdCounter.response;
        this.response2 = fwdCounter.response2;
        this.maxresp = Math.max(this.maxresp, fwdCounter.maxresp);
        this.op_max = fwdCounter.op_max;
        this.op_rate = fwdCounter.op_rate;
        this.op_rate2 = fwdCounter.op_rate2;
        this.op_count = fwdCounter.op_count;
        this.histogram = (Histogram)fwdCounter.histogram.clone();
        if (this.type.equals("xread")) {
            common.ptod("maxresp1: " + this.maxresp);
            common.where(4);
        }
    }

    public double rate() {
        double d = (double)this.operations * 1000000.0 / (double)this.fstats.getElapsed();
        return d;
    }

    public double resp() {
        if (this.operations == 0L) {
            return 0.0;
        }
        return (double)this.response / (double)this.operations / 1000.0;
    }

    public double respMax() {
        if (this.type.equals("xread")) {
            common.ptod("maxresp2: " + this.maxresp);
            common.where(4);
        }
        return (double)this.maxresp / 1000.0;
    }

    public double rateMax() {
        return this.op_max;
    }

    public double respStd() {
        if (this.operations <= 1L || this.response == 0L) {
            return 0.0;
        }
        return Math.sqrt(((double)this.operations * (double)this.response2 - (double)this.response * (double)this.response) / (double)(this.operations * (this.operations - 1L))) / 1000.0;
    }

    public double rateStd() {
        if (this.op_count <= 1L || this.op_rate == 0L) {
            return 0.0;
        }
        return Math.sqrt(((double)this.op_count * (double)this.op_rate2 - (double)this.op_rate * (double)this.op_rate) / (double)(this.op_count * (this.op_count - 1L)));
    }
}

