/*
 * Decompiled with CFR 0.152.
 */
package Vdb;

import Vdb.FsdEntry;
import Vdb.Host;
import Vdb.Jnl_entry;
import Vdb.OpenFlags;
import Vdb.Operations;
import Vdb.RD_entry;
import Vdb.Validate;
import Vdb.Vdb_scan;
import Vdb.Vdbmain;
import Vdb.common;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Vector;

class FwdEntry
implements Cloneable {
    private static final String c = "Copyright (c) 2000, 2016, Oracle and/or its affiliates. All rights reserved.";
    public String fwd_name = "default";
    public String[] fsd_names = new String[0];
    public String[] host_names = new String[]{"*"};
    public String target_fsd = null;
    public double[] xfersizes = new double[]{4096.0};
    public boolean select_random = false;
    public boolean selseq_start0 = true;
    public boolean select_full = false;
    public boolean select_empty = false;
    public boolean select_nfull = false;
    public boolean select_once = false;
    public double poisson_skew = 0.0;
    public boolean sequential_io = true;
    public boolean seq_io_start0 = true;
    public boolean del_b4_write = false;
    public boolean file_sharing = false;
    public long stopafter = Long.MAX_VALUE;
    public double skew = 0.0;
    public int threads = 1;
    public double readpct = -1.0;
    public OpenFlags open_flags = null;
    private int operation = Operations.getOperationIdentifier("read");
    public static int max_fwd_name = 1;
    private static Vector<FwdEntry> fwd_list = new Vector(8);
    public static boolean format_fwd_found = false;
    public static FwdEntry recovery_fwd = null;
    public static FwdEntry dflt = new FwdEntry();
    public static FwdEntry format_fwd = new FwdEntry();

    FwdEntry() {
    }

    public Object clone() {
        try {
            FwdEntry fwdEntry = (FwdEntry)super.clone();
            fwdEntry.fsd_names = (String[])this.fsd_names.clone();
            fwdEntry.xfersizes = (double[])this.xfersizes.clone();
            if (this.open_flags != null) {
                fwdEntry.open_flags = (OpenFlags)this.open_flags.clone();
            }
            return fwdEntry;
        }
        catch (Exception exception) {
            common.failure(exception);
            return null;
        }
    }

    static String readParms(String string) {
        String string2 = string;
        FwdEntry fwdEntry = null;
        try {
            while (true) {
                Vdb_scan vdb_scan = Vdb_scan.parms_split(string2);
                if (!vdb_scan.keyword.equals("rd") && !vdb_scan.keyword.equals("wd")) {
                    int n;
                    if (vdb_scan.keyword.equals("fwd")) {
                        Vdbmain.setFwdWorkload();
                        if (vdb_scan.alphas[0].equals("default")) {
                            fwdEntry = dflt;
                        } else {
                            for (n = 0; n < fwd_list.size(); ++n) {
                                fwdEntry = fwd_list.elementAt(n);
                                if (!fwdEntry.fwd_name.equalsIgnoreCase(vdb_scan.alphas[0])) continue;
                                common.failure("Duplicate FWD name: " + fwdEntry.fwd_name);
                            }
                            fwdEntry = (FwdEntry)dflt.clone();
                            fwdEntry.fwd_name = vdb_scan.alphas[0];
                            if (fwdEntry.fwd_name.equals(Jnl_entry.RECOVERY_RUN_NAME)) {
                                recovery_fwd = fwdEntry;
                            } else if (fwdEntry.fwd_name.equals("format")) {
                                format_fwd = fwdEntry;
                                format_fwd_found = true;
                                FwdEntry.format_fwd.xfersizes = new double[]{131072.0};
                                common.plog("'fwd=format' will be used only for 'format=' workloads.");
                                common.plog("Only the 'threads=' and 'openflags=' and the first 'xfersize=' will be used.");
                            } else {
                                max_fwd_name = Math.max(max_fwd_name, fwdEntry.fwd_name.length());
                                fwd_list.add(fwdEntry);
                            }
                            if (Vdbmain.isWdWorkload()) {
                                common.ptod("'fwd' and 'wd' parameters are mutually exclusive");
                            }
                            if (Operations.getOperationIdentifier(fwdEntry.fwd_name) >= 0) {
                                common.failure("fwd name may not match a valid operation: fwd=" + fwdEntry.fwd_name);
                            }
                        }
                    } else if (vdb_scan.keyword.equals("fsd")) {
                        fwdEntry.fsd_names = vdb_scan.alphas;
                    } else if ("readpct".startsWith(vdb_scan.keyword) || "rdpct".startsWith(vdb_scan.keyword)) {
                        fwdEntry.readpct = vdb_scan.numerics[0];
                    } else if ("stopafter".startsWith(vdb_scan.keyword)) {
                        fwdEntry.stopafter = (long)vdb_scan.numerics[0];
                    } else if ("operation".startsWith(vdb_scan.keyword)) {
                        if (vdb_scan.getAlphaCount() > 1) {
                            common.failure("'fwd=" + fwdEntry.fwd_name + ",operations=' accepts only ONE parameter.");
                        }
                        fwdEntry.operation = Operations.getOperationIdentifier(vdb_scan.alphas[0]);
                        if (fwdEntry.operation == -1) {
                            common.failure("Unknown operation: " + vdb_scan.alphas[0]);
                        }
                    } else if ("fileselect".startsWith(vdb_scan.keyword)) {
                        fwdEntry.parseFileSelect(vdb_scan.raw_values);
                    } else if ("fileio".equals(vdb_scan.keyword)) {
                        fwdEntry.fileIoParameters(vdb_scan);
                    } else if ("xfersizes".startsWith(vdb_scan.keyword)) {
                        fwdEntry.xfersizes = vdb_scan.numerics;
                        double d = 0.0;
                        for (int i = 0; i < vdb_scan.numerics.length; ++i) {
                            if (i % 2 != 1) continue;
                            d += vdb_scan.numerics[i];
                        }
                        if (vdb_scan.numerics.length > 1 && (int)d != 100) {
                            common.failure("Xfersize distribution does not add up to 100");
                        }
                    } else if ("skew".startsWith(vdb_scan.keyword)) {
                        fwdEntry.skew = vdb_scan.numerics[0];
                        Host.noMultiJvmForFwdSkew();
                    } else if ("threads".startsWith(vdb_scan.keyword)) {
                        fwdEntry.threads = (int)vdb_scan.numerics[0];
                    } else if ("target".startsWith(vdb_scan.keyword)) {
                        fwdEntry.target_fsd = vdb_scan.alphas[0];
                    } else if ("host".startsWith(vdb_scan.keyword) || vdb_scan.keyword.equals("hd")) {
                        fwdEntry.host_names = vdb_scan.alphas;
                        for (n = 0; n < fwdEntry.host_names.length; ++n) {
                            if (Host.findHost(fwdEntry.host_names[n]) != null) continue;
                            common.failure("Unable to find requested host (wildcards not allowed): host=" + fwdEntry.host_names[n]);
                        }
                    } else if ("openflags".startsWith(vdb_scan.keyword)) {
                        fwdEntry.open_flags = new OpenFlags(vdb_scan.alphas, vdb_scan.numerics);
                    } else {
                        common.failure("Unknown keyword: " + vdb_scan.keyword);
                    }
                    string2 = Vdb_scan.parms_get();
                    continue;
                }
                break;
            }
        }
        catch (Exception exception) {
            common.ptod(exception);
            common.ptod("Exception during reading of input parameter file(s).");
            common.ptod("Look at the end of 'parmscan.html' to identify the last parameter scanned.");
            common.failure("Exception during reading of input parameter file(s).");
        }
        if (fwd_list.size() == 0) {
            return string2;
        }
        FwdEntry.checkParameters();
        return string2;
    }

    private static void checkParameters() {
        FwdEntry fwdEntry2;
        int n;
        for (n = 0; n < fwd_list.size(); ++n) {
            fwdEntry2 = fwd_list.elementAt(n);
            if (!fwdEntry2.sequential_io || !fwdEntry2.del_b4_write || fwdEntry2.readpct == -1.0) continue;
            common.failure("'fileselect=(sequential,delete)'. 'rdpct=' and 'delete' parameters are mutually exclusive");
        }
        for (n = 0; n < fwd_list.size(); ++n) {
            fwdEntry2 = fwd_list.elementAt(n);
            if (fwdEntry2.xfersizes.length != 0) continue;
            common.failure("'xfersizes=' parameter is required");
        }
        for (n = 0; n < fwd_list.size(); ++n) {
            fwdEntry2 = fwd_list.elementAt(n);
            if (fwdEntry2.operation != -1) continue;
            common.failure("'operation=' parameter is required for each fwd");
        }
        for (n = 0; n < fwd_list.size(); ++n) {
            fwdEntry2 = fwd_list.elementAt(n);
            if (fwdEntry2.fsd_names.length != 0) continue;
            common.failure("fwd parameter requires at least one 'fsd='");
        }
        for (n = 0; n < fwd_list.size(); ++n) {
            fwdEntry2 = fwd_list.elementAt(n);
            if (fwdEntry2.target_fsd == null || fwdEntry2.operation == Operations.MOVE || fwdEntry2.operation == Operations.COPY) continue;
            common.failure("'target=' may only be specified together with 'operation=move' or 'operation=copy'");
        }
        for (n = 0; n < fwd_list.size(); ++n) {
            fwdEntry2 = fwd_list.elementAt(n);
            if (fwdEntry2.target_fsd == null || fwdEntry2.operation != Operations.MOVE && fwdEntry2.operation != Operations.COPY || fwdEntry2.target_fsd != null) continue;
            common.failure("'target=' parameter is required with 'operation=move' or 'operation=copy'");
        }
        for (FwdEntry fwdEntry2 : fwd_list) {
            int n2 = 0;
            if (fwdEntry2.select_empty) {
                ++n2;
            }
            if (fwdEntry2.select_full) {
                ++n2;
            }
            if (fwdEntry2.select_nfull) {
                ++n2;
            }
            if (n2 > 1) {
                common.failure("fileselect=empty/full/notfull options are mutually exclusive");
            }
            if (!fwdEntry2.select_empty || fwdEntry2.sequential_io) continue;
            common.failure("fileselect=empty and fileio=random are mutually exclusive");
        }
    }

    public int getOperation() {
        return this.operation;
    }

    public void setOperation(int n) {
        this.operation = n;
    }

    public boolean compareXfersize(FwdEntry fwdEntry) {
        if (this.xfersizes.length != fwdEntry.xfersizes.length) {
            return false;
        }
        for (int i = 0; i < this.xfersizes.length; ++i) {
            if (this.xfersizes[i] == fwdEntry.xfersizes[i]) continue;
            return false;
        }
        return true;
    }

    public String printXfersize() {
        String string = "";
        for (int i = 0; i < this.xfersizes.length; ++i) {
            string = string + this.xfersizes[i] + " ";
        }
        return string;
    }

    public FsdEntry[] findFsdNames(RD_entry rD_entry) {
        HashMap<FsdEntry, FsdEntry> hashMap = new HashMap<FsdEntry, FsdEntry>(16);
        for (int i = 0; i < this.fsd_names.length; ++i) {
            boolean bl = false;
            for (int j = 0; j < FsdEntry.getFsdList().size(); ++j) {
                FsdEntry fsdEntry = FsdEntry.getFsdList().elementAt(j);
                if (!common.simple_wildcard(this.fsd_names[i], fsdEntry.name)) continue;
                hashMap.put(fsdEntry, fsdEntry);
                bl = true;
            }
            if (bl) continue;
            common.failure("Could not find fsd=" + this.fsd_names[i] + " for FWD=" + this.fwd_name);
        }
        return hashMap.values().toArray(new FsdEntry[0]);
    }

    public static Vector<FwdEntry> getFwdList() {
        return fwd_list;
    }

    public static String[] getFwdNames() {
        HashMap<String, FwdEntry> hashMap = new HashMap<String, FwdEntry>(64);
        for (int i = 0; i < fwd_list.size(); ++i) {
            FwdEntry fwdEntry = fwd_list.elementAt(i);
            hashMap.put(fwdEntry.fwd_name, fwdEntry);
        }
        return hashMap.keySet().toArray(new String[0]);
    }

    private void fileIoParameters(Vdb_scan vdb_scan) {
        if ("random".startsWith(vdb_scan.alphas[0])) {
            this.sequential_io = false;
            if (vdb_scan.getAlphaCount() > 1) {
                if ("shared".startsWith(vdb_scan.alphas[1])) {
                    if (Validate.isRealValidate()) {
                        common.failure("'fileio=(random,shared)' may not be used with Data Validation");
                    }
                    this.file_sharing = true;
                } else {
                    common.failure("Invalid 'fileio' parameter contents: " + vdb_scan.alphas[1]);
                }
            }
        } else if (vdb_scan.alphas[0].startsWith("seq")) {
            this.sequential_io = true;
            if (vdb_scan.alphas[0].contains("nz")) {
                this.seq_io_start0 = false;
            }
            if (vdb_scan.getAlphaCount() > 1) {
                if ("delete".startsWith(vdb_scan.alphas[1])) {
                    this.del_b4_write = true;
                } else {
                    common.failure("Invalid 'fileio' parameter contents: " + vdb_scan.alphas[1]);
                }
            }
        } else {
            common.failure("Invalid 'fileio' parameter contents: " + vdb_scan.alphas[0]);
        }
    }

    private void parseFileSelect(ArrayList<String> arrayList) {
        for (String string : arrayList) {
            if ("random".startsWith(string)) {
                this.select_random = true;
                continue;
            }
            if (string.startsWith("seq")) {
                this.select_random = false;
                if (!string.contains("nz")) continue;
                this.selseq_start0 = false;
                continue;
            }
            if (string.equals("once")) {
                this.select_once = true;
                continue;
            }
            if (string.equals("full")) {
                this.select_full = true;
                continue;
            }
            if (string.equals("empty")) {
                this.select_empty = true;
                continue;
            }
            if (string.equals("notfull")) {
                this.select_nfull = true;
                continue;
            }
            if (string.equals("skewed")) {
                this.select_random = true;
                this.poisson_skew = 3.0;
                continue;
            }
            if (string.equals("poisson")) {
                this.select_random = true;
                this.poisson_skew = 3.0;
                continue;
            }
            if (string.startsWith("midpoint=")) {
                String[] stringArray = string.split("=");
                if (stringArray.length != 2) {
                    common.failure("Invalid 'fileselect' parameter contents: " + string);
                }
                if (!common.isNumeric(stringArray[1])) {
                    common.failure("Invalid 'fileselect' parameter contents: " + string);
                }
                this.select_random = true;
                this.poisson_skew = Double.parseDouble(stringArray[1]);
                if (!(this.poisson_skew <= 0.0)) continue;
                common.failure("Invalid 'fileselect' parameter contents: " + string);
                continue;
            }
            if (common.isDouble(string)) {
                this.poisson_skew = Double.parseDouble(string);
                continue;
            }
            common.failure("Invalid 'fileselect' parameter contents: " + string);
        }
        if (this.select_once && !this.selseq_start0) {
            common.failure("'fileselect=(seqnz,once)' may not be used together.");
        }
    }

    static {
        FwdEntry.format_fwd.xfersizes = new double[]{131072.0};
        FwdEntry.format_fwd.threads = 8;
    }
}

