/*
 * Decompiled with CFR 0.152.
 */
package Vdb;

import Vdb.Blocked;
import Vdb.CpuStats;
import Vdb.Flat;
import Vdb.FsdEntry;
import Vdb.FwdEntry;
import Vdb.FwdStats;
import Vdb.FwgEntry;
import Vdb.Host;
import Vdb.Kstat_cpu;
import Vdb.NfsStats;
import Vdb.RD_entry;
import Vdb.Report;
import Vdb.ReportData;
import Vdb.SdSort;
import Vdb.Slave;
import Vdb.Vdbmain;
import Vdb.common;
import java.util.Arrays;
import java.util.HashMap;

public class FwdReport
extends Report {
    private static final String c = "Copyright (c) 2000, 2016, Oracle and/or its affiliates. All rights reserved.";
    private static int total_header_lines = 1;

    public static void reportFwdInterval() {
        int n;
        Object object;
        Object object2;
        for (int i = 0; i < Host.getDefinedHosts().size(); ++i) {
            object2 = Host.getDefinedHosts().elementAt(i);
            FwdStats fwdStats = new FwdStats();
            object = ((Host)object2).getSummaryReport().getData().getIntervalCpuStats();
            for (int j = 0; j < ((Host)object2).getSlaves().size(); ++j) {
                Slave slave = ((Host)object2).getSlaves().elementAt(j);
                if (slave.getCurrentWork() == null) continue;
                Report.getReport(slave).getData().reportInterval((Kstat_cpu)object);
                if (!slave_detail) continue;
                for (String string : slave.getFsdsUsed()) {
                    slave.getReport(string).getData().reportInterval((Kstat_cpu)object);
                }
            }
            Report.getReport(object2).getData().reportInterval((Kstat_cpu)object);
        }
        Kstat_cpu kstat_cpu = Report.getSummaryReport().getData().getIntervalCpuStats();
        object2 = Report.getSummaryReport().getData().getIntervalFwdStats();
        ((FwdStats)object2).printLine(Report.getSummaryReport(), kstat_cpu);
        if (!Vdbmain.kstat_console) {
            ((FwdStats)object2).printLine(Report.getStdoutReport(), kstat_cpu);
        }
        for (n = 0; n < FsdEntry.getFsdList().size(); ++n) {
            object = FsdEntry.getFsdList().elementAt(n);
            Report.getReport(((FsdEntry)object).name).getData().reportInterval(kstat_cpu);
        }
        for (n = 0; n < FwdEntry.getFwdList().size(); ++n) {
            object = FwdEntry.getFwdList().elementAt(n);
            Report.getReport(((FwdEntry)object).fwd_name).getData().reportInterval(kstat_cpu);
            if (((FwdEntry)object).fwd_name.equals("format")) break;
        }
        if (FwdReport.isKstatReporting()) {
            Report.reportKstat();
        }
        if (common.get_debug(common.PRINT_FS_COUNTERS)) {
            Blocked.printCountersToLog();
        }
        if (CpuStats.isCpuReporting()) {
            FwdReport.writeFlatCpu(kstat_cpu);
        }
        ((FwdStats)object2).writeFlat("" + Report.getInterval(), kstat_cpu);
        Flat.printInterval();
        ((FwdStats)object2).writeBinFile();
    }

    public static FwdStats reportRunTotals() {
        Object object;
        Object object2;
        int n;
        Object object3;
        Object object4;
        Object object5;
        String string = Report.getAvgLabel();
        for (int i = 0; i < Host.getDefinedHosts().size(); ++i) {
            object5 = Host.getDefinedHosts().elementAt(i);
            object4 = new FwdStats();
            object3 = ((Host)object5).getSummaryReport().getData().getTotalCpuStats();
            for (n = 0; n < ((Host)object5).getSlaves().size(); ++n) {
                object2 = ((Host)object5).getSlaves().elementAt(n);
                if (((Slave)object2).getCurrentWork() == null) continue;
                Report.getReport(object2).getData().reportFwdTotal((Kstat_cpu)object3, string);
                if (!slave_detail) continue;
                for (String string2 : ((Slave)object2).getFsdsUsed()) {
                    ((Slave)object2).getReport(string2).getData().reportFwdTotal((Kstat_cpu)object3, string);
                }
            }
            Report.getReport(object5).getData().reportFwdTotal((Kstat_cpu)object3, string);
            if (!NfsStats.areNfsReportsNeeded()) continue;
            ((Host)object5).PrintNfsstatTotals(string);
        }
        Kstat_cpu kstat_cpu = Report.getSummaryReport().getData().getTotalCpuStats();
        object5 = Report.getSummaryReport().getData().getTotalFwdStats();
        ((FwdStats)object5).printLineL(Report.getSummaryReport(), kstat_cpu, string);
        ((FwdStats)object5).printStdLine(Report.getSummaryReport(), kstat_cpu, string);
        ((FwdStats)object5).printMaxLine(Report.getSummaryReport(), kstat_cpu, string);
        if (!Vdbmain.kstat_console) {
            ((FwdStats)object5).printLineL(Report.getStdoutReport(), kstat_cpu, string);
            ((FwdStats)object5).printStdLine(Report.getStdoutReport(), kstat_cpu, string);
            ((FwdStats)object5).printMaxLine(Report.getStdoutReport(), kstat_cpu, string);
        }
        if (total_header_lines++ % 10 == 1) {
            FwdStats.printHeaders(Report.getTotalReport());
        }
        ((FwdStats)object5).printLineL(Report.getTotalReport(), kstat_cpu, string);
        ((FwdStats)object5).writeFlat(string, kstat_cpu);
        if (CpuStats.isCpuReporting()) {
            Report.writeFlatCpu(kstat_cpu);
        }
        ReportData.reportFwdTotals(FsdEntry.getFsdNames(), kstat_cpu, string);
        ReportData.reportFwdTotals(FwdEntry.getFwdNames(), kstat_cpu, string);
        object4 = Report.getReport("histogram");
        object3 = "Total of all requested operations since warmup: ";
        ((Report)object4).println(((FwdStats)object5).getReqstdHistogram().printHistogram((String)object3));
        for (n = 0; n < FsdEntry.getFsdList().size(); ++n) {
            object2 = FsdEntry.getFsdList().elementAt(n);
            object4 = Report.getReport(object2, "histogram");
            object = ((Report)object4).getData();
            ((Report)object4).println(((ReportData)object).getTotalFwdStats().getReqstdHistogram().printHistogram((String)object3));
        }
        for (n = 0; n < FwdEntry.getFwdList().size(); ++n) {
            object2 = FwdEntry.getFwdList().elementAt(n);
            object4 = Report.getReport(object2, "histogram");
            object = ((Report)object4).getData();
            ((Report)object4).println(((ReportData)object).getTotalFwdStats().getReqstdHistogram().printHistogram((String)object3));
            if (((FwdEntry)object2).fwd_name.equals("format")) break;
        }
        return object5;
    }

    public static void createSlaveFsdReports(Host host) {
        for (Slave slave : host.getSlaves()) {
            for (String string : slave.getFsdsUsed()) {
                Report report = new Report(slave, string, "Slave FSD report for fsd=" + string, slave_detail);
                slave.addReport(string, report);
                if (!slave_detail) continue;
                String string2 = "fsd=" + string;
                slave.getSummaryReport().printHtmlLink("Links to slave FSD reports", report.getFileName(), string2);
            }
        }
    }

    public static void createHostFsdReports() {
        for (Host host : Host.getDefinedHosts()) {
            String[] stringArray = FwdReport.getFsdsUsedForHost(host);
            Arrays.sort(stringArray, new SdSort());
            for (String string : stringArray) {
                String string2 = "Host FSD report for fsd=" + string + ",host=" + host.getLabel();
                Report report = new Report(host, string, string2, host_detail);
                host.addReport(string, report);
                string2 = "fsd=" + string;
                host.getSummaryReport().printHtmlLink("Link to host FSD reports", report.getFileName(), string2);
            }
            FwdReport.createSlaveFsdReports(host);
        }
    }

    public static String[] getFsdsUsedForHost(Host host) {
        HashMap<String, String> hashMap = new HashMap<String, String>(16);
        for (RD_entry rD_entry : Vdbmain.rd_list) {
            for (FwgEntry fwgEntry : rD_entry.fwgs_for_rd) {
                if (!fwgEntry.host_name.equals(host.getLabel())) continue;
                hashMap.put(fwgEntry.fsd_name, fwgEntry.fsd_name);
            }
        }
        return hashMap.keySet().toArray(new String[0]);
    }

    public static String[] getFsdsUsedForSlave(Slave slave) {
        HashMap<String, String> hashMap = new HashMap<String, String>(16);
        for (RD_entry rD_entry : Vdbmain.rd_list) {
            for (FwgEntry fwgEntry : rD_entry.fwgs_for_rd) {
                if (!fwgEntry.host_name.equals(slave.getHost().getLabel())) continue;
                hashMap.put(fwgEntry.fsd_name, fwgEntry.fsd_name);
            }
        }
        return hashMap.keySet().toArray(new String[0]);
    }
}

