/*
 * Decompiled with CFR 0.152.
 */
package Vdb;

import Utils.Bin;
import Utils.ClassPath;
import Utils.Fget;
import Utils.Format;
import Utils.FwdNamedData;
import Utils.Lookup;
import Utils.LookupAnchor;
import Vdb.CpuStats;
import Vdb.Date_record;
import Vdb.Flat;
import Vdb.FwdCounter;
import Vdb.FwdPrint;
import Vdb.FwgEntry;
import Vdb.FwgThread;
import Vdb.Histogram;
import Vdb.Kstat_cpu;
import Vdb.Native;
import Vdb.Operations;
import Vdb.RD_entry;
import Vdb.Report;
import Vdb.Reporter;
import Vdb.Validate;
import Vdb.common;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Vector;

public class FwdStats
implements Serializable {
    private static final String c = "Copyright (c) 2000, 2016, Oracle and/or its affiliates. All rights reserved.";
    public FwdCounter read = new FwdCounter(this, "read   ");
    public FwdCounter write = new FwdCounter(this, "write  ");
    public FwdCounter mkdir = new FwdCounter(this, "mkdir  ");
    public FwdCounter create = new FwdCounter(this, "create ");
    public FwdCounter getattr = new FwdCounter(this, "getattr");
    public FwdCounter setattr = new FwdCounter(this, "setattr");
    public FwdCounter access = new FwdCounter(this, "access ");
    public FwdCounter open = new FwdCounter(this, "open   ");
    public FwdCounter close = new FwdCounter(this, "close  ");
    public FwdCounter copy = new FwdCounter(this, "copy   ");
    public FwdCounter move = new FwdCounter(this, "move   ");
    public FwdCounter delete = new FwdCounter(this, "delete ");
    public FwdCounter rmdir = new FwdCounter(this, "rmdir  ");
    public FwdCounter put = new FwdCounter(this, "put    ");
    public FwdCounter get = new FwdCounter(this, "get    ");
    public long r_bytes = 0L;
    public long w_bytes = 0L;
    public long permit_time = 0L;
    public long permit_count = 0L;
    private long elapsed;
    public boolean work_done;
    private static Bin fwd_bin_file;
    private static String all_fields;
    private static FwdPrint inp;
    private static FwdPrint acp;
    private static FwdPrint cpup;
    private static FwdPrint rdp;
    private static FwdPrint wrp;
    private static FwdPrint pctp;
    private static FwdPrint mbp;
    private static FwdPrint mbt;
    private static FwdPrint xfp;
    private static FwdPrint mdp;
    private static FwdPrint ddp;
    private static FwdPrint crp;
    private static FwdPrint opp;
    private static FwdPrint clp;
    private static FwdPrint delp;
    private static FwdPrint getp;
    private static FwdPrint setp;
    private static FwdPrint accs;
    private static FwdPrint copp;
    private static FwdPrint movp;
    private static FwdPrint putp;
    private static FwdPrint ggtp;
    private static int time_travel_window;
    private static int time_travel_count;
    private static boolean skip_response_times;
    private static double MB;

    public static void count(int n, long l) {
        long l2 = Native.get_simple_tod();
        if (skip_response_times) {
            l2 = l;
        }
        if (l > l2) {
            l = FwdStats.timeTravel(l, l2);
        }
        FwgThread fwgThread = (FwgThread)Thread.currentThread();
        fwgThread.per_thread_stats.add(n, l2 - l, 0);
    }

    public static void countXfer(int n, long l, int n2) {
        long l2 = Native.get_simple_tod();
        if (skip_response_times) {
            l2 = l;
        }
        if (l > l2) {
            l = FwdStats.timeTravel(l, l2);
        }
        FwgThread fwgThread = (FwgThread)Thread.currentThread();
        fwgThread.per_thread_stats.add(n, l2 - l, n2);
    }

    private void add(int n, long l, int n2) {
        if (n == Operations.READ) {
            this.read.addResp(l);
        } else if (n == Operations.WRITE) {
            this.write.addResp(l);
        } else if (n == Operations.GETATTR) {
            this.getattr.addResp(l);
        } else if (n == Operations.SETATTR) {
            this.setattr.addResp(l);
        } else if (n == Operations.ACCESS) {
            this.access.addResp(l);
        } else if (n == Operations.CREATE) {
            this.create.addResp(l);
        } else if (n == Operations.MKDIR) {
            this.mkdir.addResp(l);
        } else if (n == Operations.OPEN) {
            this.open.addResp(l);
        } else if (n == Operations.CLOSE) {
            this.close.addResp(l);
        } else if (n == Operations.DELETE) {
            this.delete.addResp(l);
        } else if (n == Operations.RMDIR) {
            this.rmdir.addResp(l);
        } else if (n == Operations.COPY) {
            this.copy.addResp(l);
        } else if (n == Operations.MOVE) {
            this.move.addResp(l);
        } else if (n == Operations.PUT) {
            this.put.addResp(l);
        } else if (n == Operations.GET) {
            this.get.addResp(l);
        } else {
            common.failure("FwdStats.add(): unknown operation: " + n);
        }
        if (n == Operations.READ) {
            this.r_bytes += (long)n2;
        } else if (n == Operations.WRITE) {
            this.w_bytes += (long)n2;
        }
    }

    public void accum(FwdStats fwdStats, boolean bl) {
        this.read.accum(fwdStats.read);
        this.write.accum(fwdStats.write);
        this.mkdir.accum(fwdStats.mkdir);
        this.create.accum(fwdStats.create);
        this.getattr.accum(fwdStats.getattr);
        this.setattr.accum(fwdStats.setattr);
        this.access.accum(fwdStats.access);
        this.open.accum(fwdStats.open);
        this.close.accum(fwdStats.close);
        this.delete.accum(fwdStats.delete);
        this.rmdir.accum(fwdStats.rmdir);
        this.copy.accum(fwdStats.copy);
        this.move.accum(fwdStats.move);
        this.put.accum(fwdStats.put);
        this.get.accum(fwdStats.get);
        this.r_bytes += fwdStats.r_bytes;
        this.w_bytes += fwdStats.w_bytes;
        this.permit_count += fwdStats.permit_count;
        this.permit_time += fwdStats.permit_time;
        if (bl) {
            this.elapsed += fwdStats.elapsed;
        } else if (fwdStats.elapsed != 0L) {
            this.elapsed = fwdStats.elapsed;
        }
    }

    public void delta(FwdStats fwdStats, FwdStats fwdStats2) {
        this.read.delta(fwdStats.read, fwdStats2.read);
        this.write.delta(fwdStats.write, fwdStats2.write);
        this.mkdir.delta(fwdStats.mkdir, fwdStats2.mkdir);
        this.create.delta(fwdStats.create, fwdStats2.create);
        this.getattr.delta(fwdStats.getattr, fwdStats2.getattr);
        this.setattr.delta(fwdStats.setattr, fwdStats2.setattr);
        this.access.delta(fwdStats.access, fwdStats2.access);
        this.open.delta(fwdStats.open, fwdStats2.open);
        this.close.delta(fwdStats.close, fwdStats2.close);
        this.delete.delta(fwdStats.delete, fwdStats2.delete);
        this.rmdir.delta(fwdStats.rmdir, fwdStats2.rmdir);
        this.copy.delta(fwdStats.copy, fwdStats2.copy);
        this.move.delta(fwdStats.move, fwdStats2.move);
        this.put.delta(fwdStats.put, fwdStats2.put);
        this.get.delta(fwdStats.get, fwdStats2.get);
        this.r_bytes = fwdStats.r_bytes - fwdStats2.r_bytes;
        this.w_bytes = fwdStats.w_bytes - fwdStats2.w_bytes;
        this.permit_count = fwdStats.permit_count - fwdStats2.permit_count;
        this.permit_time = fwdStats.permit_time - fwdStats2.permit_time;
    }

    public void copyStats(FwdStats fwdStats) {
        this.read.copy(fwdStats.read);
        this.write.copy(fwdStats.write);
        this.mkdir.copy(fwdStats.mkdir);
        this.create.copy(fwdStats.create);
        this.getattr.copy(fwdStats.getattr);
        this.setattr.copy(fwdStats.setattr);
        this.access.copy(fwdStats.access);
        this.open.copy(fwdStats.open);
        this.close.copy(fwdStats.close);
        this.delete.copy(fwdStats.delete);
        this.rmdir.copy(fwdStats.rmdir);
        this.copy.copy(fwdStats.copy);
        this.move.copy(fwdStats.move);
        this.put.copy(fwdStats.put);
        this.get.copy(fwdStats.get);
        this.r_bytes = fwdStats.r_bytes;
        this.w_bytes = fwdStats.w_bytes;
        this.permit_count = fwdStats.permit_count;
        this.permit_time = fwdStats.permit_time;
    }

    public static void printHeaders(Report report) {
        Object object;
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("MMM dd, yyyy");
        String string = simpleDateFormat.format(new Date());
        String string2 = "";
        String string3 = "";
        if ((report == Report.getSummaryReport() || report == Report.getStdoutReport()) && Report.getAuxReport() != null) {
            object = Report.getAuxReport().getSummaryHeaders();
            string2 = object[0];
            string3 = object[1];
        }
        object = "";
        String string4 = "";
        if (common.get_debug(common.REPORT_FWG_PERMITS)) {
            object = " thread";
            string4 = "  busy ";
        }
        report.println("");
        report.println(string + FwdStats.getHeader1(CpuStats.isCpuReporting()) + string2 + (String)object);
        report.println("            " + FwdStats.getHeader2(CpuStats.isCpuReporting()) + string3 + string4);
    }

    public static String getShortHeader1() {
        String string = FwdStats.getHeader1(false);
        return string.substring(inp.getHeader1().length());
    }

    public static String getHeader1(boolean bl) {
        String string = "";
        string = string + inp.getHeader1();
        string = string + acp.getHeader1();
        string = string + (bl ? cpup.getHeader1() : "");
        string = string + pctp.getHeader1();
        string = string + rdp.getHeader1();
        string = string + wrp.getHeader1();
        string = string + mbp.getHeader1();
        string = string + mbt.getHeader1();
        string = string + xfp.getHeader1();
        if (Operations.isOperationUsed(Operations.MKDIR)) {
            string = string + mdp.getHeader1();
        }
        if (Operations.isOperationUsed(Operations.RMDIR)) {
            string = string + ddp.getHeader1();
        }
        if (Operations.isOperationUsed(Operations.CREATE)) {
            string = string + crp.getHeader1();
        }
        string = string + opp.getHeader1();
        string = string + clp.getHeader1();
        if (Operations.isOperationUsed(Operations.DELETE)) {
            string = string + delp.getHeader1();
        }
        if (Operations.isOperationUsed(Operations.GETATTR)) {
            string = string + getp.getHeader1();
        }
        if (Operations.isOperationUsed(Operations.SETATTR)) {
            string = string + setp.getHeader1();
        }
        if (Operations.isOperationUsed(Operations.ACCESS)) {
            string = string + accs.getHeader1();
        }
        if (Operations.isOperationUsed(Operations.COPY)) {
            string = string + copp.getHeader1();
        }
        if (Operations.isOperationUsed(Operations.MOVE)) {
            string = string + movp.getHeader1();
        }
        return string;
    }

    public static String getShortHeader2() {
        String string = FwdStats.getHeader2(false);
        return string.substring(inp.getHeader2().length());
    }

    public static String getHeader2(boolean bl) {
        String string = "";
        string = string + inp.getHeader2();
        string = string + acp.getHeader2();
        string = string + (bl ? cpup.getHeader2() : "");
        string = string + pctp.getHeader2();
        string = string + rdp.getHeader2();
        string = string + wrp.getHeader2();
        string = string + mbp.getHeader2();
        string = string + mbt.getHeader2();
        string = string + xfp.getHeader2();
        if (Operations.isOperationUsed(Operations.MKDIR)) {
            string = string + mdp.getHeader2();
        }
        if (Operations.isOperationUsed(Operations.RMDIR)) {
            string = string + ddp.getHeader2();
        }
        if (Operations.isOperationUsed(Operations.CREATE)) {
            string = string + crp.getHeader2();
        }
        string = string + opp.getHeader2();
        string = string + clp.getHeader2();
        if (Operations.isOperationUsed(Operations.DELETE)) {
            string = string + delp.getHeader2();
        }
        if (Operations.isOperationUsed(Operations.GETATTR)) {
            string = string + getp.getHeader2();
        }
        if (Operations.isOperationUsed(Operations.SETATTR)) {
            string = string + setp.getHeader2();
        }
        if (Operations.isOperationUsed(Operations.ACCESS)) {
            string = string + accs.getHeader2();
        }
        if (Operations.isOperationUsed(Operations.COPY)) {
            string = string + copp.getHeader2();
        }
        if (Operations.isOperationUsed(Operations.MOVE)) {
            string = string + movp.getHeader2();
        }
        return string;
    }

    public void printLine(Report report, Kstat_cpu kstat_cpu) {
        if (Reporter.needHeaders()) {
            FwdStats.printHeaders(report);
        }
        this.printLineL(report, kstat_cpu, Format.f("%d", Report.getInterval()));
    }

    public String printShortLine(Report report, Kstat_cpu kstat_cpu, String string) {
        String string2 = this.printLineL(report, kstat_cpu, string);
        return string2.substring(inp.getData(string).length());
    }

    public String printLineL(Report report, Kstat_cpu kstat_cpu, String string) {
        double d = (double)this.r_bytes * 1000000.0 / (double)this.elapsed / MB;
        double d2 = (double)this.w_bytes * 1000000.0 / (double)this.elapsed / MB;
        long l = 0L;
        double d3 = 0.0;
        if (this.read.operations + this.write.operations > 0L) {
            l = (this.r_bytes + this.w_bytes) / (this.read.operations + this.write.operations);
            d3 = (double)this.read.operations * 100.0 / (double)(this.read.operations + this.write.operations);
        }
        String string2 = "";
        string2 = string2 + inp.getData(string);
        string2 = string2 + acp.getData(this.getReqstdRate(), this.getReqstdlResp());
        if (CpuStats.isCpuReporting() && kstat_cpu != null) {
            string2 = string2 + cpup.getData(kstat_cpu.user_pct() + kstat_cpu.kernel_pct(), kstat_cpu.kernel_pct());
        }
        string2 = string2 + pctp.getData(d3);
        string2 = string2 + rdp.getData(this.read.rate(), this.read.resp());
        string2 = string2 + wrp.getData(this.write.rate(), this.write.resp());
        string2 = string2 + mbp.getData(d, d2);
        string2 = string2 + mbt.getData(d + d2);
        string2 = string2 + xfp.getData(l);
        if (Operations.isOperationUsed(Operations.MKDIR)) {
            string2 = string2 + mdp.getData(this.mkdir.rate(), this.mkdir.resp());
        }
        if (Operations.isOperationUsed(Operations.RMDIR)) {
            string2 = string2 + ddp.getData(this.rmdir.rate(), this.rmdir.resp());
        }
        if (Operations.isOperationUsed(Operations.CREATE)) {
            string2 = string2 + crp.getData(this.create.rate(), this.create.resp());
        }
        string2 = string2 + opp.getData(this.open.rate(), this.open.resp());
        string2 = string2 + clp.getData(this.close.rate(), this.close.resp());
        if (Operations.isOperationUsed(Operations.DELETE)) {
            string2 = string2 + delp.getData(this.delete.rate(), this.delete.resp());
        }
        if (Operations.isOperationUsed(Operations.GETATTR)) {
            string2 = string2 + getp.getData(this.getattr.rate(), this.getattr.resp());
        }
        if (Operations.isOperationUsed(Operations.SETATTR)) {
            string2 = string2 + setp.getData(this.setattr.rate(), this.setattr.resp());
        }
        if (Operations.isOperationUsed(Operations.ACCESS)) {
            string2 = string2 + accs.getData(this.access.rate(), this.access.resp());
        }
        if (Operations.isOperationUsed(Operations.COPY)) {
            string2 = string2 + copp.getData(this.copy.rate(), this.copy.resp());
        }
        if (Operations.isOperationUsed(Operations.MOVE)) {
            string2 = string2 + movp.getData(this.move.rate(), this.move.resp());
        }
        if (this.permit_count > 0L && common.get_debug(common.REPORT_FWG_PERMITS) && !string.contains("avg")) {
            long l2 = this.permit_time / this.permit_count / this.elapsed;
            double d4 = (1000.0 - (double)l2) * 100.0 / 1000.0;
            d4 = Math.max(0.0, d4);
            d4 = Math.min(100.0, d4);
            string2 = string2 + String.format(" %5.1f", d4);
        }
        if (report == null) {
            return string2;
        }
        if ((report == Report.getSummaryReport() || report == Report.getStdoutReport()) && Report.getAuxReport() != null) {
            string2 = string2 + Report.getAuxReport().getSummaryData();
        }
        report.println(common.tod() + string2);
        return null;
    }

    public String printMaxLine(Report report, Kstat_cpu kstat_cpu, String string) {
        string = string.replace("avg", "max");
        double d = (double)this.r_bytes * 1000000.0 / (double)this.elapsed / MB;
        double d2 = (double)this.w_bytes * 1000000.0 / (double)this.elapsed / MB;
        long l = 0L;
        double d3 = 0.0;
        if (this.read.operations + this.write.operations > 0L) {
            l = (this.r_bytes + this.w_bytes) / (this.read.operations + this.write.operations);
            d3 = (double)this.read.operations * 100.0 / (double)(this.read.operations + this.write.operations);
        }
        String string2 = "";
        string2 = string2 + inp.getData(string);
        FwdCounter fwdCounter = this.getSingleCounter();
        string2 = fwdCounter == null ? string2 + acp.getDataZ(0.0, 0.0) : string2 + acp.getDataZ(fwdCounter.rateMax(), fwdCounter.respMax());
        if (CpuStats.isCpuReporting() && kstat_cpu != null) {
            string2 = string2 + cpup.getDataZ(0.0, 0.0);
        }
        string2 = string2 + pctp.getDataZ(0.0);
        string2 = string2 + rdp.getDataZ(this.read.rateMax(), this.read.respMax());
        string2 = string2 + wrp.getDataZ(this.write.rateMax(), this.write.respMax());
        string2 = string2 + mbp.getDataZ(0.0, 0.0);
        string2 = string2 + mbt.getDataZ(0.0);
        string2 = string2 + xfp.getDataZ(0.0);
        if (Operations.isOperationUsed(Operations.MKDIR)) {
            string2 = string2 + mdp.getDataZ(this.mkdir.rateMax(), this.mkdir.respMax());
        }
        if (Operations.isOperationUsed(Operations.RMDIR)) {
            string2 = string2 + ddp.getDataZ(this.rmdir.rateMax(), this.rmdir.respMax());
        }
        if (Operations.isOperationUsed(Operations.CREATE)) {
            string2 = string2 + crp.getDataZ(this.create.rateMax(), this.create.respMax());
        }
        string2 = string2 + opp.getDataZ(this.open.rateMax(), this.open.respMax());
        string2 = string2 + clp.getDataZ(this.close.rateMax(), this.close.respMax());
        if (Operations.isOperationUsed(Operations.DELETE)) {
            string2 = string2 + delp.getDataZ(this.delete.rateMax(), this.delete.respMax());
        }
        if (Operations.isOperationUsed(Operations.GETATTR)) {
            string2 = string2 + getp.getDataZ(this.getattr.rateMax(), this.getattr.respMax());
        }
        if (Operations.isOperationUsed(Operations.SETATTR)) {
            string2 = string2 + setp.getDataZ(this.setattr.rateMax(), this.setattr.respMax());
        }
        if (Operations.isOperationUsed(Operations.ACCESS)) {
            string2 = string2 + accs.getDataZ(this.access.rateMax(), this.access.respMax());
        }
        if (Operations.isOperationUsed(Operations.COPY)) {
            string2 = string2 + copp.getDataZ(this.copy.rateMax(), this.copy.respMax());
        }
        if (Operations.isOperationUsed(Operations.MOVE)) {
            string2 = string2 + movp.getDataZ(this.move.rateMax(), this.move.respMax());
        }
        if (report == null) {
            return string2;
        }
        if ((report == Report.getSummaryReport() || report == Report.getStdoutReport()) && Report.getAuxReport() != null) {
            string2 = string2 + Report.getAuxReport().getSummaryData();
        }
        report.println(common.tod() + string2);
        return null;
    }

    public String printStdLine(Report report, Kstat_cpu kstat_cpu, String string) {
        string = string.replace("avg", "std");
        double d = (double)this.r_bytes * 1000000.0 / (double)this.elapsed / MB;
        double d2 = (double)this.w_bytes * 1000000.0 / (double)this.elapsed / MB;
        long l = 0L;
        double d3 = 0.0;
        if (this.read.operations + this.write.operations > 0L) {
            l = (this.r_bytes + this.w_bytes) / (this.read.operations + this.write.operations);
            d3 = (double)this.read.operations * 100.0 / (double)(this.read.operations + this.write.operations);
        }
        String string2 = "";
        string2 = string2 + inp.getData(string);
        FwdCounter fwdCounter = this.getSingleCounter();
        string2 = fwdCounter == null ? string2 + acp.getDataZ(0.0, 0.0) : string2 + acp.getDataZ(fwdCounter.rateStd(), fwdCounter.respStd());
        if (CpuStats.isCpuReporting() && kstat_cpu != null) {
            string2 = string2 + cpup.getDataZ(0.0, 0.0);
        }
        string2 = string2 + pctp.getDataZ(0.0);
        string2 = string2 + rdp.getDataZ(this.read.rateStd(), this.read.respStd());
        string2 = string2 + wrp.getDataZ(this.write.rateStd(), this.write.respStd());
        string2 = string2 + mbp.getDataZ(0.0, 0.0);
        string2 = string2 + mbt.getDataZ(0.0);
        string2 = string2 + xfp.getDataZ(0.0);
        if (Operations.isOperationUsed(Operations.MKDIR)) {
            string2 = string2 + mdp.getDataZ(this.mkdir.rateStd(), this.mkdir.respStd());
        }
        if (Operations.isOperationUsed(Operations.RMDIR)) {
            string2 = string2 + ddp.getDataZ(this.rmdir.rateStd(), this.rmdir.respStd());
        }
        if (Operations.isOperationUsed(Operations.CREATE)) {
            string2 = string2 + crp.getDataZ(this.create.rateStd(), this.create.respStd());
        }
        string2 = string2 + opp.getDataZ(this.open.rateStd(), this.open.respStd());
        string2 = string2 + clp.getDataZ(this.close.rateStd(), this.close.respStd());
        if (Operations.isOperationUsed(Operations.DELETE)) {
            string2 = string2 + delp.getDataZ(this.delete.rateStd(), this.delete.respStd());
        }
        if (Operations.isOperationUsed(Operations.GETATTR)) {
            string2 = string2 + getp.getDataZ(this.getattr.rateStd(), this.getattr.respStd());
        }
        if (Operations.isOperationUsed(Operations.SETATTR)) {
            string2 = string2 + setp.getDataZ(this.setattr.rateStd(), this.setattr.respStd());
        }
        if (Operations.isOperationUsed(Operations.ACCESS)) {
            string2 = string2 + accs.getDataZ(this.access.rateStd(), this.access.respStd());
        }
        if (Operations.isOperationUsed(Operations.COPY)) {
            string2 = string2 + copp.getDataZ(this.copy.rateStd(), this.copy.respStd());
        }
        if (Operations.isOperationUsed(Operations.MOVE)) {
            string2 = string2 + movp.getDataZ(this.move.rateStd(), this.move.respStd());
        }
        if (report == null) {
            return string2;
        }
        if ((report == Report.getSummaryReport() || report == Report.getStdoutReport()) && Report.getAuxReport() != null) {
            string2 = string2 + Report.getAuxReport().getSummaryData();
        }
        report.println(common.tod() + string2);
        return null;
    }

    public long getElapsed() {
        return this.elapsed;
    }

    public void setElapsed(long l) {
        this.elapsed = l;
    }

    private String conditional(FwdPrint fwdPrint, FwdCounter fwdCounter, int n) {
        if (Operations.isOperationUsed(n)) {
            return fwdPrint.getData(fwdCounter.rate(), fwdCounter.resp());
        }
        return "";
    }

    public double getReqstdRate() {
        double d = 0.0;
        if (RD_entry.next_rd.rd_name.startsWith(RD_entry.FSD_FORMAT_RUN)) {
            return this.write.rate();
        }
        if (this.isOperationRequested(Operations.READ)) {
            d += this.read.rate();
        }
        if (this.isOperationRequested(Operations.WRITE)) {
            d += this.write.rate();
        }
        if (this.isOperationRequested(Operations.MKDIR)) {
            d += this.mkdir.rate();
        }
        if (this.isOperationRequested(Operations.CREATE)) {
            d += this.create.rate();
        }
        if (this.isOperationRequested(Operations.OPEN)) {
            d += this.open.rate();
        }
        if (this.isOperationRequested(Operations.CLOSE)) {
            d += this.close.rate();
        }
        if (this.isOperationRequested(Operations.DELETE)) {
            d += this.delete.rate();
        }
        if (this.isOperationRequested(Operations.RMDIR)) {
            d += this.rmdir.rate();
        }
        if (this.isOperationRequested(Operations.GETATTR)) {
            d += this.getattr.rate();
        }
        if (this.isOperationRequested(Operations.SETATTR)) {
            d += this.setattr.rate();
        }
        if (this.isOperationRequested(Operations.ACCESS)) {
            d += this.access.rate();
        }
        if (this.isOperationRequested(Operations.COPY)) {
            d += this.copy.rate();
        }
        if (this.isOperationRequested(Operations.MOVE)) {
            d += this.move.rate();
        }
        if (this.isOperationRequested(Operations.PUT)) {
            d += this.put.rate();
        }
        if (this.isOperationRequested(Operations.GET)) {
            d += this.get.rate();
        }
        return d;
    }

    public double getTotalRate() {
        double d = 0.0;
        d += FwdStats.removeTrash(this.read.rate());
        d += FwdStats.removeTrash(this.write.rate());
        d += FwdStats.removeTrash(this.mkdir.rate());
        d += FwdStats.removeTrash(this.create.rate());
        d += FwdStats.removeTrash(this.open.rate());
        d += FwdStats.removeTrash(this.close.rate());
        d += FwdStats.removeTrash(this.delete.rate());
        d += FwdStats.removeTrash(this.rmdir.rate());
        d += FwdStats.removeTrash(this.getattr.rate());
        d += FwdStats.removeTrash(this.setattr.rate());
        d += FwdStats.removeTrash(this.access.rate());
        d += FwdStats.removeTrash(this.copy.rate());
        d += FwdStats.removeTrash(this.move.rate());
        d += FwdStats.removeTrash(this.put.rate());
        return d += FwdStats.removeTrash(this.get.rate());
    }

    private static double removeTrash(double d) {
        return d;
    }

    public FwdCounter getSingleCounter() {
        int n = 0;
        if (RD_entry.next_rd.rd_name.startsWith(RD_entry.FSD_FORMAT_RUN)) {
            return this.write;
        }
        if (this.isOperationRequested(Operations.READ)) {
            ++n;
        }
        if (this.isOperationRequested(Operations.WRITE)) {
            ++n;
        }
        if (this.isOperationRequested(Operations.MKDIR)) {
            ++n;
        }
        if (this.isOperationRequested(Operations.CREATE)) {
            ++n;
        }
        if (this.isOperationRequested(Operations.OPEN)) {
            ++n;
        }
        if (this.isOperationRequested(Operations.CLOSE)) {
            ++n;
        }
        if (this.isOperationRequested(Operations.DELETE)) {
            ++n;
        }
        if (this.isOperationRequested(Operations.RMDIR)) {
            ++n;
        }
        if (this.isOperationRequested(Operations.GETATTR)) {
            ++n;
        }
        if (this.isOperationRequested(Operations.SETATTR)) {
            ++n;
        }
        if (this.isOperationRequested(Operations.ACCESS)) {
            ++n;
        }
        if (this.isOperationRequested(Operations.COPY)) {
            ++n;
        }
        if (this.isOperationRequested(Operations.MOVE)) {
            ++n;
        }
        if (this.isOperationRequested(Operations.PUT)) {
            ++n;
        }
        if (this.isOperationRequested(Operations.GET)) {
            ++n;
        }
        if (n == 0) {
            common.failure("getSingleCounter(): unexpected operations count");
        } else {
            if (n > 1) {
                return null;
            }
            if (this.isOperationRequested(Operations.READ)) {
                return this.read;
            }
            if (this.isOperationRequested(Operations.WRITE)) {
                return this.write;
            }
            if (this.isOperationRequested(Operations.MKDIR)) {
                return this.mkdir;
            }
            if (this.isOperationRequested(Operations.CREATE)) {
                return this.create;
            }
            if (this.isOperationRequested(Operations.OPEN)) {
                return this.open;
            }
            if (this.isOperationRequested(Operations.CLOSE)) {
                return this.close;
            }
            if (this.isOperationRequested(Operations.DELETE)) {
                return this.delete;
            }
            if (this.isOperationRequested(Operations.RMDIR)) {
                return this.rmdir;
            }
            if (this.isOperationRequested(Operations.GETATTR)) {
                return this.getattr;
            }
            if (this.isOperationRequested(Operations.SETATTR)) {
                return this.setattr;
            }
            if (this.isOperationRequested(Operations.ACCESS)) {
                return this.access;
            }
            if (this.isOperationRequested(Operations.COPY)) {
                return this.copy;
            }
            if (this.isOperationRequested(Operations.MOVE)) {
                return this.move;
            }
            if (this.isOperationRequested(Operations.PUT)) {
                return this.put;
            }
            if (this.isOperationRequested(Operations.GET)) {
                return this.get;
            }
        }
        common.failure("getSingleCounter(): unexpected operations count");
        return null;
    }

    public long getTotalBytes() {
        return this.r_bytes + this.w_bytes;
    }

    public long getTotalBytesRead() {
        return this.r_bytes;
    }

    public long getTotalBytesWritten() {
        return this.w_bytes;
    }

    public double getReqstdlResp() {
        double d = 0.0;
        if (RD_entry.next_rd.rd_name.startsWith(RD_entry.FSD_FORMAT_RUN)) {
            return this.write.resp();
        }
        if (this.isOperationRequested(Operations.READ)) {
            d += (double)this.read.response;
        }
        if (this.isOperationRequested(Operations.WRITE)) {
            d += (double)this.write.response;
        }
        if (this.isOperationRequested(Operations.MKDIR)) {
            d += (double)this.mkdir.response;
        }
        if (this.isOperationRequested(Operations.CREATE)) {
            d += (double)this.create.response;
        }
        if (this.isOperationRequested(Operations.OPEN)) {
            d += (double)this.open.response;
        }
        if (this.isOperationRequested(Operations.CLOSE)) {
            d += (double)this.close.response;
        }
        if (this.isOperationRequested(Operations.DELETE)) {
            d += (double)this.delete.response;
        }
        if (this.isOperationRequested(Operations.RMDIR)) {
            d += (double)this.rmdir.response;
        }
        if (this.isOperationRequested(Operations.GETATTR)) {
            d += (double)this.getattr.response;
        }
        if (this.isOperationRequested(Operations.SETATTR)) {
            d += (double)this.setattr.response;
        }
        if (this.isOperationRequested(Operations.ACCESS)) {
            d += (double)this.access.response;
        }
        if (this.isOperationRequested(Operations.COPY)) {
            d += (double)this.copy.response;
        }
        if (this.isOperationRequested(Operations.MOVE)) {
            d += (double)this.move.response;
        }
        if (d == 0.0) {
            return 0.0;
        }
        return d / this.getReqstdRate() / ((double)this.elapsed / 1000.0);
    }

    public Histogram getReqstdHistogram() {
        Histogram histogram = new Histogram("default");
        if (RD_entry.next_rd.rd_name.startsWith(RD_entry.FSD_FORMAT_RUN)) {
            histogram.accumBuckets(this.write.getHistogram());
        } else {
            if (this.isOperationRequested(Operations.READ)) {
                histogram.accumBuckets(this.read.getHistogram());
            }
            if (this.isOperationRequested(Operations.WRITE)) {
                histogram.accumBuckets(this.write.getHistogram());
            }
            if (this.isOperationRequested(Operations.MKDIR)) {
                histogram.accumBuckets(this.mkdir.getHistogram());
            }
            if (this.isOperationRequested(Operations.CREATE)) {
                histogram.accumBuckets(this.create.getHistogram());
            }
            if (this.isOperationRequested(Operations.OPEN)) {
                histogram.accumBuckets(this.open.getHistogram());
            }
            if (this.isOperationRequested(Operations.CLOSE)) {
                histogram.accumBuckets(this.close.getHistogram());
            }
            if (this.isOperationRequested(Operations.DELETE)) {
                histogram.accumBuckets(this.delete.getHistogram());
            }
            if (this.isOperationRequested(Operations.RMDIR)) {
                histogram.accumBuckets(this.rmdir.getHistogram());
            }
            if (this.isOperationRequested(Operations.GETATTR)) {
                histogram.accumBuckets(this.getattr.getHistogram());
            }
            if (this.isOperationRequested(Operations.SETATTR)) {
                histogram.accumBuckets(this.setattr.getHistogram());
            }
            if (this.isOperationRequested(Operations.ACCESS)) {
                histogram.accumBuckets(this.access.getHistogram());
            }
            if (this.isOperationRequested(Operations.COPY)) {
                histogram.accumBuckets(this.copy.getHistogram());
            }
            if (this.isOperationRequested(Operations.MOVE)) {
                histogram.accumBuckets(this.move.getHistogram());
            }
        }
        return histogram;
    }

    private boolean isOperationRequested(int n) {
        Vector<FwgEntry> vector = RD_entry.next_rd.fwgs_for_rd;
        for (int i = 0; i < vector.size(); ++i) {
            FwgEntry fwgEntry = vector.elementAt(i);
            if (fwgEntry.getOperation() == n) {
                return true;
            }
            if (!(fwgEntry.readpct >= 0.0) || n != Operations.READ && n != Operations.WRITE) continue;
            return true;
        }
        return false;
    }

    private static String title(int n, int n2) {
        String string = Operations.getOperationText(n);
        int n3 = n2 - string.length();
        String string2 = "..................".substring(0, n3 / 2);
        String string3 = "..................".substring(0, n3 - string2.length());
        return string2 + string + string3;
    }

    private static String title(String string, int n) {
        int n2 = n - string.length();
        String string2 = "..................".substring(0, n2 / 2);
        String string3 = "..................".substring(0, n2 - string2.length());
        return string2 + string + string3;
    }

    public void writeFlat(String string, Kstat_cpu kstat_cpu) {
        double d = (double)this.r_bytes * 1000000.0 / (double)this.elapsed / MB;
        double d2 = (double)this.w_bytes * 1000000.0 / (double)this.elapsed / MB;
        long l = 0L;
        if (this.read.operations + this.write.operations > 0L) {
            l = (this.r_bytes + this.w_bytes) / (this.read.operations + this.write.operations);
        }
        double d3 = Validate.getCompressionRatio();
        Flat.put_col("Run", RD_entry.next_rd.rd_name);
        Flat.put_col("Interval", string);
        Flat.put_col("rate", this.getReqstdRate());
        FwdCounter fwdCounter = this.getSingleCounter();
        if (fwdCounter != null) {
            Flat.put_col("Rate_std", fwdCounter.rateStd());
            Flat.put_col("Rate_max", fwdCounter.rateMax());
        }
        Flat.put_col("resp", this.getReqstdlResp());
        if (fwdCounter != null) {
            Flat.put_col("Resp_std", fwdCounter.respStd());
            Flat.put_col("Resp_max", fwdCounter.respMax());
        }
        Flat.put_col("MB/sec", d + d2);
        Flat.put_col("MB_read", d);
        Flat.put_col("MB_write", d2);
        Flat.put_col("Xfersize", l);
        Flat.put_col("Read_rate", this.read.rate());
        Flat.put_col("Read_rate_std", this.read.rateStd());
        Flat.put_col("Read_rate_max ", this.read.rateMax());
        Flat.put_col("Read_resp", this.read.resp());
        Flat.put_col("Read_resp_std", this.read.respStd());
        Flat.put_col("Read_resp_max ", this.read.respMax());
        Flat.put_col("Write_rate", this.write.rate());
        Flat.put_col("Write_rate_std", this.write.rateStd());
        Flat.put_col("Write_rate_max ", this.write.rateMax());
        Flat.put_col("Write_resp", this.write.resp());
        Flat.put_col("Write_resp_std", this.write.respStd());
        Flat.put_col("Write_resp_max ", this.write.respMax());
        Flat.put_col("Mkdir_rate", this.mkdir.rate());
        Flat.put_col("Mkdir_rate_std", this.mkdir.rateStd());
        Flat.put_col("Mkdir_rate_max ", this.mkdir.rateMax());
        Flat.put_col("Mkdir_resp", this.mkdir.resp());
        Flat.put_col("Mkdir_resp_std", this.mkdir.respStd());
        Flat.put_col("Mkdir_resp_max ", this.mkdir.respMax());
        Flat.put_col("Rmdir_rate", this.rmdir.rate());
        Flat.put_col("Rmdir_rate_std", this.rmdir.rateStd());
        Flat.put_col("Rmdir_rate_max ", this.rmdir.rateMax());
        Flat.put_col("Rmdir_resp", this.rmdir.resp());
        Flat.put_col("Rmdir_resp_std", this.rmdir.respStd());
        Flat.put_col("Rmdir_resp_max ", this.rmdir.respMax());
        Flat.put_col("Create_rate", this.create.rate());
        Flat.put_col("Create_rate_std", this.create.rateStd());
        Flat.put_col("Create_rate_max ", this.create.rateMax());
        Flat.put_col("Create_resp", this.create.resp());
        Flat.put_col("Create_resp_std", this.create.respStd());
        Flat.put_col("Create_resp_max ", this.create.respMax());
        Flat.put_col("Open_rate", this.open.rate());
        Flat.put_col("Open_rate_std", this.open.rateStd());
        Flat.put_col("Open_rate_max ", this.open.rateMax());
        Flat.put_col("Open_resp", this.open.resp());
        Flat.put_col("Open_resp_std", this.open.respStd());
        Flat.put_col("Open_resp_max ", this.open.respMax());
        Flat.put_col("Close_rate", this.close.rate());
        Flat.put_col("Close_rate_std", this.close.rateStd());
        Flat.put_col("Close_rate_max ", this.close.rateMax());
        Flat.put_col("Close_resp", this.close.resp());
        Flat.put_col("Close_resp_std", this.close.respStd());
        Flat.put_col("Close_resp_max ", this.close.respMax());
        Flat.put_col("Delete_rate", this.delete.rate());
        Flat.put_col("Delete_rate_std", this.delete.rateStd());
        Flat.put_col("Delete_rate_max ", this.delete.rateMax());
        Flat.put_col("Delete_resp", this.delete.resp());
        Flat.put_col("Delete_resp_std", this.delete.respStd());
        Flat.put_col("Delete_resp_max ", this.delete.respMax());
        Flat.put_col("Getattr_rate", this.getattr.rate());
        Flat.put_col("Getattr_rate_std", this.getattr.rateStd());
        Flat.put_col("Getattr_rate_max ", this.getattr.rateMax());
        Flat.put_col("Getattr_resp", this.getattr.resp());
        Flat.put_col("Getattr_resp_std", this.getattr.respStd());
        Flat.put_col("Getattr_resp_max ", this.getattr.respMax());
        Flat.put_col("Setattr_rate", this.setattr.rate());
        Flat.put_col("Setattr_rate_std", this.setattr.rateStd());
        Flat.put_col("Setattr_rate_max ", this.setattr.rateMax());
        Flat.put_col("Setattr_resp", this.setattr.resp());
        Flat.put_col("Setattr_resp_std", this.setattr.respStd());
        Flat.put_col("Setattr_resp_max ", this.setattr.respMax());
        Flat.put_col("Access_rate", this.access.rate());
        Flat.put_col("Access_rate_std", this.access.rateStd());
        Flat.put_col("Access_rate_max ", this.access.rateMax());
        Flat.put_col("Access_resp", this.access.resp());
        Flat.put_col("Access_resp_std", this.access.respStd());
        Flat.put_col("Access_resp_max ", this.access.respMax());
        if (d3 < 0.0) {
            Flat.put_col("compratio", "n/a");
        } else {
            Flat.put_col("compratio", d3);
        }
    }

    public static void defineNamedData(String string) {
        LookupAnchor lookupAnchor = new FwdNamedData().getAnchor();
        new Lookup(lookupAnchor, "Read_rate");
        new Lookup(lookupAnchor, "Read_resp");
        new Lookup(lookupAnchor, "Write_rate");
        new Lookup(lookupAnchor, "Write_resp");
        new Lookup(lookupAnchor, "MB_read");
        new Lookup(lookupAnchor, "MB_write");
        new Lookup(lookupAnchor, "MB_total");
        new Lookup(lookupAnchor, "Xfersize");
        new Lookup(lookupAnchor, "Mkdir_rate");
        new Lookup(lookupAnchor, "Mkdir_resp");
        new Lookup(lookupAnchor, "Rmdir_rate");
        new Lookup(lookupAnchor, "Rmdir_resp");
        new Lookup(lookupAnchor, "Create_rate");
        new Lookup(lookupAnchor, "Create_resp");
        new Lookup(lookupAnchor, "Open_rate");
        new Lookup(lookupAnchor, "Open_resp");
        new Lookup(lookupAnchor, "Close_rate");
        new Lookup(lookupAnchor, "Close_resp");
        new Lookup(lookupAnchor, "Delete_rate");
        new Lookup(lookupAnchor, "Delete_resp");
        new Lookup(lookupAnchor, "Getattr_rate");
        new Lookup(lookupAnchor, "Getattr_resp");
        new Lookup(lookupAnchor, "Setattr_rate");
        new Lookup(lookupAnchor, "Setattr_resp");
        new Lookup(lookupAnchor, "Access_rate");
        new Lookup(lookupAnchor, "Access_resp");
        new Lookup(lookupAnchor, "Copy_rate");
        new Lookup(lookupAnchor, "Copy_resp");
        new Lookup(lookupAnchor, "Move_rate");
        new Lookup(lookupAnchor, "Move_resp");
        new Lookup(lookupAnchor, "Get_rate");
        new Lookup(lookupAnchor, "Get_resp");
        new Lookup(lookupAnchor, "Put_rate");
        new Lookup(lookupAnchor, "Put_resp");
        lookupAnchor.setDoubles();
        all_fields = "";
        String[] stringArray = lookupAnchor.getFieldNames();
        for (int i = 0; i < stringArray.length; ++i) {
            all_fields = all_fields + stringArray[i] + " ";
        }
        fwd_bin_file = new Bin(string, "swat_mon.bin");
        fwd_bin_file.output();
        Date date = new Date();
        new Date_record(date, date).export(fwd_bin_file);
        fwd_bin_file.put_array(lookupAnchor.getAnchorName(), 45);
        fwd_bin_file.put_array(lookupAnchor.getFieldTitles(), 46);
    }

    public void writeBinFile() {
        long l = System.currentTimeMillis();
        FwdNamedData fwdNamedData = new FwdNamedData();
        fwdNamedData.setElapsed(this.elapsed);
        fwdNamedData.setTime(l);
        double d = (double)this.r_bytes * 1000000.0 / (double)this.elapsed / MB;
        double d2 = (double)this.w_bytes * 1000000.0 / (double)this.elapsed / MB;
        long l2 = 0L;
        if (this.read.operations + this.write.operations > 0L) {
            l2 = (this.r_bytes + this.w_bytes) / (this.read.operations + this.write.operations);
        }
        String string = "";
        string = string + Format.f("%.3f ", this.read.rate() * (double)this.elapsed / 1000.0);
        string = string + Format.f("%.3f ", this.read.resp() * (double)this.elapsed / 1000.0);
        string = string + Format.f("%.3f ", this.write.rate() * (double)this.elapsed / 1000.0);
        string = string + Format.f("%.3f ", this.write.resp() * (double)this.elapsed / 1000.0);
        string = string + Format.f("%.3f ", d * (double)this.elapsed / 1000.0);
        string = string + Format.f("%.3f ", d2 * (double)this.elapsed / 1000.0);
        string = string + Format.f("%.3f ", (d + d2) * (double)this.elapsed / 1000.0);
        string = string + Format.f("%.3f ", l2 * this.elapsed / 1000L);
        string = string + Format.f("%.3f ", this.mkdir.rate() * (double)this.elapsed / 1000.0);
        string = string + Format.f("%.3f ", this.mkdir.resp() * (double)this.elapsed / 1000.0);
        string = string + Format.f("%.3f ", this.rmdir.rate() * (double)this.elapsed / 1000.0);
        string = string + Format.f("%.3f ", this.rmdir.resp() * (double)this.elapsed / 1000.0);
        string = string + Format.f("%.3f ", this.create.rate() * (double)this.elapsed / 1000.0);
        string = string + Format.f("%.3f ", this.create.resp() * (double)this.elapsed / 1000.0);
        string = string + Format.f("%.3f ", this.open.rate() * (double)this.elapsed / 1000.0);
        string = string + Format.f("%.3f ", this.open.resp() * (double)this.elapsed / 1000.0);
        string = string + Format.f("%.3f ", this.close.rate() * (double)this.elapsed / 1000.0);
        string = string + Format.f("%.3f ", this.close.resp() * (double)this.elapsed / 1000.0);
        string = string + Format.f("%.3f ", this.delete.rate() * (double)this.elapsed / 1000.0);
        string = string + Format.f("%.3f ", this.delete.resp() * (double)this.elapsed / 1000.0);
        string = string + Format.f("%.3f ", this.getattr.rate() * (double)this.elapsed / 1000.0);
        string = string + Format.f("%.3f ", this.getattr.resp() * (double)this.elapsed / 1000.0);
        string = string + Format.f("%.3f ", this.setattr.rate() * (double)this.elapsed / 1000.0);
        string = string + Format.f("%.3f ", this.setattr.resp() * (double)this.elapsed / 1000.0);
        string = string + Format.f("%.3f ", this.access.rate() * (double)this.elapsed / 1000.0);
        string = string + Format.f("%.3f ", this.access.resp() * (double)this.elapsed / 1000.0);
        string = string + Format.f("%.3f ", this.copy.rate() * (double)this.elapsed / 1000.0);
        string = string + Format.f("%.3f ", this.copy.resp() * (double)this.elapsed / 1000.0);
        string = string + Format.f("%.3f ", this.move.rate() * (double)this.elapsed / 1000.0);
        string = string + Format.f("%.3f ", this.move.resp() * (double)this.elapsed / 1000.0);
        string = string + Format.f("%.3f ", this.get.rate() * (double)this.elapsed / 1000.0);
        string = string + Format.f("%.3f ", this.get.resp() * (double)this.elapsed / 1000.0);
        string = string + Format.f("%.3f ", this.put.rate() * (double)this.elapsed / 1000.0);
        string = string + Format.f("%.3f ", this.put.resp() * (double)this.elapsed / 1000.0);
        fwdNamedData.parseNamedData(all_fields + " * " + string);
        fwd_bin_file.put_array(fwdNamedData.getAnchorName(), 45);
        fwd_bin_file.put_array(fwdNamedData.export(), 47);
        fwd_bin_file.flush();
    }

    private static int checkTimeTravel() {
        if (!Fget.file_exists(ClassPath.classPath(), "timetravel.txt")) {
            return 0;
        }
        String[] stringArray = Fget.readFileToArray(ClassPath.classPath(), "timetravel.txt");
        if (stringArray.length == 1) {
            common.ptod("checkTimeTravel: " + stringArray[0]);
            return Integer.parseInt(stringArray[0].trim());
        }
        return 0;
    }

    private static synchronized long timeTravel(long l, long l2) {
        long l3 = l - l2;
        if (time_travel_window == 0) {
            common.failure("FwdStats.count(): start time greater than end time: " + l + " " + l2 + " " + (l - l2));
        }
        if ((long)time_travel_window < l3) {
            common.failure("FwdStats.count(): start time greater than end time: " + l + " " + l2 + " " + (l - l2) + "; greater than allowed time travel window");
        }
        if (time_travel_count == 0) {
            common.ptod("FwdStats.count(): start time greater than end time. Only 1000 occurrences are allowed.");
        }
        if (time_travel_count++ < 100) {
            common.ptod("FwdStats.count(): start time greater than end time: " + l + " " + l2 + " " + (l - l2));
        }
        if (time_travel_count > 1000) {
            common.failure("FwdStats.count(): start time greater than end time: " + l + " " + l2 + " " + (l - l2) + "; Maximum 1000 allowed");
        }
        return l2;
    }

    static {
        inp = new FwdPrint("Interval", "", "12.0");
        acp = new FwdPrint("ReqstdOps.", "rate", "6.1", "resp", "6.3");
        cpup = new FwdPrint("cpu%", "total", "5.1", "sys", "4.2");
        rdp = new FwdPrint("read", "rate", "6.1", "resp", "6.3");
        wrp = new FwdPrint("write", "rate", "6.1", "resp", "6.3");
        pctp = new FwdPrint(" read", "pct", "5.1");
        mbp = new FwdPrint("mb/sec", "read", "5.2", "write", "5.2");
        mbt = new FwdPrint("mb/sec", "total", "6.2");
        xfp = new FwdPrint("xfer", "size", "7.0");
        mdp = new FwdPrint("mkdir", "rate", "5.1", "resp", "6.3");
        ddp = new FwdPrint("rmdir", "rate", "5.1", "resp", "6.3");
        crp = new FwdPrint("create", "rate", "5.1", "resp", "6.3");
        opp = new FwdPrint("open", "rate", "5.1", "resp", "6.3");
        clp = new FwdPrint("close", "rate", "5.1", "resp", "6.3");
        delp = new FwdPrint("delete", "rate", "5.1", "resp", "6.3");
        getp = new FwdPrint("getattr", "rate", "5.1", "resp", "6.3");
        setp = new FwdPrint("setattr", "rate", "5.1", "resp", "6.3");
        accs = new FwdPrint("access", "rate", "5.1", "resp", "6.3");
        copp = new FwdPrint("copy", "rate", "5.1", "resp", "6.3");
        movp = new FwdPrint("move", "rate", "5.1", "resp", "6.3");
        putp = new FwdPrint("put", "mb", "5.1");
        ggtp = new FwdPrint("get", "mb", "5.1");
        time_travel_window = FwdStats.checkTimeTravel();
        time_travel_count = 0;
        skip_response_times = common.get_debug(common.NO_RESPONSE_TIMES);
        MB = 1048576.0;
    }
}

