/*
 * Decompiled with CFR 0.152.
 */
package Vdb;

import Utils.Format;
import Vdb.ActiveFile;
import Vdb.Blocked;
import Vdb.Directory;
import Vdb.FileEntry;
import Vdb.FwdStats;
import Vdb.FwgEntry;
import Vdb.FwgQueue;
import Vdb.FwgWaiter;
import Vdb.Native;
import Vdb.OpCopy;
import Vdb.OpCreate;
import Vdb.OpMove;
import Vdb.OpRead;
import Vdb.OpReadWrite;
import Vdb.OpWrite;
import Vdb.Operations;
import Vdb.Patterns;
import Vdb.SlaveJvm;
import Vdb.SlaveWorker;
import Vdb.Task_num;
import Vdb.Validate;
import Vdb.Work;
import Vdb.common;
import java.util.Date;
import java.util.Vector;

abstract class FwgThread
extends Thread {
    private static final String c = "Copyright (c) 2000, 2016, Oracle and/or its affiliates. All rights reserved.";
    protected FwgEntry fwg;
    protected Task_num tn;
    private int seqno;
    protected ActiveFile afe = null;
    public long consecutive_blocks = 0L;
    public long last_ok_request = System.currentTimeMillis();
    private int last_block = 0;
    private long native_read_buffer = 0L;
    private long native_write_buffer = 0L;
    public long permit_last = 0L;
    public long permit_time = 0L;
    public long permit_tod = 0L;
    protected boolean format;
    protected boolean format_restart;
    protected int operation;
    private boolean expect_rmdirs;
    private int buffer_size = 0;
    public FwdStats per_thread_stats = new FwdStats();
    public FwdStats old_stats = new FwdStats();
    protected static long YEAR = 31536000L;
    protected int OUTPUT_FILE_MUST_EXIST = 99;
    protected int OUTPUT_FILE_MAY_NOT_EXIST = 98;
    protected int OUTPUT_FILE_EITHER = 97;
    protected int OUTPUT_FILE_NOT_COMPLETE = 96;
    private static Object shutdown_lock = new Object();
    private static boolean fast_block_kill = common.get_debug(common.FAST_BLOCK_KILL);
    private static boolean report_permits = common.get_debug(common.REPORT_FWG_PERMITS);
    private static int BLOCK_KILL = fast_block_kill ? 100 : 10000;
    private static int thread_number = 0;

    protected abstract boolean doOperation() throws InterruptedException;

    public FwgThread(Task_num task_num, FwgEntry fwgEntry) {
        this.seqno = thread_number++;
        if (task_num != null) {
            this.setName(task_num.task_name + " rd=" + SlaveWorker.work.work_rd_name);
        } else {
            this.setName("notask  rd=" + SlaveWorker.work.work_rd_name);
        }
        this.tn = task_num;
        this.fwg = fwgEntry;
        this.format = SlaveWorker.work.format_run;
        this.format_restart = this.format && SlaveWorker.work.format_flags.format_restart;
        this.operation = fwgEntry.getOperation();
        this.expect_rmdirs = SlaveWorker.canWeExpectDirectoryDeletes();
        if (this instanceof OpCreate || this instanceof OpRead || this instanceof OpWrite || this instanceof OpCopy || this instanceof OpMove) {
            this.buffer_size = fwgEntry.getMaxXfersize();
            if (fwgEntry.dedup != null) {
                FwgEntry fwgEntry2 = fwgEntry;
                this.buffer_size = Math.max(this.buffer_size, fwgEntry2.dedup.getDedupUnit());
                FwgEntry fwgEntry3 = fwgEntry;
                this.buffer_size += fwgEntry3.dedup.getDedupUnit();
            }
            if (Validate.isRealValidate() || this instanceof OpRead || this instanceof OpReadWrite || this instanceof OpWrite || this instanceof OpCopy || this instanceof OpMove) {
                this.native_read_buffer = Native.allocBuffer(this.buffer_size);
            }
            boolean bl = false;
            if (task_num == null) {
                bl = true;
            } else if (this instanceof OpReadWrite) {
                bl = true;
            } else if (!(this instanceof OpRead)) {
                bl = true;
            }
            if (bl) {
                this.native_write_buffer = Native.allocBuffer(this.buffer_size);
                Patterns.storeStartingFsdPattern(this.native_write_buffer, this.buffer_size);
            }
        }
        if (task_num != null) {
            task_num.task_set_start_pending();
        }
    }

    public void finalize() throws Throwable {
        if (this.native_read_buffer != 0L) {
            Native.freeBuffer(this.buffer_size, this.native_read_buffer);
        }
        if (this.native_write_buffer != 0L) {
            Native.freeBuffer(this.buffer_size, this.native_write_buffer);
        }
        super.finalize();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        Thread.currentThread().setPriority(1);
        FwgQueue fwgQueue = FwgWaiter.getMyQueue(this.fwg);
        try {
            boolean bl = common.get_debug(common.USE_FORMAT_RATE);
            this.tn.task_set_start_complete();
            this.tn.waitForMasterGo();
            if (this.fwg.anchor.isDeletePending()) {
                this.fwg.anchor.cleanupOldFiles(this.fwg);
            }
            while (!SlaveJvm.isWorkloadDone() && !this.fwg.getShutdown()) {
                if (!this.format && !Validate.isJournalRecoveryActive()) {
                    try {
                        if (!report_permits) {
                            fwgQueue.getPermit();
                        } else {
                            long l = System.nanoTime();
                            fwgQueue.getPermit();
                            this.permit_time += System.nanoTime() - l;
                        }
                    }
                    catch (InterruptedException interruptedException) {
                        break;
                    }
                }
                if (!this.doOperation()) break;
                this.consecutive_blocks = 0L;
                this.last_ok_request = System.currentTimeMillis();
            }
            ActiveFile.conditionalCloseFile(this.afe);
            this.tn.task_set_terminating(0.0);
        }
        catch (Throwable throwable) {
            common.abnormal_term(throwable);
        }
        Object object = shutdown_lock;
        synchronized (object) {
            if (Task_num.checkAllInTermination()) {
                SlaveJvm.setWorkloadDone(true);
            }
        }
    }

    protected FileEntry findNonExistingFile() {
        while (!SlaveJvm.isWorkloadDone()) {
            FileEntry fileEntry = this.fwg.anchor.getFile(this.fwg);
            if (fileEntry == null) {
                return null;
            }
            if (!fileEntry.setFileBusyExc()) {
                this.block(Blocked.FILE_BUSY);
                continue;
            }
            if (fileEntry.isBadFile()) {
                this.block(Blocked.BAD_FILE_SKIPPED);
                fileEntry.setUnBusy();
                continue;
            }
            if (this.format_restart && fileEntry.exists() && !fileEntry.isFull()) {
                return fileEntry;
            }
            if (this.format && fileEntry.exists()) {
                fileEntry.setUnBusy();
                this.block(Blocked.FILE_MAY_NOT_EXIST);
                if (this.fwg.anchor.allFilesFull()) {
                    return null;
                }
                common.sleep_some_usecs(200L);
                continue;
            }
            if (fileEntry.exists()) {
                fileEntry.setUnBusy();
                String[] stringArray = new String[]{"Anchor: " + this.fwg.anchor.getAnchorName(), "Vdbench is trying to create a new file, but all files already exist, ", "and no threads are currently active deleting files"};
                if (!this.canWeGetMoreFiles(stringArray)) {
                    return null;
                }
                this.block(Blocked.FILE_MAY_NOT_EXIST);
                continue;
            }
            if (this.expect_rmdirs && !this.format && !fileEntry.setParentBusy(true)) {
                fileEntry.cleanup();
                this.block(Blocked.PARENT_DIR_BUSY);
                continue;
            }
            if (!fileEntry.getParent().exist()) {
                fileEntry.cleanup();
                this.block(Blocked.MISSING_PARENT);
                continue;
            }
            return fileEntry;
        }
        return null;
    }

    protected boolean doSequentialWrite(boolean bl) {
        this.afe.xfersize = this.fwg.getXferSize();
        if (!this.afe.setNextSequentialWrite() || this.afe.done_enough) {
            if (this.format) {
                this.afe.getFileEntry().setFormatComplete(true);
            }
            this.afe = this.afe.closeFile();
            if (bl) {
                this.afe = null;
                return false;
            }
            FileEntry fileEntry = this.format_restart ? this.findFileToWrite(this.OUTPUT_FILE_NOT_COMPLETE) : this.findFileToWrite(this.OUTPUT_FILE_EITHER);
            if (fileEntry == null) {
                return false;
            }
            this.afe = this.openForWrite(fileEntry);
            this.afe.xfersize = this.fwg.getXferSize();
            boolean bl2 = this.afe.setNextSequentialWrite();
        }
        this.afe.writeBlock();
        this.afe.checkEnough();
        return true;
    }

    protected ActiveFile obsolete_openFile(FileEntry fileEntry) {
        if (this.fwg.getOperation() == Operations.WRITE || this.fwg.readpct >= 0.0) {
            return this.openForWrite(fileEntry);
        }
        return this.openForRead(fileEntry);
    }

    protected ActiveFile openForRead(FileEntry fileEntry) {
        ActiveFile activeFile = new ActiveFile(fileEntry, this.fwg, this.native_read_buffer, this.native_write_buffer);
        long l = Native.get_simple_tod();
        activeFile.openFile(true);
        this.fwg.blocked.count(Blocked.READ_OPENS);
        FwdStats.count(Operations.OPEN, l);
        return activeFile;
    }

    protected ActiveFile openForWrite(FileEntry fileEntry) {
        if (this.fwg.sequential_io && this.fwg.del_b4_write && fileEntry.exists() && (this.fwg.stopafter == 0L || fileEntry.getCurrentSize() == fileEntry.getReqSize())) {
            fileEntry.deleteFile(this.fwg);
        }
        ActiveFile activeFile = new ActiveFile(fileEntry, this.fwg, this.native_read_buffer, this.native_write_buffer);
        long l = Native.get_simple_tod();
        activeFile.openFile(false);
        this.fwg.blocked.count(Blocked.WRITE_OPENS);
        FwdStats.count(Operations.OPEN, l);
        if (this.fwg.getOperation() == Operations.WRITE && !fileEntry.exists()) {
            FwdStats.count(Operations.CREATE, l);
        }
        if (this.format_restart) {
            long l2 = this.fwg.getXferSize();
            activeFile.next_lba = fileEntry.getCurrentSize() / l2 * l2;
        }
        return activeFile;
    }

    public FileEntry findFileToWrite(int n) {
        while (!SlaveJvm.isWorkloadDone()) {
            String[] stringArray;
            boolean bl;
            FileEntry fileEntry = !this.format && (this.fwg.getOperation() == Operations.COPY || this.fwg.getOperation() == Operations.MOVE) ? this.fwg.target_anchor.getFile(this.fwg) : this.fwg.anchor.getFile(this.fwg);
            if (fileEntry == null) {
                return null;
            }
            boolean bl2 = bl = this.fwg.del_b4_write ? fileEntry.setFileBusyExc() : fileEntry.setFileBusy();
            if (!bl) {
                this.block(Blocked.FILE_BUSY);
                continue;
            }
            if (fileEntry.isBadFile()) {
                this.block(Blocked.BAD_FILE_SKIPPED);
                fileEntry.setUnBusy();
                continue;
            }
            if (n == this.OUTPUT_FILE_MUST_EXIST && !fileEntry.exists()) {
                fileEntry.setUnBusy();
                stringArray = new String[]{"Anchor: " + this.fwg.anchor.getAnchorName(), "Vdbench is trying to write to a file, but no files are available, and no", "threads are currently active creating new files: " + this.fwg.anchor.getAnchorName()};
                if (!this.canWeGetMoreFiles(stringArray)) {
                    return null;
                }
                this.block(Blocked.FILE_MUST_EXIST);
                continue;
            }
            if (n == this.OUTPUT_FILE_MAY_NOT_EXIST && fileEntry.exists()) {
                fileEntry.setUnBusy();
                stringArray = new String[]{"Anchor: " + this.fwg.anchor.getAnchorName(), "Vdbench is trying to write to a file, but it needs a file that doesnot exist yet, and no threads are currently active deleting files."};
                if (!this.canWeExpectFileDeletes(stringArray)) {
                    return null;
                }
                this.block(Blocked.FILE_MAY_NOT_EXIST);
                continue;
            }
            if (n == this.OUTPUT_FILE_NOT_COMPLETE && fileEntry.exists() && fileEntry.isFull()) {
                fileEntry.setUnBusy();
                this.block(Blocked.FILE_IS_FULL);
                if (this.format) {
                    common.sleep_some(200L);
                }
                if (!fileEntry.getAnchor().allFilesFull()) continue;
                return null;
            }
            if (this.format && fileEntry.isFormatComplete()) {
                fileEntry.setUnBusy();
                return null;
            }
            if (this.format && fileEntry.isFull()) {
                fileEntry.setFormatComplete(true);
                fileEntry.setUnBusy();
                continue;
            }
            if (!fileEntry.getParent().exist()) {
                fileEntry.setUnBusy();
                this.block(Blocked.MISSING_PARENT);
                continue;
            }
            return fileEntry;
        }
        return null;
    }

    protected FileEntry findFileToRead() {
        while (!SlaveJvm.isWorkloadDone()) {
            FileEntry fileEntry = this.fwg.anchor.getFile(this.fwg);
            if (fileEntry == null) {
                return null;
            }
            if (!fileEntry.setFileBusy()) {
                this.block(Blocked.FILE_BUSY);
                continue;
            }
            if (fileEntry.isBadFile()) {
                this.block(Blocked.BAD_FILE_SKIPPED);
                fileEntry.setUnBusy();
                continue;
            }
            if (!fileEntry.exists()) {
                String[] stringArray;
                fileEntry.setUnBusy();
                this.block(Blocked.FILE_MUST_EXIST);
                if ((this.operation == Operations.MOVE || this.operation == Operations.COPY) && this.fwg.anchor.getExistingFileCount() != 0 || this.canWeGetMoreFiles(stringArray = new String[]{"Anchor: " + this.fwg.anchor.getAnchorName(), "Vdbench is trying to read from a file, but no files are available, and no", "threads are currently active creating new files"})) continue;
                return null;
            }
            if (Validate.isJournalRecoveryActive()) {
                if (this.fwg.anchor.getDVMap().anyBadBlocks(fileEntry.getFileStartLba(), fileEntry.getCurrentSize())) {
                    fileEntry.setUnBusy();
                    continue;
                }
                if (!this.fwg.anchor.getDVMap().anyValidBlocks(fileEntry.getFileStartLba(), fileEntry.getCurrentSize())) {
                    fileEntry.setUnBusy();
                    continue;
                }
            }
            if (fileEntry.getCurrentSize() == 0L) {
                fileEntry.setUnBusy();
                this.block(Blocked.FILE_NOT_FULL);
                continue;
            }
            return fileEntry;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean canWeGetMoreFiles(String[] stringArray) {
        if (this.fwg.anchor.anyMoreFilesToCreate() == 0L) {
            if (SlaveWorker.canWeExpectFileDeletes()) {
                return true;
            }
            FwgEntry fwgEntry = this.fwg;
            synchronized (fwgEntry) {
                if (!SlaveWorker.work.format_run && !this.fwg.getShutdown()) {
                    this.fwg.setShutdown(true);
                    this.sendMessage(stringArray, "FwgThread.canWeGetMoreFiles(): Shutting down threads for operation=" + Operations.getOperationText(this.operation));
                }
                if (SlaveWorker.work.format_run) {
                    return false;
                }
            }
            return false;
        }
        if (this.fwg.anchor.getExistingFileCount() == 0 && !SlaveWorker.canWeExpectFileCreates()) {
            FwgEntry fwgEntry = this.fwg;
            synchronized (fwgEntry) {
                if (!SlaveWorker.work.format_run && !this.fwg.getShutdown()) {
                    this.fwg.setShutdown(true);
                    this.sendMessage(stringArray, "FwgThread.canWeGetMoreFiles(): Shutting down threads for operation=" + Operations.getOperationText(this.operation));
                }
            }
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean canWeExpectFileDeletes(String[] stringArray) {
        Work work = SlaveWorker.work;
        for (int i = 0; i < work.fwgs_for_slave.size(); ++i) {
            FwgEntry fwgEntry = work.fwgs_for_slave.elementAt(i);
            if (fwgEntry.getOperation() == Operations.DELETE) {
                return true;
            }
            if (fwgEntry.getOperation() != Operations.MOVE) continue;
            return true;
        }
        FwgEntry fwgEntry = this.fwg;
        synchronized (fwgEntry) {
            if (!this.fwg.getShutdown()) {
                this.fwg.setShutdown(true);
                this.sendMessage(stringArray, "FwgThread.canWeExpectFileDeletes(): Shutting down threads for operation=" + Operations.getOperationText(this.operation));
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean canWeGetMoreDirectories(String[] stringArray) {
        if (this.fwg.anchor.anyMoreDirectories() == 0L) {
            if (this.expect_rmdirs) {
                return true;
            }
            FwgEntry fwgEntry = this.fwg;
            synchronized (fwgEntry) {
                if (!SlaveWorker.work.format_run && !this.fwg.getShutdown()) {
                    this.fwg.setShutdown(true);
                    this.sendMessage(stringArray, "FwgThread.canWeGetMoreDirectories(): Shutting down threads for operation=" + Operations.getOperationText(this.operation));
                }
            }
            return false;
        }
        if (this.fwg.anchor.getExistingDirCount() == 0L && !SlaveWorker.canWeExpectDirectoryCreates()) {
            FwgEntry fwgEntry = this.fwg;
            synchronized (fwgEntry) {
                if (!SlaveWorker.work.format_run && !this.fwg.getShutdown()) {
                    this.fwg.setShutdown(true);
                    this.sendMessage(stringArray, "FwgThread.canWeGetMoreDirectories(): Shutting down threads for operation=" + Operations.getOperationText(this.operation));
                }
            }
            return false;
        }
        return true;
    }

    private void sendMessage(String[] stringArray, String string) {
        int n;
        Vector<String> vector = new Vector<String>(10, 0);
        for (n = 0; n < stringArray.length; ++n) {
            vector.add(stringArray[n]);
        }
        vector.add(string);
        vector.add("");
        for (n = 0; n < vector.size(); ++n) {
            common.ptod(vector.elementAt(n));
        }
        SlaveJvm.sendMessageToConsole(vector);
    }

    protected void block(int n) {
        this.block(n, "");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void block(int n, String string) {
        ++this.consecutive_blocks;
        this.last_block = n;
        this.fwg.blocked.count(n);
        if (n == Blocked.FILE_MUST_EXIST && (this.fwg.getOperation() == Operations.COPY || this.fwg.getOperation() == Operations.MOVE)) {
            return;
        }
        if (n == Blocked.FILE_MUST_EXIST && this.fwg.getOperation() == Operations.DELETE) {
            return;
        }
        if (this.format) {
            return;
        }
        common.sleep_some_usecs(200L);
        if (this.format && n == Blocked.DIR_EXISTS) {
            return;
        }
        if (this.format && n == Blocked.MISSING_PARENT) {
            return;
        }
        if (this.format && n == Blocked.PARENT_DIR_BUSY) {
            return;
        }
        if (this.consecutive_blocks > (long)BLOCK_KILL) {
            if (this.format && n == Blocked.FILE_IS_FULL) {
                return;
            }
            if (this.format && n == Blocked.FILE_MAY_NOT_EXIST) {
                return;
            }
            if (this.format && n == Blocked.FILE_BUSY) {
                return;
            }
            Object object = common.ptod_lock;
            synchronized (object) {
                double d = System.currentTimeMillis() - this.last_ok_request;
                Blocked.printTrace();
                Blocked.printAndResetCounters();
                Vector<String> vector = new Vector<String>(16);
                for (Directory comparable : this.fwg.anchor.getDirList()) {
                    if (!comparable.isBusyNoSync()) continue;
                    vector.add(String.format("dir=%s,busy=%b", comparable.getFullName(), comparable.isBusyNoSync()));
                }
                for (FileEntry fileEntry : this.fwg.anchor.getFileList()) {
                    if (!fileEntry.isBusy()) continue;
                    vector.add(String.format("file=%s,busy=%b", fileEntry.getFullName(), fileEntry.isBusy()));
                }
                vector.add("Thread: " + Thread.currentThread().getName());
                vector.add("");
                vector.add("last_ok_request: " + new Date(this.last_ok_request));
                vector.add(Format.f("Duration: %.2f seconds", d / 1000.0));
                vector.add("consecutive_blocks: " + this.consecutive_blocks);
                vector.add("last_block:         " + Blocked.getLabel(this.last_block));
                vector.add("operation:          " + Operations.getOperationText(this.operation));
                if (string.length() > 0) {
                    vector.add("msg: " + string);
                }
                vector.add("");
                vector.add("Do you maybe have more threads running than that you have ");
                vector.add("files and therefore some threads ultimately give up after " + BLOCK_KILL + " tries?");
                SlaveJvm.sendMessageToConsole(vector);
                common.failure("Too many thread blocks");
            }
        }
    }
}

