/*
 * Decompiled with CFR 0.152.
 */
package Vdb;

import Vdb.common;
import java.lang.management.GarbageCollectorMXBean;
import java.lang.management.ManagementFactory;

public class GcTracker {
    private long tod = System.currentTimeMillis();
    private long elapsed = 0L;
    private long gc_count = 0L;
    private long ccount = 0L;
    private long gc_time = 0L;
    private long gc_beans = 0L;
    private static boolean report_now = false;
    private static GcTracker prev_tracker = new GcTracker();

    public GcTracker() {
        for (GarbageCollectorMXBean garbageCollectorMXBean : ManagementFactory.getGarbageCollectorMXBeans()) {
            long l;
            ++this.gc_beans;
            long l2 = garbageCollectorMXBean.getCollectionCount();
            if (l2 >= 0L) {
                this.gc_count += l2;
            }
            if ((l = garbageCollectorMXBean.getCollectionTime()) < 0L) continue;
            this.gc_time += l;
        }
        this.ccount = this.gc_count;
    }

    public static void gc() {
        common.ptod("Requesting full garbage collection");
        GcTracker.reportAlways();
        System.gc();
        GcTracker.reportAlways();
    }

    public static void reportAlways() {
        report_now = true;
        GcTracker.report();
    }

    public static void report() {
        GcTracker gcTracker = new GcTracker();
        long l = gcTracker.tod - GcTracker.prev_tracker.tod;
        long l2 = gcTracker.gc_count - GcTracker.prev_tracker.gc_count;
        long l3 = gcTracker.gc_time - GcTracker.prev_tracker.gc_time;
        long l4 = gcTracker.ccount;
        long l5 = gcTracker.gc_beans;
        double d = (double)Runtime.getRuntime().freeMemory() / 1048576.0;
        double d2 = (double)Runtime.getRuntime().totalMemory() / 1048576.0;
        double d3 = (double)Runtime.getRuntime().maxMemory() / 1048576.0;
        double d4 = d2 - d;
        if (l == 0L) {
            l = 1L;
        }
        prev_tracker = gcTracker;
        if (!report_now) {
            if (common.get_debug(common.GCTRACKER)) {
                report_now = true;
            } else if (l2 > 0L && l3 > 100000L) {
                report_now = true;
            }
        }
        if (!report_now) {
            return;
        }
        double d5 = (double)l3 * 100.0 / (double)l;
        double d6 = l3 / l / 1000L;
        String string = String.format("GcTracker: cum: %3d intv: %2d ms: %,7d mss: %5.2f%% Heap_MB max: %5.0f curr: %5.0f used: %5.0f free: %5.0f ", l4, l2, l3, d6, d3, d2, d4, d);
        common.plog(string);
        report_now = false;
    }

    public static void main(String[] stringArray) throws Exception {
        for (int i = 0; i < 5; ++i) {
            common.sleep_some(1000L);
            System.gc();
            GcTracker.report();
        }
    }
}

