/*
 * Decompiled with CFR 0.152.
 */
package Vdb;

import Utils.ClassPath;
import Vdb.Debug_cmds;
import Vdb.Slave;
import Vdb.SlaveJvm;
import Vdb.SlaveList;
import Vdb.SlaveSocket;
import Vdb.SocketMessage;
import Vdb.ThreadControl;
import Vdb.Vdbmain;
import Vdb.common;
import java.util.Vector;

class HeartBeat
extends ThreadControl {
    private static final String c = "Copyright (c) 2000, 2015, Oracle and/or its affiliates. All rights reserved.";
    private static String[] dflt_cmd = new String[]{ClassPath.classPath("vdbench jstack")};
    public static Debug_cmds heartbeat_error = null;
    private static boolean check_slave_heartbeat;
    private static int DEFAULT;
    private static int seconds_late;
    private static HeartBeat beater;

    public HeartBeat(boolean bl) {
        if (common.get_debug(common.LONGER_HEARTBEAT)) {
            DEFAULT = 900;
            seconds_late = 900;
        } else if (common.get_debug(common.SHORTER_HEARTBEAT)) {
            DEFAULT = 30;
            seconds_late = 30;
        }
        check_slave_heartbeat = bl;
        if (bl) {
            this.setName("Check Slave HeartBeat");
        } else {
            this.setName("Check Master HeartBeat");
        }
    }

    @Override
    public void run() {
        block9: {
            beater = this;
            this.setIndependent();
            try {
                do {
                    if (check_slave_heartbeat) {
                        if (!HeartBeat.checkSlaveHeartBeat()) {
                            if (heartbeat_error != null) {
                                heartbeat_error.run_command();
                            }
                            this.removeIndependent();
                            common.memory_usage();
                            common.failure("Heartbeat monitor: One or more slaves did not respond");
                        }
                        HeartBeat.sendSlaveHeartBeat();
                    } else if (!HeartBeat.checkMasterHeartBeat()) {
                        if (heartbeat_error != null) {
                            heartbeat_error.run_command();
                        }
                        this.removeIndependent();
                        common.memory_usage();
                        common.failure("Heartbeat monitor: Master did not respond. Timeout value: " + seconds_late);
                    }
                    common.sleep_some(seconds_late / 4 * 1000);
                    if (!Thread.currentThread().isInterrupted()) continue;
                    this.removeIndependent();
                    break block9;
                } while (!SlaveList.shutdown_requested);
                common.ptod("Heartbeat Monitor: shutting down after what may have been a lost interrupt.");
                this.removeIndependent();
            }
            catch (Exception exception) {
                common.ptod("Heartbeat monitor died unexpectedly. Run terminated.");
                common.memory_usage();
                common.failure(exception);
            }
        }
    }

    private static boolean checkSlaveHeartBeat() {
        long l = System.currentTimeMillis();
        boolean bl = false;
        Vector<Slave> vector = SlaveList.getSlaveList();
        for (int i = 0; i < vector.size(); ++i) {
            Slave slave = vector.elementAt(i);
            if (slave.isShutdown() || slave.getSocket() == null || slave.getSocket().getlastHeartBeat() + (long)((seconds_late + 5) * 1000) >= l) continue;
            common.ptod("HeartBeat.checkHeartBeat(): slave " + slave.getLabel() + " has not responded for " + (seconds_late + 5) + " seconds.");
            bl = true;
        }
        return !bl;
    }

    private static void sendSlaveHeartBeat() {
        Vector<Slave> vector = SlaveList.getSlaveList();
        for (int i = 0; i < vector.size(); ++i) {
            Slave slave = vector.elementAt(i);
            SlaveSocket slaveSocket = slave.getSocket();
            if (slave.isShutdown()) continue;
            SocketMessage socketMessage = new SocketMessage(SocketMessage.HEARTBEAT_MESSAGE);
            slaveSocket.putMessage(socketMessage);
        }
    }

    private static boolean checkMasterHeartBeat() {
        long l = System.currentTimeMillis();
        if (Vdbmain.isWorkloadDone()) {
            return true;
        }
        if (SlaveJvm.getMasterSocket() != null && SlaveJvm.getMasterSocket().getlastHeartBeat() + (long)(seconds_late * 1000) < l) {
            common.ptod("HeartBeat.checkHeartBeat(): Master has not responded for " + seconds_late + " seconds.");
            return false;
        }
        return true;
    }

    static {
        seconds_late = DEFAULT = 180;
    }
}

