/*
 * Decompiled with CFR 0.152.
 */
package Vdb;

import Vdb.Host;
import Vdb.Mount;
import Vdb.Vdb_scan;
import Vdb.common;
import java.util.Vector;

public class HostParms {
    private static final String c = "Copyright (c) 2000, 2016, Oracle and/or its affiliates. All rights reserved.";
    private static Host dflt_host = new Host();

    static String readParms(String string) {
        Host host;
        int n;
        Host host2 = null;
        String string2 = string;
        int n2 = 0;
        if (string2 == null) {
            common.failure("Early EOF on input parameters");
        }
        while (true) {
            Vdb_scan vdb_scan = Vdb_scan.parms_split(string2);
            if (vdb_scan.keyword.equals("rg") || vdb_scan.keyword.equals("sd") || vdb_scan.keyword.equals("fsd") || vdb_scan.keyword.equals("wd") || vdb_scan.keyword.equals("fwd") || vdb_scan.keyword.equals("rd")) break;
            if (vdb_scan.keyword.equals("host") && n2++ == 0) {
                common.ptod("");
                common.ptod("Specifying 'host=(xxx.yyy.com,host_x) has been deprecated.");
                common.ptod("Please specify 'hd=host_x,system=xxx.yyy.com' instead.");
                common.ptod("Vdbench will honor this parameter until the next release.");
                common.ptod("");
            }
            if (vdb_scan.keyword.equals("hd") || vdb_scan.keyword.equals("host")) {
                if ((vdb_scan.keyword.equals("host") || vdb_scan.getAlphaCount() > 1) && n2++ == 0) {
                    common.ptod("Specifying 'hd=(xxx.yyy.com,host_x) or");
                    common.ptod("Specifying 'host=(xxx.yyy.com,host_x) has been deprecated.");
                    common.ptod("Please specify 'hd=host_x,system=xxx.yyy.com' instead.");
                    common.ptod("Vdbench will honor this parameter until the next release.");
                }
                if (vdb_scan.alphas[0].equals("default")) {
                    host2 = dflt_host;
                } else {
                    host2 = (Host)dflt_host.clone();
                    host2.host_label = vdb_scan.alphas[0];
                    host2.host_ip = vdb_scan.alphas[0];
                    if (vdb_scan.getAlphaCount() > 1) {
                        host2.host_label = vdb_scan.alphas[1];
                    }
                    Host.addHost(host2);
                }
            } else if ("system".startsWith(vdb_scan.keyword)) {
                host2.host_ip = vdb_scan.alphas[0];
                if (!Host.doesHostExist(host2.host_ip)) {
                    common.failure("Host '" + host2.host_ip + "' does not exist");
                }
            } else if ("master".startsWith(vdb_scan.keyword)) {
                host2.master_ip = vdb_scan.alphas[0];
                host2.runHostName();
            } else if ("vdbench".startsWith(vdb_scan.keyword)) {
                host2.host_vdbench = vdb_scan.alphas[0];
            } else if ("shell".startsWith(vdb_scan.keyword)) {
                host2.host_shell = vdb_scan.alphas[0];
            } else if ("user".startsWith(vdb_scan.keyword)) {
                host2.host_user = vdb_scan.alphas[0];
            } else if ("jvms".startsWith(vdb_scan.keyword)) {
                host2.setJvmCount((int)vdb_scan.numerics[0]);
                host2.jvms_in_parm = true;
            } else if ("clients".startsWith(vdb_scan.keyword)) {
                host2.client_count = (int)vdb_scan.numerics[0];
            } else if ("mount".startsWith(vdb_scan.keyword)) {
                host2.host_mount = new Mount(vdb_scan.alphas);
            } else {
                common.failure("HostParms.ReadParms(): invalid keyword: " + vdb_scan.keyword);
            }
            if ((string2 = Vdb_scan.parms_get()) != null) continue;
            common.failure("Early EOF on input parameters");
        }
        if (Host.getDefinedHosts().size() == 0) {
            Host.addHost((Host)dflt_host.clone());
        }
        Vector<Host> vector = Host.getDefinedHosts();
        for (n = 0; n < vector.size(); ++n) {
            host = vector.elementAt(n);
            if (host.client_count <= 0) continue;
            for (int i = 1; i < host.client_count; ++i) {
                Host host3 = (Host)host.clone();
                host3.host_label = host3.host_label + "_cl" + i;
                host3.client_count = 0;
                Host.addHost(host3);
                common.plog("Added client: " + host3.host_label);
            }
            host.client_count = 0;
            host.host_label = host.host_label + "_cl0";
            common.plog("Added client: " + host.host_label);
        }
        vector = Host.getDefinedHosts();
        for (n = 0; n < vector.size(); ++n) {
            host = vector.elementAt(n);
            if (host.host_vdbench.endsWith("/") || host.host_vdbench.endsWith("\\")) continue;
            if (host.host_vdbench.indexOf("/") != -1) {
                host.host_vdbench = host.host_vdbench + "/";
                continue;
            }
            if (host.host_vdbench.indexOf("\\") != -1) {
                host.host_vdbench = host.host_vdbench + "\\";
                continue;
            }
            common.failure("'vdbench=' directory name must end with a file separator (\\ or /): " + host.host_vdbench);
        }
        return string2;
    }
}

