/*
 * Decompiled with CFR 0.152.
 */
package Vdb;

import User.UserCmd;
import Vdb.ActiveFile;
import Vdb.BadDataBlock;
import Vdb.BadSector;
import Vdb.Cmd_entry;
import Vdb.ConcatLbaSearch;
import Vdb.ConcatSds;
import Vdb.DV_map;
import Vdb.Dedup;
import Vdb.Errno;
import Vdb.ErrorLog;
import Vdb.FifoList;
import Vdb.File_handles;
import Vdb.HelpDebug;
import Vdb.KeyMap;
import Vdb.Native;
import Vdb.Patterns;
import Vdb.ReplayDevice;
import Vdb.ReplayInfo;
import Vdb.SD_entry;
import Vdb.ShowLba;
import Vdb.SlaveJvm;
import Vdb.SlaveWorker;
import Vdb.SocketMessage;
import Vdb.StreamContext;
import Vdb.Task_num;
import Vdb.ThreadMonitor;
import Vdb.Timers;
import Vdb.Timestamp;
import Vdb.Validate;
import Vdb.WG_entry;
import Vdb.common;

public class IO_task
extends Thread {
    private static final String c = "Copyright (c) 2000, 2016, Oracle and/or its affiliates. All rights reserved.";
    private SD_entry sd = null;
    private FifoList get_from_fifo;
    private Task_num tn;
    private int allocated_buffer_size;
    private long write_buffer;
    private long read_buffer;
    private int ios_currently_active = 0;
    private Cmd_entry[] cmd_array = new Cmd_entry[1];
    private long pid_and_lwp;
    private KeyMap key_map = null;
    private long rc = 0L;
    private int data_flag;
    private boolean compression_only;
    private UserCmd usercmd;
    private StreamContext stream_context = null;
    private ThreadMonitor tmonitor = null;
    private Timers gettime = new Timers("IO_task getArray");
    private Timers iotime = new Timers("IO_task iotime");
    private int key_blocksize = 0;
    private int max_sd_xfersize = 0;
    private SD_entry concat_search_key = new SD_entry();
    private ConcatLbaSearch search_method = new ConcatLbaSearch();
    private static boolean print_io_comp = common.get_debug(common.PRINT_IO_COMP);
    private static boolean fake_before = common.get_debug(common.FAKE_TRACE_BEFORE);
    private static boolean fake_trace = false;
    private static boolean remove_after_error = Validate.removeAfterError();

    public IO_task(Task_num task_num, SD_entry sD_entry) {
        this.sd = sD_entry;
        this.get_from_fifo = this.sd.fifo_to_iot;
        this.tn = task_num;
        this.data_flag = Validate.createDataFlag();
        this.compression_only = (this.data_flag & Validate.FLAG_COMPRESSION) != 0;
        this.max_sd_xfersize = this.sd.getMaxSdXfersize();
        if (Validate.isRealValidate()) {
            this.key_blocksize = this.sd.dv_map.getKeyBlockSize();
        } else if (Validate.isValidateForDedup()) {
            this.key_blocksize = Dedup.getDedupUnit();
        }
        this.setName(this.tn.task_name);
        this.tn.task_set_start_pending();
        fake_trace = Validate.showLba();
    }

    public IO_task(Task_num task_num, FifoList fifoList, int n) {
        this.sd = null;
        this.get_from_fifo = fifoList;
        this.tn = task_num;
        this.data_flag = Validate.createDataFlag();
        this.compression_only = (this.data_flag & Validate.FLAG_COMPRESSION) != 0;
        this.max_sd_xfersize = n;
        this.key_blocksize = n;
        if (Dedup.isDedup()) {
            this.key_blocksize = Dedup.getDedupUnit();
        }
        this.setName(this.tn.task_name);
        this.tn.task_set_start_pending();
        fake_trace = Validate.showLba();
    }

    private boolean doWeNeedWriteBuffer() {
        if (this.sd != null && !this.sd.isOpenForWrite()) {
            return false;
        }
        if (Validate.isRealValidate() || Validate.isValidateForDedup()) {
            return true;
        }
        return true;
    }

    public static synchronized void io_error_report(long l, long l2, long l3, long l4, long l5, long l6) {
        boolean bl = l != 0L;
        DV_map dV_map = null;
        String string = null;
        SD_entry sD_entry = null;
        ActiveFile activeFile = null;
        Object object = File_handles.findHandle(l2);
        if (object instanceof SD_entry) {
            sD_entry = (SD_entry)object;
            dV_map = sD_entry.dv_map;
            string = sD_entry.lun;
            ++sD_entry.sd_error_count;
            sD_entry.sd_error_time = System.currentTimeMillis();
            if (remove_after_error) {
                if (Validate.getErrorSleep() > 0) {
                    ErrorLog.ptod("'data_errors=remove_device' requested for sd=%s. SD will not receive any new work for %d seconds.", sD_entry.sd_name, Validate.getErrorSleep());
                } else {
                    ErrorLog.ptod("'data_errors=remove_device' requested for sd=%s. No longer issuing i/o against this SD.", sD_entry.sd_name);
                }
            }
        } else if (object instanceof ActiveFile) {
            activeFile = (ActiveFile)object;
            dV_map = activeFile.getFileEntry().getAnchor().getDVMap();
            string = activeFile.getFileEntry().getFullName();
        } else {
            string = (String)object;
            common.ptod("errno: " + l5);
            common.ptod("lun:   " + string);
            common.ptod("Non-SD or FSD related i/o error: " + Errno.xlate_errno(l5));
            common.ptod("Unknown file handle. Continuing");
        }
        BadSector badSector = null;
        if (l5 == 60003L) {
            if (sD_entry != null) {
                badSector = BadDataBlock.getFirstBadSector(sD_entry, l3, 0L);
                if (BadDataBlock.reportBadDataBlock(sD_entry, l3, 0L, l6)) {
                    return;
                }
            } else {
                badSector = BadDataBlock.getFirstBadSector(activeFile, l3, activeFile.getFileEntry().getFileStartLba());
                if (BadDataBlock.reportBadDataBlock(activeFile, l3, activeFile.getFileEntry().getFileStartLba(), l6)) {
                    return;
                }
            }
        }
        String string2 = String.format("op: %-6s lun: %-30s lba: %12d 0x%08X xfer: %8d errno: %s ", bl ? "read" : "write", string, l3, l3, l4, Errno.xlate_errno(l5));
        ErrorLog.ptod(string2, new Object[0]);
        if (l5 == 60003L) {
            SlaveJvm.sendMessageToMaster(SocketMessage.ONE_TIME_STATUS, "Data corruption detected. See errorlog.html");
        } else {
            SlaveJvm.sendMessageToMaster(SocketMessage.ONE_TIME_STATUS, "I/O error detected. See errorlog.html");
        }
        if (Validate.getErrorCommand() != null) {
            if (l5 == 60003L) {
                ErrorLog.runErrorCommand(badSector.lun, badSector.file_lba, badSector.sector_lba, badSector.data_blksize, String.format("0x%04x", badSector.error_flag));
            } else {
                ErrorLog.runErrorCommand(string, l3, -1L, l4, bl ? "r" : "w");
            }
        }
        ErrorLog.countErrorsOnSlave(1);
        if (Validate.isValidate()) {
            try {
                if (sD_entry != null) {
                    KeyMap keyMap = new KeyMap(0L, sD_entry.getKeyBlockSize(), SlaveWorker.work.maximum_xfersize);
                    keyMap.markDataBlockBad(dV_map, l3);
                } else if (activeFile != null) {
                    KeyMap keyMap = activeFile.getKeyMap();
                    keyMap.markDataBlockBad(dV_map, l3);
                }
            }
            catch (Exception exception) {
                common.failure(exception);
            }
        }
    }

    @Override
    public void run() {
        try {
            Thread thread = Thread.currentThread();
            Thread.currentThread();
            thread.setPriority(1);
            this.initialize();
            int n = 0;
            try {
                while (!SlaveJvm.isWorkloadDone()) {
                    this.gettime.before();
                    n = this.get_from_fifo.getArray(this.cmd_array);
                    this.tmonitor.add1();
                    this.gettime.after();
                    if (!SlaveJvm.isWorkloadDone()) {
                        if (SlaveJvm.stoppingWork()) {
                            common.sleep_some(300000L);
                            return;
                        }
                        if (this.cmd_array[0].delta_tod != Long.MAX_VALUE) {
                            if (remove_after_error && this.sd.sd_error_count > 0L) {
                                int n2 = Validate.getErrorSleep() * 1000;
                                if (n2 <= 0 || System.currentTimeMillis() - this.sd.sd_error_time <= (long)n2) continue;
                                this.sd.sd_error_count = 0L;
                                continue;
                            }
                            if (this.cmd_array[0].sd_ptr.scsi_bus_reset != 0L || this.cmd_array[0].sd_ptr.scsi_lun_reset != 0L) {
                                this.cmd_array[0].sd_ptr.scsi_reset();
                            }
                            this.iotime.before();
                            if (this.processSingleIO(this.cmd_array[0])) {
                                this.iotime.after();
                                continue;
                            }
                        }
                    }
                    break;
                }
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            Thread.interrupted();
            if (this.read_buffer != 0L) {
                Native.freeBuffer(this.allocated_buffer_size, this.read_buffer);
            }
            if (this.write_buffer != 0L) {
                Native.freeBuffer(this.allocated_buffer_size, this.write_buffer);
            }
            Thread.interrupted();
            this.gettime.print();
            this.iotime.print();
            this.tn.task_set_terminating(0.0);
        }
        catch (Throwable throwable) {
            common.abnormal_term(throwable);
        }
    }

    private boolean processSingleIO(Cmd_entry cmd_entry) {
        if (fake_before && fake_trace) {
            ShowLba.writeRecord(cmd_entry);
        }
        if (cmd_entry.cmd_wg.user_class != null) {
            this.usercmd = new UserCmd(cmd_entry);
            cmd_entry.cmd_wg.user_class.preIO(this.usercmd);
            this.usercmd.updateCommand();
            if (cmd_entry.cmd_lba == 0L && !cmd_entry.cmd_read_flag && !cmd_entry.sd_ptr.canWeUseBlockZero()) {
                common.failure("Attempting to read or write to lba 0");
            }
        }
        if (this.stream_context != null) {
            cmd_entry.cmd_lba = this.stream_context.getNextSequentialLba(cmd_entry);
            if (cmd_entry.cmd_lba < 0L) {
                cmd_entry.cmd_wg.sequentials_lower();
                return false;
            }
        }
        if (cmd_entry.sd_ptr.concatenated_sd) {
            cmd_entry.concat_lba = cmd_entry.cmd_lba;
            cmd_entry.concat_sd = cmd_entry.sd_ptr;
            WG_entry wG_entry = cmd_entry.cmd_wg;
            this.sd = ConcatSds.translateConcatToRealSd(cmd_entry, this.concat_search_key, this.search_method, wG_entry.access_block_zero);
            if (cmd_entry.cmd_lba == 0L && !cmd_entry.cmd_read_flag && !cmd_entry.sd_ptr.canWeUseBlockZero()) {
                common.failure("Attempting to write to lba 0");
            }
        }
        ++this.ios_currently_active;
        if (cmd_entry.cmd_read_flag && !Validate.isRealValidate()) {
            this.rc = Native.readFile(cmd_entry.sd_ptr.fhandle, cmd_entry.cmd_lba, cmd_entry.cmd_xfersize, this.read_buffer, cmd_entry.jni_index);
        } else if (!cmd_entry.cmd_read_flag && Patterns.usePatternFile()) {
            this.rc = Native.writeFile(cmd_entry.sd_ptr.fhandle, cmd_entry.cmd_lba, cmd_entry.cmd_xfersize, this.write_buffer, cmd_entry.jni_index);
        } else {
            if (this.key_map.storeDataBlockInfo(cmd_entry.cmd_lba, cmd_entry.cmd_xfersize, cmd_entry.sd_ptr.dv_map)) {
                common.failure("Unexpected DV_ERROR block found.");
            }
            this.ioWithDataPatterns(cmd_entry);
        }
        --this.ios_currently_active;
        if (cmd_entry.cmd_wg.user_class != null) {
            cmd_entry.cmd_wg.user_class.postIO(this.usercmd);
        }
        cmd_entry.cmd_wg.subtract_io(cmd_entry);
        if (print_io_comp) {
            cmd_entry.cmd_print("print_io_comp2");
        }
        if (!fake_before && fake_trace) {
            ShowLba.writeRecord(cmd_entry);
        }
        return true;
    }

    private void ioWithDataPatterns(Cmd_entry cmd_entry) {
        if (Dedup.isDedup()) {
            this.sd.dedup.dedupSdBlock(this.key_map, cmd_entry);
        } else {
            this.key_map.setSdCompressionOnlyOffset(cmd_entry.cmd_lba);
        }
        if (Validate.isRealValidate() && this.key_map.storeDataBlockInfo(cmd_entry.cmd_lba, cmd_entry.cmd_xfersize, cmd_entry.sd_ptr.dv_map)) {
            return;
        }
        if (cmd_entry.cmd_read_flag) {
            if (!Validate.isValidateForDedup() && !Validate.isRealValidate()) {
                common.failure("This simple read call should never make it here!");
            }
            if (cmd_entry.type_of_dv_read != Validate.FLAG_PENDING_READ) {
                cmd_entry.type_of_dv_read = Validate.FLAG_NORMAL_READ;
            }
            this.readAndValidateBlock(cmd_entry);
            if (cmd_entry.type_of_dv_read == Validate.FLAG_PENDING_READ) {
                this.saveCurrentTod(Timestamp.PENDING_READ);
            } else if (cmd_entry.type_of_dv_read == Validate.FLAG_PENDING_REREAD) {
                this.saveCurrentTod(Timestamp.PENDING_REREAD);
            } else {
                this.saveCurrentTod(Timestamp.READ_ONLY);
            }
            if (Validate.isRealValidate()) {
                if (cmd_entry.type_of_dv_read == Validate.FLAG_PENDING_READ) {
                    this.key_map.storeDataBlockInfo(cmd_entry.cmd_lba, cmd_entry.cmd_xfersize, cmd_entry.sd_ptr.dv_map);
                }
                this.key_map.storeKeys();
            }
            return;
        }
        if (Validate.isRealValidate() && this.key_map.anyDataToCompare() && !Validate.isNoPreRead()) {
            cmd_entry.type_of_dv_read = Validate.FLAG_PRE_READ;
            this.readAndValidateBlock(cmd_entry);
            this.saveCurrentTod(Timestamp.PRE_READ);
            if (this.rc != 0L) {
                this.key_map.storeKeys();
                return;
            }
        }
        if (SlaveJvm.stoppingWork()) {
            return;
        }
        long l = this.patternWrite(cmd_entry);
        this.saveLastTod(Timestamp.WRITE, l);
        this.key_map.saveWriteXfer((int)cmd_entry.cmd_xfersize);
        if (Validate.isRealValidate() || Validate.isValidateForDedup()) {
            if (this.rc == 0L && Validate.isImmediateRead() && !SlaveJvm.stoppingWork()) {
                cmd_entry.type_of_dv_read = Validate.FLAG_READ_IMMEDIATE;
                this.readAndValidateBlock(cmd_entry);
                this.saveCurrentTod(Timestamp.READ_IMMED);
            }
            this.key_map.storeKeys();
            if (this.sd.dedup != null) {
                this.sd.dedup.countDedup(this.key_map, this.sd.dv_map);
            }
        }
    }

    private void readAndValidateBlock(Cmd_entry cmd_entry) {
        if (!this.key_map.anyDataToCompare()) {
            this.rc = Native.readFile(cmd_entry.sd_ptr.fhandle, cmd_entry.cmd_lba, cmd_entry.cmd_xfersize, this.read_buffer, cmd_entry.jni_index);
            return;
        }
        if (cmd_entry.type_of_dv_read == Validate.FLAG_PENDING_READ && HelpDebug.doAfterCount("corruptDuringPendingRead")) {
            HelpDebug.corruptBlock(cmd_entry.sd_ptr.fhandle, (int)cmd_entry.cmd_xfersize, cmd_entry.cmd_lba);
        }
        this.rc = Native.multiKeyReadAndValidateBlock(cmd_entry.sd_ptr.fhandle, this.data_flag | cmd_entry.type_of_dv_read, 0L, cmd_entry.cmd_lba, (int)cmd_entry.cmd_xfersize, this.read_buffer, this.key_map.getKeyCount(), this.key_map.getKeys(), this.key_map.getCompressions(), this.key_map.getDedupsets(), cmd_entry.sd_ptr.sd_name8, cmd_entry.jni_index);
        if (cmd_entry.type_of_dv_read == Validate.FLAG_PENDING_READ && this.rc == 0L) {
            ErrorLog.plog("Pending key block at lba 0x%08x key 0x%02x is OK.", cmd_entry.cmd_lba, this.sd.dv_map.dv_get(cmd_entry.cmd_lba) & 0x7F);
            common.ptod("Pending key block at lba 0x%08x key 0x%02x is OK.", cmd_entry.cmd_lba, this.sd.dv_map.dv_get(cmd_entry.cmd_lba) & 0x7F);
        } else if (cmd_entry.type_of_dv_read == Validate.FLAG_PENDING_READ && this.rc == 60003L) {
            int n;
            Byte by;
            if (this.key_map.storeDataBlockInfo(cmd_entry.cmd_lba, cmd_entry.cmd_xfersize, cmd_entry.sd_ptr.dv_map) || !this.key_map.anyDataToCompare()) {
                this.rc = 0L;
                return;
            }
            if (Dedup.isDedup()) {
                cmd_entry.sd_ptr.dedup.dedupSdBlock(this.key_map, cmd_entry);
            }
            if ((by = this.sd.dv_map.journal.before_map.pending_map.get(cmd_entry.cmd_lba)) == null) {
                common.failure("Invalid pending map state");
            }
            if ((n = by & 0xFF) == 132) {
                if (HelpDebug.doAfterCount("corruptAfterPendingRead")) {
                    HelpDebug.corruptBlock(cmd_entry.sd_ptr.fhandle, (int)cmd_entry.cmd_xfersize, cmd_entry.cmd_lba);
                }
                cmd_entry.type_of_dv_read = Validate.FLAG_PENDING_REREAD;
                this.rc = Native.multiKeyReadAndValidateBlock(cmd_entry.sd_ptr.fhandle, this.data_flag | cmd_entry.type_of_dv_read, 0L, cmd_entry.cmd_lba, (int)cmd_entry.cmd_xfersize, this.read_buffer, this.key_map.getKeyCount(), this.key_map.getKeys(), this.key_map.getCompressions(), this.key_map.getDedupsets(), cmd_entry.sd_ptr.sd_name8, cmd_entry.jni_index);
            }
        }
        if (this.rc == 0L) {
            this.key_map.countRawReadAndValidates(cmd_entry.sd_ptr, cmd_entry.cmd_lba);
        }
    }

    private long patternWrite(Cmd_entry cmd_entry) {
        if (Validate.isValidate() && !this.key_map.incrementKeys()) {
            common.where();
            return 0L;
        }
        if (Validate.isJournaling()) {
            this.key_map.writeBeforeJournalImage();
        }
        long l = Validate.isRealValidate() ? System.currentTimeMillis() : 0L;
        this.rc = 0L;
        if (!HelpDebug.doAfterCount("skipWriteAfter")) {
            if (HelpDebug.doAfterModulo("simulateSdWriteError")) {
                cmd_entry.cmd_lba |= 2L;
            }
            boolean bl = false;
            if (HelpDebug.doAfterCount("writeShortBlock")) {
                bl = true;
                cmd_entry.cmd_xfersize /= 2L;
            }
            this.rc = Native.multiKeyFillAndWriteBlock(cmd_entry.sd_ptr.fhandle, l, this.data_flag, 0L, cmd_entry.cmd_lba, (int)cmd_entry.cmd_xfersize, this.key_map.pattern_lba, this.key_map.pattern_length, this.write_buffer, this.key_map.getKeyCount(), this.key_map.getKeys(), this.key_map.getCompressions(), this.key_map.getDedupsets(), cmd_entry.sd_ptr.sd_name8, cmd_entry.jni_index);
            if (common.get_debug(common.FSYNC_AFTER_WRITE)) {
                Native.fsync(cmd_entry.sd_ptr.fhandle);
            }
            if (bl) {
                System.exit(777);
            }
        }
        if (Dedup.isDuplicate(this.key_map.getDedupsets()[0]) && HelpDebug.doAfterCount("corruptAfterWriteDup")) {
            HelpDebug.corruptBlock(cmd_entry.sd_ptr.fhandle, (int)cmd_entry.cmd_xfersize, cmd_entry.cmd_lba);
        }
        if (HelpDebug.doAfterCount("corruptAfterWrite")) {
            HelpDebug.corruptBlock(cmd_entry.sd_ptr.fhandle, (int)cmd_entry.cmd_xfersize, cmd_entry.cmd_lba);
        }
        if (HelpDebug.doForLba("corruptLbaAfterWrite", cmd_entry.cmd_lba, cmd_entry.cmd_xfersize)) {
            HelpDebug.corruptBlock(cmd_entry.sd_ptr.fhandle, (int)cmd_entry.cmd_xfersize, cmd_entry.cmd_lba);
        }
        if (Validate.isJournaling()) {
            this.key_map.writeAfterJournalImage();
        }
        this.key_map.countRawWrites(cmd_entry.sd_ptr, cmd_entry.cmd_lba);
        return l;
    }

    public long getPids() {
        return this.pid_and_lwp;
    }

    public void setStreamContext(StreamContext streamContext, int n) {
        this.stream_context = streamContext;
        if (this.stream_context != null) {
            common.ptod("StreamContext for thread=%02d; %s", n, streamContext);
        }
    }

    private void initialize() {
        this.key_map = Validate.isRealValidate() || Validate.isValidateForDedup() ? (ReplayInfo.isReplay() ? new KeyMap(0L, this.key_blocksize, ReplayDevice.getAllDevicesMaxXfersize()) : new KeyMap(0L, this.key_blocksize, this.max_sd_xfersize)) : (ReplayInfo.isReplay() && Validate.isValidateForDedup() ? new KeyMap(0L, this.key_blocksize, ReplayDevice.getAllDevicesMaxXfersize()) : new KeyMap());
        if (common.onSolaris()) {
            this.pid_and_lwp = Native.getSolarisPids();
        }
        this.allocated_buffer_size = this.max_sd_xfersize;
        if (Dedup.isDedup()) {
            this.allocated_buffer_size *= 2;
        }
        if (ReplayInfo.isReplay()) {
            this.allocated_buffer_size = ReplayDevice.getAllDevicesMaxXfersize();
            if (Dedup.isDedup()) {
                this.allocated_buffer_size *= 2;
            }
        }
        this.read_buffer = Native.allocBuffer(this.allocated_buffer_size);
        if (this.doWeNeedWriteBuffer()) {
            this.write_buffer = Native.allocBuffer(this.allocated_buffer_size);
            Patterns.storeStartingSdPattern(this.write_buffer, this.allocated_buffer_size);
        }
        this.tmonitor = new ThreadMonitor("IO_task", this.sd != null ? this.sd.sd_name : "shared", null);
        this.tn.task_set_start_complete();
        this.tn.waitForMasterGo();
    }

    public int getActiveCount() {
        return this.ios_currently_active;
    }

    private void saveCurrentTod(long l) {
        if (!Validate.isStoreTime()) {
            return;
        }
        this.saveLastTod(l, System.currentTimeMillis());
    }

    private void saveLastTod(long l, long l2) {
        if (this.rc == 0L) {
            this.key_map.saveTimestamp(l, l2);
        }
    }

    public static void main(String[] stringArray) {
    }
}

