/*
 * Decompiled with CFR 0.152.
 */
package Vdb;

import Utils.Fget;
import Utils.Fput;
import Utils.NfsV3;
import Utils.NfsV4;
import Utils.OS_cmd;
import Utils.Semaphore;
import Vdb.ConcatMarkers;
import Vdb.ConcatSds;
import Vdb.CpuStats;
import Vdb.Dedup;
import Vdb.Devxlate;
import Vdb.FwgEntry;
import Vdb.Host;
import Vdb.InstancePointer;
import Vdb.Kstat_cpu;
import Vdb.Kstat_data;
import Vdb.LunInfoFromHost;
import Vdb.MiscParms;
import Vdb.Mount;
import Vdb.Native;
import Vdb.NfsStats;
import Vdb.RD_entry;
import Vdb.ReplayDevice;
import Vdb.ReplayInfo;
import Vdb.ReplaySplit;
import Vdb.SD_entry;
import Vdb.Signal;
import Vdb.Slave;
import Vdb.SlaveJvm;
import Vdb.SocketMessage;
import Vdb.Status;
import Vdb.Validate;
import Vdb.Vdbmain;
import Vdb.WG_entry;
import Vdb.Work;
import Vdb.common;
import java.io.File;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Vector;

public class InfoFromHost
implements Serializable {
    private static final String c = "Copyright (c) 2000, 2016, Oracle and/or its affiliates. All rights reserved.";
    public String host_label;
    public ArrayList<LunInfoFromHost> luns_on_host = new ArrayList(8);
    private Vector instance_pointers;
    private boolean windows_host = false;
    private boolean solaris_host = false;
    private boolean linux_host = false;
    private boolean aix_host = false;
    private boolean hp_host = false;
    private boolean mac_host = false;
    private Dedup dedup_options = null;
    private ReplayInfo replay_info = null;
    private Kstat_cpu kstat_cpu = null;
    private boolean error_with_kstat = false;
    private NfsV3 nfs3_delta = null;
    private NfsV4 nfs4_delta = null;
    private boolean fwd_workload;
    private boolean create_anchors;
    public boolean validate = false;
    public Mount host_mount = null;
    private static Semaphore wait_for_host_info;
    private static HashMap<String, HashMap<String, LunInfoFromHost>> hosts_with_work;
    private static Vector<LunInfoFromHost> all_returned_luns;
    private static Vector all_returned_hosts;
    private static boolean any_kstat_errors;
    private static boolean configuration_loaded;
    private static HashMap sd_formats_done;
    public static String NO_DISMOUNT_FILE;

    public InfoFromHost(String string) {
        this.host_label = string;
    }

    public static void askHostsForStuff() {
        Object object;
        Object object2;
        Object object3;
        int n;
        Object[] objectArray;
        Status.printStatus("Query host configuration started", new Object[0]);
        hosts_with_work = new HashMap(4);
        Object var0 = null;
        HashMap<String, LunInfoFromHost> hashMap = null;
        all_returned_luns = new Vector(16, 0);
        all_returned_hosts = new Vector(16, 0);
        wait_for_host_info = new Semaphore(0L);
        RD_entry.next_rd = null;
        while ((objectArray = RD_entry.getNextWorkload()) != null) {
            for (n = 0; Vdbmain.isWdWorkload() && n < objectArray.wgs_for_rd.size(); ++n) {
                object3 = objectArray.wgs_for_rd.get(n);
                object2 = ((WG_entry)object3).getSlave().getHost().getLabel();
                hashMap = hosts_with_work.get(object2);
                if (hashMap == null) {
                    hosts_with_work.put((String)object2, new HashMap(4));
                }
                hashMap = hosts_with_work.get(object2);
                object = ((WG_entry)object3).getRealSds();
                for (Serializable serializable : object) {
                    String string = ((WG_entry)object3).getSlave().getHost().getLunNameForSd((SD_entry)serializable);
                    InfoFromHost.createLunInfoFromHost(hashMap, ((WG_entry)object3).getSlave().getHost(), string, ((SD_entry)serializable).isOpenForWrite(), ((SD_entry)serializable).end_lba);
                }
            }
            if (Validate.sdConcatenation()) {
                ConcatMarkers.checkLunCounts(hosts_with_work);
            }
            for (n = 0; Vdbmain.isFwdWorkload() && n < objectArray.fwgs_for_rd.size(); ++n) {
                object3 = objectArray.fwgs_for_rd.elementAt(n);
                if (((FwgEntry)object3).host_name.equals("*")) {
                    common.plog("fwg.host_name: " + ((FwgEntry)object3).host_name + " " + ((FwgEntry)object3).fsd_name + " " + ((FwgEntry)object3).getName() + " " + RD_entry.next_rd.rd_name);
                }
                if ((hashMap = hosts_with_work.get(((FwgEntry)object3).host_name)) == null) {
                    hosts_with_work.put(((FwgEntry)object3).host_name, new HashMap(4));
                }
                hashMap = hosts_with_work.get(((FwgEntry)object3).host_name);
                object2 = new LunInfoFromHost();
                ((LunInfoFromHost)object2).lun = ((FwgEntry)object3).anchor.getAnchorName();
                ((LunInfoFromHost)object2).lun = Work.unix2Windows(Host.findHost(((FwgEntry)object3).host_name), ((LunInfoFromHost)object2).lun);
                hashMap.put(((LunInfoFromHost)object2).lun, (LunInfoFromHost)object2);
            }
        }
        objectArray = hosts_with_work.keySet().toArray(new String[0]);
        Arrays.sort(objectArray);
        for (n = 0; n < objectArray.length; ++n) {
            Serializable serializable;
            object3 = objectArray[n];
            object2 = new InfoFromHost((String)object3);
            ((InfoFromHost)object2).validate = Validate.isValidate();
            ((InfoFromHost)object2).host_mount = Host.findHost((String)object3).host_mount;
            object = hosts_with_work.get(object3);
            Serializable[] serializableArray = ((HashMap)object).values().toArray(new LunInfoFromHost[0]);
            for (int i = 0; i < serializableArray.length; ++i) {
                serializable = serializableArray[i];
                ((InfoFromHost)object2).luns_on_host.add((LunInfoFromHost)serializable);
                if (Validate.sdConcatenation()) {
                    common.plog("ConcatMarkers: Requesting LunInfoFromHost from host=%s,lun=%s", ((InfoFromHost)object2).host_label, ((LunInfoFromHost)serializable).lun);
                }
                if (n != 0 || i != 0) continue;
                ((InfoFromHost)object2).replay_info = ReplayInfo.getInfo();
            }
            Host.findHost((String)object3).setHostInfo((InfoFromHost)object2);
            ((InfoFromHost)object2).fwd_workload = Vdbmain.isFwdWorkload();
            ((InfoFromHost)object2).create_anchors = MiscParms.create_anchors;
            Slave slave = Host.findHost((String)object3).getFirstSlave();
            serializable = new SocketMessage(SocketMessage.GET_LUN_INFO_FROM_SLAVE);
            ((SocketMessage)serializable).setData(object2);
            slave.getSocket().putMessage((SocketMessage)serializable);
        }
        for (n = 99990; n < Host.getDefinedHosts().size(); ++n) {
            object3 = Host.getDefinedHosts().elementAt(n);
            if (((Host)object3).getHostInfo() != null) continue;
            common.failure("Host=" + ((Host)object3).getLabel() + " is defined but not used. Please remove.");
        }
        if (objectArray.length > 0) {
            InfoFromHost.waitForAllHosts();
        }
        Status.printStatus("Query host configuration completed", new Object[0]);
    }

    private static void createLunInfoFromHost(HashMap<String, LunInfoFromHost> hashMap, Host host, String string, boolean bl, long l) {
        LunInfoFromHost lunInfoFromHost = hashMap.get(string);
        if (lunInfoFromHost == null) {
            lunInfoFromHost = new LunInfoFromHost();
            lunInfoFromHost.lun = Work.unix2Windows(host, string);
            lunInfoFromHost.original_lun = string;
            lunInfoFromHost.host_name = host.getLabel();
            lunInfoFromHost.marker_needed = Validate.sdConcatenation();
            lunInfoFromHost.end_lba = l;
            hashMap.put(string, lunInfoFromHost);
            if (lunInfoFromHost.lun == null) {
                common.failure("'null' LunInfoFromHost.lun");
            }
        }
        if (!lunInfoFromHost.open_for_write && bl) {
            lunInfoFromHost.open_for_write = true;
        }
    }

    private static void waitForAllHosts() {
        Signal signal = new Signal(30);
        try {
            while (!wait_for_host_info.attempt(1000L)) {
                if (!signal.go()) continue;
                String[] stringArray = hosts_with_work.keySet().toArray(new String[0]);
                for (int i = 0; i < stringArray.length; ++i) {
                    common.ptod("Waiting for configuration information from slave: " + stringArray[i]);
                }
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public static void getInfoForMaster(InfoFromHost infoFromHost) {
        long l = System.currentTimeMillis();
        Vector<Devxlate> vector = new Vector<Devxlate>(8, 0);
        infoFromHost.windows_host = common.onWindows();
        infoFromHost.solaris_host = common.onSolaris();
        infoFromHost.linux_host = common.onLinux();
        infoFromHost.aix_host = common.onAix();
        infoFromHost.hp_host = common.onHp();
        infoFromHost.mac_host = common.onMac();
        if (!(infoFromHost.windows_host || infoFromHost.solaris_host || infoFromHost.linux_host || infoFromHost.aix_host || infoFromHost.mac_host || infoFromHost.hp_host)) {
            common.ptod("Vdbench is supported on Windows, Solaris, Linux, AIX, OSX, and HP/UX");
            common.failure("Vdbench is running on an unknown platform: " + System.getProperty("os.name"));
        }
        if ((infoFromHost.windows_host || infoFromHost.solaris_host || infoFromHost.linux_host) && CpuStats.getNativeCpuStats() != null) {
            infoFromHost.kstat_cpu = CpuStats.getDelta();
        }
        InfoFromHost.checkAutoMount(infoFromHost);
        SlaveJvm.setMount(infoFromHost.host_mount);
        if (infoFromHost.host_mount != null) {
            infoFromHost.host_mount.initialHostMount();
        }
        if (common.onSolaris() && !common.get_debug(common.NO_KSTAT)) {
            Native.openKstat();
        }
        Signal signal = new Signal(30);
        long l2 = System.currentTimeMillis();
        for (int i = 0; i < infoFromHost.luns_on_host.size(); ++i) {
            long l3;
            LunInfoFromHost lunInfoFromHost = infoFromHost.luns_on_host.get(i);
            if (!common.onWindows() && lunInfoFromHost.lun.indexOf("\\") != -1) {
                common.failure("lun=" + lunInfoFromHost.lun + "; Lun requested on a non-windows " + "system contains a backslash. Are you sure you wanted to " + " send this to a non-windows system? Please correct");
            }
            if (lunInfoFromHost.lun.toLowerCase().startsWith("\\\\.\\") || lunInfoFromHost.lun.startsWith("/dev/")) {
                lunInfoFromHost.getRawInfo();
            } else {
                infoFromHost.maybeCreateDirectory(lunInfoFromHost.lun);
                lunInfoFromHost.getFileInfo();
            }
            if (lunInfoFromHost.marker_needed) {
                ConcatMarkers.readMarker(lunInfoFromHost);
            }
            if (common.onSolaris() && !common.get_debug(common.NO_KSTAT)) {
                NfsStats.getAllNfsDeltasFromKstat();
                infoFromHost.setNfsData(NfsStats.getNfs3(), NfsStats.getNfs4());
                if (lunInfoFromHost.sd_instance != null) {
                    Devxlate devxlate = new Devxlate(lunInfoFromHost.lun);
                    devxlate.instance = lunInfoFromHost.sd_instance;
                    devxlate.kstat_pointer = Native.getKstatPointer(devxlate.instance);
                    vector.add(devxlate);
                    continue;
                }
                if (!configuration_loaded) {
                    Devxlate.getDeviceLookupData();
                    configuration_loaded = true;
                }
                Vector vector2 = infoFromHost.fwd_workload ? Devxlate.get_device_info(lunInfoFromHost.lun + "/tmp") : Devxlate.get_device_info(Kstat_data.translateSoftLink(lunInfoFromHost.lun));
                for (int j = 0; j < vector2.size(); ++j) {
                    Object e = vector2.elementAt(j);
                    if (e instanceof String) {
                        lunInfoFromHost.kstat_error_messages.add(e);
                        continue;
                    }
                    if (e == null) {
                        lunInfoFromHost.kstat_error_messages.add("null entry found in devxlate_list");
                        continue;
                    }
                    Devxlate devxlate = (Devxlate)e;
                    devxlate.kstat_pointer = Native.getKstatPointer(devxlate.instance);
                    vector.add(devxlate);
                }
            }
            if (!signal.go() || (l3 = (System.currentTimeMillis() - l2) / 1000L) <= 5L) continue;
            SlaveJvm.sendMessageToConsole("It has taken %d seconds to get the size of %d SDs/FSDs", l3, i + 1);
        }
        ReplayInfo.setInfo(infoFromHost.replay_info);
        if (ReplayInfo.getInfo() != null && ReplayInfo.isReplay()) {
            ReplaySplit.readAndSplitTraceFile();
            infoFromHost.replay_info = ReplayInfo.getInfo();
        }
        infoFromHost.error_with_kstat = SlaveJvm.getKstatError();
        infoFromHost.instance_pointers = InstancePointer.createInstancePointers(vector);
        SlaveJvm.sendMessageToMaster(SocketMessage.GET_LUN_INFO_FROM_SLAVE, infoFromHost);
        double d = (double)(System.currentTimeMillis() - l) / 1000.0;
        common.ptod("Configuration interpretation took %.2f seconds", d);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void receiveInfoFromHost() {
        Vector<LunInfoFromHost> vector = all_returned_luns;
        synchronized (vector) {
            if (hosts_with_work.get(this.host_label) == null) {
                common.failure("Receiving info from unknown host: " + this.host_label);
            }
            hosts_with_work.remove(this.host_label);
            all_returned_luns.addAll(this.luns_on_host);
            all_returned_hosts.add(this);
            if (this.error_with_kstat) {
                any_kstat_errors = true;
                common.ptod("Host=" + this.host_label + ": Unable to find proper Kstat information for one or more luns or files");
                common.ptod("Please look at the logfile of host=" + this.host_label + " for more information");
            }
            if (this.solaris_host || this.linux_host) {
                Host.findHost(this.host_label).createAdmMessagesFile();
            }
            this.possibleReplayInfo();
            if (hosts_with_work.isEmpty()) {
                InfoFromHost.checkDevxlateEntries();
                InfoFromHost.checkForKstatErrors();
                InfoFromHost.matchDataWithSds();
                InfoFromHost.storeAndCompare();
                if (Validate.sdConcatenation()) {
                    ConcatMarkers.verifyMarkerResults(all_returned_hosts);
                }
                ConcatSds.calculateSize();
                wait_for_host_info.release();
            }
        }
    }

    private static void checkForKstatErrors() {
        for (int i = 0; i < Host.getDefinedHosts().size(); ++i) {
            Host host = Host.getDefinedHosts().elementAt(i);
            InfoFromHost infoFromHost = host.getHostInfo();
            for (int j = 0; infoFromHost != null && j < infoFromHost.luns_on_host.size(); ++j) {
                LunInfoFromHost lunInfoFromHost = infoFromHost.luns_on_host.get(j);
                if (lunInfoFromHost.kstat_error_messages.size() == 0 || !Vdbmain.kstat_console) continue;
                Vdbmain.kstat_console = false;
                common.ptod("");
                common.ptod("There were probems collecting Kstat information on at least one host (host=" + lunInfoFromHost.host_name + ").");
                common.ptod("Execution option '-k' has been deactivated");
                common.ptod("");
            }
        }
    }

    public static void checkCpuReporting() {
        int n;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        int n7 = 0;
        boolean bl = false;
        for (n = 0; n < all_returned_hosts.size(); ++n) {
            InfoFromHost infoFromHost = (InfoFromHost)all_returned_hosts.elementAt(n);
            if (infoFromHost.windows_host) {
                ++n2;
            }
            if (infoFromHost.solaris_host) {
                ++n4;
            }
            if (infoFromHost.linux_host) {
                ++n3;
            }
            if (infoFromHost.aix_host) {
                ++n5;
            }
            if (infoFromHost.hp_host) {
                ++n6;
            }
            if (infoFromHost.mac_host) {
                ++n7;
            }
            if (infoFromHost.windows_host && infoFromHost.kstat_cpu == null) {
                bl = true;
            }
            if (infoFromHost.solaris_host && infoFromHost.kstat_cpu == null) {
                bl = true;
            }
            if (infoFromHost.linux_host && infoFromHost.kstat_cpu == null) {
                bl = true;
            }
            if (!infoFromHost.mac_host || infoFromHost.kstat_cpu != null) continue;
            bl = true;
        }
        n = n2 + n3 + n4 + n5 + n6;
        if (n4 + n2 + n3 == n && !bl) {
            CpuStats.setCpuReporting();
        } else {
            common.ptod("Not every host is reporting Cpu statistics. Cpu reporting disabled");
        }
    }

    private static void checkDevxlateEntries() {
        for (int i = 0; i < all_returned_hosts.size(); ++i) {
            InfoFromHost infoFromHost = (InfoFromHost)all_returned_hosts.elementAt(i);
            Host.findHost(infoFromHost.host_label).setHostInfo(infoFromHost);
        }
    }

    private static void matchDataWithSds() {
        LunInfoFromHost lunInfoFromHost;
        int n;
        Host host;
        int n2;
        boolean bl = false;
        for (n2 = 0; n2 < Host.getDefinedHosts().size(); ++n2) {
            host = Host.getDefinedHosts().elementAt(n2);
            for (n = 0; n < all_returned_luns.size(); ++n) {
                lunInfoFromHost = all_returned_luns.elementAt(n);
                if (!host.getLabel().equals(lunInfoFromHost.host_name)) continue;
                String[] stringArray = host.getSdNamesForLun(lunInfoFromHost.original_lun);
                for (int i = 0; i < stringArray.length; ++i) {
                    SD_entry sD_entry = SD_entry.findSD(stringArray[i]);
                    sD_entry.host_info.add(lunInfoFromHost);
                    if (lunInfoFromHost.lun_exists) {
                        if (sD_entry.isOpenForWrite() && !lunInfoFromHost.write_allowed) {
                            bl = true;
                            common.ptod("sd=" + sD_entry.sd_name + ",host=" + lunInfoFromHost.host_name + ",lun=" + lunInfoFromHost.lun + " does not have write access.");
                        }
                        if (sD_entry.isOpenForWrite() || lunInfoFromHost.read_allowed) continue;
                        bl = true;
                        common.ptod("sd=" + sD_entry.sd_name + ",host=" + lunInfoFromHost.host_name + ",lun=" + lunInfoFromHost.lun + " does not have read access.");
                        continue;
                    }
                    if (!lunInfoFromHost.lun.toLowerCase().startsWith("\\\\.\\") && !lunInfoFromHost.lun.startsWith("/dev/")) continue;
                    bl = true;
                    common.ptod("Raw device 'sd=%s,lun=%s' does not exist, or no permissions.", sD_entry.sd_name, lunInfoFromHost.lun);
                }
            }
        }
        if (bl) {
            common.failure("Please check above failures");
        }
        if (Vdbmain.isFwdWorkload()) {
            for (n2 = 0; n2 < Host.getDefinedHosts().size(); ++n2) {
                host = Host.getDefinedHosts().elementAt(n2);
                for (n = 0; n < all_returned_luns.size(); ++n) {
                    lunInfoFromHost = all_returned_luns.elementAt(n);
                    if (lunInfoFromHost.lun_exists) continue;
                    common.failure("File system anchor does not exist on host=" + host.getLabel() + "; anchor=" + lunInfoFromHost.lun + " \n\tMaybe add 'create_anchors=yes' at the beginning of " + "your parameter file?");
                }
            }
        }
    }

    private void possibleReplayInfo() {
        ReplayInfo replayInfo = ReplayInfo.getInfo();
        if (this.replay_info == null) {
            return;
        }
        Vector<ReplayDevice> vector = this.replay_info.getDeviceList();
        for (int i = 0; i < vector.size(); ++i) {
            ReplayDevice replayDevice = vector.elementAt(i);
            ReplayDevice replayDevice2 = ReplayDevice.findDeviceAndCreate(replayDevice.getDeviceNumber());
            if (replayDevice2.getDuplicateNumber() != 0L) continue;
            replayDevice.copyTo(replayDevice2);
            InfoFromHost infoFromHost = this;
            if (!infoFromHost.replay_info.duplicationNeeded()) continue;
            for (long j = 1L; j <= (long)replayDevice2.duplicates_found; ++j) {
                long l = ReplayDevice.addDupToDevnum(replayDevice2.getDeviceNumber(), j);
                ReplayDevice replayDevice3 = ReplayDevice.findExistingDevice(l);
                replayDevice.copyTo(replayDevice3);
            }
        }
    }

    private static void storeAndCompare() {
        int n;
        for (int i = 9999990; i < Vdbmain.sd_list.size(); ++i) {
            SD_entry sD_entry = Vdbmain.sd_list.get(i);
            common.ptod("storeAndCompare sd: " + sD_entry.sd_name);
            for (n = 1; n < sD_entry.host_info.size(); ++n) {
                LunInfoFromHost lunInfoFromHost = (LunInfoFromHost)sD_entry.host_info.elementAt(n);
                common.ptod("storeAndCompare info2: " + lunInfoFromHost.host_name);
            }
        }
        long l = 0L;
        n = 0;
        for (int i = 0; i < Vdbmain.sd_list.size(); ++i) {
            SD_entry sD_entry = Vdbmain.sd_list.get(i);
            if (!sD_entry.sd_is_referenced || sD_entry.concatenated_sd) continue;
            LunInfoFromHost lunInfoFromHost = (LunInfoFromHost)sD_entry.host_info.get(0);
            for (int j = 1; j < sD_entry.host_info.size(); ++j) {
                LunInfoFromHost lunInfoFromHost2 = (LunInfoFromHost)sD_entry.host_info.get(j);
                if (lunInfoFromHost.lun_exists == lunInfoFromHost2.lun_exists && lunInfoFromHost.lun_size == lunInfoFromHost2.lun_size) continue;
                lunInfoFromHost.mismatch(sD_entry);
                lunInfoFromHost2.mismatch(sD_entry);
                common.failure("Lun status must be equal across hosts. ");
            }
            sD_entry.psize = lunInfoFromHost.lun_size;
            if (sD_entry.end_lba == 0L) {
                sD_entry.end_lba = sD_entry.psize;
            }
            if (sD_entry.end_lba == 0L) {
                common.ptod("");
                common.ptod("Undefined size for sd=" + sD_entry.sd_name + ",lun=" + lunInfoFromHost.lun);
                common.ptod("Either the lun or file does not exist, or you do not have permission to open the lun or file.");
                common.failure("No lun or file size available.");
            }
            if (sD_entry.psize != 0L && sD_entry.psize < sD_entry.end_lba) {
                common.ptod("");
                common.ptod("Warning: size requested for sd=" + sD_entry.sd_name + ",lun=" + sD_entry.lun + ": " + sD_entry.end_lba + "; size available: " + sD_entry.psize + ". Insufficient size.");
                if (Validate.sdConcatenation()) {
                    common.ptod("Insufficient size.");
                    common.failure("If this is a file: auto file creation or file expansion not supported when requesting 'concatenatesds=yes'");
                }
                if (!MiscParms.do_not_format_sds) {
                    common.ptod("If this is a file system file vdbench will try to expand it. ");
                    common.ptod("");
                }
            }
            common.plog("sd=%s,lun=%s lun size: %,d bytes; %,.4f GB (1024**3); %,.4f GB (1000**3)", sD_entry.sd_name, sD_entry.lun, sD_entry.psize, (double)sD_entry.psize / 1.073741824E9, (double)sD_entry.psize / 1.0E9);
            ++n;
            l += sD_entry.psize;
        }
        if (n > 1) {
            common.plog("");
            common.plog("Total SD size: %,d bytes; %,.4f GB (1024**3); %,.4f GB (1000**3)", l, (double)l / 1.073741824E9, (double)l / 1.0E9);
        }
    }

    public boolean isSolaris() {
        return this.solaris_host;
    }

    private static void runMountCommand(String string) {
        int n;
        if (common.onWindows()) {
            common.plog("Running on Windows. No 'mount' command available.");
            return;
        }
        OS_cmd oS_cmd = new OS_cmd();
        oS_cmd.addText(string);
        oS_cmd.execute();
        boolean bl = oS_cmd.getRC();
        String[] stringArray = oS_cmd.getStdout();
        String[] stringArray2 = oS_cmd.getStderr();
        common.plog("mount command output for " + string + ":");
        for (n = 0; n < stringArray.length; ++n) {
            common.plog("stdout: " + stringArray[n]);
        }
        for (n = 0; n < stringArray2.length; ++n) {
            common.plog("stderr: " + stringArray2[n]);
        }
        if (!bl) {
            SlaveJvm.sendMessageToConsole(string + " failed. Maybe mount was not needed?.");
            SlaveJvm.sendMessageToConsole("See host's stdout.html file for messages.");
        }
    }

    public Vector getInstancePointers() {
        return this.instance_pointers;
    }

    public static boolean anyKstatErrors() {
        return any_kstat_errors;
    }

    public ArrayList getLuns() {
        return this.luns_on_host;
    }

    public void setNfsData(NfsV3 nfsV3, NfsV4 nfsV4) {
        this.nfs3_delta = nfsV3;
        this.nfs4_delta = nfsV4;
    }

    public NfsV3 getNfs3() {
        return this.nfs3_delta;
    }

    public NfsV4 getNfs4() {
        return this.nfs4_delta;
    }

    private void maybeCreateDirectory(String string) {
        File file;
        if (this.fwd_workload && !(file = new File(string)).exists()) {
            if (this.create_anchors) {
                if (!file.mkdirs()) {
                    this.maybeSomeHost(string);
                    return;
                }
            } else if (!file.mkdir()) {
                this.maybeSomeHost(string);
                return;
            }
            SlaveJvm.sendMessageToConsole("Created anchor directory: " + string);
            file = null;
            System.gc();
            System.gc();
        }
    }

    private void maybeSomeHost(String string) {
        Signal signal = new Signal(10);
        while (!new File(string).exists()) {
            common.sleep_some_usecs(500L);
            if (!signal.go()) continue;
            common.failure("Unable to create anchor directory: " + string);
        }
    }

    private static void checkAutoMount(InfoFromHost infoFromHost) {
        for (int i = 0; i < infoFromHost.luns_on_host.size(); ++i) {
            LunInfoFromHost lunInfoFromHost = infoFromHost.luns_on_host.get(i);
            File file = new File(lunInfoFromHost.lun);
            file.isFile();
            if (!infoFromHost.fwd_workload || !Fget.dir_exists(lunInfoFromHost.lun) || Fget.file_exists(lunInfoFromHost.lun, NO_DISMOUNT_FILE)) continue;
            Fput fput = new Fput(lunInfoFromHost.lun, NO_DISMOUNT_FILE);
            fput.println("This file was created to keep anchor busy and prevent auto-dismount");
            fput.flush();
            Fput.chmod(lunInfoFromHost.lun + File.separator + NO_DISMOUNT_FILE);
        }
    }

    static {
        any_kstat_errors = false;
        configuration_loaded = false;
        sd_formats_done = new HashMap(8);
        NO_DISMOUNT_FILE = "no_dismount.txt";
    }
}

