/*
 * Decompiled with CFR 0.152.
 */
package Vdb;

import Vdb.SD_entry;
import Vdb.SdStats;
import Vdb.Validate;
import Vdb.WG_entry;
import Vdb.Work;
import Vdb.common;
import java.util.ArrayList;

public class JniIndex {
    private static final String c = "Copyright (c) 2000, 2014, Oracle and/or its affiliates. All rights reserved.";
    public int jni_index;
    public String sd_name;
    public String wd_name;
    public SdStats dlt_stats = new SdStats();
    public SdStats old_stats = new SdStats();

    public static void createIndexes(Work work) {
        int n;
        int n2 = 0;
        if (!Validate.sdConcatenation()) {
            for (n = 0; n < work.wgs_for_slave.size(); ++n) {
                WG_entry wG_entry = work.wgs_for_slave.get(n);
                wG_entry.jni_index_list = new ArrayList(1);
                JniIndex jniIndex = new JniIndex();
                jniIndex.jni_index = n2++;
                jniIndex.sd_name = wG_entry.sd_used.sd_name;
                jniIndex.wd_name = wG_entry.wd_name;
                wG_entry.jni_index_list.add(jniIndex);
            }
        } else {
            for (n = 0; n < work.wgs_for_slave.size(); ++n) {
                WG_entry wG_entry = work.wgs_for_slave.get(n);
                wG_entry.jni_index_list = new ArrayList(wG_entry.sds_in_concatenation.size());
                for (int i = 0; i < wG_entry.sds_in_concatenation.size(); ++i) {
                    SD_entry sD_entry = wG_entry.sds_in_concatenation.get(i);
                    JniIndex jniIndex = new JniIndex();
                    jniIndex.jni_index = n2++;
                    jniIndex.sd_name = sD_entry.sd_name;
                    jniIndex.wd_name = wG_entry.wd_name;
                    wG_entry.jni_index_list.add(jniIndex);
                }
            }
        }
        if (n2 >= (n = 10240)) {
            common.ptod("There is a hardcoded limit of %d statistics table elements.", n);
            common.ptod("One per SD per WD");
            common.failure("Maximum current jni_index value is %d, it currently is %d. Contact Henk", n, n2);
        }
    }
}

