/*
 * Decompiled with CFR 0.152.
 */
package Vdb;

import Vdb.DV_map;
import Vdb.Elapsed;
import Vdb.File_handles;
import Vdb.Jnl_entry;
import Vdb.Native;
import Vdb.common;
import java.util.ArrayList;

public class JournalThread
extends Thread {
    private static final String c = "Copyright (c) 2000, 2016, Oracle and/or its affiliates. All rights reserved.";
    private Jnl_entry jnl = null;
    private DV_map map = null;
    private long handle = 0L;
    private String fname = null;
    private long start_key_blk = 0L;
    private long key_blocks = 0L;
    private long key_blksize = 0L;
    private boolean restore = false;
    private long jnl_lba = 0L;
    private long bad_blocks = 0L;
    private long known_blocks = 0L;

    public JournalThread(Jnl_entry jnl_entry, DV_map dV_map, long l, long l2, long l3, long l4, boolean bl) {
        this.jnl = jnl_entry;
        this.map = dV_map;
        this.handle = l;
        this.fname = File_handles.getLastName(l);
        this.start_key_blk = l2;
        this.key_blocks = l3;
        this.key_blksize = l4;
        this.restore = bl;
        this.jnl_lba = 512L;
        this.jnl_lba += l2 / 480L * 512L;
        if (l4 != (long)dV_map.getKeyBlockSize()) {
            common.failure("mismatch in key block size: %d %d", l4, dV_map.getKeyBlockSize());
        }
    }

    @Override
    public void run() {
        try {
            if (this.restore) {
                this.restorePortionOfMap();
            } else {
                this.dumpPortionOfMap();
            }
        }
        catch (Throwable throwable) {
            common.abnormal_term(throwable);
        }
    }

    private void dumpPortionOfMap() {
        int n = 8;
        int n2 = n * 512;
        long l = Native.allocBuffer(n2);
        int[] nArray = new int[n * 512 / 4];
        Elapsed elapsed = new Elapsed("dumpPortionOfMap of " + this.fname, 250000L);
        long l2 = this.start_key_blk;
        while (l2 < this.start_key_blk + this.key_blocks) {
            int n3 = 0;
            int n4 = 0;
            for (int i = 0; i < n && l2 < this.start_key_blk + this.key_blocks; ++i) {
                nArray[n3 + 0] = Jnl_entry.MAP_EYE_CATCHER;
                nArray[n3 + 1] = Jnl_entry.MAP_EYE_CATCHER;
                n3 += Jnl_entry.MAP_SKIP_HDR;
                for (int j = Jnl_entry.MAP_SKIP_HDR; j < 128 && l2 < this.map.key_blocks; ++j) {
                    nArray[n3] = this.map.dv_get_nolock(l2++ * this.key_blksize) << 24 | this.map.dv_get_nolock(l2++ * this.key_blksize) << 16 | this.map.dv_get_nolock(l2++ * this.key_blksize) << 8 | this.map.dv_get_nolock(l2++ * this.key_blksize);
                    ++n3;
                }
                elapsed.track(480L);
                ++n4;
            }
            Native.arrayToBuffer(nArray, l);
            Jnl_entry.jnl_write(this.handle, this.jnl_lba, n4 * 512, l);
            this.jnl_lba += (long)(n4 * 512);
        }
        elapsed.end(5);
        Native.freeBuffer(n2, l);
    }

    private void restorePortionOfMap() {
        long l = Native.allocBuffer(512);
        int[] nArray = new int[128];
        Elapsed elapsed = new Elapsed("restorePortionOfMap of " + this.fname, 250000L);
        long l2 = this.start_key_blk;
        while (l2 < this.start_key_blk + this.key_blocks) {
            try {
                Jnl_entry.jnl_read(this.handle, this.jnl_lba, 512L, l, nArray, Jnl_entry.MAP_EYE_CATCHER);
                elapsed.track(480L);
            }
            catch (Exception exception) {
                common.ptod("Error while restoring the journal map. Journal likely is corrupted");
                common.ptod(exception);
                common.failure(exception);
            }
            if (nArray[0] != Jnl_entry.MAP_EYE_CATCHER) {
                common.failure("Missing eye catcher in journal file at lba 0x%08x", this.jnl_lba);
            }
            for (int i = Jnl_entry.MAP_SKIP_HDR; i < 128 && l2 < this.start_key_blk + this.key_blocks; ++i) {
                int n = nArray[i] >> 24 & 0xFF;
                int n2 = nArray[i] >> 16 & 0xFF;
                int n3 = nArray[i] >> 8 & 0xFF;
                int n4 = nArray[i] & 0xFF;
                this.storeKey(l2++, n);
                this.storeKey(l2++, n2);
                this.storeKey(l2++, n3);
                this.storeKey(l2++, n4);
            }
            this.jnl_lba += 512L;
        }
        Jnl_entry.plog("Data Validation map restored for %s. Map contains %,16d known blocks.", this.fname, this.known_blocks);
        if (this.bad_blocks > 0L) {
            Jnl_entry.plog(String.format("Key blocks found in journal that are in error: %d. They will NOT be re-verified.", this.bad_blocks), new Object[0]);
        }
        elapsed.end(5);
        Native.freeBuffer(512, l);
    }

    private void storeKey(long l, int n) {
        this.map.dv_set_nolock(l * this.key_blksize, n);
        if (n == 127) {
            ++this.bad_blocks;
            Jnl_entry.plog("Key block at 0x08%x is marked in error in journal", l * this.key_blksize);
        } else if (n != 0) {
            ++this.known_blocks;
        }
    }

    public static void waitForList(ArrayList<Thread> arrayList) {
        while (true) {
            int n = 0;
            for (Thread thread : arrayList) {
                if (!thread.isAlive()) continue;
                ++n;
            }
            if (n == 0) break;
            common.sleep_some(100L);
        }
    }
}

