/*
 * Decompiled with CFR 0.152.
 */
package Vdb;

import Utils.Format;
import Vdb.InstancePointer;
import Vdb.Report;
import Vdb.common;
import java.io.IOException;
import java.io.Serializable;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;

public class Kstat_data
implements Serializable {
    private static final String c = "Copyright (c) 2000, 2016, Oracle and/or its affiliates. All rights reserved.";
    long nread;
    long nwritten;
    long reads;
    long writes;
    long wlentime;
    long rtime;
    long rlentime;
    long totalio;
    long tod;
    long elapsed;
    int devices = 0;
    InstancePointer pointer = null;

    public void kstat_accum(Kstat_data kstat_data, boolean bl) {
        this.nread += kstat_data.nread;
        this.nwritten += kstat_data.nwritten;
        this.reads += kstat_data.reads;
        this.writes += kstat_data.writes;
        this.wlentime += kstat_data.wlentime;
        this.rtime += kstat_data.rtime;
        this.rlentime += kstat_data.rlentime;
        this.totalio += kstat_data.totalio;
        if (bl) {
            this.elapsed += kstat_data.elapsed;
            this.devices = kstat_data.devices;
        } else {
            ++this.devices;
            this.elapsed = kstat_data.elapsed;
        }
    }

    public double kstat_rate() {
        if (this.elapsed == 0L) {
            return 0.0;
        }
        return (double)this.totalio * 1000000.0 / (double)this.elapsed;
    }

    public double kstat_megabytes() {
        if (this.elapsed == 0L) {
            return 0.0;
        }
        return (double)(this.nread + this.nwritten) * 1000000.0 / (double)Report.MB / (double)this.elapsed;
    }

    public double kstat_readpct() {
        if (this.totalio == 0L) {
            return 0.0;
        }
        return (double)this.reads * 100.0 / (double)this.totalio;
    }

    public double kstat_wait() {
        if (this.elapsed == 0L || this.totalio == 0L) {
            return 0.0;
        }
        return this.kstat_ioswaiting() * 1000.0 / this.kstat_rate();
    }

    public double kstat_svctm() {
        if (this.elapsed == 0L || this.totalio == 0L) {
            return 0.0;
        }
        return this.kstat_iosrunning() * 1000.0 / this.kstat_rate();
    }

    public double kstat_busy() {
        if (this.elapsed == 0L) {
            return 0.0;
        }
        int n = this.devices == 0 ? 1 : this.devices;
        return (double)this.rtime * 100.0 / (double)this.elapsed / 1000.0 / (double)n;
    }

    public double kstat_ioswaiting() {
        if (this.elapsed == 0L) {
            return 0.0;
        }
        return (double)this.wlentime / (double)this.elapsed / 1000.0;
    }

    public double kstat_iosrunning() {
        if (this.elapsed == 0L) {
            return 0.0;
        }
        return (double)this.rlentime / (double)this.elapsed / 1000.0;
    }

    public double kstat_bytes() {
        if (this.totalio == 0L) {
            return 0.0;
        }
        return (double)(this.nread + this.nwritten) / (double)this.totalio;
    }

    public String toString() {
        String string = "";
        string = string + Format.f("nread: %4d ", this.nread);
        string = string + Format.f("nwritten: %4d ", this.nwritten);
        string = string + Format.f("reads: %4d ", this.reads);
        string = string + Format.f("writes: %4d ", this.writes);
        return string;
    }

    public static String translateSoftLink(String string) {
        try {
            Path path = FileSystems.getDefault().getPath(string, new String[0]);
            if (!Files.isSymbolicLink(path)) {
                return string;
            }
            String string2 = path.toRealPath(new LinkOption[0]).toString();
            if (common.onSolaris() && string2.startsWith("/devices/")) {
                return string;
            }
            return string2;
        }
        catch (IOException iOException) {
            common.ptod("Exception trying to get soft link name for '%s'. Ignored", string);
            common.ptod(iOException);
            return string;
        }
    }

    public static void main(String[] stringArray) {
        String string = stringArray[0];
        try {
            Path path = FileSystems.getDefault().getPath(string, new String[0]);
            if (!Files.isSymbolicLink(path)) {
                common.ptod("Not a symbolic link");
                return;
            }
            string = path.toRealPath(new LinkOption[0]).toString();
            common.ptod("rawname: " + string);
        }
        catch (IOException iOException) {
            common.ptod("Exception trying to get soft link name for '%s'. Ignored", string);
            common.ptod(iOException);
            return;
        }
    }
}

