/*
 * Decompiled with CFR 0.152.
 */
package Vdb;

import Utils.Fput;
import Utils.Getopt;
import Utils.OS_cmd;
import Vdb.DirData;
import Vdb.FileAnchor;
import Vdb.LsData;
import Vdb.common;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;

public class LS {
    private static final String c = "Copyright (c) 2000, 2016, Oracle and/or its affiliates. All rights reserved.";
    private static int loop_protector = 0;
    private static ArrayList detail_data = new ArrayList(32768);
    private static long size_added = 0L;
    private static LsData[] data = null;
    protected static boolean reuse = false;
    protected static boolean sort_size = false;
    protected static boolean limit_output = false;
    private static boolean no_recursive = false;
    protected static int limit_lines = Integer.MAX_VALUE;
    private static int dir_count = 0;
    private static boolean depth = false;
    private static int how_deep = 0;
    protected static long minimum_report = 0L;
    private static long start = System.currentTimeMillis();

    public static void main(String[] stringArray) throws Exception {
        Getopt getopt = new Getopt(stringArray, "rnsl:d:m:", 1);
        getopt.print("ls");
        if (!getopt.isOK()) {
            getopt.print("ls");
            common.ptod("");
            common.ptod("Usage: lll [-n] [-s] [-l nn] [-d nn] [-m nn] directory");
            common.ptod("-n:    No looking at sub directories");
            common.ptod("-s:    Sort output descending by file size");
            common.ptod("-r:    Reuse directory information saved earlier");
            common.ptod("-m nn: Minimum reporting. Skip output < nn bytes (k/m/g/t)");
            common.ptod("-l nn: Line count: report on the first 'nn' lines");
            common.ptod("-d nn: Depth. This reports totals_report of 'nn' directories deep");
            common.ptod("");
            common.failure("Parameter scan error");
        }
        String string = ".";
        if (getopt.get_positionals().size() != 0) {
            string = getopt.get_positional();
        }
        if (string.endsWith(File.separator)) {
            string = string.substring(0, string.lastIndexOf(File.separator));
        }
        reuse = getopt.check('r');
        no_recursive = getopt.check('n');
        sort_size = getopt.check('s');
        if (getopt.check('l')) {
            limit_lines = (int)getopt.get_long();
        }
        if (depth = getopt.check('d')) {
            how_deep = (int)getopt.get_long();
        }
        if (getopt.check('m')) {
            minimum_report = common.parseSize(getopt.get_string());
        }
        if (sort_size && limit_lines == Integer.MAX_VALUE) {
            limit_lines = 20;
        }
        if (!reuse) {
            System.err.print("One '.' per directory scanned: ");
        }
        LS.readDirectories(string);
        data = detail_data.toArray(new LsData[0]);
        Arrays.sort(data);
        for (int i = 0; depth && i < data.length; ++i) {
            DirData.addFile(data[i], how_deep);
        }
        long l = 0L;
        long l2 = 0L;
        for (int i = 0; i < data.length; ++i) {
            l += LS.data[i].ls_size;
            ++l2;
        }
        if (!reuse) {
            System.out.println(String.format("Total file size: %,d (%s); Directories: %d; Files: %d", l, LS.xlateSize(l), dir_count, l2));
        }
        if (!depth) {
            LS.printDetail();
        } else {
            DirData.printDirectories();
        }
    }

    private static void readDirectories(String string) {
        if (reuse) {
            detail_data = (ArrayList)common.serial_in(Fput.getTmpDir() + "vdbench_ls.tmp");
            return;
        }
        long l = System.currentTimeMillis();
        LS.recursive(string);
        long l2 = System.currentTimeMillis();
        if (l2 - l > 10000L) {
            System.err.println("\n" + dir_count + " directories in " + (l2 - l) / 1000L + " seconds.");
        } else {
            System.err.println();
        }
        if (!reuse) {
            common.serial_out(Fput.getTmpDir() + "vdbench_ls.tmp", detail_data);
        }
    }

    private static void recursive(String string) {
        if (string.contains("///")) {
            common.ptod("Some kind of recursive error is going on: " + string);
            return;
        }
        String string2 = null;
        try {
            if (dir_count++ % 100 == 0) {
                System.err.println("\n\nScanning: " + string);
            }
            ++loop_protector;
            if (dir_count % 25 == 0) {
                long l;
                long l2 = (System.currentTimeMillis() - start) / 1000L;
                long l3 = l = l2 > 0L ? (long)dir_count / l2 : 0L;
                if (dir_count % 100 == 0) {
                    System.err.print(String.format("(%d) (%d/%s) (%d secs) (%d dirs/sec)", dir_count, detail_data.size(), FileAnchor.whatSize(size_added), l2, l));
                } else {
                    System.err.print(String.format("(%4d)", dir_count));
                }
            } else if (dir_count % 2 == 0) {
                System.err.print(".");
            }
            if (loop_protector > 20) {
                common.failure("Is there a loop here? " + string);
            }
            OS_cmd oS_cmd = new OS_cmd();
            if (common.onWindows()) {
                oS_cmd.addText("ls -ln");
            } else if (common.onLinux()) {
                oS_cmd.addText("ls -l");
            } else {
                oS_cmd.addText("/usr/bin/ls -l");
            }
            oS_cmd.addQuot(string);
            oS_cmd.execute(false);
            String[] stringArray = oS_cmd.getStdout();
            for (int i = 0; i < stringArray.length; ++i) {
                string2 = stringArray[i].trim();
                String[] stringArray2 = string2.trim().split(" +");
                if (string2.startsWith("total") || string2.endsWith(":")) continue;
                String string3 = "";
                for (int j = 0; j < stringArray2.length && j < 8; ++j) {
                    string3 = string3 + stringArray2[j] + " ";
                }
                string3 = string3.trim();
                String string4 = "";
                for (int j = 8; j < stringArray2.length; ++j) {
                    string4 = string4 + stringArray2[j] + " ";
                }
                string4 = string4.trim();
                if (string2.startsWith("d") && !no_recursive) {
                    LS.recursive(string + File.separator + string4);
                    continue;
                }
                if (string2.startsWith("l")) {
                    System.err.println("\nlink: " + string + " " + string4);
                    continue;
                }
                if (string2.startsWith("c")) continue;
                LsData lsData = new LsData(string3, string, string4, string2);
                detail_data.add(lsData);
                size_added += lsData.ls_size;
            }
            --loop_protector;
        }
        catch (Exception exception) {
            System.err.println();
            System.err.println("line: " + string2);
            common.failure(exception);
        }
    }

    private static void printDetail() {
        for (int i = 0; i < data.length; ++i) {
            if (--limit_lines <= 0 || LS.data[i].ls_size < minimum_report) continue;
            System.out.println(data[i].getDetail());
        }
    }

    public static String xlateSize(long l) {
        long l2 = 1024L;
        long l3 = 0x100000L;
        long l4 = 0x40000000L;
        String string = l < l2 * 10L ? String.format("%,d", l) : (l < l3 * 10L ? String.format("%,dk", l / l2) : (l < l4 * 10L ? String.format("%,dm", l / l3) : String.format("%,dg", l / l4)));
        return string;
    }
}

