/*
 * Decompiled with CFR 0.152.
 */
package Vdb;

import Utils.ClassPath;
import Utils.Fget;
import Utils.OS_cmd;
import Vdb.Kstat_cpu;
import Vdb.Kstat_data;
import Vdb.Native;
import Vdb.common;

public class Linux {
    private static final String c = "Copyright (c) 2000, 2016, Oracle and/or its affiliates. All rights reserved.";
    private static long ticks_per_second;
    private static boolean first_time;

    public static Kstat_cpu getCpuStats() {
        if (first_time) {
            first_time = false;
            boolean bl = common.onZLinux() ? Linux.getTickCount390() : Linux.getTickCount();
            if (!bl) {
                return null;
            }
        }
        Kstat_cpu kstat_cpu = new Kstat_cpu();
        try {
            String[] stringArray = Fget.readFileToArray("/proc/stat");
            if (stringArray.length < 1) {
                Linux.disable("No data found in /proc/stat. Linux data collection disabled");
                return null;
            }
            int n = -1;
            for (int i = 0; i < stringArray.length; ++i) {
                if (!stringArray[i].startsWith("cpu")) continue;
                ++n;
            }
            String[] stringArray2 = stringArray[0].split(" +");
            kstat_cpu.cpu_user = Long.parseLong(stringArray2[1]) * 100L * ticks_per_second / (long)n;
            kstat_cpu.cpu_kernel = Long.parseLong(stringArray2[3]) * 100L * ticks_per_second / (long)n;
            kstat_cpu.cpu_kernel += Long.parseLong(stringArray2[6]) * 100L * ticks_per_second / (long)n;
            kstat_cpu.cpu_kernel += Long.parseLong(stringArray2[7]) * 100L * ticks_per_second / (long)n;
            kstat_cpu.cpu_total = kstat_cpu.cpu_user + kstat_cpu.cpu_kernel;
            kstat_cpu.cpu_total += Long.parseLong(stringArray2[2]) * 100L * ticks_per_second / (long)n;
            kstat_cpu.cpu_total += Long.parseLong(stringArray2[4]) * 100L * ticks_per_second / (long)n;
            kstat_cpu.cpu_total += Long.parseLong(stringArray2[5]) * 100L * ticks_per_second / (long)n;
            kstat_cpu.cpu_total += Long.parseLong(stringArray2[7]) * 100L * ticks_per_second / (long)n;
        }
        catch (Exception exception) {
            Linux.disable("Unexpected exception parsing Linux Cpu statistics. Collection disabled");
            common.ptod(exception);
        }
        return kstat_cpu;
    }

    private static boolean getTickCount() {
        String string = System.getProperty("os.arch");
        if (string.equals("ppc64") || string.equals("ppc64")) {
            ticks_per_second = 100L;
            common.ptod("getTickCount(): set to 100 for PPC");
            return true;
        }
        ticks_per_second = Native.getTickCount();
        if (ticks_per_second <= 0L) {
            common.ptod("Error retrieving tick count: %d. Setting to 100", ticks_per_second);
            ticks_per_second = 100L;
            return true;
        }
        common.plog("ticks_per_second: " + ticks_per_second);
        return true;
    }

    private static boolean getTickCount390() {
        String string = System.getProperty("os.arch");
        OS_cmd oS_cmd = new OS_cmd();
        if (string.equals("s390")) {
            oS_cmd.addText(ClassPath.classPath("linux/linux_clock_390_32"));
        } else if (string.equals("s390x")) {
            oS_cmd.addText(ClassPath.classPath("linux/linux_clock_390_64"));
        } else {
            common.failure("Invalid S390 architecture: " + string);
        }
        oS_cmd.setStdout();
        oS_cmd.setStderr();
        oS_cmd.execute();
        String[] stringArray = oS_cmd.getStdout();
        String[] stringArray2 = oS_cmd.getStderr();
        if (stringArray.length != 1) {
            int n;
            for (n = 0; n < stringArray.length; ++n) {
                common.ptod("linux_clock stdout: " + stringArray[0]);
            }
            for (n = 0; n < stringArray2.length; ++n) {
                common.ptod("linux_clock stderr: " + stringArray2[0]);
            }
            Linux.disable("Unexpected return values from 'linux_clock'; Linux processing disabled");
            return false;
        }
        String[] stringArray3 = stringArray[0].split(" +");
        if (stringArray3.length != 2) {
            Linux.disable("Unexpected return values from 'linux_clock'; Linux processing disabled");
            return false;
        }
        ticks_per_second = Long.parseLong(stringArray3[1]);
        common.plog("ticks_per_second: " + ticks_per_second);
        return true;
    }

    private static void disable(String string) {
        common.ptod("");
        common.ptod(string);
        common.ptod("");
        String[] stringArray = Fget.readFileToArray("/proc/stat");
        common.plog("/proc/stat:");
        for (int i = 0; i < stringArray.length; ++i) {
            common.plog(stringArray[i]);
        }
    }

    public static long getLinuxSize(String string) {
        String string2 = string;
        String string3 = null;
        try {
            string2 = Kstat_data.translateSoftLink(string2);
            String[] stringArray = Fget.readFileToArray("/proc/partitions");
            for (int i = 0; i < stringArray.length; ++i) {
                String[] stringArray2;
                string3 = stringArray[i].trim();
                if (string3.length() == 0 || string3.startsWith("major") || (stringArray2 = string3.split(" +")).length != 4 || !("/dev/" + stringArray2[3]).equalsIgnoreCase(string2)) continue;
                long l = Long.parseLong(stringArray2[2]);
                return l * 1024L;
            }
        }
        catch (Exception exception) {
            common.ptod("Unexpected Exception while looking for Linux raw lun size.");
            common.ptod("line: " + string3);
            common.ptod("Returning raw lun size of zero.");
            common.ptod(exception);
        }
        common.ptod("Unable to find lun size for %s (%s): ", string, string2);
        return 0L;
    }

    public static void main(String[] stringArray) {
        long l = Linux.getLinuxSize(stringArray[0]);
        common.ptod("size: %,12d bytes", l);
        common.ptod("size: %.3fg %.3fg", (double)l / 1.0E9, (double)l / 1.073741824E9);
    }

    static {
        first_time = true;
    }
}

