/*
 * Decompiled with CFR 0.152.
 */
package Vdb;

import Utils.Fget;
import Utils.Fput;
import Utils.OS_cmd;
import Vdb.Dedup;
import Vdb.Elapsed;
import Vdb.ErrorLog;
import Vdb.FileAnchor;
import Vdb.Jnl_entry;
import Vdb.MapCounts;
import Vdb.common;
import java.io.File;
import java.io.RandomAccessFile;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.util.HashMap;

public class MapFile
extends Thread {
    private static final String c = "Copyright (c) 2000, 2016, Oracle and/or its affiliates. All rights reserved.";
    private String filename;
    private int bytes_in_map;
    private MappedByteBuffer bbuffer;
    private FileChannel channel;
    public MapCounts counter = null;
    private static HashMap file_map = new HashMap(16);
    public static final long MAX_BYTES = 0x40000000L;
    public static final int BYTE_SHIFT = 30;
    public static final long BYTE_AND = 0x3FFFFFFFL;

    public static MapFile[] createNewFile(String string, String string2, long l) {
        if (Dedup.isDedup()) {
            ++l;
        }
        long l2 = (l + 0x40000000L - 1L) / 0x40000000L;
        MapFile[] mapFileArray = new MapFile[(int)l2];
        for (int i = 0; i < mapFileArray.length; ++i) {
            File file;
            String string3 = MapFile.createMapFileName(string, string2, i);
            if (file_map.get(string3) != null) {
                common.failure("Map file still open: " + string3);
            }
            if ((file = new File(string3)).exists() && !file.delete()) {
                ErrorLog.plog("Unable to delete old map file: " + string3, new Object[0]);
                common.failure("Unable to delete old map file: " + string3);
            }
            int n = (int)Math.min(l - (long)i * 0x40000000L, 0x40000000L);
            MapFile mapFile = mapFileArray[i] = new MapFile();
            try {
                mapFile.filename = string3;
                mapFile.bytes_in_map = n;
                mapFile.channel = new RandomAccessFile(mapFile.filename, "rw").getChannel();
                mapFile.bbuffer = mapFile.channel.map(FileChannel.MapMode.READ_WRITE, 0L, mapFile.bytes_in_map);
                file_map.put(mapFile.filename, mapFile);
            }
            catch (Exception exception) {
                common.failure(exception);
            }
            for (int j = 0; j < mapFile.bytes_in_map; ++j) {
                mapFile.bbuffer.put((byte)0);
            }
            ErrorLog.plog("Created new mmap file: %s mmap size: %s", mapFile.filename, FileAnchor.whatSize(mapFile.bytes_in_map));
        }
        return mapFileArray;
    }

    public static MapFile[] openOldFile(String string, String string2, long l) {
        int n = (int)(l + 0x40000000L - 1L);
        MapFile[] mapFileArray = new MapFile[n];
        for (int i = 0; i < n; ++i) {
            String string3 = MapFile.createMapFileName(string, string2, i);
            int n2 = (int)Math.min(l - (long)i * 0x40000000L, 0x40000000L);
            File file = new File(string3);
            if (!file.exists()) {
                common.failure("Opening of old map file failed: " + string3);
            }
            if (file.length() != (long)n2) {
                common.failure("Map file size mismatch: %s current size: %d requested size: %d", string3, file.length(), n2);
            }
            if (file_map.get(string3) != null) {
                common.failure("Map file still open: " + string3);
            }
            MapFile mapFile = new MapFile();
            try {
                mapFile.filename = string3;
                mapFile.bytes_in_map = n2;
                mapFile.bbuffer = new RandomAccessFile(mapFile.filename, "rw").getChannel().map(FileChannel.MapMode.READ_WRITE, 0L, mapFile.bytes_in_map);
                file_map.put(mapFile.filename, mapFile);
            }
            catch (Exception exception) {
                common.failure(exception);
            }
            ErrorLog.plog("Reusing mmap file: %s mmap size: %s", mapFile.filename, FileAnchor.whatSize(mapFile.bytes_in_map));
        }
        return mapFileArray;
    }

    public void put(int n, int n2) {
        this.bbuffer.put(n, (byte)n2);
    }

    public int get(int n) {
        int n2 = this.bbuffer.get(n) & 0xFF;
        return n2;
    }

    public long get8(int n) {
        try {
            long l = this.bbuffer.getLong(n);
            return l;
        }
        catch (Exception exception) {
            common.ptod("index: " + n);
            common.failure(exception);
            return -1L;
        }
    }

    public void closeMapFile() {
        try {
            this.bbuffer.force();
            this.channel.close();
            file_map.remove(this.filename);
        }
        catch (Exception exception) {
            common.failure(exception);
        }
    }

    public String getFilename() {
        return this.filename;
    }

    public int getBytesInMap() {
        return this.bytes_in_map;
    }

    private static String createMapFileName(String string, String string2, int n) {
        if (string != null && !Jnl_entry.isRawJournal(string)) {
            return String.format("%svdbench.%s.mmap.%d", Fget.separator(string), string2, n);
        }
        String string3 = common.getProcessIdString();
        return String.format("%svdbench.pid%s.%s.mmap.%d", Fput.getTmpDir(), string3, string2, n);
    }

    public static void cleanupOrphanMapFiles() {
        HashMap<String, String> hashMap = new HashMap<String, String>(32);
        try {
            String[] stringArray;
            String[] stringArray2;
            Object object;
            if (common.onWindows()) {
                object = OS_cmd.execute("tasklist /nh", false);
                for (String string : stringArray2 = ((OS_cmd)object).getStdout()) {
                    if (string.trim().length() == 0) continue;
                    stringArray = string.trim().split(" +");
                    hashMap.put(stringArray[1], stringArray[1]);
                }
            } else {
                object = OS_cmd.execute("ps -eo pid", false);
                for (String string : stringArray2 = ((OS_cmd)object).getStdout()) {
                    if (string.trim().length() == 0) continue;
                    hashMap.put(string.trim(), string.trim());
                }
            }
            object = Fput.getTmpDir();
            for (String string : stringArray2 = new File((String)object).list()) {
                String string2;
                if (!string.startsWith("vdbench.pid") || !string.contains(".mmap") || (stringArray = string.trim().split("\\.+")).length < 3 || hashMap.get(string2 = stringArray[1].substring(3)) != null) continue;
                if (!new File((String)object, string).delete()) {
                    common.ptod("Unable to delete mmap file %s%s", object, string);
                    continue;
                }
                common.plog("Deleted orphan mmap file: %s%s", object, string);
            }
        }
        catch (Exception exception) {
            common.ptod("Error cleaning up orphan mmap files. Continueing");
            common.ptod(exception);
        }
    }

    public synchronized void setAllUnbusy() {
        this.counter = new MapCounts();
        Elapsed elapsed = new Elapsed("MapFile.setAllUnbusy", 250000000L);
        for (long i = 0L; i < (long)this.getBytesInMap(); ++i) {
            long l = i;
            int n = (int)(l >> 30);
            int n2 = (int)(l & 0x3FFFFFFFL);
            int n3 = this.get(n2);
            if ((n3 & 0x7F) == 127) {
                ++this.counter.bad_blocks;
            } else if (n3 != 0) {
                ++this.counter.blocks_known;
            }
            if ((n3 & 0x80) != 0) {
                this.put(n2, n3 & 0x7F);
                ++this.counter.blocks_busy;
            }
            elapsed.track();
        }
        elapsed.end(5);
    }
}

