/*
 * Decompiled with CFR 0.152.
 */
package Vdb;

import Utils.ClassPath;
import Vdb.BoxPrint;
import Vdb.BucketRanges;
import Vdb.DV_map;
import Vdb.Debug_cmds;
import Vdb.Dedup;
import Vdb.HeartBeat;
import Vdb.Patterns;
import Vdb.RD_entry;
import Vdb.Report;
import Vdb.Reporter;
import Vdb.SlaveSocket;
import Vdb.Status;
import Vdb.SwatCharts;
import Vdb.Timeout;
import Vdb.Validate;
import Vdb.Vdb_scan;
import Vdb.Vdbmain;
import Vdb.common;
import java.util.ArrayList;

public class MiscParms {
    private static final String c = "Copyright (c) 2000, 2016, Oracle and/or its affiliates. All rights reserved.";
    public static boolean maintain_run_totals = false;
    public static String[] unix2windows = null;
    public static int formatxfersize = 0;
    public static boolean create_anchors = false;
    public static boolean format_sds = false;
    public static boolean do_not_format_sds = false;
    public static String[] aux_parms = null;
    private static ArrayList<String[]> miscellaneous = new ArrayList(4);

    static String readParms() {
        String string = Vdb_scan.parms_get();
        if (string == null) {
            common.failure("Early EOF on input parameters");
        }
        try {
            while (true) {
                Vdb_scan vdb_scan = Vdb_scan.parms_split(string);
                if (!(vdb_scan.keyword.equals("rg") || vdb_scan.keyword.equals("sd") || vdb_scan.keyword.equals("fsd") || vdb_scan.keyword.equals("wd") || vdb_scan.keyword.equals("fwd") || vdb_scan.keyword.equals("rd") || vdb_scan.keyword.equals("hd") || vdb_scan.keyword.equals("host"))) {
                    if ("compression".equals(vdb_scan.keyword)) {
                        double d = 100.0 / vdb_scan.getDouble();
                        common.ptod("*");
                        common.ptod("********************************************************************************");
                        common.ptod("* compression= parameter replaced by compratio=. This no longer is a percentage.");
                        common.ptod("* compression= has been converted to 'compratio=%.2f'", d);
                        common.ptod("********************************************************************************");
                        common.ptod("*");
                        Patterns.setDefaultCompressionRatio(d);
                        Validate.setCompressionRatio(d);
                    }
                    if ("compratio".startsWith(vdb_scan.keyword)) {
                        Patterns.setDefaultCompressionRatio(vdb_scan.numerics[0]);
                        Validate.setCompressionRatio(vdb_scan.numerics[0]);
                    } else if ("compressionseed".startsWith(vdb_scan.keyword)) {
                        if (vdb_scan.getNumCount() > 0) {
                            DV_map.compression_seed = (long)vdb_scan.numerics[0];
                        } else if (vdb_scan.alphas[0].equals("tod")) {
                            DV_map.compression_seed = System.currentTimeMillis();
                        } else {
                            common.failure("Invalid 'compressionseed=' parameter: " + vdb_scan.alphas[0]);
                        }
                    } else if (vdb_scan.keyword.startsWith("dedup")) {
                        Dedup.dedup_default.parseDedupParms(vdb_scan, true);
                    } else if ("port".startsWith(vdb_scan.keyword)) {
                        SlaveSocket.setMasterPort((int)vdb_scan.numerics[0]);
                    } else if ("pattern".startsWith(vdb_scan.keyword)) {
                        Patterns.parsePattern(vdb_scan.alphas);
                    } else if ("data_errors".startsWith(vdb_scan.keyword) || "dataerrors".startsWith(vdb_scan.keyword)) {
                        Validate.parseDataErrors(vdb_scan);
                    } else if ("swat".startsWith(vdb_scan.keyword)) {
                        common.failure("The 'swat=' parameter is no longer supported");
                        if (vdb_scan.getAlphaCount() == 1) {
                            new SwatCharts(vdb_scan.alphas[0], ClassPath.classPath("swatcharts.txt"));
                        } else {
                            new SwatCharts(vdb_scan.alphas[0], vdb_scan.alphas[1]);
                        }
                    } else if ("validate".startsWith(vdb_scan.keyword)) {
                        Validate.parseValidateOptions(vdb_scan);
                    } else if (vdb_scan.keyword.equals("journal")) {
                        Validate.parseJournalOptions(vdb_scan);
                    } else if (vdb_scan.keyword.equals("startcmd") || vdb_scan.keyword.equals("start_cmd")) {
                        Debug_cmds.starting_command.storeCommands(vdb_scan.alphas);
                    } else if (vdb_scan.keyword.equals("endcmd") || vdb_scan.keyword.equals("end_cmd")) {
                        Debug_cmds.ending_command.storeCommands(vdb_scan.alphas);
                    } else if (vdb_scan.keyword.equals("heartbeat_error")) {
                        HeartBeat.heartbeat_error = new Debug_cmds().storeCommands(vdb_scan.alphas);
                    } else if (vdb_scan.keyword.equals("debug")) {
                        if (vdb_scan.getNumCount() == 0) {
                            common.failure("'debug=' requires a numeric value");
                        }
                        common.set_debug((int)vdb_scan.numerics[0]);
                    } else {
                        if (vdb_scan.keyword.equals("parm=")) continue;
                        if ("unix2windows".startsWith(vdb_scan.keyword)) {
                            if (vdb_scan.getAlphaCount() != 2) {
                                common.failure("'unix2windows=' requires two subparameters, e.g. 'unix2windows=(/mnt,c:\\)");
                            }
                            unix2windows = vdb_scan.alphas;
                        } else if ("formatxfersize".startsWith(vdb_scan.keyword)) {
                            formatxfersize = (int)vdb_scan.numerics[0];
                        } else if ("create_anchors".startsWith(vdb_scan.keyword)) {
                            create_anchors = vdb_scan.alphas[0].toLowerCase().startsWith("y");
                        } else if ("formatsds".startsWith(vdb_scan.keyword)) {
                            if (vdb_scan.alphas[0].toLowerCase().startsWith("y")) {
                                format_sds = true;
                            } else if (vdb_scan.alphas[0].toLowerCase().startsWith("n")) {
                                do_not_format_sds = true;
                            } else {
                                common.failure("Invalid contents for formatsds=" + vdb_scan.alphas[0]);
                            }
                        } else if ("report".startsWith(vdb_scan.keyword)) {
                            Report.parseParameters(vdb_scan.alphas);
                        } else if ("report_run_totals".startsWith(vdb_scan.keyword)) {
                            maintain_run_totals = vdb_scan.alphas[0].toLowerCase().startsWith("y");
                        } else if ("histogram".startsWith(vdb_scan.keyword)) {
                            if (vdb_scan.alpha_count == 2) {
                                BucketRanges.setOption(vdb_scan.alphas[0], vdb_scan.alphas[1]);
                            } else {
                                new BucketRanges(vdb_scan.alphas);
                            }
                        } else if ("psrset".startsWith(vdb_scan.keyword)) {
                            if (!common.onSolaris()) {
                                common.failure("'psrset=' option is only supported on Solaris");
                            }
                            Validate.setPsrset(vdb_scan.getIntArray());
                        } else if ("auxreport".startsWith(vdb_scan.keyword)) {
                            aux_parms = vdb_scan.alphas;
                        } else if ("monitor".startsWith(vdb_scan.keyword)) {
                            Reporter.monitor_file = vdb_scan.alphas[0];
                        } else if ("concatenatesds".startsWith(vdb_scan.keyword)) {
                            if (vdb_scan.alphas[0].toLowerCase().startsWith("y")) {
                                Validate.setSdConcatenation();
                            } else if (!vdb_scan.alphas[0].toLowerCase().startsWith("n")) {
                                common.failure("Invalid contents for concatenatesds=%s; only value allowed is 'yes' or 'no'", vdb_scan.alphas[0]);
                            }
                        } else if ("messagescan".startsWith(vdb_scan.keyword)) {
                            MiscParms.addMiscKeyParameters("messagescan", vdb_scan.alphas);
                        } else if ("abort_failed_skew".startsWith(vdb_scan.keyword)) {
                            Validate.setSkewAbort(vdb_scan.numerics[0]);
                        } else if ("misc".startsWith(vdb_scan.keyword)) {
                            MiscParms.addMiscParameters(vdb_scan.alphas);
                        } else if (vdb_scan.keyword.equals("pattern_buffer")) {
                            Validate.setPatternMB((int)vdb_scan.numerics[0]);
                        } else if (vdb_scan.keyword.equals("showlba")) {
                            Validate.setShowLba(vdb_scan.alphas[0].toLowerCase().startsWith("y"));
                        } else if (vdb_scan.keyword.equals("loop")) {
                            MiscParms.scanLoopParameter(vdb_scan);
                        } else if ("timeout".startsWith(vdb_scan.keyword)) {
                            Timeout.scanTimeoutParameter(vdb_scan.raw_values);
                        } else if ("ios_per_jvm".startsWith(vdb_scan.keyword)) {
                            RD_entry.IOS_PER_JVM = (int)vdb_scan.numerics[0];
                        } else if ("fwd_thread_adjust".startsWith(vdb_scan.keyword)) {
                            RD_entry.fwd_thread_adjust = vdb_scan.alphas[0].startsWith("y");
                        } else {
                            common.failure("Unknown keyword: " + vdb_scan.keyword);
                        }
                    }
                    string = Vdb_scan.parms_get();
                    continue;
                }
                break;
            }
        }
        catch (Exception exception) {
            common.ptod(exception);
            common.ptod("Exception during reading of input parameter file(s).");
            common.ptod("Look at the end of 'parmscan.html' to identify the last parameter scanned.");
            common.failure("Exception during reading of input parameter file(s).");
        }
        if (Dedup.dedup_default != null) {
            Dedup.dedup_default.checkDedupParms();
        }
        Patterns.checkPattern();
        if (common.get_debug(common.SIMULATE)) {
            Vdbmain.simulate = true;
        }
        if (Validate.sdConcatenation() && format_sds) {
            common.failure("The 'formatsds=' and 'concatenatesds' parameters are mutually exclusive.");
        }
        if (Validate.sdConcatenation() && Validate.isValidate()) {
            common.failure("Data Validation and SD concatenation are mutually exclusive.");
        }
        return string;
    }

    public static ArrayList<String[]> getMiscellaneous() {
        return miscellaneous;
    }

    public static void setMiscellaneous(ArrayList arrayList) {
        miscellaneous = arrayList;
    }

    public static void addMiscParameters(String[] stringArray) {
        String string = stringArray[0];
        for (int i = 0; i < miscellaneous.size(); ++i) {
            String[] stringArray2 = miscellaneous.get(i);
            if (!stringArray2[0].equalsIgnoreCase(string)) continue;
            ArrayList<String> arrayList = new ArrayList<String>(stringArray2.length * 2);
            for (String string2 : stringArray2) {
                arrayList.add(string2);
            }
            for (int j = 1; j < stringArray.length; ++j) {
                arrayList.add(stringArray[j]);
            }
            String[] stringArray3 = arrayList.toArray(new String[0]);
            miscellaneous.set(i, stringArray3);
            return;
        }
        miscellaneous.add(stringArray);
    }

    private static void addMiscKeyParameters(String string, String[] stringArray) {
        for (String[] stringArray2 : miscellaneous) {
            if (!stringArray2[0].equals(string)) continue;
            common.failure("MiscParms.addMiscKeyParameters: duplicate keyword not allowed: '%s'", string);
        }
        ArrayList arrayList = new ArrayList(8);
        arrayList.add(string);
        for (String string2 : stringArray) {
            arrayList.add(string2);
        }
        MiscParms.addMiscParameters(arrayList.toArray(new String[0]));
    }

    public static String[] getKeyParameters(String string) {
        for (String[] stringArray : miscellaneous) {
            if (!stringArray[0].equalsIgnoreCase(string)) continue;
            return stringArray;
        }
        return null;
    }

    public static String[] getKeyParameters(String string, String string2) {
        for (String[] stringArray : miscellaneous) {
            if (stringArray.length <= 1 || !stringArray[0].equalsIgnoreCase(string) || !stringArray[1].equalsIgnoreCase(string2)) continue;
            return stringArray;
        }
        return null;
    }

    private static void scanLoopParameter(Vdb_scan vdb_scan) {
        String string = vdb_scan.raw_values.get(0);
        Vdbmain.loop_all_runs = true;
        String string2 = string;
        int n = 1;
        if (string2.endsWith("s")) {
            n = 1;
            string2 = string2.substring(0, string2.length() - 1);
        } else if (string2.endsWith("m")) {
            n = 60;
            string2 = string2.substring(0, string2.length() - 1);
        } else if (string2.endsWith("h")) {
            n = 3600;
            string2 = string2.substring(0, string2.length() - 1);
        } else if (!common.isNumeric(string2)) {
            common.failure("Expecting no parameter or a numeric paramater after '-l': " + string);
        } else {
            Vdbmain.loop_count = Long.parseLong(string2);
        }
        if (Vdbmain.loop_count == Long.MAX_VALUE) {
            Vdbmain.loop_duration = Long.parseLong(string2) * (long)n;
            Vdbmain.loop_duration *= 1000L;
        }
    }

    public static boolean shutDownAfterLoops(long l) {
        if (!Vdbmain.loop_all_runs) {
            return true;
        }
        ++Vdbmain.loops_done;
        if (Vdbmain.loop_count != Long.MAX_VALUE) {
            if (Vdbmain.loops_done >= Vdbmain.loop_count) {
                BoxPrint.printOne("Terminating loop run after %d loops", Vdbmain.loop_count);
                return true;
            }
            return false;
        }
        if (System.currentTimeMillis() - l > Vdbmain.loop_duration) {
            BoxPrint.printOne("Terminating loop run after %d seconds", (System.currentTimeMillis() - l) / 1000L);
            return true;
        }
        return false;
    }

    public static void printLoopStart() {
        if (!Vdbmain.loop_all_runs) {
            return;
        }
        Status.printStatus("Starting loop " + (Vdbmain.loops_done + 1L), new Object[0]);
        common.ptod("Starting loop " + (Vdbmain.loops_done + 1L));
    }
}

