/*
 * Decompiled with CFR 0.152.
 */
package Vdb;

import Utils.Format;
import Vdb.Errno;
import Vdb.File_handles;
import Vdb.Kstat_cpu;
import Vdb.Kstat_data;
import Vdb.OpenFlags;
import Vdb.SlaveJvm;
import Vdb.common;

public class Native {
    private static final String c = "Copyright (c) 2000, 2016, Oracle and/or its affiliates. All rights reserved.";
    private static long total_size = 0L;
    private static long max_size = 0L;
    static Object alloc_lock = new Object();
    private static long total_sleep;
    private static long sleeps;
    public static long ks_global;

    public static native void nativeSleep(long var0);

    public static native long openfile(String var0, int var1, int var2);

    public static long openFile(String string, int n) {
        return Native.openFile(string, null, n);
    }

    public static long openFile(String string) {
        return Native.openFile(string, null, 0);
    }

    public static long openFile(String string, OpenFlags openFlags, int n) {
        long l;
        int n2 = 0;
        boolean bl = false;
        boolean bl2 = false;
        if (n != 0 && common.get_debug(common.NEVER_OPEN_FOR_WRITE)) {
            common.failure("'NEVER_OPEN_FOR_WRITE' is set. Trying to open " + string);
        }
        if (openFlags != null) {
            n2 = openFlags.getOpenFlags();
            if (!string.startsWith("/dev/")) {
                bl = openFlags.isOther(OpenFlags.SOL_DIRECTIO);
                bl2 = openFlags.isOther(OpenFlags.SOL_DIRECTIO_OFF);
            }
        }
        long l2 = Native.openfile(string, n2, n);
        if (bl && (l = Native.directio(l2, 1L)) != 0L) {
            common.failure("Failed call to directio: " + Errno.xlate_errno(l));
        }
        if (bl2 && (l = Native.directio(l2, 0L)) != 0L) {
            common.failure("Failed call to directio: " + Errno.xlate_errno(l));
        }
        return l2;
    }

    private static native long closefile(long var0);

    public static long closeFile(long l) {
        if (l <= 0L) {
            common.failure("Bad file handle: %d", l);
        }
        return Native.closeFile(l, null);
    }

    public static long closeFile(long l, OpenFlags openFlags) {
        long l2;
        boolean bl = false;
        boolean bl2 = false;
        if (openFlags != null && !File_handles.getFileName(l).startsWith("/dev/")) {
            bl = openFlags.isOther(OpenFlags.FSYNC_ON_CLOSE);
            bl2 = openFlags.isOther(OpenFlags.SOL_DIRECTIO);
        }
        if (bl && (l2 = Native.fsync(l)) != 0L) {
            common.failure("Native.closeFile(fhandle): fsync failed, rc= " + l2);
        }
        if (bl2 && (l2 = Native.directio(l, 0L)) != 0L) {
            common.failure("Failed call to directio: " + Errno.xlate_errno(l2));
        }
        if ((l2 = Native.closefile(l)) != 0L) {
            common.ptod("Native.closeFile(fhandle): close failed: %d", l2);
        }
        return l2;
    }

    public static native long fsync(long var0);

    private static native long directio(long var0, long var2);

    private static native long getsize(long var0, String var2);

    public static long getSize(long l, String string) {
        long l2 = Native.getsize(l, string);
        return l2;
    }

    public static native long get_simple_tod();

    private static native long read(long var0, long var2, long var4, long var6, int var8);

    public static long readFile(long l, long l2, long l3, long l4) {
        if (l <= 0L) {
            common.failure("Bad file handle: %d", l);
        }
        return Native.readFile(l, l2, l3, l4, -1);
    }

    public static long readFile(long l, long l2, long l3, long l4, int n) {
        if (l <= 0L) {
            common.failure("Bad file handle: %d", l);
        }
        long l5 = Native.read(l, l2, l3, l4, n);
        return l5;
    }

    private static native long write(long var0, long var2, long var4, long var6, int var8);

    public static long writeFile(long l, long l2, long l3, long l4) {
        if (l <= 0L) {
            common.failure("Bad file handle: %d", l);
        }
        return Native.writeFile(l, l2, l3, l4, -1);
    }

    public static long writeFile(long l, long l2, long l3, long l4, int n) {
        if (l <= 0L) {
            common.failure("Bad file handle: %d", l);
        }
        long l5 = Native.write(l, l2, l3, l4, n);
        return l5;
    }

    private static native long noDedupWrite(long var0, long var2, long var4, long var6, int var8);

    public static long noDedupAndWrite(long l, long l2, long l3, long l4, int n) {
        return Native.noDedupWrite(l, l2, l3, l4, n);
    }

    static native void store_pattern(int[] var0);

    private static native void array_to_buffer(int[] var0, long var1, int var3);

    public static void arrayToBuffer(int[] nArray, long l, int n) {
        Native.array_to_buffer(nArray, l, n);
    }

    public static void arrayToBuffer(int[] nArray, long l) {
        Native.array_to_buffer(nArray, l, nArray.length * 4);
    }

    static native void buffer_to_array(int[] var0, long var1, int var3);

    static native void longBufferToArray(long[] var0, long var1, int var3);

    static native void arrayToLongBuffer(long[] var0, long var1, int var3);

    private static native long allocbuf(int var0);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static long allocBuffer(int n) {
        Object object = alloc_lock;
        synchronized (object) {
            long l = Native.allocbuf(n);
            if (l == 0L) {
                Native.printMemoryUsage();
                common.memory_usage();
                common.failure("allocbuffer() failed. Asking for %,d; already have %,d allocated", n, total_size);
            }
            max_size = Math.max(total_size += (long)n, max_size);
            return l;
        }
    }

    private static native void freebuf(int var0, long var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void freeBuffer(int n, long l) {
        Object object = alloc_lock;
        synchronized (object) {
            total_size -= (long)n;
            Native.freebuf(n, l);
        }
    }

    public static void printMemoryUsage() {
        common.plog("Maximum native memory allocation: %,12d; Current allocation: %,12d", max_size, total_size);
        max_size = 0L;
    }

    static native long getKstatPointer(String var0);

    static native long getKstatData(Kstat_data var0, long var1);

    static native long getCpuData(Kstat_cpu var0);

    private static native long openKstatGlobal();

    private static native long closeKstatGlobal();

    public static void openKstat() {
        ks_global = Native.openKstatGlobal();
    }

    public static void closeKstat() {
        if (ks_global == 0L) {
            common.failure("closeKstat(): null");
        }
        Native.closeKstatGlobal();
        ks_global = 0L;
    }

    static native void setup_jni_context(int var0, String var1, long[] var2, long[] var3);

    static native String get_one_set_statistics(int var0, int var1, long[] var2, long[] var3);

    static native void alloc_jni_shared_memory(long var0);

    static void allocSharedMemory() {
        Native.alloc_jni_shared_memory(SlaveJvm.getOwnerId());
    }

    public static native long getSolarisPids();

    static native String getWindowsErrorText(int var0);

    private static native long multiKeyReadAndValidate(long var0, int var2, long var3, long var5, int var7, long var8, int var10, int[] var11, long[] var12, long[] var13, String var14, int var15);

    public static long multiKeyReadAndValidateBlock(long l, int n, long l2, long l3, int n2, long l4, int n3, int[] nArray, long[] lArray, long[] lArray2, String string, int n4) {
        if (string.length() != 8) {
            common.failure("Native.multiKeyReadAndValidate: 'name' must be 8 characters long: >>>" + string + "<<<");
        }
        long l5 = Native.multiKeyReadAndValidate(l, n, l2, l3, n2, l4, n3, nArray, lArray, lArray2, string, n4);
        return l5;
    }

    private static native long multiKeyFillAndWrite(long var0, long var2, int var4, long var5, long var7, int var9, long var10, int var12, long var13, int var15, int[] var16, long[] var17, long[] var18, String var19, int var20);

    public static long multiKeyFillAndWriteBlock(long l, long l2, int n, long l3, long l4, int n2, long l5, int n3, long l6, int n4, int[] nArray, long[] lArray, long[] lArray2, String string, int n5) {
        if (string.length() != 8) {
            common.failure("multiKeyFillAndWriteBlock(): 'name' must be 8 characters long: >>>" + string + "<<<");
        }
        long l7 = Native.multiKeyFillAndWrite(l, l2, n, l3, l4, n2, l5, n3, l6, n4, nArray, lArray, lArray2, string, n5);
        return l7;
    }

    static native void fillLfsrArray(int[] var0, long var1, int var3, String var4);

    static native void fillLfsrBuffer(long var0, int var2, long var3, int var5, String var6);

    static native int eraseFileSystemCache(long var0, long var2);

    static native String getErrorText(int var0);

    public static native long chmod(String var0);

    public static native long getTickCount();

    public static native long truncateFile(long var0, long var2);

    public static void main(String[] stringArray) {
        long l = 773586944L;
        int n = 13;
        String string = "12345678";
        int[] nArray = new int[128];
        Native.fillLfsrArray(nArray, l, n, string);
        for (int i = 0; i < nArray.length; i += 4) {
            String string2 = String.format("0x%03x: ", i * 4);
            string2 = string2 + Format.f("%08x ", nArray[i]);
            string2 = string2 + Format.f("%08x ", nArray[i + 1]);
            string2 = string2 + Format.f("%08x ", nArray[i + 2]);
            string2 = string2 + Format.f("%08x ", nArray[i + 3]);
            common.ptod("line: " + string2);
        }
    }

    static {
        common.get_shared_lib();
        total_sleep = 0L;
        sleeps = 0L;
        ks_global = 0L;
    }
}

