/*
 * Decompiled with CFR 0.152.
 */
package Vdb;

import Utils.NamedData;
import Utils.NamedKstat;
import Utils.NfsV3;
import Utils.NfsV4;
import Vdb.Host;
import Vdb.Native;
import Vdb.Report;
import Vdb.common;
import Vdb.reporting;

public class NfsStats {
    private static final String c = "Copyright (c) 2000, 2015, Oracle and/or its affiliates. All rights reserved.";
    private static NfsV3 nfs3_old = new NfsV3();
    private static NfsV3 nfs3_new = new NfsV3();
    private static NfsV3 nfs3_delta = new NfsV3();
    private static NfsV4 nfs4_old = new NfsV4();
    private static NfsV4 nfs4_new = new NfsV4();
    private static NfsV4 nfs4_delta = new NfsV4();
    private static long kstat_ctl_t = 0L;
    private static boolean nfs_reports_needed = false;
    public static String warning = "\n\nBe very clearly aware that this report shows nfsstat data for ALL \nNFS mounted file systems on your system, and not only your test files.\nIf your Vdbench output directory is on an NFS mounted directory       \nNFS activity generated by Vdbench reporting is also included.         \nIf you don't want Vdbench reporting included, specify a Vdbench       \noutput directory that does not use NFS.                             \n\n";

    public static void setNfsReportsNeeded(boolean bl) {
        nfs_reports_needed = bl;
    }

    public static boolean areNfsReportsNeeded() {
        return nfs_reports_needed;
    }

    public static void getAllNfsDeltasFromKstat() {
        String string;
        long l = Native.get_simple_tod();
        if (kstat_ctl_t == 0L) {
            kstat_ctl_t = NamedKstat.kstat_open();
            string = NamedKstat.kstat_lookup_stuff(kstat_ctl_t, "nfs", "rfsreqcnt_v3");
            if (string.startsWith("JNI")) {
                common.ptod("getAllNfsStats(): no data found for nfs version3");
                nfs3_delta = null;
            }
            if ((string = NamedKstat.kstat_lookup_stuff(kstat_ctl_t, "nfs", "rfsreqcnt_v4")).startsWith("JNI")) {
                common.ptod("getAllNfsStats(): no data found for nfs version4");
                nfs4_delta = null;
            }
        }
        if (nfs3_delta != null) {
            string = NamedKstat.kstat_lookup_stuff(kstat_ctl_t, "nfs", "rfsreqcnt_v3");
            nfs3_new = new NfsV3();
            nfs3_new.parseNamedData(string);
            nfs3_new.setTime(l);
        }
        if (nfs4_delta != null) {
            string = NamedKstat.kstat_lookup_stuff(kstat_ctl_t, "nfs", "rfsreqcnt_v4");
            nfs4_new = new NfsV4();
            nfs4_new.parseNamedData(string);
            nfs4_new.setTime(l);
        }
        NfsStats.allDelta();
        NfsStats.newToOld();
    }

    public static void newToOld() {
        nfs3_old = nfs3_new;
        nfs4_old = nfs4_new;
    }

    public static void allDelta() {
        if (nfs3_delta != null) {
            nfs3_delta.delta(nfs3_new, nfs3_old);
        }
        if (nfs4_delta != null) {
            nfs4_delta.delta(nfs4_new, nfs4_old);
        }
    }

    public static void createNfsReports() {
        for (int i = 0; i < Host.getDefinedHosts().size(); ++i) {
            Host host = Host.getDefinedHosts().elementAt(i);
            if (host.getHostInfo() == null) continue;
            host.createNfsReports();
        }
    }

    public static reporting[] nfsLayout(NamedData namedData, Object object) {
        String[] stringArray = namedData.getFieldTitles();
        reporting[] reportingArray = new reporting[stringArray.length + 2];
        reportingArray[0] = new reporting("interval", "", "%*s", 8);
        for (int i = 0; i < stringArray.length; ++i) {
            String string = stringArray[i];
            int n = Math.max(5, string.length());
            reportingArray[i + 1] = new reporting(string, "rate", "%*.1F", n);
        }
        return reportingArray;
    }

    public static void PrintAllNfs(String string) {
        for (int i = 0; i < Host.getDefinedHosts().size(); ++i) {
            Host host = Host.getDefinedHosts().elementAt(i);
            if (host.getHostInfo() == null) continue;
            host.PrintNfsstatInterval(string);
        }
    }

    public static void NfsPrint(Report report, NamedData namedData, reporting[] reportingArray, String string, Object object) {
        StringBuffer stringBuffer = new StringBuffer(256);
        stringBuffer.append(reportingArray[0].report(string));
        String[] stringArray = namedData.getFieldTitles();
        for (int i = 0; i < stringArray.length; ++i) {
            stringBuffer.append(reportingArray[i + 1].report(namedData.getRate(i)));
        }
        report.println(common.tod() + stringBuffer.toString());
    }

    public static void NfsPrintVertical(Report report, NamedData namedData) {
        int n;
        String[] stringArray = namedData.getFieldTitles();
        double d = 0.0;
        for (n = 0; n < stringArray.length; ++n) {
            d += namedData.getRate(n);
        }
        if (d == 0.0) {
            return;
        }
        report.println("");
        report.println("Non-zero rates. Note that the %% is NOT expected to represent Vdbench skew:");
        for (n = 0; n < stringArray.length; ++n) {
            double d2 = namedData.getRate(n);
            if (!(d2 > 0.0)) continue;
            report.println("%s %-12s %,8.0f %5.2f%%", common.tod(), stringArray[n], d2, d2 * 100.0 / d);
        }
        report.println("%s %-12s %,8.0f", common.tod(), "Total", d);
    }

    public static NfsV3 getNfs3() {
        return nfs3_delta;
    }

    public static NfsV4 getNfs4() {
        return nfs4_delta;
    }
}

