/*
 * Decompiled with CFR 0.152.
 */
package Vdb;

import Utils.NamedData;
import Utils.NamedKstat;
import Utils.OS_cmd;
import Vdb.NwAdapter;
import Vdb.common;
import java.util.ArrayList;

public class NwStats {
    private static final String c = "Copyright (c) 2000, 2017, Oracle and/or its affiliates. All rights reserved.";
    private static ArrayList<NwAdapter> adapters = null;
    private static long kstat_ctl_t = 0L;
    public static long in_bytes = 7777L;
    public static long ot_bytes = 7777L;

    public static ArrayList<NwAdapter> getData() {
        return adapters;
    }

    public static void getAdapters() {
        if (adapters != null) {
            return;
        }
        if (!common.onSolaris()) {
            common.failure("Network monitoring only available on Solaris at this time");
        }
        adapters = new ArrayList(8);
        common.get_shared_lib();
        kstat_ctl_t = NamedKstat.kstat_open();
        OS_cmd oS_cmd = new OS_cmd();
        oS_cmd.add("/usr/bin/kstat -m link -c net -s obytes64 -p", new Object[0]);
        oS_cmd.execute(false);
        if (!oS_cmd.getRC()) {
            oS_cmd.printStderr();
            oS_cmd.printStdout();
            common.failure("No network adapters found");
        }
        NamedData.newInstance("Utils.NamedData/link");
        for (String string : oS_cmd.getStdout()) {
            String[] stringArray = string.split(":");
            NwAdapter nwAdapter = new NwAdapter();
            nwAdapter.name = stringArray[2];
            adapters.add(nwAdapter);
            NwStats.loadStatistics();
            nwAdapter.index_ib = nwAdapter.old_data.getAnchor().getIndexForField("rbytes64");
            nwAdapter.index_ob = nwAdapter.old_data.getAnchor().getIndexForField("obytes64");
        }
        if (adapters.size() == 0) {
            oS_cmd.printStderr();
            oS_cmd.printStdout();
            common.failure("No network adapters found");
        }
    }

    public static void loadStatistics() {
        for (NwAdapter nwAdapter : adapters) {
            String string = NamedKstat.kstat_lookup_stuff(kstat_ctl_t, "link", nwAdapter.name);
            nwAdapter.cur_data = NamedData.newInstance("Utils.NamedData/link");
            nwAdapter.cur_data.parseNamedData(string);
            nwAdapter.cur_data.setTime(System.currentTimeMillis());
            nwAdapter.dlt_data.delta(nwAdapter.cur_data, nwAdapter.old_data);
            nwAdapter.old_data = nwAdapter.cur_data;
        }
    }

    public static long getOtbytes(ArrayList<NwAdapter> arrayList) {
        long l = 0L;
        for (NwAdapter nwAdapter : arrayList) {
            l += nwAdapter.dlt_data.getCounters()[nwAdapter.index_ob];
        }
        return l;
    }

    public static long getInbytes(ArrayList<NwAdapter> arrayList) {
        long l = 0L;
        for (NwAdapter nwAdapter : arrayList) {
            l += nwAdapter.dlt_data.getCounters()[nwAdapter.index_ib];
        }
        return l;
    }

    public static void main(String[] stringArray) {
        NwStats.getAdapters();
        for (int i = 0; i < 10; ++i) {
            common.sleep_some(1000L);
            NwStats.loadStatistics();
        }
    }
}

