/*
 * Decompiled with CFR 0.152.
 */
package Vdb;

import Vdb.ActiveFile;
import Vdb.Blocked;
import Vdb.FileEntry;
import Vdb.FwdStats;
import Vdb.FwgEntry;
import Vdb.FwgThread;
import Vdb.Native;
import Vdb.Task_num;
import Vdb.Validate;

class OpCopy
extends FwgThread {
    private static final String c = "Copyright (c) 2000, 2016, Oracle and/or its affiliates. All rights reserved.";

    public OpCopy(Task_num task_num, FwgEntry fwgEntry) {
        super(task_num, fwgEntry);
    }

    @Override
    protected boolean doOperation() throws InterruptedException {
        FileEntry fileEntry;
        FileEntry fileEntry2;
        while (true) {
            if ((fileEntry2 = this.findFileToRead()) == null) {
                return false;
            }
            if (!this.fwg.select_random && fileEntry2.hasBeenCopied()) {
                fileEntry2.setUnBusy();
                return false;
            }
            fileEntry = this.fwg.target_anchor.getRelativeFile(fileEntry2.getFileNoInList());
            if (fileEntry.setFileBusyExc()) break;
            this.block(Blocked.FILE_BUSY);
            fileEntry2.setUnBusy();
        }
        if (fileEntry.exists()) {
            fileEntry.deleteFile(this.fwg);
        }
        long l = Native.get_simple_tod();
        ActiveFile activeFile = this.openForRead(fileEntry2);
        ActiveFile activeFile2 = this.openForWrite(fileEntry);
        while (true) {
            activeFile.xfersize = this.fwg.getXferSize();
            if (!activeFile.setNextSequentialRead()) break;
            activeFile.readBlock();
            activeFile2.xfersize = activeFile.xfersize;
            activeFile2.next_lba = activeFile.next_lba;
            if (Validate.isValidate()) {
                activeFile2.getKeyMap().storeDataBlockInfo(activeFile2.next_lba, activeFile2.xfersize, activeFile2.getAnchor().getDVMap());
            }
            activeFile2.writeBlock();
        }
        fileEntry2.setCopied(true);
        activeFile = activeFile.closeFile();
        activeFile2 = activeFile2.closeFile();
        FwdStats.count(this.operation, l);
        this.fwg.blocked.count(Blocked.FILES_COPIED);
        return true;
    }
}

