/*
 * Decompiled with CFR 0.152.
 */
package Vdb;

import Vdb.Blocked;
import Vdb.FileEntry;
import Vdb.FwdStats;
import Vdb.FwgEntry;
import Vdb.FwgThread;
import Vdb.Native;
import Vdb.Operations;
import Vdb.SlaveJvm;
import Vdb.SlaveWorker;
import Vdb.Task_num;
import Vdb.common;

class OpCreate
extends FwgThread {
    private static final String c = "Copyright (c) 2000, 2016, Oracle and/or its affiliates. All rights reserved.";
    private static boolean debug = common.get_debug(common.REPORT_CREATES);

    public OpCreate(Task_num task_num, FwgEntry fwgEntry) {
        super(task_num, fwgEntry);
    }

    @Override
    protected boolean doOperation() {
        boolean bl = false;
        FileEntry fileEntry = this.findNonExistingFile();
        if (fileEntry == null) {
            if (bl) {
                common.ptod("doOperation1 false");
            }
            return false;
        }
        long l = Native.get_simple_tod();
        this.afe = this.openForWrite(fileEntry);
        if (this.fwg.getOperation() == Operations.CREATE) {
            this.afe.closeFile();
        } else {
            if (SlaveWorker.work.format_run && common.get_debug(common.FILE_FORMAT_TRUNCATE)) {
                long l2 = Native.truncateFile(this.afe.getHandle(), this.afe.getFileEntry().getReqSize());
                if (l2 != 0L) {
                    common.failure("ftruncate of file %s for %,d bytes failed, error code %d", this.afe.getFileEntry().getFullName(), this.afe.getFileEntry().getReqSize(), l2);
                }
                this.afe.closeFile();
                this.fwg.blocked.count(Blocked.SPARSE_CREATES);
                if (bl) {
                    common.ptod("doOperation2 true");
                }
                return true;
            }
            while (this.doSequentialWrite(true)) {
                if (!SlaveJvm.isWorkloadDone()) continue;
                this.afe.closeFile();
                break;
            }
        }
        FwdStats.count(Operations.CREATE, l);
        if (bl) {
            common.ptod("doOperation3 true ");
        }
        return true;
    }
}

