/*
 * Decompiled with CFR 0.152.
 */
package Vdb;

import Vdb.Blocked;
import Vdb.ControlFile;
import Vdb.FileAnchor;
import Vdb.FormatCounter;
import Vdb.FwdStats;
import Vdb.FwgEntry;
import Vdb.FwgThread;
import Vdb.FwgWaiter;
import Vdb.InfoFromHost;
import Vdb.Native;
import Vdb.OpCreate;
import Vdb.OpMkdir;
import Vdb.Operations;
import Vdb.Signal;
import Vdb.SlaveJvm;
import Vdb.SlaveWorker;
import Vdb.Task_num;
import Vdb.common;
import java.io.File;
import java.util.ArrayList;

class OpFormat
extends FwgThread {
    private static final String c = "Copyright (c) 2000, 2016, Oracle and/or its affiliates. All rights reserved.";
    private OpMkdir mkdir = null;
    private OpCreate create = null;
    private static Signal signal;
    private int format_thread_number;
    private ArrayList<File> dirs_to_clean = null;
    private static Object duplicate_lock;

    public OpFormat(Task_num task_num, FwgEntry fwgEntry) {
        super(task_num, fwgEntry);
        signal = new Signal(15);
        this.mkdir = new OpMkdir(null, fwgEntry);
        this.create = new OpCreate(null, fwgEntry);
    }

    public void storeCleanDir(File file) {
        if (this.dirs_to_clean == null) {
            this.dirs_to_clean = new ArrayList(8);
        }
        this.dirs_to_clean.add(file);
    }

    public void setFormatThreadNumber(int n) {
        this.format_thread_number = n;
    }

    @Override
    protected boolean doOperation() throws InterruptedException {
        if (SlaveWorker.work.format_flags.format_clean) {
            return false;
        }
        if (this.fwg.anchor.mkdir_threads_running.notZero()) {
            if (!this.mkdir.doOperation() || !this.fwg.anchor.moreDirsToFormat()) {
                this.waitForAllOtherThreads(this.fwg, this.fwg.anchor.mkdir_threads_running, "mkdir");
            }
            return true;
        }
        if (SlaveWorker.work.format_flags.format_dirs_requested) {
            return false;
        }
        if (this.fwg.anchor.create_threads_running.notZero()) {
            this.reportStuff("Created", this.fwg.anchor.getFileCount(), this.fwg.anchor.getExistingFileCount());
            if (!this.create.doOperation() || !this.fwg.anchor.anyFilesToFormat()) {
                this.waitForAllOtherThreads(this.fwg, this.fwg.anchor.create_threads_running, "create");
                this.fwg.work_done = true;
                return false;
            }
            return true;
        }
        this.reportStuff("Formatted", this.fwg.anchor.getFileCount(), this.fwg.anchor.getFullFileCount());
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void reportStuff(String string, long l, long l2) {
        Object object = duplicate_lock;
        synchronized (object) {
            int n = (int)l / 100;
            if (n != 0 && l2 % (long)n == 0L && signal.go()) {
                double d = (double)l2 * 100.0 / (double)l;
                if (this.fwg.anchor.last_format_pct <= n) {
                    SlaveJvm.sendMessageToConsole("anchor=%s: %s %,d of %,d files (%.2f%%)", this.fwg.anchor.getAnchorName(), string, l2, l, d);
                    this.fwg.anchor.last_format_pct = n;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void waitForAllOtherThreads(FwgEntry fwgEntry, FormatCounter formatCounter, String string) throws InterruptedException {
        FwgWaiter.getMyQueue(fwgEntry).suspendFwg();
        FormatCounter formatCounter2 = formatCounter;
        synchronized (formatCounter2) {
            --formatCounter.counter;
            if (formatCounter.counter == 0) {
                SlaveJvm.sendMessageToConsole("anchor=" + fwgEntry.anchor.getAnchorName() + " " + string + " complete.");
                formatCounter.notifyAll();
                fwgEntry.anchor.startRoundRobin();
                FwgWaiter.getMyQueue(fwgEntry).restartFwg();
                return;
            }
            while (formatCounter.counter > 0) {
                formatCounter.wait(100L);
            }
        }
    }

    public void deletePendingLevel1Directories() {
        if (this.dirs_to_clean == null || this.dirs_to_clean.size() == 0) {
            return;
        }
        for (File file : this.dirs_to_clean) {
            if (SlaveJvm.isWorkloadDone()) {
                return;
            }
            long l = System.currentTimeMillis();
            this.deleteOldStuff(file, this.fwg);
            long l2 = (System.currentTimeMillis() - l) / 1000L;
            if (l2 <= 30L) continue;
            common.ptod("deletePendingLevel1Directories: it took %4d seconds to clean up %s ", l2, file.getName());
        }
    }

    private void deleteOldStuff(File file, FwgEntry fwgEntry) {
        String string = file.getAbsolutePath();
        FileAnchor fileAnchor = fwgEntry.anchor;
        Signal signal = new Signal(30);
        this.readDirsAndDelete(fwgEntry, file, signal);
    }

    private void readDirsAndDelete(FwgEntry fwgEntry, File file, Signal signal) {
        FileAnchor fileAnchor = fwgEntry.anchor;
        File[] fileArray = file.listFiles();
        if (fileArray == null) {
            common.ptod("readDirsAndDelete(): directory not found and ignored: " + file.getAbsolutePath());
            return;
        }
        for (File file2 : fileArray) {
            if (SlaveJvm.isWorkloadDone()) {
                return;
            }
            String string = file2.getName();
            if (string.endsWith(InfoFromHost.NO_DISMOUNT_FILE) || !string.startsWith("vdb") || string.endsWith(ControlFile.CONTROL_FILE) || string.indexOf(ControlFile.CONTROL_FILE) == -1 && !string.endsWith(".dir") && !string.endsWith(".file") && !string.endsWith(".file.gz")) continue;
            if (string.endsWith("file")) {
                long l = Native.get_simple_tod();
                if (!file2.delete()) {
                    if (!fwgEntry.shared) {
                        common.failure("Unable to delete file: " + file2.getAbsolutePath());
                        continue;
                    }
                    fwgEntry.blocked.count(Blocked.FILE_DELETE_SHARED);
                    continue;
                }
                FwdStats.count(Operations.DELETE, l);
                fwgEntry.blocked.count(Blocked.FILE_DELETES);
                fileAnchor.countFileDeletes();
                continue;
            }
            this.readDirsAndDelete(fwgEntry, file2, signal);
        }
        long l = Native.get_simple_tod();
        if (!file.delete()) {
            if (!fwgEntry.shared) {
                common.ptod("");
                common.ptod("Unable to delete directory: " + file.getAbsolutePath());
                common.ptod("Are there any files left that were not created by Vdbench?");
                common.failure("Unable to delete directory: " + file.getAbsolutePath() + ". \n\t\tAre there any files left that were not created by Vdbench?");
            } else {
                fileAnchor.countDirDeletes();
                fwgEntry.blocked.count(Blocked.DIR_DELETE_SHARED);
            }
        } else {
            FwdStats.count(Operations.RMDIR, l);
            fwgEntry.blocked.count(Blocked.DIRECTORY_DELETES);
        }
    }

    static {
        duplicate_lock = new Object();
    }
}

